/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.RelationshipToRole;
import com.datadog.api.client.v2.model.RestrictionQueryCreatePayload;
import com.datadog.api.client.v2.model.RestrictionQueryListResponse;
import com.datadog.api.client.v2.model.RestrictionQueryRolesResponse;
import com.datadog.api.client.v2.model.RestrictionQueryUpdatePayload;
import com.datadog.api.client.v2.model.RestrictionQueryWithRelationshipsResponse;
import com.datadog.api.client.v2.model.RestrictionQueryWithoutRelationshipsResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class LogsRestrictionQueriesApi {
    private ApiClient apiClient;

    public LogsRestrictionQueriesApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public LogsRestrictionQueriesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void addRoleToRestrictionQuery(String restrictionQueryId, RelationshipToRole body) throws ApiException {
        this.addRoleToRestrictionQueryWithHttpInfo(restrictionQueryId, body);
    }

    public CompletableFuture<Void> addRoleToRestrictionQueryAsync(String restrictionQueryId, RelationshipToRole body) {
        return this.addRoleToRestrictionQueryWithHttpInfoAsync(restrictionQueryId, body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> addRoleToRestrictionQueryWithHttpInfo(String restrictionQueryId, RelationshipToRole body) throws ApiException {
        String operationId = "addRoleToRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        RelationshipToRole localVarPostBody = body;
        if (restrictionQueryId == null) {
            throw new ApiException(400, "Missing the required parameter 'restrictionQueryId' when calling addRoleToRestrictionQuery");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addRoleToRestrictionQuery");
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/{restriction_query_id}/roles".replaceAll("\\{restriction_query_id\\}", this.apiClient.escapeString(restrictionQueryId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.addRoleToRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> addRoleToRestrictionQueryWithHttpInfoAsync(String restrictionQueryId, RelationshipToRole body) {
        Invocation.Builder builder;
        String operationId = "addRoleToRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        RelationshipToRole localVarPostBody = body;
        if (restrictionQueryId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'restrictionQueryId' when calling addRoleToRestrictionQuery"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling addRoleToRestrictionQuery"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/{restriction_query_id}/roles".replaceAll("\\{restriction_query_id\\}", this.apiClient.escapeString(restrictionQueryId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.addRoleToRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public RestrictionQueryWithoutRelationshipsResponse createRestrictionQuery(RestrictionQueryCreatePayload body) throws ApiException {
        return this.createRestrictionQueryWithHttpInfo(body).getData();
    }

    public CompletableFuture<RestrictionQueryWithoutRelationshipsResponse> createRestrictionQueryAsync(RestrictionQueryCreatePayload body) {
        return this.createRestrictionQueryWithHttpInfoAsync(body).thenApply(response -> (RestrictionQueryWithoutRelationshipsResponse)response.getData());
    }

    public ApiResponse<RestrictionQueryWithoutRelationshipsResponse> createRestrictionQueryWithHttpInfo(RestrictionQueryCreatePayload body) throws ApiException {
        String operationId = "createRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        RestrictionQueryCreatePayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createRestrictionQuery");
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.createRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryWithoutRelationshipsResponse>(){});
    }

    public CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>> createRestrictionQueryWithHttpInfoAsync(RestrictionQueryCreatePayload body) {
        Invocation.Builder builder;
        String operationId = "createRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        RestrictionQueryCreatePayload localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createRestrictionQuery"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.createRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryWithoutRelationshipsResponse>(){});
    }

    public void deleteRestrictionQuery(String restrictionQueryId) throws ApiException {
        this.deleteRestrictionQueryWithHttpInfo(restrictionQueryId);
    }

    public CompletableFuture<Void> deleteRestrictionQueryAsync(String restrictionQueryId) {
        return this.deleteRestrictionQueryWithHttpInfoAsync(restrictionQueryId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteRestrictionQueryWithHttpInfo(String restrictionQueryId) throws ApiException {
        String operationId = "deleteRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (restrictionQueryId == null) {
            throw new ApiException(400, "Missing the required parameter 'restrictionQueryId' when calling deleteRestrictionQuery");
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/{restriction_query_id}".replaceAll("\\{restriction_query_id\\}", this.apiClient.escapeString(restrictionQueryId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.deleteRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteRestrictionQueryWithHttpInfoAsync(String restrictionQueryId) {
        Invocation.Builder builder;
        String operationId = "deleteRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (restrictionQueryId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'restrictionQueryId' when calling deleteRestrictionQuery"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/{restriction_query_id}".replaceAll("\\{restriction_query_id\\}", this.apiClient.escapeString(restrictionQueryId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.deleteRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public RestrictionQueryWithRelationshipsResponse getRestrictionQuery(String restrictionQueryId) throws ApiException {
        return this.getRestrictionQueryWithHttpInfo(restrictionQueryId).getData();
    }

    public CompletableFuture<RestrictionQueryWithRelationshipsResponse> getRestrictionQueryAsync(String restrictionQueryId) {
        return this.getRestrictionQueryWithHttpInfoAsync(restrictionQueryId).thenApply(response -> (RestrictionQueryWithRelationshipsResponse)response.getData());
    }

    public ApiResponse<RestrictionQueryWithRelationshipsResponse> getRestrictionQueryWithHttpInfo(String restrictionQueryId) throws ApiException {
        String operationId = "getRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (restrictionQueryId == null) {
            throw new ApiException(400, "Missing the required parameter 'restrictionQueryId' when calling getRestrictionQuery");
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/{restriction_query_id}".replaceAll("\\{restriction_query_id\\}", this.apiClient.escapeString(restrictionQueryId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.getRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryWithRelationshipsResponse>(){});
    }

    public CompletableFuture<ApiResponse<RestrictionQueryWithRelationshipsResponse>> getRestrictionQueryWithHttpInfoAsync(String restrictionQueryId) {
        Invocation.Builder builder;
        String operationId = "getRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<RestrictionQueryWithRelationshipsResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryWithRelationshipsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (restrictionQueryId == null) {
            CompletableFuture<ApiResponse<RestrictionQueryWithRelationshipsResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryWithRelationshipsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'restrictionQueryId' when calling getRestrictionQuery"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/{restriction_query_id}".replaceAll("\\{restriction_query_id\\}", this.apiClient.escapeString(restrictionQueryId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.getRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RestrictionQueryWithRelationshipsResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryWithRelationshipsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryWithRelationshipsResponse>(){});
    }

    public RestrictionQueryListResponse getRoleRestrictionQuery(String roleId) throws ApiException {
        return this.getRoleRestrictionQueryWithHttpInfo(roleId).getData();
    }

    public CompletableFuture<RestrictionQueryListResponse> getRoleRestrictionQueryAsync(String roleId) {
        return this.getRoleRestrictionQueryWithHttpInfoAsync(roleId).thenApply(response -> (RestrictionQueryListResponse)response.getData());
    }

    public ApiResponse<RestrictionQueryListResponse> getRoleRestrictionQueryWithHttpInfo(String roleId) throws ApiException {
        String operationId = "getRoleRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling getRoleRestrictionQuery");
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/role/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.getRoleRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryListResponse>(){});
    }

    public CompletableFuture<ApiResponse<RestrictionQueryListResponse>> getRoleRestrictionQueryWithHttpInfoAsync(String roleId) {
        Invocation.Builder builder;
        String operationId = "getRoleRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<RestrictionQueryListResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryListResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (roleId == null) {
            CompletableFuture<ApiResponse<RestrictionQueryListResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'roleId' when calling getRoleRestrictionQuery"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/role/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.getRoleRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RestrictionQueryListResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryListResponse>(){});
    }

    public RestrictionQueryListResponse listRestrictionQueries() throws ApiException {
        return this.listRestrictionQueriesWithHttpInfo(new ListRestrictionQueriesOptionalParameters()).getData();
    }

    public CompletableFuture<RestrictionQueryListResponse> listRestrictionQueriesAsync() {
        return this.listRestrictionQueriesWithHttpInfoAsync(new ListRestrictionQueriesOptionalParameters()).thenApply(response -> (RestrictionQueryListResponse)response.getData());
    }

    public RestrictionQueryListResponse listRestrictionQueries(ListRestrictionQueriesOptionalParameters parameters) throws ApiException {
        return this.listRestrictionQueriesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<RestrictionQueryListResponse> listRestrictionQueriesAsync(ListRestrictionQueriesOptionalParameters parameters) {
        return this.listRestrictionQueriesWithHttpInfoAsync(parameters).thenApply(response -> (RestrictionQueryListResponse)response.getData());
    }

    public ApiResponse<RestrictionQueryListResponse> listRestrictionQueriesWithHttpInfo(ListRestrictionQueriesOptionalParameters parameters) throws ApiException {
        String operationId = "listRestrictionQueries";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/logs/config/restriction_queries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.listRestrictionQueries", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryListResponse>(){});
    }

    public CompletableFuture<ApiResponse<RestrictionQueryListResponse>> listRestrictionQueriesWithHttpInfoAsync(ListRestrictionQueriesOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listRestrictionQueries";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<RestrictionQueryListResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryListResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/logs/config/restriction_queries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        try {
            builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.listRestrictionQueries", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RestrictionQueryListResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryListResponse>(){});
    }

    public RestrictionQueryRolesResponse listRestrictionQueryRoles(String restrictionQueryId) throws ApiException {
        return this.listRestrictionQueryRolesWithHttpInfo(restrictionQueryId, new ListRestrictionQueryRolesOptionalParameters()).getData();
    }

    public CompletableFuture<RestrictionQueryRolesResponse> listRestrictionQueryRolesAsync(String restrictionQueryId) {
        return this.listRestrictionQueryRolesWithHttpInfoAsync(restrictionQueryId, new ListRestrictionQueryRolesOptionalParameters()).thenApply(response -> (RestrictionQueryRolesResponse)response.getData());
    }

    public RestrictionQueryRolesResponse listRestrictionQueryRoles(String restrictionQueryId, ListRestrictionQueryRolesOptionalParameters parameters) throws ApiException {
        return this.listRestrictionQueryRolesWithHttpInfo(restrictionQueryId, parameters).getData();
    }

    public CompletableFuture<RestrictionQueryRolesResponse> listRestrictionQueryRolesAsync(String restrictionQueryId, ListRestrictionQueryRolesOptionalParameters parameters) {
        return this.listRestrictionQueryRolesWithHttpInfoAsync(restrictionQueryId, parameters).thenApply(response -> (RestrictionQueryRolesResponse)response.getData());
    }

    public ApiResponse<RestrictionQueryRolesResponse> listRestrictionQueryRolesWithHttpInfo(String restrictionQueryId, ListRestrictionQueryRolesOptionalParameters parameters) throws ApiException {
        String operationId = "listRestrictionQueryRoles";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (restrictionQueryId == null) {
            throw new ApiException(400, "Missing the required parameter 'restrictionQueryId' when calling listRestrictionQueryRoles");
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/logs/config/restriction_queries/{restriction_query_id}/roles".replaceAll("\\{restriction_query_id\\}", this.apiClient.escapeString(restrictionQueryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.listRestrictionQueryRoles", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryRolesResponse>(){});
    }

    public CompletableFuture<ApiResponse<RestrictionQueryRolesResponse>> listRestrictionQueryRolesWithHttpInfoAsync(String restrictionQueryId, ListRestrictionQueryRolesOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listRestrictionQueryRoles";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<RestrictionQueryRolesResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryRolesResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (restrictionQueryId == null) {
            CompletableFuture<ApiResponse<RestrictionQueryRolesResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryRolesResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'restrictionQueryId' when calling listRestrictionQueryRoles"));
            return result;
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/logs/config/restriction_queries/{restriction_query_id}/roles".replaceAll("\\{restriction_query_id\\}", this.apiClient.escapeString(restrictionQueryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        try {
            builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.listRestrictionQueryRoles", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RestrictionQueryRolesResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryRolesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryRolesResponse>(){});
    }

    public RestrictionQueryListResponse listUserRestrictionQueries(String userId) throws ApiException {
        return this.listUserRestrictionQueriesWithHttpInfo(userId).getData();
    }

    public CompletableFuture<RestrictionQueryListResponse> listUserRestrictionQueriesAsync(String userId) {
        return this.listUserRestrictionQueriesWithHttpInfoAsync(userId).thenApply(response -> (RestrictionQueryListResponse)response.getData());
    }

    public ApiResponse<RestrictionQueryListResponse> listUserRestrictionQueriesWithHttpInfo(String userId) throws ApiException {
        String operationId = "listUserRestrictionQueries";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listUserRestrictionQueries");
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/user/{user_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.listUserRestrictionQueries", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryListResponse>(){});
    }

    public CompletableFuture<ApiResponse<RestrictionQueryListResponse>> listUserRestrictionQueriesWithHttpInfoAsync(String userId) {
        Invocation.Builder builder;
        String operationId = "listUserRestrictionQueries";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<RestrictionQueryListResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryListResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (userId == null) {
            CompletableFuture<ApiResponse<RestrictionQueryListResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling listUserRestrictionQueries"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/user/{user_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.listUserRestrictionQueries", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RestrictionQueryListResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryListResponse>(){});
    }

    public void removeRoleFromRestrictionQuery(String restrictionQueryId, RelationshipToRole body) throws ApiException {
        this.removeRoleFromRestrictionQueryWithHttpInfo(restrictionQueryId, body);
    }

    public CompletableFuture<Void> removeRoleFromRestrictionQueryAsync(String restrictionQueryId, RelationshipToRole body) {
        return this.removeRoleFromRestrictionQueryWithHttpInfoAsync(restrictionQueryId, body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> removeRoleFromRestrictionQueryWithHttpInfo(String restrictionQueryId, RelationshipToRole body) throws ApiException {
        String operationId = "removeRoleFromRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        RelationshipToRole localVarPostBody = body;
        if (restrictionQueryId == null) {
            throw new ApiException(400, "Missing the required parameter 'restrictionQueryId' when calling removeRoleFromRestrictionQuery");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling removeRoleFromRestrictionQuery");
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/{restriction_query_id}/roles".replaceAll("\\{restriction_query_id\\}", this.apiClient.escapeString(restrictionQueryId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.removeRoleFromRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> removeRoleFromRestrictionQueryWithHttpInfoAsync(String restrictionQueryId, RelationshipToRole body) {
        Invocation.Builder builder;
        String operationId = "removeRoleFromRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        RelationshipToRole localVarPostBody = body;
        if (restrictionQueryId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'restrictionQueryId' when calling removeRoleFromRestrictionQuery"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling removeRoleFromRestrictionQuery"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/{restriction_query_id}/roles".replaceAll("\\{restriction_query_id\\}", this.apiClient.escapeString(restrictionQueryId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.removeRoleFromRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public RestrictionQueryWithoutRelationshipsResponse replaceRestrictionQuery(String restrictionQueryId, RestrictionQueryUpdatePayload body) throws ApiException {
        return this.replaceRestrictionQueryWithHttpInfo(restrictionQueryId, body).getData();
    }

    public CompletableFuture<RestrictionQueryWithoutRelationshipsResponse> replaceRestrictionQueryAsync(String restrictionQueryId, RestrictionQueryUpdatePayload body) {
        return this.replaceRestrictionQueryWithHttpInfoAsync(restrictionQueryId, body).thenApply(response -> (RestrictionQueryWithoutRelationshipsResponse)response.getData());
    }

    public ApiResponse<RestrictionQueryWithoutRelationshipsResponse> replaceRestrictionQueryWithHttpInfo(String restrictionQueryId, RestrictionQueryUpdatePayload body) throws ApiException {
        String operationId = "replaceRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        RestrictionQueryUpdatePayload localVarPostBody = body;
        if (restrictionQueryId == null) {
            throw new ApiException(400, "Missing the required parameter 'restrictionQueryId' when calling replaceRestrictionQuery");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling replaceRestrictionQuery");
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/{restriction_query_id}".replaceAll("\\{restriction_query_id\\}", this.apiClient.escapeString(restrictionQueryId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.replaceRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryWithoutRelationshipsResponse>(){});
    }

    public CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>> replaceRestrictionQueryWithHttpInfoAsync(String restrictionQueryId, RestrictionQueryUpdatePayload body) {
        Invocation.Builder builder;
        String operationId = "replaceRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        RestrictionQueryUpdatePayload localVarPostBody = body;
        if (restrictionQueryId == null) {
            CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'restrictionQueryId' when calling replaceRestrictionQuery"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling replaceRestrictionQuery"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/{restriction_query_id}".replaceAll("\\{restriction_query_id\\}", this.apiClient.escapeString(restrictionQueryId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.replaceRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryWithoutRelationshipsResponse>(){});
    }

    public RestrictionQueryWithoutRelationshipsResponse updateRestrictionQuery(String restrictionQueryId, RestrictionQueryUpdatePayload body) throws ApiException {
        return this.updateRestrictionQueryWithHttpInfo(restrictionQueryId, body).getData();
    }

    public CompletableFuture<RestrictionQueryWithoutRelationshipsResponse> updateRestrictionQueryAsync(String restrictionQueryId, RestrictionQueryUpdatePayload body) {
        return this.updateRestrictionQueryWithHttpInfoAsync(restrictionQueryId, body).thenApply(response -> (RestrictionQueryWithoutRelationshipsResponse)response.getData());
    }

    public ApiResponse<RestrictionQueryWithoutRelationshipsResponse> updateRestrictionQueryWithHttpInfo(String restrictionQueryId, RestrictionQueryUpdatePayload body) throws ApiException {
        String operationId = "updateRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        RestrictionQueryUpdatePayload localVarPostBody = body;
        if (restrictionQueryId == null) {
            throw new ApiException(400, "Missing the required parameter 'restrictionQueryId' when calling updateRestrictionQuery");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateRestrictionQuery");
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/{restriction_query_id}".replaceAll("\\{restriction_query_id\\}", this.apiClient.escapeString(restrictionQueryId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.updateRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryWithoutRelationshipsResponse>(){});
    }

    public CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>> updateRestrictionQueryWithHttpInfoAsync(String restrictionQueryId, RestrictionQueryUpdatePayload body) {
        Invocation.Builder builder;
        String operationId = "updateRestrictionQuery";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        RestrictionQueryUpdatePayload localVarPostBody = body;
        if (restrictionQueryId == null) {
            CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'restrictionQueryId' when calling updateRestrictionQuery"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateRestrictionQuery"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/restriction_queries/{restriction_query_id}".replaceAll("\\{restriction_query_id\\}", this.apiClient.escapeString(restrictionQueryId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsRestrictionQueriesApi.updateRestrictionQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>> result = new CompletableFuture<ApiResponse<RestrictionQueryWithoutRelationshipsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionQueryWithoutRelationshipsResponse>(){});
    }

    public static class ListRestrictionQueryRolesOptionalParameters {
        private Long pageSize;
        private Long pageNumber;

        public ListRestrictionQueryRolesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListRestrictionQueryRolesOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }
    }

    public static class ListRestrictionQueriesOptionalParameters {
        private Long pageSize;
        private Long pageNumber;

        public ListRestrictionQueriesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListRestrictionQueriesOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }
    }
}

