/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.NotificationChannelPhoneConfigType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"formatted_number", "number", "region", "sms_subscribed_at", "type", "verified"})
public class NotificationChannelPhoneConfig {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FORMATTED_NUMBER = "formatted_number";
    private String formattedNumber;
    public static final String JSON_PROPERTY_NUMBER = "number";
    private String number;
    public static final String JSON_PROPERTY_REGION = "region";
    private String region;
    public static final String JSON_PROPERTY_SMS_SUBSCRIBED_AT = "sms_subscribed_at";
    private JsonNullable<OffsetDateTime> smsSubscribedAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TYPE = "type";
    private NotificationChannelPhoneConfigType type = NotificationChannelPhoneConfigType.PHONE;
    public static final String JSON_PROPERTY_VERIFIED = "verified";
    private Boolean verified;
    private Map<String, Object> additionalProperties;

    public NotificationChannelPhoneConfig() {
    }

    @JsonCreator
    public NotificationChannelPhoneConfig(@JsonProperty(required=true, value="formatted_number") String formattedNumber, @JsonProperty(required=true, value="number") String number, @JsonProperty(required=true, value="region") String region, @JsonProperty(required=true, value="type") NotificationChannelPhoneConfigType type, @JsonProperty(required=true, value="verified") Boolean verified) {
        this.formattedNumber = formattedNumber;
        this.number = number;
        this.region = region;
        this.type = type;
        this.unparsed |= !type.isValid();
        this.verified = verified;
    }

    public NotificationChannelPhoneConfig formattedNumber(String formattedNumber) {
        this.formattedNumber = formattedNumber;
        return this;
    }

    @JsonProperty(value="formatted_number")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFormattedNumber() {
        return this.formattedNumber;
    }

    public void setFormattedNumber(String formattedNumber) {
        this.formattedNumber = formattedNumber;
    }

    public NotificationChannelPhoneConfig number(String number) {
        this.number = number;
        return this;
    }

    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public NotificationChannelPhoneConfig region(String region) {
        this.region = region;
        return this;
    }

    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public NotificationChannelPhoneConfig smsSubscribedAt(OffsetDateTime smsSubscribedAt) {
        this.smsSubscribedAt = JsonNullable.of((Object)smsSubscribedAt);
        return this;
    }

    @Nullable
    @JsonIgnore
    public OffsetDateTime getSmsSubscribedAt() {
        return (OffsetDateTime)this.smsSubscribedAt.orElse(null);
    }

    @JsonProperty(value="sms_subscribed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getSmsSubscribedAt_JsonNullable() {
        return this.smsSubscribedAt;
    }

    @JsonProperty(value="sms_subscribed_at")
    public void setSmsSubscribedAt_JsonNullable(JsonNullable<OffsetDateTime> smsSubscribedAt) {
        this.smsSubscribedAt = smsSubscribedAt;
    }

    public void setSmsSubscribedAt(OffsetDateTime smsSubscribedAt) {
        this.smsSubscribedAt = JsonNullable.of((Object)smsSubscribedAt);
    }

    public NotificationChannelPhoneConfig type(NotificationChannelPhoneConfigType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NotificationChannelPhoneConfigType getType() {
        return this.type;
    }

    public void setType(NotificationChannelPhoneConfigType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public NotificationChannelPhoneConfig verified(Boolean verified) {
        this.verified = verified;
        return this;
    }

    @JsonProperty(value="verified")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getVerified() {
        return this.verified;
    }

    public void setVerified(Boolean verified) {
        this.verified = verified;
    }

    @JsonAnySetter
    public NotificationChannelPhoneConfig putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationChannelPhoneConfig notificationChannelPhoneConfig = (NotificationChannelPhoneConfig)o;
        return Objects.equals(this.formattedNumber, notificationChannelPhoneConfig.formattedNumber) && Objects.equals(this.number, notificationChannelPhoneConfig.number) && Objects.equals(this.region, notificationChannelPhoneConfig.region) && Objects.equals(this.smsSubscribedAt, notificationChannelPhoneConfig.smsSubscribedAt) && Objects.equals(this.type, notificationChannelPhoneConfig.type) && Objects.equals(this.verified, notificationChannelPhoneConfig.verified) && Objects.equals(this.additionalProperties, notificationChannelPhoneConfig.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.formattedNumber, this.number, this.region, this.smsSubscribedAt, this.type, this.verified, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationChannelPhoneConfig {\n");
        sb.append("    formattedNumber: ").append(this.toIndentedString(this.formattedNumber)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    smsSubscribedAt: ").append(this.toIndentedString(this.smsSubscribedAt)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    verified: ").append(this.toIndentedString(this.verified)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

