/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.MonitorAssetCategory;
import com.datadog.api.client.v1.model.MonitorAssetResourceType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"category", "name", "resource_key", "resource_type", "url"})
public class MonitorAsset {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private MonitorAssetCategory category;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_RESOURCE_KEY = "resource_key";
    private String resourceKey;
    public static final String JSON_PROPERTY_RESOURCE_TYPE = "resource_type";
    private MonitorAssetResourceType resourceType;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    private Map<String, Object> additionalProperties;

    public MonitorAsset() {
    }

    @JsonCreator
    public MonitorAsset(@JsonProperty(required=true, value="category") MonitorAssetCategory category, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="url") String url) {
        this.category = category;
        this.unparsed |= !category.isValid();
        this.name = name;
        this.url = url;
    }

    public MonitorAsset category(MonitorAssetCategory category) {
        this.category = category;
        this.unparsed |= !category.isValid();
        return this;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MonitorAssetCategory getCategory() {
        return this.category;
    }

    public void setCategory(MonitorAssetCategory category) {
        if (!category.isValid()) {
            this.unparsed = true;
        }
        this.category = category;
    }

    public MonitorAsset name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MonitorAsset resourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="resource_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResourceKey() {
        return this.resourceKey;
    }

    public void setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    public MonitorAsset resourceType(MonitorAssetResourceType resourceType) {
        this.resourceType = resourceType;
        this.unparsed |= !resourceType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="resource_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorAssetResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(MonitorAssetResourceType resourceType) {
        if (!resourceType.isValid()) {
            this.unparsed = true;
        }
        this.resourceType = resourceType;
    }

    public MonitorAsset url(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @JsonAnySetter
    public MonitorAsset putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitorAsset monitorAsset = (MonitorAsset)o;
        return Objects.equals(this.category, monitorAsset.category) && Objects.equals(this.name, monitorAsset.name) && Objects.equals(this.resourceKey, monitorAsset.resourceKey) && Objects.equals(this.resourceType, monitorAsset.resourceType) && Objects.equals(this.url, monitorAsset.url) && Objects.equals(this.additionalProperties, monitorAsset.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.name, this.resourceKey, this.resourceType, this.url, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonitorAsset {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resourceKey: ").append(this.toIndentedString(this.resourceKey)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString(this.resourceType)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

