/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ActionQueryProperties;
import com.datadog.api.client.v2.model.ActionQueryType;
import com.datadog.api.client.v2.model.AppBuilderEvent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"events", "id", "name", "properties", "type"})
public class ActionQuery {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_EVENTS = "events";
    private List<AppBuilderEvent> events = null;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private ActionQueryProperties properties;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ActionQueryType type = ActionQueryType.ACTION;
    private Map<String, Object> additionalProperties;

    public ActionQuery() {
    }

    @JsonCreator
    public ActionQuery(@JsonProperty(required=true, value="id") UUID id, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="properties") ActionQueryProperties properties, @JsonProperty(required=true, value="type") ActionQueryType type) {
        this.id = id;
        this.name = name;
        this.properties = properties;
        this.unparsed |= properties.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public ActionQuery events(List<AppBuilderEvent> events) {
        this.events = events;
        for (AppBuilderEvent item : events) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ActionQuery addEventsItem(AppBuilderEvent eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<AppBuilderEvent>();
        }
        this.events.add(eventsItem);
        this.unparsed |= eventsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AppBuilderEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<AppBuilderEvent> events) {
        this.events = events;
    }

    public ActionQuery id(UUID id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public ActionQuery name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ActionQuery properties(ActionQueryProperties properties) {
        this.properties = properties;
        this.unparsed |= properties.unparsed;
        return this;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ActionQueryProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ActionQueryProperties properties) {
        this.properties = properties;
    }

    public ActionQuery type(ActionQueryType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ActionQueryType getType() {
        return this.type;
    }

    public void setType(ActionQueryType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public ActionQuery putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionQuery actionQuery = (ActionQuery)o;
        return Objects.equals(this.events, actionQuery.events) && Objects.equals(this.id, actionQuery.id) && Objects.equals(this.name, actionQuery.name) && Objects.equals(this.properties, actionQuery.properties) && Objects.equals(this.type, actionQuery.type) && Objects.equals(this.additionalProperties, actionQuery.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.events, this.id, this.name, this.properties, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionQuery {\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

