/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ReferenceTableSourceType;
import com.datadog.api.client.v2.model.TableResultV2DataAttributesFileMetadata;
import com.datadog.api.client.v2.model.TableResultV2DataAttributesSchema;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"created_by", "description", "file_metadata", "last_updated_by", "row_count", "schema", "source", "status", "table_name", "tags", "updated_at"})
public class TableResultV2DataAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CREATED_BY = "created_by";
    private String createdBy;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_FILE_METADATA = "file_metadata";
    private TableResultV2DataAttributesFileMetadata fileMetadata;
    public static final String JSON_PROPERTY_LAST_UPDATED_BY = "last_updated_by";
    private String lastUpdatedBy;
    public static final String JSON_PROPERTY_ROW_COUNT = "row_count";
    private Long rowCount;
    public static final String JSON_PROPERTY_SCHEMA = "schema";
    private TableResultV2DataAttributesSchema schema;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private ReferenceTableSourceType source;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_TABLE_NAME = "table_name";
    private String tableName;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private String updatedAt;
    private Map<String, Object> additionalProperties;

    public TableResultV2DataAttributes createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public TableResultV2DataAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TableResultV2DataAttributes fileMetadata(TableResultV2DataAttributesFileMetadata fileMetadata) {
        this.fileMetadata = fileMetadata;
        this.unparsed |= fileMetadata.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="file_metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TableResultV2DataAttributesFileMetadata getFileMetadata() {
        return this.fileMetadata;
    }

    public void setFileMetadata(TableResultV2DataAttributesFileMetadata fileMetadata) {
        this.fileMetadata = fileMetadata;
    }

    public TableResultV2DataAttributes lastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="last_updated_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public TableResultV2DataAttributes rowCount(Long rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    @Nullable
    @JsonProperty(value="row_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(Long rowCount) {
        this.rowCount = rowCount;
    }

    public TableResultV2DataAttributes schema(TableResultV2DataAttributesSchema schema) {
        this.schema = schema;
        this.unparsed |= schema.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TableResultV2DataAttributesSchema getSchema() {
        return this.schema;
    }

    public void setSchema(TableResultV2DataAttributesSchema schema) {
        this.schema = schema;
    }

    public TableResultV2DataAttributes source(ReferenceTableSourceType source) {
        this.source = source;
        this.unparsed |= !source.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReferenceTableSourceType getSource() {
        return this.source;
    }

    public void setSource(ReferenceTableSourceType source) {
        if (!source.isValid()) {
            this.unparsed = true;
        }
        this.source = source;
    }

    public TableResultV2DataAttributes status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public TableResultV2DataAttributes tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    @Nullable
    @JsonProperty(value="table_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public TableResultV2DataAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public TableResultV2DataAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public TableResultV2DataAttributes updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonAnySetter
    public TableResultV2DataAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableResultV2DataAttributes tableResultV2DataAttributes = (TableResultV2DataAttributes)o;
        return Objects.equals(this.createdBy, tableResultV2DataAttributes.createdBy) && Objects.equals(this.description, tableResultV2DataAttributes.description) && Objects.equals(this.fileMetadata, tableResultV2DataAttributes.fileMetadata) && Objects.equals(this.lastUpdatedBy, tableResultV2DataAttributes.lastUpdatedBy) && Objects.equals(this.rowCount, tableResultV2DataAttributes.rowCount) && Objects.equals(this.schema, tableResultV2DataAttributes.schema) && Objects.equals(this.source, tableResultV2DataAttributes.source) && Objects.equals(this.status, tableResultV2DataAttributes.status) && Objects.equals(this.tableName, tableResultV2DataAttributes.tableName) && Objects.equals(this.tags, tableResultV2DataAttributes.tags) && Objects.equals(this.updatedAt, tableResultV2DataAttributes.updatedAt) && Objects.equals(this.additionalProperties, tableResultV2DataAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.createdBy, this.description, this.fileMetadata, this.lastUpdatedBy, this.rowCount, this.schema, this.source, this.status, this.tableName, this.tags, this.updatedAt, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableResultV2DataAttributes {\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    fileMetadata: ").append(this.toIndentedString(this.fileMetadata)).append("\n");
        sb.append("    lastUpdatedBy: ").append(this.toIndentedString(this.lastUpdatedBy)).append("\n");
        sb.append("    rowCount: ").append(this.toIndentedString(this.rowCount)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    tableName: ").append(this.toIndentedString(this.tableName)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

