/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ScaRequestDataAttributesCommit;
import com.datadog.api.client.v2.model.ScaRequestDataAttributesDependenciesItems;
import com.datadog.api.client.v2.model.ScaRequestDataAttributesFilesItems;
import com.datadog.api.client.v2.model.ScaRequestDataAttributesRelationsItems;
import com.datadog.api.client.v2.model.ScaRequestDataAttributesRepository;
import com.datadog.api.client.v2.model.ScaRequestDataAttributesVulnerabilitiesItems;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"commit", "dependencies", "env", "files", "relations", "repository", "service", "tags", "vulnerabilities"})
public class ScaRequestDataAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_COMMIT = "commit";
    private ScaRequestDataAttributesCommit commit;
    public static final String JSON_PROPERTY_DEPENDENCIES = "dependencies";
    private List<ScaRequestDataAttributesDependenciesItems> dependencies = null;
    public static final String JSON_PROPERTY_ENV = "env";
    private String env;
    public static final String JSON_PROPERTY_FILES = "files";
    private List<ScaRequestDataAttributesFilesItems> files = null;
    public static final String JSON_PROPERTY_RELATIONS = "relations";
    private List<ScaRequestDataAttributesRelationsItems> relations = null;
    public static final String JSON_PROPERTY_REPOSITORY = "repository";
    private ScaRequestDataAttributesRepository repository;
    public static final String JSON_PROPERTY_SERVICE = "service";
    private String service;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, String> tags = null;
    public static final String JSON_PROPERTY_VULNERABILITIES = "vulnerabilities";
    private List<ScaRequestDataAttributesVulnerabilitiesItems> vulnerabilities = null;
    private Map<String, Object> additionalProperties;

    public ScaRequestDataAttributes commit(ScaRequestDataAttributesCommit commit) {
        this.commit = commit;
        this.unparsed |= commit.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="commit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScaRequestDataAttributesCommit getCommit() {
        return this.commit;
    }

    public void setCommit(ScaRequestDataAttributesCommit commit) {
        this.commit = commit;
    }

    public ScaRequestDataAttributes dependencies(List<ScaRequestDataAttributesDependenciesItems> dependencies) {
        this.dependencies = dependencies;
        for (ScaRequestDataAttributesDependenciesItems item : dependencies) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ScaRequestDataAttributes addDependenciesItem(ScaRequestDataAttributesDependenciesItems dependenciesItem) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<ScaRequestDataAttributesDependenciesItems>();
        }
        this.dependencies.add(dependenciesItem);
        this.unparsed |= dependenciesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="dependencies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ScaRequestDataAttributesDependenciesItems> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<ScaRequestDataAttributesDependenciesItems> dependencies) {
        this.dependencies = dependencies;
    }

    public ScaRequestDataAttributes env(String env) {
        this.env = env;
        return this;
    }

    @Nullable
    @JsonProperty(value="env")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public ScaRequestDataAttributes files(List<ScaRequestDataAttributesFilesItems> files) {
        this.files = files;
        for (ScaRequestDataAttributesFilesItems item : files) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ScaRequestDataAttributes addFilesItem(ScaRequestDataAttributesFilesItems filesItem) {
        if (this.files == null) {
            this.files = new ArrayList<ScaRequestDataAttributesFilesItems>();
        }
        this.files.add(filesItem);
        this.unparsed |= filesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="files")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ScaRequestDataAttributesFilesItems> getFiles() {
        return this.files;
    }

    public void setFiles(List<ScaRequestDataAttributesFilesItems> files) {
        this.files = files;
    }

    public ScaRequestDataAttributes relations(List<ScaRequestDataAttributesRelationsItems> relations) {
        this.relations = relations;
        for (ScaRequestDataAttributesRelationsItems item : relations) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ScaRequestDataAttributes addRelationsItem(ScaRequestDataAttributesRelationsItems relationsItem) {
        if (this.relations == null) {
            this.relations = new ArrayList<ScaRequestDataAttributesRelationsItems>();
        }
        this.relations.add(relationsItem);
        this.unparsed |= relationsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="relations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ScaRequestDataAttributesRelationsItems> getRelations() {
        return this.relations;
    }

    public void setRelations(List<ScaRequestDataAttributesRelationsItems> relations) {
        this.relations = relations;
    }

    public ScaRequestDataAttributes repository(ScaRequestDataAttributesRepository repository) {
        this.repository = repository;
        this.unparsed |= repository.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="repository")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScaRequestDataAttributesRepository getRepository() {
        return this.repository;
    }

    public void setRepository(ScaRequestDataAttributesRepository repository) {
        this.repository = repository;
    }

    public ScaRequestDataAttributes service(String service) {
        this.service = service;
        return this;
    }

    @Nullable
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public ScaRequestDataAttributes tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ScaRequestDataAttributes putTagsItem(String key, String tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public ScaRequestDataAttributes vulnerabilities(List<ScaRequestDataAttributesVulnerabilitiesItems> vulnerabilities) {
        this.vulnerabilities = vulnerabilities;
        for (ScaRequestDataAttributesVulnerabilitiesItems item : vulnerabilities) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ScaRequestDataAttributes addVulnerabilitiesItem(ScaRequestDataAttributesVulnerabilitiesItems vulnerabilitiesItem) {
        if (this.vulnerabilities == null) {
            this.vulnerabilities = new ArrayList<ScaRequestDataAttributesVulnerabilitiesItems>();
        }
        this.vulnerabilities.add(vulnerabilitiesItem);
        this.unparsed |= vulnerabilitiesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="vulnerabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ScaRequestDataAttributesVulnerabilitiesItems> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public void setVulnerabilities(List<ScaRequestDataAttributesVulnerabilitiesItems> vulnerabilities) {
        this.vulnerabilities = vulnerabilities;
    }

    @JsonAnySetter
    public ScaRequestDataAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScaRequestDataAttributes scaRequestDataAttributes = (ScaRequestDataAttributes)o;
        return Objects.equals(this.commit, scaRequestDataAttributes.commit) && Objects.equals(this.dependencies, scaRequestDataAttributes.dependencies) && Objects.equals(this.env, scaRequestDataAttributes.env) && Objects.equals(this.files, scaRequestDataAttributes.files) && Objects.equals(this.relations, scaRequestDataAttributes.relations) && Objects.equals(this.repository, scaRequestDataAttributes.repository) && Objects.equals(this.service, scaRequestDataAttributes.service) && Objects.equals(this.tags, scaRequestDataAttributes.tags) && Objects.equals(this.vulnerabilities, scaRequestDataAttributes.vulnerabilities) && Objects.equals(this.additionalProperties, scaRequestDataAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.commit, this.dependencies, this.env, this.files, this.relations, this.repository, this.service, this.tags, this.vulnerabilities, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScaRequestDataAttributes {\n");
        sb.append("    commit: ").append(this.toIndentedString(this.commit)).append("\n");
        sb.append("    dependencies: ").append(this.toIndentedString(this.dependencies)).append("\n");
        sb.append("    env: ").append(this.toIndentedString(this.env)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("    relations: ").append(this.toIndentedString(this.relations)).append("\n");
        sb.append("    repository: ").append(this.toIndentedString(this.repository)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    vulnerabilities: ").append(this.toIndentedString(this.vulnerabilities)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

