/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ObservabilityPipelineConfigDestinationItem;
import com.datadog.api.client.v2.model.ObservabilityPipelineConfigProcessorItem;
import com.datadog.api.client.v2.model.ObservabilityPipelineConfigSourceItem;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"destinations", "processors", "sources"})
public class ObservabilityPipelineConfig {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DESTINATIONS = "destinations";
    private List<ObservabilityPipelineConfigDestinationItem> destinations = new ArrayList<ObservabilityPipelineConfigDestinationItem>();
    public static final String JSON_PROPERTY_PROCESSORS = "processors";
    private List<ObservabilityPipelineConfigProcessorItem> processors = null;
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private List<ObservabilityPipelineConfigSourceItem> sources = new ArrayList<ObservabilityPipelineConfigSourceItem>();
    private Map<String, Object> additionalProperties;

    public ObservabilityPipelineConfig() {
    }

    @JsonCreator
    public ObservabilityPipelineConfig(@JsonProperty(required=true, value="destinations") List<ObservabilityPipelineConfigDestinationItem> destinations, @JsonProperty(required=true, value="sources") List<ObservabilityPipelineConfigSourceItem> sources) {
        this.destinations = destinations;
        this.sources = sources;
    }

    public ObservabilityPipelineConfig destinations(List<ObservabilityPipelineConfigDestinationItem> destinations) {
        this.destinations = destinations;
        for (ObservabilityPipelineConfigDestinationItem item : destinations) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ObservabilityPipelineConfig addDestinationsItem(ObservabilityPipelineConfigDestinationItem destinationsItem) {
        this.destinations.add(destinationsItem);
        this.unparsed |= destinationsItem.unparsed;
        return this;
    }

    @JsonProperty(value="destinations")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<ObservabilityPipelineConfigDestinationItem> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(List<ObservabilityPipelineConfigDestinationItem> destinations) {
        this.destinations = destinations;
    }

    public ObservabilityPipelineConfig processors(List<ObservabilityPipelineConfigProcessorItem> processors) {
        this.processors = processors;
        for (ObservabilityPipelineConfigProcessorItem item : processors) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ObservabilityPipelineConfig addProcessorsItem(ObservabilityPipelineConfigProcessorItem processorsItem) {
        if (this.processors == null) {
            this.processors = new ArrayList<ObservabilityPipelineConfigProcessorItem>();
        }
        this.processors.add(processorsItem);
        this.unparsed |= processorsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="processors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ObservabilityPipelineConfigProcessorItem> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<ObservabilityPipelineConfigProcessorItem> processors) {
        this.processors = processors;
    }

    public ObservabilityPipelineConfig sources(List<ObservabilityPipelineConfigSourceItem> sources) {
        this.sources = sources;
        for (ObservabilityPipelineConfigSourceItem item : sources) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ObservabilityPipelineConfig addSourcesItem(ObservabilityPipelineConfigSourceItem sourcesItem) {
        this.sources.add(sourcesItem);
        this.unparsed |= sourcesItem.unparsed;
        return this;
    }

    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<ObservabilityPipelineConfigSourceItem> getSources() {
        return this.sources;
    }

    public void setSources(List<ObservabilityPipelineConfigSourceItem> sources) {
        this.sources = sources;
    }

    @JsonAnySetter
    public ObservabilityPipelineConfig putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObservabilityPipelineConfig observabilityPipelineConfig = (ObservabilityPipelineConfig)o;
        return Objects.equals(this.destinations, observabilityPipelineConfig.destinations) && Objects.equals(this.processors, observabilityPipelineConfig.processors) && Objects.equals(this.sources, observabilityPipelineConfig.sources) && Objects.equals(this.additionalProperties, observabilityPipelineConfig.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.destinations, this.processors, this.sources, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ObservabilityPipelineConfig {\n");
        sb.append("    destinations: ").append(this.toIndentedString(this.destinations)).append("\n");
        sb.append("    processors: ").append(this.toIndentedString(this.processors)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

