/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.Cpu;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"cpu", "ephemeral_storage", "heap", "memory", "overhead"})
public class Estimation {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CPU = "cpu";
    private Cpu cpu;
    public static final String JSON_PROPERTY_EPHEMERAL_STORAGE = "ephemeral_storage";
    private Long ephemeralStorage;
    public static final String JSON_PROPERTY_HEAP = "heap";
    private Long heap;
    public static final String JSON_PROPERTY_MEMORY = "memory";
    private Long memory;
    public static final String JSON_PROPERTY_OVERHEAD = "overhead";
    private Long overhead;
    private Map<String, Object> additionalProperties;

    public Estimation cpu(Cpu cpu) {
        this.cpu = cpu;
        this.unparsed |= cpu.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="cpu")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Cpu getCpu() {
        return this.cpu;
    }

    public void setCpu(Cpu cpu) {
        this.cpu = cpu;
    }

    public Estimation ephemeralStorage(Long ephemeralStorage) {
        this.ephemeralStorage = ephemeralStorage;
        return this;
    }

    @Nullable
    @JsonProperty(value="ephemeral_storage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEphemeralStorage() {
        return this.ephemeralStorage;
    }

    public void setEphemeralStorage(Long ephemeralStorage) {
        this.ephemeralStorage = ephemeralStorage;
    }

    public Estimation heap(Long heap) {
        this.heap = heap;
        return this;
    }

    @Nullable
    @JsonProperty(value="heap")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getHeap() {
        return this.heap;
    }

    public void setHeap(Long heap) {
        this.heap = heap;
    }

    public Estimation memory(Long memory) {
        this.memory = memory;
        return this;
    }

    @Nullable
    @JsonProperty(value="memory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMemory() {
        return this.memory;
    }

    public void setMemory(Long memory) {
        this.memory = memory;
    }

    public Estimation overhead(Long overhead) {
        this.overhead = overhead;
        return this;
    }

    @Nullable
    @JsonProperty(value="overhead")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getOverhead() {
        return this.overhead;
    }

    public void setOverhead(Long overhead) {
        this.overhead = overhead;
    }

    @JsonAnySetter
    public Estimation putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Estimation estimation = (Estimation)o;
        return Objects.equals(this.cpu, estimation.cpu) && Objects.equals(this.ephemeralStorage, estimation.ephemeralStorage) && Objects.equals(this.heap, estimation.heap) && Objects.equals(this.memory, estimation.memory) && Objects.equals(this.overhead, estimation.overhead) && Objects.equals(this.additionalProperties, estimation.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.cpu, this.ephemeralStorage, this.heap, this.memory, this.overhead, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Estimation {\n");
        sb.append("    cpu: ").append(this.toIndentedString(this.cpu)).append("\n");
        sb.append("    ephemeralStorage: ").append(this.toIndentedString(this.ephemeralStorage)).append("\n");
        sb.append("    heap: ").append(this.toIndentedString(this.heap)).append("\n");
        sb.append("    memory: ").append(this.toIndentedString(this.memory)).append("\n");
        sb.append("    overhead: ").append(this.toIndentedString(this.overhead)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

