/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CasePriority;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"description", "priority", "title", "type_id"})
public class CaseCreateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private CasePriority priority = CasePriority.NOT_DEFINED;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TYPE_ID = "type_id";
    private String typeId;
    private Map<String, Object> additionalProperties;

    public CaseCreateAttributes() {
    }

    @JsonCreator
    public CaseCreateAttributes(@JsonProperty(required=true, value="title") String title, @JsonProperty(required=true, value="type_id") String typeId) {
        this.title = title;
        this.typeId = typeId;
    }

    public CaseCreateAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CaseCreateAttributes priority(CasePriority priority) {
        this.priority = priority;
        this.unparsed |= !priority.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CasePriority getPriority() {
        return this.priority;
    }

    public void setPriority(CasePriority priority) {
        if (!priority.isValid()) {
            this.unparsed = true;
        }
        this.priority = priority;
    }

    public CaseCreateAttributes title(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CaseCreateAttributes typeId(String typeId) {
        this.typeId = typeId;
        return this;
    }

    @JsonProperty(value="type_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    @JsonAnySetter
    public CaseCreateAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseCreateAttributes caseCreateAttributes = (CaseCreateAttributes)o;
        return Objects.equals(this.description, caseCreateAttributes.description) && Objects.equals(this.priority, caseCreateAttributes.priority) && Objects.equals(this.title, caseCreateAttributes.title) && Objects.equals(this.typeId, caseCreateAttributes.typeId) && Objects.equals(this.additionalProperties, caseCreateAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.priority, this.title, this.typeId, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CaseCreateAttributes {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

