/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.ResolveVulnerableSymbolsRequest;
import com.datadog.api.client.v2.model.ResolveVulnerableSymbolsResponse;
import com.datadog.api.client.v2.model.ScaRequest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class StaticAnalysisApi {
    private ApiClient apiClient;

    public StaticAnalysisApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public StaticAnalysisApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ResolveVulnerableSymbolsResponse createSCAResolveVulnerableSymbols(ResolveVulnerableSymbolsRequest body) throws ApiException {
        return this.createSCAResolveVulnerableSymbolsWithHttpInfo(body).getData();
    }

    public CompletableFuture<ResolveVulnerableSymbolsResponse> createSCAResolveVulnerableSymbolsAsync(ResolveVulnerableSymbolsRequest body) {
        return this.createSCAResolveVulnerableSymbolsWithHttpInfoAsync(body).thenApply(response -> (ResolveVulnerableSymbolsResponse)response.getData());
    }

    public ApiResponse<ResolveVulnerableSymbolsResponse> createSCAResolveVulnerableSymbolsWithHttpInfo(ResolveVulnerableSymbolsRequest body) throws ApiException {
        String operationId = "createSCAResolveVulnerableSymbols";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        ResolveVulnerableSymbolsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSCAResolveVulnerableSymbols");
        }
        String localVarPath = "/api/v2/static-analysis-sca/vulnerabilities/resolve-vulnerable-symbols";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.StaticAnalysisApi.createSCAResolveVulnerableSymbols", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ResolveVulnerableSymbolsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ResolveVulnerableSymbolsResponse>> createSCAResolveVulnerableSymbolsWithHttpInfoAsync(ResolveVulnerableSymbolsRequest body) {
        Invocation.Builder builder;
        String operationId = "createSCAResolveVulnerableSymbols";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ResolveVulnerableSymbolsResponse>> result = new CompletableFuture<ApiResponse<ResolveVulnerableSymbolsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        ResolveVulnerableSymbolsRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<ResolveVulnerableSymbolsResponse>> result = new CompletableFuture<ApiResponse<ResolveVulnerableSymbolsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSCAResolveVulnerableSymbols"));
            return result;
        }
        String localVarPath = "/api/v2/static-analysis-sca/vulnerabilities/resolve-vulnerable-symbols";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.StaticAnalysisApi.createSCAResolveVulnerableSymbols", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ResolveVulnerableSymbolsResponse>> result = new CompletableFuture<ApiResponse<ResolveVulnerableSymbolsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ResolveVulnerableSymbolsResponse>(){});
    }

    public void createSCAResult(ScaRequest body) throws ApiException {
        this.createSCAResultWithHttpInfo(body);
    }

    public CompletableFuture<Void> createSCAResultAsync(ScaRequest body) {
        return this.createSCAResultWithHttpInfoAsync(body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> createSCAResultWithHttpInfo(ScaRequest body) throws ApiException {
        String operationId = "createSCAResult";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        ScaRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSCAResult");
        }
        String localVarPath = "/api/v2/static-analysis-sca/dependencies";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.StaticAnalysisApi.createSCAResult", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> createSCAResultWithHttpInfoAsync(ScaRequest body) {
        Invocation.Builder builder;
        String operationId = "createSCAResult";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        ScaRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSCAResult"));
            return result;
        }
        String localVarPath = "/api/v2/static-analysis-sca/dependencies";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.StaticAnalysisApi.createSCAResult", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }
}

