/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CreateTableRequest;
import com.datadog.api.client.v2.model.CreateUploadRequest;
import com.datadog.api.client.v2.model.CreateUploadResponse;
import com.datadog.api.client.v2.model.PatchTableRequest;
import com.datadog.api.client.v2.model.ReferenceTableSortType;
import com.datadog.api.client.v2.model.TableResultV2;
import com.datadog.api.client.v2.model.TableResultV2Array;
import com.datadog.api.client.v2.model.TableRowResourceArray;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ReferenceTablesApi {
    private ApiClient apiClient;

    public ReferenceTablesApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ReferenceTablesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public TableResultV2 createReferenceTable(CreateTableRequest body) throws ApiException {
        return this.createReferenceTableWithHttpInfo(body).getData();
    }

    public CompletableFuture<TableResultV2> createReferenceTableAsync(CreateTableRequest body) {
        return this.createReferenceTableWithHttpInfoAsync(body).thenApply(response -> (TableResultV2)response.getData());
    }

    public ApiResponse<TableResultV2> createReferenceTableWithHttpInfo(CreateTableRequest body) throws ApiException {
        CreateTableRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createReferenceTable");
        }
        String localVarPath = "/api/v2/reference-tables/tables";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ReferenceTablesApi.createReferenceTable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TableResultV2>(){});
    }

    public CompletableFuture<ApiResponse<TableResultV2>> createReferenceTableWithHttpInfoAsync(CreateTableRequest body) {
        Invocation.Builder builder;
        CreateTableRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<TableResultV2>> result = new CompletableFuture<ApiResponse<TableResultV2>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createReferenceTable"));
            return result;
        }
        String localVarPath = "/api/v2/reference-tables/tables";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ReferenceTablesApi.createReferenceTable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TableResultV2>> result = new CompletableFuture<ApiResponse<TableResultV2>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TableResultV2>(){});
    }

    public CreateUploadResponse createReferenceTableUpload(CreateUploadRequest body) throws ApiException {
        return this.createReferenceTableUploadWithHttpInfo(body).getData();
    }

    public CompletableFuture<CreateUploadResponse> createReferenceTableUploadAsync(CreateUploadRequest body) {
        return this.createReferenceTableUploadWithHttpInfoAsync(body).thenApply(response -> (CreateUploadResponse)response.getData());
    }

    public ApiResponse<CreateUploadResponse> createReferenceTableUploadWithHttpInfo(CreateUploadRequest body) throws ApiException {
        CreateUploadRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createReferenceTableUpload");
        }
        String localVarPath = "/api/v2/reference-tables/uploads";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ReferenceTablesApi.createReferenceTableUpload", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateUploadResponse>(){});
    }

    public CompletableFuture<ApiResponse<CreateUploadResponse>> createReferenceTableUploadWithHttpInfoAsync(CreateUploadRequest body) {
        Invocation.Builder builder;
        CreateUploadRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CreateUploadResponse>> result = new CompletableFuture<ApiResponse<CreateUploadResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createReferenceTableUpload"));
            return result;
        }
        String localVarPath = "/api/v2/reference-tables/uploads";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ReferenceTablesApi.createReferenceTableUpload", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CreateUploadResponse>> result = new CompletableFuture<ApiResponse<CreateUploadResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateUploadResponse>(){});
    }

    public void deleteTable(String id) throws ApiException {
        this.deleteTableWithHttpInfo(id);
    }

    public CompletableFuture<Void> deleteTableAsync(String id) {
        return this.deleteTableWithHttpInfoAsync(id).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteTableWithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteTable");
        }
        String localVarPath = "/api/v2/reference-tables/tables/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ReferenceTablesApi.deleteTable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteTableWithHttpInfoAsync(String id) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling deleteTable"));
            return result;
        }
        String localVarPath = "/api/v2/reference-tables/tables/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ReferenceTablesApi.deleteTable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public TableRowResourceArray getRowsByID(String id, List<String> rowId) throws ApiException {
        return this.getRowsByIDWithHttpInfo(id, rowId).getData();
    }

    public CompletableFuture<TableRowResourceArray> getRowsByIDAsync(String id, List<String> rowId) {
        return this.getRowsByIDWithHttpInfoAsync(id, rowId).thenApply(response -> (TableRowResourceArray)response.getData());
    }

    public ApiResponse<TableRowResourceArray> getRowsByIDWithHttpInfo(String id, List<String> rowId) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getRowsByID");
        }
        if (rowId == null) {
            throw new ApiException(400, "Missing the required parameter 'rowId' when calling getRowsByID");
        }
        String localVarPath = "/api/v2/reference-tables/tables/{id}/rows".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "row_id", rowId));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ReferenceTablesApi.getRowsByID", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TableRowResourceArray>(){});
    }

    public CompletableFuture<ApiResponse<TableRowResourceArray>> getRowsByIDWithHttpInfoAsync(String id, List<String> rowId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<TableRowResourceArray>> result = new CompletableFuture<ApiResponse<TableRowResourceArray>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling getRowsByID"));
            return result;
        }
        if (rowId == null) {
            CompletableFuture<ApiResponse<TableRowResourceArray>> result = new CompletableFuture<ApiResponse<TableRowResourceArray>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'rowId' when calling getRowsByID"));
            return result;
        }
        String localVarPath = "/api/v2/reference-tables/tables/{id}/rows".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "row_id", rowId));
        try {
            builder = this.apiClient.createBuilder("v2.ReferenceTablesApi.getRowsByID", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TableRowResourceArray>> result = new CompletableFuture<ApiResponse<TableRowResourceArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TableRowResourceArray>(){});
    }

    public TableResultV2 getTable(String id) throws ApiException {
        return this.getTableWithHttpInfo(id).getData();
    }

    public CompletableFuture<TableResultV2> getTableAsync(String id) {
        return this.getTableWithHttpInfoAsync(id).thenApply(response -> (TableResultV2)response.getData());
    }

    public ApiResponse<TableResultV2> getTableWithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getTable");
        }
        String localVarPath = "/api/v2/reference-tables/tables/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ReferenceTablesApi.getTable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TableResultV2>(){});
    }

    public CompletableFuture<ApiResponse<TableResultV2>> getTableWithHttpInfoAsync(String id) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<TableResultV2>> result = new CompletableFuture<ApiResponse<TableResultV2>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling getTable"));
            return result;
        }
        String localVarPath = "/api/v2/reference-tables/tables/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ReferenceTablesApi.getTable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TableResultV2>> result = new CompletableFuture<ApiResponse<TableResultV2>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TableResultV2>(){});
    }

    public TableResultV2Array listTables() throws ApiException {
        return this.listTablesWithHttpInfo(new ListTablesOptionalParameters()).getData();
    }

    public CompletableFuture<TableResultV2Array> listTablesAsync() {
        return this.listTablesWithHttpInfoAsync(new ListTablesOptionalParameters()).thenApply(response -> (TableResultV2Array)response.getData());
    }

    public TableResultV2Array listTables(ListTablesOptionalParameters parameters) throws ApiException {
        return this.listTablesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<TableResultV2Array> listTablesAsync(ListTablesOptionalParameters parameters) {
        return this.listTablesWithHttpInfoAsync(parameters).thenApply(response -> (TableResultV2Array)response.getData());
    }

    public ApiResponse<TableResultV2Array> listTablesWithHttpInfo(ListTablesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long limit = parameters.limit;
        Long offset = parameters.offset;
        ReferenceTableSortType sort = parameters.sort;
        String filterStatus = parameters.filterStatus;
        String filterTableNameExact = parameters.filterTableNameExact;
        String filterTableNameContains = parameters.filterTableNameContains;
        String localVarPath = "/api/v2/reference-tables/tables";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[status]", filterStatus));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[table_name][exact]", filterTableNameExact));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[table_name][contains]", filterTableNameContains));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ReferenceTablesApi.listTables", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TableResultV2Array>(){});
    }

    public CompletableFuture<ApiResponse<TableResultV2Array>> listTablesWithHttpInfoAsync(ListTablesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long limit = parameters.limit;
        Long offset = parameters.offset;
        ReferenceTableSortType sort = parameters.sort;
        String filterStatus = parameters.filterStatus;
        String filterTableNameExact = parameters.filterTableNameExact;
        String filterTableNameContains = parameters.filterTableNameContains;
        String localVarPath = "/api/v2/reference-tables/tables";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[status]", filterStatus));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[table_name][exact]", filterTableNameExact));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[table_name][contains]", filterTableNameContains));
        try {
            builder = this.apiClient.createBuilder("v2.ReferenceTablesApi.listTables", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TableResultV2Array>> result = new CompletableFuture<ApiResponse<TableResultV2Array>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TableResultV2Array>(){});
    }

    public void updateReferenceTable(String id, PatchTableRequest body) throws ApiException {
        this.updateReferenceTableWithHttpInfo(id, body);
    }

    public CompletableFuture<Void> updateReferenceTableAsync(String id, PatchTableRequest body) {
        return this.updateReferenceTableWithHttpInfoAsync(id, body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> updateReferenceTableWithHttpInfo(String id, PatchTableRequest body) throws ApiException {
        PatchTableRequest localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateReferenceTable");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateReferenceTable");
        }
        String localVarPath = "/api/v2/reference-tables/tables/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ReferenceTablesApi.updateReferenceTable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> updateReferenceTableWithHttpInfoAsync(String id, PatchTableRequest body) {
        Invocation.Builder builder;
        PatchTableRequest localVarPostBody = body;
        if (id == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling updateReferenceTable"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateReferenceTable"));
            return result;
        }
        String localVarPath = "/api/v2/reference-tables/tables/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ReferenceTablesApi.updateReferenceTable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public static class ListTablesOptionalParameters {
        private Long limit;
        private Long offset;
        private ReferenceTableSortType sort;
        private String filterStatus;
        private String filterTableNameExact;
        private String filterTableNameContains;

        public ListTablesOptionalParameters limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public ListTablesOptionalParameters offset(Long offset) {
            this.offset = offset;
            return this;
        }

        public ListTablesOptionalParameters sort(ReferenceTableSortType sort) {
            this.sort = sort;
            return this;
        }

        public ListTablesOptionalParameters filterStatus(String filterStatus) {
            this.filterStatus = filterStatus;
            return this;
        }

        public ListTablesOptionalParameters filterTableNameExact(String filterTableNameExact) {
            this.filterTableNameExact = filterTableNameExact;
            return this;
        }

        public ListTablesOptionalParameters filterTableNameContains(String filterTableNameContains) {
            this.filterTableNameContains = filterTableNameContains;
            return this;
        }
    }
}

