/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.OrgConnectionCreateRequest;
import com.datadog.api.client.v2.model.OrgConnectionListResponse;
import com.datadog.api.client.v2.model.OrgConnectionResponse;
import com.datadog.api.client.v2.model.OrgConnectionUpdateRequest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class OrgConnectionsApi {
    private ApiClient apiClient;

    public OrgConnectionsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public OrgConnectionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OrgConnectionResponse createOrgConnections(OrgConnectionCreateRequest body) throws ApiException {
        return this.createOrgConnectionsWithHttpInfo(body).getData();
    }

    public CompletableFuture<OrgConnectionResponse> createOrgConnectionsAsync(OrgConnectionCreateRequest body) {
        return this.createOrgConnectionsWithHttpInfoAsync(body).thenApply(response -> (OrgConnectionResponse)response.getData());
    }

    public ApiResponse<OrgConnectionResponse> createOrgConnectionsWithHttpInfo(OrgConnectionCreateRequest body) throws ApiException {
        OrgConnectionCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createOrgConnections");
        }
        String localVarPath = "/api/v2/org_connections";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OrgConnectionsApi.createOrgConnections", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrgConnectionResponse>(){});
    }

    public CompletableFuture<ApiResponse<OrgConnectionResponse>> createOrgConnectionsWithHttpInfoAsync(OrgConnectionCreateRequest body) {
        Invocation.Builder builder;
        OrgConnectionCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<OrgConnectionResponse>> result = new CompletableFuture<ApiResponse<OrgConnectionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createOrgConnections"));
            return result;
        }
        String localVarPath = "/api/v2/org_connections";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OrgConnectionsApi.createOrgConnections", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OrgConnectionResponse>> result = new CompletableFuture<ApiResponse<OrgConnectionResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrgConnectionResponse>(){});
    }

    public void deleteOrgConnections(UUID connectionId) throws ApiException {
        this.deleteOrgConnectionsWithHttpInfo(connectionId);
    }

    public CompletableFuture<Void> deleteOrgConnectionsAsync(UUID connectionId) {
        return this.deleteOrgConnectionsWithHttpInfoAsync(connectionId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteOrgConnectionsWithHttpInfo(UUID connectionId) throws ApiException {
        Object localVarPostBody = null;
        if (connectionId == null) {
            throw new ApiException(400, "Missing the required parameter 'connectionId' when calling deleteOrgConnections");
        }
        String localVarPath = "/api/v2/org_connections/{connection_id}".replaceAll("\\{connection_id\\}", this.apiClient.escapeString(connectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OrgConnectionsApi.deleteOrgConnections", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteOrgConnectionsWithHttpInfoAsync(UUID connectionId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (connectionId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'connectionId' when calling deleteOrgConnections"));
            return result;
        }
        String localVarPath = "/api/v2/org_connections/{connection_id}".replaceAll("\\{connection_id\\}", this.apiClient.escapeString(connectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OrgConnectionsApi.deleteOrgConnections", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public OrgConnectionListResponse listOrgConnections() throws ApiException {
        return this.listOrgConnectionsWithHttpInfo(new ListOrgConnectionsOptionalParameters()).getData();
    }

    public CompletableFuture<OrgConnectionListResponse> listOrgConnectionsAsync() {
        return this.listOrgConnectionsWithHttpInfoAsync(new ListOrgConnectionsOptionalParameters()).thenApply(response -> (OrgConnectionListResponse)response.getData());
    }

    public OrgConnectionListResponse listOrgConnections(ListOrgConnectionsOptionalParameters parameters) throws ApiException {
        return this.listOrgConnectionsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<OrgConnectionListResponse> listOrgConnectionsAsync(ListOrgConnectionsOptionalParameters parameters) {
        return this.listOrgConnectionsWithHttpInfoAsync(parameters).thenApply(response -> (OrgConnectionListResponse)response.getData());
    }

    public ApiResponse<OrgConnectionListResponse> listOrgConnectionsWithHttpInfo(ListOrgConnectionsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String sinkOrgId = parameters.sinkOrgId;
        String sourceOrgId = parameters.sourceOrgId;
        Long limit = parameters.limit;
        Long offset = parameters.offset;
        String localVarPath = "/api/v2/org_connections";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sink_org_id", sinkOrgId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source_org_id", sourceOrgId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OrgConnectionsApi.listOrgConnections", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrgConnectionListResponse>(){});
    }

    public CompletableFuture<ApiResponse<OrgConnectionListResponse>> listOrgConnectionsWithHttpInfoAsync(ListOrgConnectionsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String sinkOrgId = parameters.sinkOrgId;
        String sourceOrgId = parameters.sourceOrgId;
        Long limit = parameters.limit;
        Long offset = parameters.offset;
        String localVarPath = "/api/v2/org_connections";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sink_org_id", sinkOrgId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source_org_id", sourceOrgId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        try {
            builder = this.apiClient.createBuilder("v2.OrgConnectionsApi.listOrgConnections", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OrgConnectionListResponse>> result = new CompletableFuture<ApiResponse<OrgConnectionListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrgConnectionListResponse>(){});
    }

    public OrgConnectionResponse updateOrgConnections(UUID connectionId, OrgConnectionUpdateRequest body) throws ApiException {
        return this.updateOrgConnectionsWithHttpInfo(connectionId, body).getData();
    }

    public CompletableFuture<OrgConnectionResponse> updateOrgConnectionsAsync(UUID connectionId, OrgConnectionUpdateRequest body) {
        return this.updateOrgConnectionsWithHttpInfoAsync(connectionId, body).thenApply(response -> (OrgConnectionResponse)response.getData());
    }

    public ApiResponse<OrgConnectionResponse> updateOrgConnectionsWithHttpInfo(UUID connectionId, OrgConnectionUpdateRequest body) throws ApiException {
        OrgConnectionUpdateRequest localVarPostBody = body;
        if (connectionId == null) {
            throw new ApiException(400, "Missing the required parameter 'connectionId' when calling updateOrgConnections");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateOrgConnections");
        }
        String localVarPath = "/api/v2/org_connections/{connection_id}".replaceAll("\\{connection_id\\}", this.apiClient.escapeString(connectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OrgConnectionsApi.updateOrgConnections", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrgConnectionResponse>(){});
    }

    public CompletableFuture<ApiResponse<OrgConnectionResponse>> updateOrgConnectionsWithHttpInfoAsync(UUID connectionId, OrgConnectionUpdateRequest body) {
        Invocation.Builder builder;
        OrgConnectionUpdateRequest localVarPostBody = body;
        if (connectionId == null) {
            CompletableFuture<ApiResponse<OrgConnectionResponse>> result = new CompletableFuture<ApiResponse<OrgConnectionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'connectionId' when calling updateOrgConnections"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<OrgConnectionResponse>> result = new CompletableFuture<ApiResponse<OrgConnectionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateOrgConnections"));
            return result;
        }
        String localVarPath = "/api/v2/org_connections/{connection_id}".replaceAll("\\{connection_id\\}", this.apiClient.escapeString(connectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OrgConnectionsApi.updateOrgConnections", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OrgConnectionResponse>> result = new CompletableFuture<ApiResponse<OrgConnectionResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrgConnectionResponse>(){});
    }

    public static class ListOrgConnectionsOptionalParameters {
        private String sinkOrgId;
        private String sourceOrgId;
        private Long limit;
        private Long offset;

        public ListOrgConnectionsOptionalParameters sinkOrgId(String sinkOrgId) {
            this.sinkOrgId = sinkOrgId;
            return this;
        }

        public ListOrgConnectionsOptionalParameters sourceOrgId(String sourceOrgId) {
            this.sourceOrgId = sourceOrgId;
            return this;
        }

        public ListOrgConnectionsOptionalParameters limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public ListOrgConnectionsOptionalParameters offset(Long offset) {
            this.offset = offset;
            return this;
        }
    }
}

