/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CreatePageRequest;
import com.datadog.api.client.v2.model.CreatePageResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class OnCallPagingApi {
    private ApiClient apiClient;

    public OnCallPagingApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public OnCallPagingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void acknowledgeOnCallPage(UUID pageId) throws ApiException {
        this.acknowledgeOnCallPageWithHttpInfo(pageId);
    }

    public CompletableFuture<Void> acknowledgeOnCallPageAsync(UUID pageId) {
        return this.acknowledgeOnCallPageWithHttpInfoAsync(pageId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> acknowledgeOnCallPageWithHttpInfo(UUID pageId) throws ApiException {
        Object localVarPostBody = null;
        if (pageId == null) {
            throw new ApiException(400, "Missing the required parameter 'pageId' when calling acknowledgeOnCallPage");
        }
        String localVarPath = "/api/v2/on-call/pages/{page_id}/acknowledge".replaceAll("\\{page_id\\}", this.apiClient.escapeString(pageId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallPagingApi.acknowledgeOnCallPage", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> acknowledgeOnCallPageWithHttpInfoAsync(UUID pageId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (pageId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'pageId' when calling acknowledgeOnCallPage"));
            return result;
        }
        String localVarPath = "/api/v2/on-call/pages/{page_id}/acknowledge".replaceAll("\\{page_id\\}", this.apiClient.escapeString(pageId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OnCallPagingApi.acknowledgeOnCallPage", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CreatePageResponse createOnCallPage(CreatePageRequest body) throws ApiException {
        return this.createOnCallPageWithHttpInfo(body).getData();
    }

    public CompletableFuture<CreatePageResponse> createOnCallPageAsync(CreatePageRequest body) {
        return this.createOnCallPageWithHttpInfoAsync(body).thenApply(response -> (CreatePageResponse)response.getData());
    }

    public ApiResponse<CreatePageResponse> createOnCallPageWithHttpInfo(CreatePageRequest body) throws ApiException {
        CreatePageRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createOnCallPage");
        }
        String localVarPath = "/api/v2/on-call/pages";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallPagingApi.createOnCallPage", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreatePageResponse>(){});
    }

    public CompletableFuture<ApiResponse<CreatePageResponse>> createOnCallPageWithHttpInfoAsync(CreatePageRequest body) {
        Invocation.Builder builder;
        CreatePageRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CreatePageResponse>> result = new CompletableFuture<ApiResponse<CreatePageResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createOnCallPage"));
            return result;
        }
        String localVarPath = "/api/v2/on-call/pages";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OnCallPagingApi.createOnCallPage", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CreatePageResponse>> result = new CompletableFuture<ApiResponse<CreatePageResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreatePageResponse>(){});
    }

    public void escalateOnCallPage(UUID pageId) throws ApiException {
        this.escalateOnCallPageWithHttpInfo(pageId);
    }

    public CompletableFuture<Void> escalateOnCallPageAsync(UUID pageId) {
        return this.escalateOnCallPageWithHttpInfoAsync(pageId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> escalateOnCallPageWithHttpInfo(UUID pageId) throws ApiException {
        Object localVarPostBody = null;
        if (pageId == null) {
            throw new ApiException(400, "Missing the required parameter 'pageId' when calling escalateOnCallPage");
        }
        String localVarPath = "/api/v2/on-call/pages/{page_id}/escalate".replaceAll("\\{page_id\\}", this.apiClient.escapeString(pageId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallPagingApi.escalateOnCallPage", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> escalateOnCallPageWithHttpInfoAsync(UUID pageId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (pageId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'pageId' when calling escalateOnCallPage"));
            return result;
        }
        String localVarPath = "/api/v2/on-call/pages/{page_id}/escalate".replaceAll("\\{page_id\\}", this.apiClient.escapeString(pageId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OnCallPagingApi.escalateOnCallPage", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void resolveOnCallPage(UUID pageId) throws ApiException {
        this.resolveOnCallPageWithHttpInfo(pageId);
    }

    public CompletableFuture<Void> resolveOnCallPageAsync(UUID pageId) {
        return this.resolveOnCallPageWithHttpInfoAsync(pageId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> resolveOnCallPageWithHttpInfo(UUID pageId) throws ApiException {
        Object localVarPostBody = null;
        if (pageId == null) {
            throw new ApiException(400, "Missing the required parameter 'pageId' when calling resolveOnCallPage");
        }
        String localVarPath = "/api/v2/on-call/pages/{page_id}/resolve".replaceAll("\\{page_id\\}", this.apiClient.escapeString(pageId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallPagingApi.resolveOnCallPage", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> resolveOnCallPageWithHttpInfoAsync(UUID pageId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (pageId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'pageId' when calling resolveOnCallPage"));
            return result;
        }
        String localVarPath = "/api/v2/on-call/pages/{page_id}/resolve".replaceAll("\\{page_id\\}", this.apiClient.escapeString(pageId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OnCallPagingApi.resolveOnCallPage", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }
}

