/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.FleetDeploymentConfigureCreateRequest;
import com.datadog.api.client.v2.model.FleetDeploymentResponse;
import com.datadog.api.client.v2.model.FleetDeploymentsResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class FleetAutomationApi {
    private ApiClient apiClient;

    public FleetAutomationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public FleetAutomationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void cancelFleetDeployment(String deploymentId) throws ApiException {
        this.cancelFleetDeploymentWithHttpInfo(deploymentId);
    }

    public CompletableFuture<Void> cancelFleetDeploymentAsync(String deploymentId) {
        return this.cancelFleetDeploymentWithHttpInfoAsync(deploymentId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> cancelFleetDeploymentWithHttpInfo(String deploymentId) throws ApiException {
        String operationId = "cancelFleetDeployment";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (deploymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'deploymentId' when calling cancelFleetDeployment");
        }
        String localVarPath = "/api/unstable/fleet/deployments/{deployment_id}/cancel".replaceAll("\\{deployment_id\\}", this.apiClient.escapeString(deploymentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.cancelFleetDeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> cancelFleetDeploymentWithHttpInfoAsync(String deploymentId) {
        Invocation.Builder builder;
        String operationId = "cancelFleetDeployment";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (deploymentId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'deploymentId' when calling cancelFleetDeployment"));
            return result;
        }
        String localVarPath = "/api/unstable/fleet/deployments/{deployment_id}/cancel".replaceAll("\\{deployment_id\\}", this.apiClient.escapeString(deploymentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.cancelFleetDeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public FleetDeploymentResponse createFleetDeploymentConfigure(FleetDeploymentConfigureCreateRequest body) throws ApiException {
        return this.createFleetDeploymentConfigureWithHttpInfo(body).getData();
    }

    public CompletableFuture<FleetDeploymentResponse> createFleetDeploymentConfigureAsync(FleetDeploymentConfigureCreateRequest body) {
        return this.createFleetDeploymentConfigureWithHttpInfoAsync(body).thenApply(response -> (FleetDeploymentResponse)response.getData());
    }

    public ApiResponse<FleetDeploymentResponse> createFleetDeploymentConfigureWithHttpInfo(FleetDeploymentConfigureCreateRequest body) throws ApiException {
        String operationId = "createFleetDeploymentConfigure";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FleetDeploymentConfigureCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createFleetDeploymentConfigure");
        }
        String localVarPath = "/api/unstable/fleet/deployments/configure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.createFleetDeploymentConfigure", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentResponse>(){});
    }

    public CompletableFuture<ApiResponse<FleetDeploymentResponse>> createFleetDeploymentConfigureWithHttpInfoAsync(FleetDeploymentConfigureCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createFleetDeploymentConfigure";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FleetDeploymentConfigureCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createFleetDeploymentConfigure"));
            return result;
        }
        String localVarPath = "/api/unstable/fleet/deployments/configure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.createFleetDeploymentConfigure", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentResponse>(){});
    }

    public FleetDeploymentResponse getFleetDeployment(String deploymentId) throws ApiException {
        return this.getFleetDeploymentWithHttpInfo(deploymentId).getData();
    }

    public CompletableFuture<FleetDeploymentResponse> getFleetDeploymentAsync(String deploymentId) {
        return this.getFleetDeploymentWithHttpInfoAsync(deploymentId).thenApply(response -> (FleetDeploymentResponse)response.getData());
    }

    public ApiResponse<FleetDeploymentResponse> getFleetDeploymentWithHttpInfo(String deploymentId) throws ApiException {
        String operationId = "getFleetDeployment";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (deploymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'deploymentId' when calling getFleetDeployment");
        }
        String localVarPath = "/api/unstable/fleet/deployments/{deployment_id}".replaceAll("\\{deployment_id\\}", this.apiClient.escapeString(deploymentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.getFleetDeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentResponse>(){});
    }

    public CompletableFuture<ApiResponse<FleetDeploymentResponse>> getFleetDeploymentWithHttpInfoAsync(String deploymentId) {
        Invocation.Builder builder;
        String operationId = "getFleetDeployment";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (deploymentId == null) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'deploymentId' when calling getFleetDeployment"));
            return result;
        }
        String localVarPath = "/api/unstable/fleet/deployments/{deployment_id}".replaceAll("\\{deployment_id\\}", this.apiClient.escapeString(deploymentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.getFleetDeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentResponse>(){});
    }

    public FleetDeploymentsResponse listFleetDeployments() throws ApiException {
        return this.listFleetDeploymentsWithHttpInfo(new ListFleetDeploymentsOptionalParameters()).getData();
    }

    public CompletableFuture<FleetDeploymentsResponse> listFleetDeploymentsAsync() {
        return this.listFleetDeploymentsWithHttpInfoAsync(new ListFleetDeploymentsOptionalParameters()).thenApply(response -> (FleetDeploymentsResponse)response.getData());
    }

    public FleetDeploymentsResponse listFleetDeployments(ListFleetDeploymentsOptionalParameters parameters) throws ApiException {
        return this.listFleetDeploymentsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<FleetDeploymentsResponse> listFleetDeploymentsAsync(ListFleetDeploymentsOptionalParameters parameters) {
        return this.listFleetDeploymentsWithHttpInfoAsync(parameters).thenApply(response -> (FleetDeploymentsResponse)response.getData());
    }

    public ApiResponse<FleetDeploymentsResponse> listFleetDeploymentsWithHttpInfo(ListFleetDeploymentsOptionalParameters parameters) throws ApiException {
        String operationId = "listFleetDeployments";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/unstable/fleet/deployments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_offset", pageOffset));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.listFleetDeployments", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentsResponse>(){});
    }

    public CompletableFuture<ApiResponse<FleetDeploymentsResponse>> listFleetDeploymentsWithHttpInfoAsync(ListFleetDeploymentsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listFleetDeployments";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FleetDeploymentsResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/unstable/fleet/deployments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_offset", pageOffset));
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.listFleetDeployments", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FleetDeploymentsResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentsResponse>(){});
    }

    public static class ListFleetDeploymentsOptionalParameters {
        private Long pageSize;
        private Long pageOffset;

        public ListFleetDeploymentsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListFleetDeploymentsOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }
    }
}

