/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.ArbitraryCostUpsertRequest;
import com.datadog.api.client.v2.model.ArbitraryRuleResponse;
import com.datadog.api.client.v2.model.ArbitraryRuleResponseArray;
import com.datadog.api.client.v2.model.AwsCURConfigPatchRequest;
import com.datadog.api.client.v2.model.AwsCURConfigPostRequest;
import com.datadog.api.client.v2.model.AwsCURConfigsResponse;
import com.datadog.api.client.v2.model.AwsCurConfigResponse;
import com.datadog.api.client.v2.model.AzureUCConfigPairsResponse;
import com.datadog.api.client.v2.model.AzureUCConfigPatchRequest;
import com.datadog.api.client.v2.model.AzureUCConfigPostRequest;
import com.datadog.api.client.v2.model.AzureUCConfigsResponse;
import com.datadog.api.client.v2.model.BudgetArray;
import com.datadog.api.client.v2.model.BudgetWithEntries;
import com.datadog.api.client.v2.model.CreateRulesetRequest;
import com.datadog.api.client.v2.model.CustomCostsFileGetResponse;
import com.datadog.api.client.v2.model.CustomCostsFileLineItem;
import com.datadog.api.client.v2.model.CustomCostsFileListResponse;
import com.datadog.api.client.v2.model.CustomCostsFileUploadResponse;
import com.datadog.api.client.v2.model.GCPUsageCostConfigPatchRequest;
import com.datadog.api.client.v2.model.GCPUsageCostConfigPostRequest;
import com.datadog.api.client.v2.model.GCPUsageCostConfigResponse;
import com.datadog.api.client.v2.model.GCPUsageCostConfigsResponse;
import com.datadog.api.client.v2.model.GcpUcConfigResponse;
import com.datadog.api.client.v2.model.ReorderRuleResourceArray;
import com.datadog.api.client.v2.model.ReorderRulesetResourceArray;
import com.datadog.api.client.v2.model.RulesValidateQueryRequest;
import com.datadog.api.client.v2.model.RulesValidateQueryResponse;
import com.datadog.api.client.v2.model.RulesetResp;
import com.datadog.api.client.v2.model.RulesetRespArray;
import com.datadog.api.client.v2.model.UCConfigPair;
import com.datadog.api.client.v2.model.UpdateRulesetRequest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class CloudCostManagementApi {
    private ApiClient apiClient;

    public CloudCostManagementApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public CloudCostManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AwsCurConfigResponse createCostAWSCURConfig(AwsCURConfigPostRequest body) throws ApiException {
        return this.createCostAWSCURConfigWithHttpInfo(body).getData();
    }

    public CompletableFuture<AwsCurConfigResponse> createCostAWSCURConfigAsync(AwsCURConfigPostRequest body) {
        return this.createCostAWSCURConfigWithHttpInfoAsync(body).thenApply(response -> (AwsCurConfigResponse)response.getData());
    }

    public ApiResponse<AwsCurConfigResponse> createCostAWSCURConfigWithHttpInfo(AwsCURConfigPostRequest body) throws ApiException {
        AwsCURConfigPostRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCostAWSCURConfig");
        }
        String localVarPath = "/api/v2/cost/aws_cur_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCurConfigResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsCurConfigResponse>> createCostAWSCURConfigWithHttpInfoAsync(AwsCURConfigPostRequest body) {
        Invocation.Builder builder;
        AwsCURConfigPostRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<AwsCurConfigResponse>> result = new CompletableFuture<ApiResponse<AwsCurConfigResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCostAWSCURConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/aws_cur_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsCurConfigResponse>> result = new CompletableFuture<ApiResponse<AwsCurConfigResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCurConfigResponse>(){});
    }

    public AzureUCConfigPairsResponse createCostAzureUCConfigs(AzureUCConfigPostRequest body) throws ApiException {
        return this.createCostAzureUCConfigsWithHttpInfo(body).getData();
    }

    public CompletableFuture<AzureUCConfigPairsResponse> createCostAzureUCConfigsAsync(AzureUCConfigPostRequest body) {
        return this.createCostAzureUCConfigsWithHttpInfoAsync(body).thenApply(response -> (AzureUCConfigPairsResponse)response.getData());
    }

    public ApiResponse<AzureUCConfigPairsResponse> createCostAzureUCConfigsWithHttpInfo(AzureUCConfigPostRequest body) throws ApiException {
        AzureUCConfigPostRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCostAzureUCConfigs");
        }
        String localVarPath = "/api/v2/cost/azure_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigPairsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> createCostAzureUCConfigsWithHttpInfoAsync(AzureUCConfigPostRequest body) {
        Invocation.Builder builder;
        AzureUCConfigPostRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCostAzureUCConfigs"));
            return result;
        }
        String localVarPath = "/api/v2/cost/azure_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigPairsResponse>(){});
    }

    public GCPUsageCostConfigResponse createCostGCPUsageCostConfig(GCPUsageCostConfigPostRequest body) throws ApiException {
        return this.createCostGCPUsageCostConfigWithHttpInfo(body).getData();
    }

    public CompletableFuture<GCPUsageCostConfigResponse> createCostGCPUsageCostConfigAsync(GCPUsageCostConfigPostRequest body) {
        return this.createCostGCPUsageCostConfigWithHttpInfoAsync(body).thenApply(response -> (GCPUsageCostConfigResponse)response.getData());
    }

    public ApiResponse<GCPUsageCostConfigResponse> createCostGCPUsageCostConfigWithHttpInfo(GCPUsageCostConfigPostRequest body) throws ApiException {
        GCPUsageCostConfigPostRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCostGCPUsageCostConfig");
        }
        String localVarPath = "/api/v2/cost/gcp_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCostGCPUsageCostConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPUsageCostConfigResponse>(){});
    }

    public CompletableFuture<ApiResponse<GCPUsageCostConfigResponse>> createCostGCPUsageCostConfigWithHttpInfoAsync(GCPUsageCostConfigPostRequest body) {
        Invocation.Builder builder;
        GCPUsageCostConfigPostRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<GCPUsageCostConfigResponse>> result = new CompletableFuture<ApiResponse<GCPUsageCostConfigResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCostGCPUsageCostConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/gcp_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCostGCPUsageCostConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GCPUsageCostConfigResponse>> result = new CompletableFuture<ApiResponse<GCPUsageCostConfigResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPUsageCostConfigResponse>(){});
    }

    public ArbitraryRuleResponse createCustomAllocationRule(ArbitraryCostUpsertRequest body) throws ApiException {
        return this.createCustomAllocationRuleWithHttpInfo(body).getData();
    }

    public CompletableFuture<ArbitraryRuleResponse> createCustomAllocationRuleAsync(ArbitraryCostUpsertRequest body) {
        return this.createCustomAllocationRuleWithHttpInfoAsync(body).thenApply(response -> (ArbitraryRuleResponse)response.getData());
    }

    public ApiResponse<ArbitraryRuleResponse> createCustomAllocationRuleWithHttpInfo(ArbitraryCostUpsertRequest body) throws ApiException {
        ArbitraryCostUpsertRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCustomAllocationRule");
        }
        String localVarPath = "/api/v2/cost/arbitrary_rule";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCustomAllocationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ArbitraryRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<ArbitraryRuleResponse>> createCustomAllocationRuleWithHttpInfoAsync(ArbitraryCostUpsertRequest body) {
        Invocation.Builder builder;
        ArbitraryCostUpsertRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<ArbitraryRuleResponse>> result = new CompletableFuture<ApiResponse<ArbitraryRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCustomAllocationRule"));
            return result;
        }
        String localVarPath = "/api/v2/cost/arbitrary_rule";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCustomAllocationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ArbitraryRuleResponse>> result = new CompletableFuture<ApiResponse<ArbitraryRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ArbitraryRuleResponse>(){});
    }

    public RulesetResp createTagPipelinesRuleset(CreateRulesetRequest body) throws ApiException {
        return this.createTagPipelinesRulesetWithHttpInfo(body).getData();
    }

    public CompletableFuture<RulesetResp> createTagPipelinesRulesetAsync(CreateRulesetRequest body) {
        return this.createTagPipelinesRulesetWithHttpInfoAsync(body).thenApply(response -> (RulesetResp)response.getData());
    }

    public ApiResponse<RulesetResp> createTagPipelinesRulesetWithHttpInfo(CreateRulesetRequest body) throws ApiException {
        CreateRulesetRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createTagPipelinesRuleset");
        }
        String localVarPath = "/api/v2/tags/enrichment";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createTagPipelinesRuleset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RulesetResp>(){});
    }

    public CompletableFuture<ApiResponse<RulesetResp>> createTagPipelinesRulesetWithHttpInfoAsync(CreateRulesetRequest body) {
        Invocation.Builder builder;
        CreateRulesetRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<RulesetResp>> result = new CompletableFuture<ApiResponse<RulesetResp>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createTagPipelinesRuleset"));
            return result;
        }
        String localVarPath = "/api/v2/tags/enrichment";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createTagPipelinesRuleset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RulesetResp>> result = new CompletableFuture<ApiResponse<RulesetResp>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RulesetResp>(){});
    }

    public void deleteBudget(String budgetId) throws ApiException {
        this.deleteBudgetWithHttpInfo(budgetId);
    }

    public CompletableFuture<Void> deleteBudgetAsync(String budgetId) {
        return this.deleteBudgetWithHttpInfoAsync(budgetId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteBudgetWithHttpInfo(String budgetId) throws ApiException {
        Object localVarPostBody = null;
        if (budgetId == null) {
            throw new ApiException(400, "Missing the required parameter 'budgetId' when calling deleteBudget");
        }
        String localVarPath = "/api/v2/cost/budget/{budget_id}".replaceAll("\\{budget_id\\}", this.apiClient.escapeString(budgetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteBudget", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteBudgetWithHttpInfoAsync(String budgetId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (budgetId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'budgetId' when calling deleteBudget"));
            return result;
        }
        String localVarPath = "/api/v2/cost/budget/{budget_id}".replaceAll("\\{budget_id\\}", this.apiClient.escapeString(budgetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteBudget", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteCostAWSCURConfig(Long cloudAccountId) throws ApiException {
        this.deleteCostAWSCURConfigWithHttpInfo(cloudAccountId);
    }

    public CompletableFuture<Void> deleteCostAWSCURConfigAsync(Long cloudAccountId) {
        return this.deleteCostAWSCURConfigWithHttpInfoAsync(cloudAccountId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCostAWSCURConfigWithHttpInfo(Long cloudAccountId) throws ApiException {
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling deleteCostAWSCURConfig");
        }
        String localVarPath = "/api/v2/cost/aws_cur_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCostAWSCURConfigWithHttpInfoAsync(Long cloudAccountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling deleteCostAWSCURConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/aws_cur_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteCostAzureUCConfig(Long cloudAccountId) throws ApiException {
        this.deleteCostAzureUCConfigWithHttpInfo(cloudAccountId);
    }

    public CompletableFuture<Void> deleteCostAzureUCConfigAsync(Long cloudAccountId) {
        return this.deleteCostAzureUCConfigWithHttpInfoAsync(cloudAccountId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCostAzureUCConfigWithHttpInfo(Long cloudAccountId) throws ApiException {
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling deleteCostAzureUCConfig");
        }
        String localVarPath = "/api/v2/cost/azure_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCostAzureUCConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCostAzureUCConfigWithHttpInfoAsync(Long cloudAccountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling deleteCostAzureUCConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/azure_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCostAzureUCConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteCostGCPUsageCostConfig(Long cloudAccountId) throws ApiException {
        this.deleteCostGCPUsageCostConfigWithHttpInfo(cloudAccountId);
    }

    public CompletableFuture<Void> deleteCostGCPUsageCostConfigAsync(Long cloudAccountId) {
        return this.deleteCostGCPUsageCostConfigWithHttpInfoAsync(cloudAccountId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCostGCPUsageCostConfigWithHttpInfo(Long cloudAccountId) throws ApiException {
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling deleteCostGCPUsageCostConfig");
        }
        String localVarPath = "/api/v2/cost/gcp_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCostGCPUsageCostConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCostGCPUsageCostConfigWithHttpInfoAsync(Long cloudAccountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling deleteCostGCPUsageCostConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/gcp_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCostGCPUsageCostConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteCustomAllocationRule(Long ruleId) throws ApiException {
        this.deleteCustomAllocationRuleWithHttpInfo(ruleId);
    }

    public CompletableFuture<Void> deleteCustomAllocationRuleAsync(Long ruleId) {
        return this.deleteCustomAllocationRuleWithHttpInfoAsync(ruleId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCustomAllocationRuleWithHttpInfo(Long ruleId) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteCustomAllocationRule");
        }
        String localVarPath = "/api/v2/cost/arbitrary_rule/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCustomAllocationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCustomAllocationRuleWithHttpInfoAsync(Long ruleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteCustomAllocationRule"));
            return result;
        }
        String localVarPath = "/api/v2/cost/arbitrary_rule/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCustomAllocationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteCustomCostsFile(String fileId) throws ApiException {
        this.deleteCustomCostsFileWithHttpInfo(fileId);
    }

    public CompletableFuture<Void> deleteCustomCostsFileAsync(String fileId) {
        return this.deleteCustomCostsFileWithHttpInfoAsync(fileId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCustomCostsFileWithHttpInfo(String fileId) throws ApiException {
        Object localVarPostBody = null;
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling deleteCustomCostsFile");
        }
        String localVarPath = "/api/v2/cost/custom_costs/{file_id}".replaceAll("\\{file_id\\}", this.apiClient.escapeString(fileId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCustomCostsFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCustomCostsFileWithHttpInfoAsync(String fileId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (fileId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'fileId' when calling deleteCustomCostsFile"));
            return result;
        }
        String localVarPath = "/api/v2/cost/custom_costs/{file_id}".replaceAll("\\{file_id\\}", this.apiClient.escapeString(fileId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCustomCostsFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteTagPipelinesRuleset(String rulesetId) throws ApiException {
        this.deleteTagPipelinesRulesetWithHttpInfo(rulesetId);
    }

    public CompletableFuture<Void> deleteTagPipelinesRulesetAsync(String rulesetId) {
        return this.deleteTagPipelinesRulesetWithHttpInfoAsync(rulesetId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteTagPipelinesRulesetWithHttpInfo(String rulesetId) throws ApiException {
        Object localVarPostBody = null;
        if (rulesetId == null) {
            throw new ApiException(400, "Missing the required parameter 'rulesetId' when calling deleteTagPipelinesRuleset");
        }
        String localVarPath = "/api/v2/tags/enrichment/{ruleset_id}".replaceAll("\\{ruleset_id\\}", this.apiClient.escapeString(rulesetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteTagPipelinesRuleset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteTagPipelinesRulesetWithHttpInfoAsync(String rulesetId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (rulesetId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'rulesetId' when calling deleteTagPipelinesRuleset"));
            return result;
        }
        String localVarPath = "/api/v2/tags/enrichment/{ruleset_id}".replaceAll("\\{ruleset_id\\}", this.apiClient.escapeString(rulesetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteTagPipelinesRuleset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public BudgetWithEntries getBudget(String budgetId) throws ApiException {
        return this.getBudgetWithHttpInfo(budgetId).getData();
    }

    public CompletableFuture<BudgetWithEntries> getBudgetAsync(String budgetId) {
        return this.getBudgetWithHttpInfoAsync(budgetId).thenApply(response -> (BudgetWithEntries)response.getData());
    }

    public ApiResponse<BudgetWithEntries> getBudgetWithHttpInfo(String budgetId) throws ApiException {
        Object localVarPostBody = null;
        if (budgetId == null) {
            throw new ApiException(400, "Missing the required parameter 'budgetId' when calling getBudget");
        }
        String localVarPath = "/api/v2/cost/budget/{budget_id}".replaceAll("\\{budget_id\\}", this.apiClient.escapeString(budgetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getBudget", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BudgetWithEntries>(){});
    }

    public CompletableFuture<ApiResponse<BudgetWithEntries>> getBudgetWithHttpInfoAsync(String budgetId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (budgetId == null) {
            CompletableFuture<ApiResponse<BudgetWithEntries>> result = new CompletableFuture<ApiResponse<BudgetWithEntries>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'budgetId' when calling getBudget"));
            return result;
        }
        String localVarPath = "/api/v2/cost/budget/{budget_id}".replaceAll("\\{budget_id\\}", this.apiClient.escapeString(budgetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getBudget", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<BudgetWithEntries>> result = new CompletableFuture<ApiResponse<BudgetWithEntries>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BudgetWithEntries>(){});
    }

    public AwsCurConfigResponse getCostAWSCURConfig(Long cloudAccountId) throws ApiException {
        return this.getCostAWSCURConfigWithHttpInfo(cloudAccountId).getData();
    }

    public CompletableFuture<AwsCurConfigResponse> getCostAWSCURConfigAsync(Long cloudAccountId) {
        return this.getCostAWSCURConfigWithHttpInfoAsync(cloudAccountId).thenApply(response -> (AwsCurConfigResponse)response.getData());
    }

    public ApiResponse<AwsCurConfigResponse> getCostAWSCURConfigWithHttpInfo(Long cloudAccountId) throws ApiException {
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling getCostAWSCURConfig");
        }
        String localVarPath = "/api/v2/cost/aws_cur_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCurConfigResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsCurConfigResponse>> getCostAWSCURConfigWithHttpInfoAsync(Long cloudAccountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<AwsCurConfigResponse>> result = new CompletableFuture<ApiResponse<AwsCurConfigResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling getCostAWSCURConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/aws_cur_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsCurConfigResponse>> result = new CompletableFuture<ApiResponse<AwsCurConfigResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCurConfigResponse>(){});
    }

    public UCConfigPair getCostAzureUCConfig(Long cloudAccountId) throws ApiException {
        return this.getCostAzureUCConfigWithHttpInfo(cloudAccountId).getData();
    }

    public CompletableFuture<UCConfigPair> getCostAzureUCConfigAsync(Long cloudAccountId) {
        return this.getCostAzureUCConfigWithHttpInfoAsync(cloudAccountId).thenApply(response -> (UCConfigPair)response.getData());
    }

    public ApiResponse<UCConfigPair> getCostAzureUCConfigWithHttpInfo(Long cloudAccountId) throws ApiException {
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling getCostAzureUCConfig");
        }
        String localVarPath = "/api/v2/cost/azure_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getCostAzureUCConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UCConfigPair>(){});
    }

    public CompletableFuture<ApiResponse<UCConfigPair>> getCostAzureUCConfigWithHttpInfoAsync(Long cloudAccountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<UCConfigPair>> result = new CompletableFuture<ApiResponse<UCConfigPair>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling getCostAzureUCConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/azure_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getCostAzureUCConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UCConfigPair>> result = new CompletableFuture<ApiResponse<UCConfigPair>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UCConfigPair>(){});
    }

    public GcpUcConfigResponse getCostGCPUsageCostConfig(Long cloudAccountId) throws ApiException {
        return this.getCostGCPUsageCostConfigWithHttpInfo(cloudAccountId).getData();
    }

    public CompletableFuture<GcpUcConfigResponse> getCostGCPUsageCostConfigAsync(Long cloudAccountId) {
        return this.getCostGCPUsageCostConfigWithHttpInfoAsync(cloudAccountId).thenApply(response -> (GcpUcConfigResponse)response.getData());
    }

    public ApiResponse<GcpUcConfigResponse> getCostGCPUsageCostConfigWithHttpInfo(Long cloudAccountId) throws ApiException {
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling getCostGCPUsageCostConfig");
        }
        String localVarPath = "/api/v2/cost/gcp_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getCostGCPUsageCostConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GcpUcConfigResponse>(){});
    }

    public CompletableFuture<ApiResponse<GcpUcConfigResponse>> getCostGCPUsageCostConfigWithHttpInfoAsync(Long cloudAccountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<GcpUcConfigResponse>> result = new CompletableFuture<ApiResponse<GcpUcConfigResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling getCostGCPUsageCostConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/gcp_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getCostGCPUsageCostConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GcpUcConfigResponse>> result = new CompletableFuture<ApiResponse<GcpUcConfigResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GcpUcConfigResponse>(){});
    }

    public ArbitraryRuleResponse getCustomAllocationRule(Long ruleId) throws ApiException {
        return this.getCustomAllocationRuleWithHttpInfo(ruleId).getData();
    }

    public CompletableFuture<ArbitraryRuleResponse> getCustomAllocationRuleAsync(Long ruleId) {
        return this.getCustomAllocationRuleWithHttpInfoAsync(ruleId).thenApply(response -> (ArbitraryRuleResponse)response.getData());
    }

    public ApiResponse<ArbitraryRuleResponse> getCustomAllocationRuleWithHttpInfo(Long ruleId) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling getCustomAllocationRule");
        }
        String localVarPath = "/api/v2/cost/arbitrary_rule/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getCustomAllocationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ArbitraryRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<ArbitraryRuleResponse>> getCustomAllocationRuleWithHttpInfoAsync(Long ruleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<ArbitraryRuleResponse>> result = new CompletableFuture<ApiResponse<ArbitraryRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling getCustomAllocationRule"));
            return result;
        }
        String localVarPath = "/api/v2/cost/arbitrary_rule/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getCustomAllocationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ArbitraryRuleResponse>> result = new CompletableFuture<ApiResponse<ArbitraryRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ArbitraryRuleResponse>(){});
    }

    public CustomCostsFileGetResponse getCustomCostsFile(String fileId) throws ApiException {
        return this.getCustomCostsFileWithHttpInfo(fileId).getData();
    }

    public CompletableFuture<CustomCostsFileGetResponse> getCustomCostsFileAsync(String fileId) {
        return this.getCustomCostsFileWithHttpInfoAsync(fileId).thenApply(response -> (CustomCostsFileGetResponse)response.getData());
    }

    public ApiResponse<CustomCostsFileGetResponse> getCustomCostsFileWithHttpInfo(String fileId) throws ApiException {
        Object localVarPostBody = null;
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling getCustomCostsFile");
        }
        String localVarPath = "/api/v2/cost/custom_costs/{file_id}".replaceAll("\\{file_id\\}", this.apiClient.escapeString(fileId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getCustomCostsFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomCostsFileGetResponse>(){});
    }

    public CompletableFuture<ApiResponse<CustomCostsFileGetResponse>> getCustomCostsFileWithHttpInfoAsync(String fileId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (fileId == null) {
            CompletableFuture<ApiResponse<CustomCostsFileGetResponse>> result = new CompletableFuture<ApiResponse<CustomCostsFileGetResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'fileId' when calling getCustomCostsFile"));
            return result;
        }
        String localVarPath = "/api/v2/cost/custom_costs/{file_id}".replaceAll("\\{file_id\\}", this.apiClient.escapeString(fileId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getCustomCostsFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CustomCostsFileGetResponse>> result = new CompletableFuture<ApiResponse<CustomCostsFileGetResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomCostsFileGetResponse>(){});
    }

    public RulesetResp getTagPipelinesRuleset(String rulesetId) throws ApiException {
        return this.getTagPipelinesRulesetWithHttpInfo(rulesetId).getData();
    }

    public CompletableFuture<RulesetResp> getTagPipelinesRulesetAsync(String rulesetId) {
        return this.getTagPipelinesRulesetWithHttpInfoAsync(rulesetId).thenApply(response -> (RulesetResp)response.getData());
    }

    public ApiResponse<RulesetResp> getTagPipelinesRulesetWithHttpInfo(String rulesetId) throws ApiException {
        Object localVarPostBody = null;
        if (rulesetId == null) {
            throw new ApiException(400, "Missing the required parameter 'rulesetId' when calling getTagPipelinesRuleset");
        }
        String localVarPath = "/api/v2/tags/enrichment/{ruleset_id}".replaceAll("\\{ruleset_id\\}", this.apiClient.escapeString(rulesetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getTagPipelinesRuleset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RulesetResp>(){});
    }

    public CompletableFuture<ApiResponse<RulesetResp>> getTagPipelinesRulesetWithHttpInfoAsync(String rulesetId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (rulesetId == null) {
            CompletableFuture<ApiResponse<RulesetResp>> result = new CompletableFuture<ApiResponse<RulesetResp>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'rulesetId' when calling getTagPipelinesRuleset"));
            return result;
        }
        String localVarPath = "/api/v2/tags/enrichment/{ruleset_id}".replaceAll("\\{ruleset_id\\}", this.apiClient.escapeString(rulesetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getTagPipelinesRuleset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RulesetResp>> result = new CompletableFuture<ApiResponse<RulesetResp>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RulesetResp>(){});
    }

    public BudgetArray listBudgets() throws ApiException {
        return this.listBudgetsWithHttpInfo().getData();
    }

    public CompletableFuture<BudgetArray> listBudgetsAsync() {
        return this.listBudgetsWithHttpInfoAsync().thenApply(response -> (BudgetArray)response.getData());
    }

    public ApiResponse<BudgetArray> listBudgetsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/budgets";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listBudgets", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BudgetArray>(){});
    }

    public CompletableFuture<ApiResponse<BudgetArray>> listBudgetsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/budgets";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listBudgets", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<BudgetArray>> result = new CompletableFuture<ApiResponse<BudgetArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BudgetArray>(){});
    }

    public AwsCURConfigsResponse listCostAWSCURConfigs() throws ApiException {
        return this.listCostAWSCURConfigsWithHttpInfo().getData();
    }

    public CompletableFuture<AwsCURConfigsResponse> listCostAWSCURConfigsAsync() {
        return this.listCostAWSCURConfigsWithHttpInfoAsync().thenApply(response -> (AwsCURConfigsResponse)response.getData());
    }

    public ApiResponse<AwsCURConfigsResponse> listCostAWSCURConfigsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/aws_cur_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCostAWSCURConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsCURConfigsResponse>> listCostAWSCURConfigsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/aws_cur_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCostAWSCURConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsCURConfigsResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigsResponse>(){});
    }

    public AzureUCConfigsResponse listCostAzureUCConfigs() throws ApiException {
        return this.listCostAzureUCConfigsWithHttpInfo().getData();
    }

    public CompletableFuture<AzureUCConfigsResponse> listCostAzureUCConfigsAsync() {
        return this.listCostAzureUCConfigsWithHttpInfoAsync().thenApply(response -> (AzureUCConfigsResponse)response.getData());
    }

    public ApiResponse<AzureUCConfigsResponse> listCostAzureUCConfigsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/azure_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AzureUCConfigsResponse>> listCostAzureUCConfigsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/azure_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AzureUCConfigsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigsResponse>(){});
    }

    public GCPUsageCostConfigsResponse listCostGCPUsageCostConfigs() throws ApiException {
        return this.listCostGCPUsageCostConfigsWithHttpInfo().getData();
    }

    public CompletableFuture<GCPUsageCostConfigsResponse> listCostGCPUsageCostConfigsAsync() {
        return this.listCostGCPUsageCostConfigsWithHttpInfoAsync().thenApply(response -> (GCPUsageCostConfigsResponse)response.getData());
    }

    public ApiResponse<GCPUsageCostConfigsResponse> listCostGCPUsageCostConfigsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/gcp_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCostGCPUsageCostConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPUsageCostConfigsResponse>(){});
    }

    public CompletableFuture<ApiResponse<GCPUsageCostConfigsResponse>> listCostGCPUsageCostConfigsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/gcp_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCostGCPUsageCostConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GCPUsageCostConfigsResponse>> result = new CompletableFuture<ApiResponse<GCPUsageCostConfigsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPUsageCostConfigsResponse>(){});
    }

    public ArbitraryRuleResponseArray listCustomAllocationRules() throws ApiException {
        return this.listCustomAllocationRulesWithHttpInfo().getData();
    }

    public CompletableFuture<ArbitraryRuleResponseArray> listCustomAllocationRulesAsync() {
        return this.listCustomAllocationRulesWithHttpInfoAsync().thenApply(response -> (ArbitraryRuleResponseArray)response.getData());
    }

    public ApiResponse<ArbitraryRuleResponseArray> listCustomAllocationRulesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/arbitrary_rule";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCustomAllocationRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ArbitraryRuleResponseArray>(){});
    }

    public CompletableFuture<ApiResponse<ArbitraryRuleResponseArray>> listCustomAllocationRulesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/arbitrary_rule";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCustomAllocationRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ArbitraryRuleResponseArray>> result = new CompletableFuture<ApiResponse<ArbitraryRuleResponseArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ArbitraryRuleResponseArray>(){});
    }

    public CustomCostsFileListResponse listCustomCostsFiles() throws ApiException {
        return this.listCustomCostsFilesWithHttpInfo(new ListCustomCostsFilesOptionalParameters()).getData();
    }

    public CompletableFuture<CustomCostsFileListResponse> listCustomCostsFilesAsync() {
        return this.listCustomCostsFilesWithHttpInfoAsync(new ListCustomCostsFilesOptionalParameters()).thenApply(response -> (CustomCostsFileListResponse)response.getData());
    }

    public CustomCostsFileListResponse listCustomCostsFiles(ListCustomCostsFilesOptionalParameters parameters) throws ApiException {
        return this.listCustomCostsFilesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<CustomCostsFileListResponse> listCustomCostsFilesAsync(ListCustomCostsFilesOptionalParameters parameters) {
        return this.listCustomCostsFilesWithHttpInfoAsync(parameters).thenApply(response -> (CustomCostsFileListResponse)response.getData());
    }

    public ApiResponse<CustomCostsFileListResponse> listCustomCostsFilesWithHttpInfo(ListCustomCostsFilesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageNumber = parameters.pageNumber;
        Long pageSize = parameters.pageSize;
        String filterStatus = parameters.filterStatus;
        String sort = parameters.sort;
        String localVarPath = "/api/v2/cost/custom_costs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[status]", filterStatus));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCustomCostsFiles", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomCostsFileListResponse>(){});
    }

    public CompletableFuture<ApiResponse<CustomCostsFileListResponse>> listCustomCostsFilesWithHttpInfoAsync(ListCustomCostsFilesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageNumber = parameters.pageNumber;
        Long pageSize = parameters.pageSize;
        String filterStatus = parameters.filterStatus;
        String sort = parameters.sort;
        String localVarPath = "/api/v2/cost/custom_costs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[status]", filterStatus));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCustomCostsFiles", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CustomCostsFileListResponse>> result = new CompletableFuture<ApiResponse<CustomCostsFileListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomCostsFileListResponse>(){});
    }

    public RulesetRespArray listTagPipelinesRulesets() throws ApiException {
        return this.listTagPipelinesRulesetsWithHttpInfo().getData();
    }

    public CompletableFuture<RulesetRespArray> listTagPipelinesRulesetsAsync() {
        return this.listTagPipelinesRulesetsWithHttpInfoAsync().thenApply(response -> (RulesetRespArray)response.getData());
    }

    public ApiResponse<RulesetRespArray> listTagPipelinesRulesetsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/tags/enrichment";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listTagPipelinesRulesets", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RulesetRespArray>(){});
    }

    public CompletableFuture<ApiResponse<RulesetRespArray>> listTagPipelinesRulesetsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/tags/enrichment";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listTagPipelinesRulesets", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RulesetRespArray>> result = new CompletableFuture<ApiResponse<RulesetRespArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RulesetRespArray>(){});
    }

    public void reorderCustomAllocationRules(ReorderRuleResourceArray body) throws ApiException {
        this.reorderCustomAllocationRulesWithHttpInfo(body);
    }

    public CompletableFuture<Void> reorderCustomAllocationRulesAsync(ReorderRuleResourceArray body) {
        return this.reorderCustomAllocationRulesWithHttpInfoAsync(body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> reorderCustomAllocationRulesWithHttpInfo(ReorderRuleResourceArray body) throws ApiException {
        ReorderRuleResourceArray localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling reorderCustomAllocationRules");
        }
        String localVarPath = "/api/v2/cost/arbitrary_rule/reorder";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.reorderCustomAllocationRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> reorderCustomAllocationRulesWithHttpInfoAsync(ReorderRuleResourceArray body) {
        Invocation.Builder builder;
        ReorderRuleResourceArray localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling reorderCustomAllocationRules"));
            return result;
        }
        String localVarPath = "/api/v2/cost/arbitrary_rule/reorder";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.reorderCustomAllocationRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void reorderTagPipelinesRulesets(ReorderRulesetResourceArray body) throws ApiException {
        this.reorderTagPipelinesRulesetsWithHttpInfo(body);
    }

    public CompletableFuture<Void> reorderTagPipelinesRulesetsAsync(ReorderRulesetResourceArray body) {
        return this.reorderTagPipelinesRulesetsWithHttpInfoAsync(body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> reorderTagPipelinesRulesetsWithHttpInfo(ReorderRulesetResourceArray body) throws ApiException {
        ReorderRulesetResourceArray localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling reorderTagPipelinesRulesets");
        }
        String localVarPath = "/api/v2/tags/enrichment/reorder";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.reorderTagPipelinesRulesets", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> reorderTagPipelinesRulesetsWithHttpInfoAsync(ReorderRulesetResourceArray body) {
        Invocation.Builder builder;
        ReorderRulesetResourceArray localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling reorderTagPipelinesRulesets"));
            return result;
        }
        String localVarPath = "/api/v2/tags/enrichment/reorder";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.reorderTagPipelinesRulesets", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public AwsCURConfigsResponse updateCostAWSCURConfig(Long cloudAccountId, AwsCURConfigPatchRequest body) throws ApiException {
        return this.updateCostAWSCURConfigWithHttpInfo(cloudAccountId, body).getData();
    }

    public CompletableFuture<AwsCURConfigsResponse> updateCostAWSCURConfigAsync(Long cloudAccountId, AwsCURConfigPatchRequest body) {
        return this.updateCostAWSCURConfigWithHttpInfoAsync(cloudAccountId, body).thenApply(response -> (AwsCURConfigsResponse)response.getData());
    }

    public ApiResponse<AwsCURConfigsResponse> updateCostAWSCURConfigWithHttpInfo(Long cloudAccountId, AwsCURConfigPatchRequest body) throws ApiException {
        AwsCURConfigPatchRequest localVarPostBody = body;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling updateCostAWSCURConfig");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCostAWSCURConfig");
        }
        String localVarPath = "/api/v2/cost/aws_cur_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsCURConfigsResponse>> updateCostAWSCURConfigWithHttpInfoAsync(Long cloudAccountId, AwsCURConfigPatchRequest body) {
        Invocation.Builder builder;
        AwsCURConfigPatchRequest localVarPostBody = body;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<AwsCURConfigsResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling updateCostAWSCURConfig"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<AwsCURConfigsResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateCostAWSCURConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/aws_cur_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsCURConfigsResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigsResponse>(){});
    }

    public AzureUCConfigPairsResponse updateCostAzureUCConfigs(Long cloudAccountId, AzureUCConfigPatchRequest body) throws ApiException {
        return this.updateCostAzureUCConfigsWithHttpInfo(cloudAccountId, body).getData();
    }

    public CompletableFuture<AzureUCConfigPairsResponse> updateCostAzureUCConfigsAsync(Long cloudAccountId, AzureUCConfigPatchRequest body) {
        return this.updateCostAzureUCConfigsWithHttpInfoAsync(cloudAccountId, body).thenApply(response -> (AzureUCConfigPairsResponse)response.getData());
    }

    public ApiResponse<AzureUCConfigPairsResponse> updateCostAzureUCConfigsWithHttpInfo(Long cloudAccountId, AzureUCConfigPatchRequest body) throws ApiException {
        AzureUCConfigPatchRequest localVarPostBody = body;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling updateCostAzureUCConfigs");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCostAzureUCConfigs");
        }
        String localVarPath = "/api/v2/cost/azure_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigPairsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> updateCostAzureUCConfigsWithHttpInfoAsync(Long cloudAccountId, AzureUCConfigPatchRequest body) {
        Invocation.Builder builder;
        AzureUCConfigPatchRequest localVarPostBody = body;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling updateCostAzureUCConfigs"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateCostAzureUCConfigs"));
            return result;
        }
        String localVarPath = "/api/v2/cost/azure_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigPairsResponse>(){});
    }

    public GCPUsageCostConfigResponse updateCostGCPUsageCostConfig(Long cloudAccountId, GCPUsageCostConfigPatchRequest body) throws ApiException {
        return this.updateCostGCPUsageCostConfigWithHttpInfo(cloudAccountId, body).getData();
    }

    public CompletableFuture<GCPUsageCostConfigResponse> updateCostGCPUsageCostConfigAsync(Long cloudAccountId, GCPUsageCostConfigPatchRequest body) {
        return this.updateCostGCPUsageCostConfigWithHttpInfoAsync(cloudAccountId, body).thenApply(response -> (GCPUsageCostConfigResponse)response.getData());
    }

    public ApiResponse<GCPUsageCostConfigResponse> updateCostGCPUsageCostConfigWithHttpInfo(Long cloudAccountId, GCPUsageCostConfigPatchRequest body) throws ApiException {
        GCPUsageCostConfigPatchRequest localVarPostBody = body;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling updateCostGCPUsageCostConfig");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCostGCPUsageCostConfig");
        }
        String localVarPath = "/api/v2/cost/gcp_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCostGCPUsageCostConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPUsageCostConfigResponse>(){});
    }

    public CompletableFuture<ApiResponse<GCPUsageCostConfigResponse>> updateCostGCPUsageCostConfigWithHttpInfoAsync(Long cloudAccountId, GCPUsageCostConfigPatchRequest body) {
        Invocation.Builder builder;
        GCPUsageCostConfigPatchRequest localVarPostBody = body;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<GCPUsageCostConfigResponse>> result = new CompletableFuture<ApiResponse<GCPUsageCostConfigResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling updateCostGCPUsageCostConfig"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<GCPUsageCostConfigResponse>> result = new CompletableFuture<ApiResponse<GCPUsageCostConfigResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateCostGCPUsageCostConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/gcp_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCostGCPUsageCostConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GCPUsageCostConfigResponse>> result = new CompletableFuture<ApiResponse<GCPUsageCostConfigResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPUsageCostConfigResponse>(){});
    }

    public ArbitraryRuleResponse updateCustomAllocationRule(Long ruleId, ArbitraryCostUpsertRequest body) throws ApiException {
        return this.updateCustomAllocationRuleWithHttpInfo(ruleId, body).getData();
    }

    public CompletableFuture<ArbitraryRuleResponse> updateCustomAllocationRuleAsync(Long ruleId, ArbitraryCostUpsertRequest body) {
        return this.updateCustomAllocationRuleWithHttpInfoAsync(ruleId, body).thenApply(response -> (ArbitraryRuleResponse)response.getData());
    }

    public ApiResponse<ArbitraryRuleResponse> updateCustomAllocationRuleWithHttpInfo(Long ruleId, ArbitraryCostUpsertRequest body) throws ApiException {
        ArbitraryCostUpsertRequest localVarPostBody = body;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling updateCustomAllocationRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCustomAllocationRule");
        }
        String localVarPath = "/api/v2/cost/arbitrary_rule/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCustomAllocationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ArbitraryRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<ArbitraryRuleResponse>> updateCustomAllocationRuleWithHttpInfoAsync(Long ruleId, ArbitraryCostUpsertRequest body) {
        Invocation.Builder builder;
        ArbitraryCostUpsertRequest localVarPostBody = body;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<ArbitraryRuleResponse>> result = new CompletableFuture<ApiResponse<ArbitraryRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling updateCustomAllocationRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<ArbitraryRuleResponse>> result = new CompletableFuture<ApiResponse<ArbitraryRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateCustomAllocationRule"));
            return result;
        }
        String localVarPath = "/api/v2/cost/arbitrary_rule/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCustomAllocationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ArbitraryRuleResponse>> result = new CompletableFuture<ApiResponse<ArbitraryRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ArbitraryRuleResponse>(){});
    }

    public RulesetResp updateTagPipelinesRuleset(String rulesetId, UpdateRulesetRequest body) throws ApiException {
        return this.updateTagPipelinesRulesetWithHttpInfo(rulesetId, body).getData();
    }

    public CompletableFuture<RulesetResp> updateTagPipelinesRulesetAsync(String rulesetId, UpdateRulesetRequest body) {
        return this.updateTagPipelinesRulesetWithHttpInfoAsync(rulesetId, body).thenApply(response -> (RulesetResp)response.getData());
    }

    public ApiResponse<RulesetResp> updateTagPipelinesRulesetWithHttpInfo(String rulesetId, UpdateRulesetRequest body) throws ApiException {
        UpdateRulesetRequest localVarPostBody = body;
        if (rulesetId == null) {
            throw new ApiException(400, "Missing the required parameter 'rulesetId' when calling updateTagPipelinesRuleset");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTagPipelinesRuleset");
        }
        String localVarPath = "/api/v2/tags/enrichment/{ruleset_id}".replaceAll("\\{ruleset_id\\}", this.apiClient.escapeString(rulesetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateTagPipelinesRuleset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RulesetResp>(){});
    }

    public CompletableFuture<ApiResponse<RulesetResp>> updateTagPipelinesRulesetWithHttpInfoAsync(String rulesetId, UpdateRulesetRequest body) {
        Invocation.Builder builder;
        UpdateRulesetRequest localVarPostBody = body;
        if (rulesetId == null) {
            CompletableFuture<ApiResponse<RulesetResp>> result = new CompletableFuture<ApiResponse<RulesetResp>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'rulesetId' when calling updateTagPipelinesRuleset"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<RulesetResp>> result = new CompletableFuture<ApiResponse<RulesetResp>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateTagPipelinesRuleset"));
            return result;
        }
        String localVarPath = "/api/v2/tags/enrichment/{ruleset_id}".replaceAll("\\{ruleset_id\\}", this.apiClient.escapeString(rulesetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateTagPipelinesRuleset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RulesetResp>> result = new CompletableFuture<ApiResponse<RulesetResp>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RulesetResp>(){});
    }

    public CustomCostsFileUploadResponse uploadCustomCostsFile(List<CustomCostsFileLineItem> body) throws ApiException {
        return this.uploadCustomCostsFileWithHttpInfo(body).getData();
    }

    public CompletableFuture<CustomCostsFileUploadResponse> uploadCustomCostsFileAsync(List<CustomCostsFileLineItem> body) {
        return this.uploadCustomCostsFileWithHttpInfoAsync(body).thenApply(response -> (CustomCostsFileUploadResponse)response.getData());
    }

    public ApiResponse<CustomCostsFileUploadResponse> uploadCustomCostsFileWithHttpInfo(List<CustomCostsFileLineItem> body) throws ApiException {
        List<CustomCostsFileLineItem> localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling uploadCustomCostsFile");
        }
        String localVarPath = "/api/v2/cost/custom_costs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.uploadCustomCostsFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomCostsFileUploadResponse>(){});
    }

    public CompletableFuture<ApiResponse<CustomCostsFileUploadResponse>> uploadCustomCostsFileWithHttpInfoAsync(List<CustomCostsFileLineItem> body) {
        Invocation.Builder builder;
        List<CustomCostsFileLineItem> localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CustomCostsFileUploadResponse>> result = new CompletableFuture<ApiResponse<CustomCostsFileUploadResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling uploadCustomCostsFile"));
            return result;
        }
        String localVarPath = "/api/v2/cost/custom_costs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.uploadCustomCostsFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CustomCostsFileUploadResponse>> result = new CompletableFuture<ApiResponse<CustomCostsFileUploadResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomCostsFileUploadResponse>(){});
    }

    public BudgetWithEntries upsertBudget(BudgetWithEntries body) throws ApiException {
        return this.upsertBudgetWithHttpInfo(body).getData();
    }

    public CompletableFuture<BudgetWithEntries> upsertBudgetAsync(BudgetWithEntries body) {
        return this.upsertBudgetWithHttpInfoAsync(body).thenApply(response -> (BudgetWithEntries)response.getData());
    }

    public ApiResponse<BudgetWithEntries> upsertBudgetWithHttpInfo(BudgetWithEntries body) throws ApiException {
        BudgetWithEntries localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling upsertBudget");
        }
        String localVarPath = "/api/v2/cost/budget";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.upsertBudget", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BudgetWithEntries>(){});
    }

    public CompletableFuture<ApiResponse<BudgetWithEntries>> upsertBudgetWithHttpInfoAsync(BudgetWithEntries body) {
        Invocation.Builder builder;
        BudgetWithEntries localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<BudgetWithEntries>> result = new CompletableFuture<ApiResponse<BudgetWithEntries>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling upsertBudget"));
            return result;
        }
        String localVarPath = "/api/v2/cost/budget";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.upsertBudget", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<BudgetWithEntries>> result = new CompletableFuture<ApiResponse<BudgetWithEntries>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BudgetWithEntries>(){});
    }

    public RulesValidateQueryResponse validateQuery(RulesValidateQueryRequest body) throws ApiException {
        return this.validateQueryWithHttpInfo(body).getData();
    }

    public CompletableFuture<RulesValidateQueryResponse> validateQueryAsync(RulesValidateQueryRequest body) {
        return this.validateQueryWithHttpInfoAsync(body).thenApply(response -> (RulesValidateQueryResponse)response.getData());
    }

    public ApiResponse<RulesValidateQueryResponse> validateQueryWithHttpInfo(RulesValidateQueryRequest body) throws ApiException {
        RulesValidateQueryRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling validateQuery");
        }
        String localVarPath = "/api/v2/tags/enrichment/validate-query";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.validateQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RulesValidateQueryResponse>(){});
    }

    public CompletableFuture<ApiResponse<RulesValidateQueryResponse>> validateQueryWithHttpInfoAsync(RulesValidateQueryRequest body) {
        Invocation.Builder builder;
        RulesValidateQueryRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<RulesValidateQueryResponse>> result = new CompletableFuture<ApiResponse<RulesValidateQueryResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling validateQuery"));
            return result;
        }
        String localVarPath = "/api/v2/tags/enrichment/validate-query";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.validateQuery", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RulesValidateQueryResponse>> result = new CompletableFuture<ApiResponse<RulesValidateQueryResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RulesValidateQueryResponse>(){});
    }

    public static class ListCustomCostsFilesOptionalParameters {
        private Long pageNumber;
        private Long pageSize;
        private String filterStatus;
        private String sort;

        public ListCustomCostsFilesOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListCustomCostsFilesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListCustomCostsFilesOptionalParameters filterStatus(String filterStatus) {
            this.filterStatus = filterStatus;
            return this;
        }

        public ListCustomCostsFilesOptionalParameters sort(String sort) {
            this.sort = sort;
            return this;
        }
    }
}

