/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.SecurityMonitoringRuleDetectionMethod;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleEvaluationWindow;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleImpossibleTravelOptions;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleKeepAlive;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleMaxSignalDuration;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleNewValueOptions;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleSequenceDetectionOptions;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleThirdPartyOptions;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"detectionMethod", "evaluationWindow", "impossibleTravelOptions", "keepAlive", "maxSignalDuration", "newValueOptions", "sequenceDetectionOptions", "thirdPartyRuleOptions"})
public class HistoricalJobOptions {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DETECTION_METHOD = "detectionMethod";
    private SecurityMonitoringRuleDetectionMethod detectionMethod;
    public static final String JSON_PROPERTY_EVALUATION_WINDOW = "evaluationWindow";
    private SecurityMonitoringRuleEvaluationWindow evaluationWindow;
    public static final String JSON_PROPERTY_IMPOSSIBLE_TRAVEL_OPTIONS = "impossibleTravelOptions";
    private SecurityMonitoringRuleImpossibleTravelOptions impossibleTravelOptions;
    public static final String JSON_PROPERTY_KEEP_ALIVE = "keepAlive";
    private SecurityMonitoringRuleKeepAlive keepAlive;
    public static final String JSON_PROPERTY_MAX_SIGNAL_DURATION = "maxSignalDuration";
    private SecurityMonitoringRuleMaxSignalDuration maxSignalDuration;
    public static final String JSON_PROPERTY_NEW_VALUE_OPTIONS = "newValueOptions";
    private SecurityMonitoringRuleNewValueOptions newValueOptions;
    public static final String JSON_PROPERTY_SEQUENCE_DETECTION_OPTIONS = "sequenceDetectionOptions";
    private SecurityMonitoringRuleSequenceDetectionOptions sequenceDetectionOptions;
    public static final String JSON_PROPERTY_THIRD_PARTY_RULE_OPTIONS = "thirdPartyRuleOptions";
    private SecurityMonitoringRuleThirdPartyOptions thirdPartyRuleOptions;
    private Map<String, Object> additionalProperties;

    public HistoricalJobOptions detectionMethod(SecurityMonitoringRuleDetectionMethod detectionMethod) {
        this.detectionMethod = detectionMethod;
        this.unparsed |= !detectionMethod.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="detectionMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleDetectionMethod getDetectionMethod() {
        return this.detectionMethod;
    }

    public void setDetectionMethod(SecurityMonitoringRuleDetectionMethod detectionMethod) {
        if (!detectionMethod.isValid()) {
            this.unparsed = true;
        }
        this.detectionMethod = detectionMethod;
    }

    public HistoricalJobOptions evaluationWindow(SecurityMonitoringRuleEvaluationWindow evaluationWindow) {
        this.evaluationWindow = evaluationWindow;
        this.unparsed |= !evaluationWindow.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="evaluationWindow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleEvaluationWindow getEvaluationWindow() {
        return this.evaluationWindow;
    }

    public void setEvaluationWindow(SecurityMonitoringRuleEvaluationWindow evaluationWindow) {
        if (!evaluationWindow.isValid()) {
            this.unparsed = true;
        }
        this.evaluationWindow = evaluationWindow;
    }

    public HistoricalJobOptions impossibleTravelOptions(SecurityMonitoringRuleImpossibleTravelOptions impossibleTravelOptions) {
        this.impossibleTravelOptions = impossibleTravelOptions;
        this.unparsed |= impossibleTravelOptions.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="impossibleTravelOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleImpossibleTravelOptions getImpossibleTravelOptions() {
        return this.impossibleTravelOptions;
    }

    public void setImpossibleTravelOptions(SecurityMonitoringRuleImpossibleTravelOptions impossibleTravelOptions) {
        this.impossibleTravelOptions = impossibleTravelOptions;
    }

    public HistoricalJobOptions keepAlive(SecurityMonitoringRuleKeepAlive keepAlive) {
        this.keepAlive = keepAlive;
        this.unparsed |= !keepAlive.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="keepAlive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleKeepAlive getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(SecurityMonitoringRuleKeepAlive keepAlive) {
        if (!keepAlive.isValid()) {
            this.unparsed = true;
        }
        this.keepAlive = keepAlive;
    }

    public HistoricalJobOptions maxSignalDuration(SecurityMonitoringRuleMaxSignalDuration maxSignalDuration) {
        this.maxSignalDuration = maxSignalDuration;
        this.unparsed |= !maxSignalDuration.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="maxSignalDuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleMaxSignalDuration getMaxSignalDuration() {
        return this.maxSignalDuration;
    }

    public void setMaxSignalDuration(SecurityMonitoringRuleMaxSignalDuration maxSignalDuration) {
        if (!maxSignalDuration.isValid()) {
            this.unparsed = true;
        }
        this.maxSignalDuration = maxSignalDuration;
    }

    public HistoricalJobOptions newValueOptions(SecurityMonitoringRuleNewValueOptions newValueOptions) {
        this.newValueOptions = newValueOptions;
        this.unparsed |= newValueOptions.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="newValueOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleNewValueOptions getNewValueOptions() {
        return this.newValueOptions;
    }

    public void setNewValueOptions(SecurityMonitoringRuleNewValueOptions newValueOptions) {
        this.newValueOptions = newValueOptions;
    }

    public HistoricalJobOptions sequenceDetectionOptions(SecurityMonitoringRuleSequenceDetectionOptions sequenceDetectionOptions) {
        this.sequenceDetectionOptions = sequenceDetectionOptions;
        this.unparsed |= sequenceDetectionOptions.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="sequenceDetectionOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleSequenceDetectionOptions getSequenceDetectionOptions() {
        return this.sequenceDetectionOptions;
    }

    public void setSequenceDetectionOptions(SecurityMonitoringRuleSequenceDetectionOptions sequenceDetectionOptions) {
        this.sequenceDetectionOptions = sequenceDetectionOptions;
    }

    public HistoricalJobOptions thirdPartyRuleOptions(SecurityMonitoringRuleThirdPartyOptions thirdPartyRuleOptions) {
        this.thirdPartyRuleOptions = thirdPartyRuleOptions;
        this.unparsed |= thirdPartyRuleOptions.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="thirdPartyRuleOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleThirdPartyOptions getThirdPartyRuleOptions() {
        return this.thirdPartyRuleOptions;
    }

    public void setThirdPartyRuleOptions(SecurityMonitoringRuleThirdPartyOptions thirdPartyRuleOptions) {
        this.thirdPartyRuleOptions = thirdPartyRuleOptions;
    }

    @JsonAnySetter
    public HistoricalJobOptions putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricalJobOptions historicalJobOptions = (HistoricalJobOptions)o;
        return Objects.equals(this.detectionMethod, historicalJobOptions.detectionMethod) && Objects.equals(this.evaluationWindow, historicalJobOptions.evaluationWindow) && Objects.equals(this.impossibleTravelOptions, historicalJobOptions.impossibleTravelOptions) && Objects.equals(this.keepAlive, historicalJobOptions.keepAlive) && Objects.equals(this.maxSignalDuration, historicalJobOptions.maxSignalDuration) && Objects.equals(this.newValueOptions, historicalJobOptions.newValueOptions) && Objects.equals(this.sequenceDetectionOptions, historicalJobOptions.sequenceDetectionOptions) && Objects.equals(this.thirdPartyRuleOptions, historicalJobOptions.thirdPartyRuleOptions) && Objects.equals(this.additionalProperties, historicalJobOptions.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.detectionMethod, this.evaluationWindow, this.impossibleTravelOptions, this.keepAlive, this.maxSignalDuration, this.newValueOptions, this.sequenceDetectionOptions, this.thirdPartyRuleOptions, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricalJobOptions {\n");
        sb.append("    detectionMethod: ").append(this.toIndentedString(this.detectionMethod)).append("\n");
        sb.append("    evaluationWindow: ").append(this.toIndentedString(this.evaluationWindow)).append("\n");
        sb.append("    impossibleTravelOptions: ").append(this.toIndentedString(this.impossibleTravelOptions)).append("\n");
        sb.append("    keepAlive: ").append(this.toIndentedString(this.keepAlive)).append("\n");
        sb.append("    maxSignalDuration: ").append(this.toIndentedString(this.maxSignalDuration)).append("\n");
        sb.append("    newValueOptions: ").append(this.toIndentedString(this.newValueOptions)).append("\n");
        sb.append("    sequenceDetectionOptions: ").append(this.toIndentedString(this.sequenceDetectionOptions)).append("\n");
        sb.append("    thirdPartyRuleOptions: ").append(this.toIndentedString(this.thirdPartyRuleOptions)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

