/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ServiceDefinitionV2Contact;
import com.datadog.api.client.v2.model.ServiceDefinitionV2Doc;
import com.datadog.api.client.v2.model.ServiceDefinitionV2Integrations;
import com.datadog.api.client.v2.model.ServiceDefinitionV2Link;
import com.datadog.api.client.v2.model.ServiceDefinitionV2Repo;
import com.datadog.api.client.v2.model.ServiceDefinitionV2Version;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"contacts", "dd-service", "dd-team", "docs", "extensions", "integrations", "links", "repos", "schema-version", "tags", "team"})
public class ServiceDefinitionV2 {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CONTACTS = "contacts";
    private List<ServiceDefinitionV2Contact> contacts = null;
    public static final String JSON_PROPERTY_DD_SERVICE = "dd-service";
    private String ddService;
    public static final String JSON_PROPERTY_DD_TEAM = "dd-team";
    private String ddTeam;
    public static final String JSON_PROPERTY_DOCS = "docs";
    private List<ServiceDefinitionV2Doc> docs = null;
    public static final String JSON_PROPERTY_EXTENSIONS = "extensions";
    private Map<String, Object> extensions = null;
    public static final String JSON_PROPERTY_INTEGRATIONS = "integrations";
    private ServiceDefinitionV2Integrations integrations;
    public static final String JSON_PROPERTY_LINKS = "links";
    private List<ServiceDefinitionV2Link> links = null;
    public static final String JSON_PROPERTY_REPOS = "repos";
    private List<ServiceDefinitionV2Repo> repos = null;
    public static final String JSON_PROPERTY_SCHEMA_VERSION = "schema-version";
    private ServiceDefinitionV2Version schemaVersion = ServiceDefinitionV2Version.V2;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TEAM = "team";
    private String team;
    private Map<String, Object> additionalProperties;

    public ServiceDefinitionV2() {
    }

    @JsonCreator
    public ServiceDefinitionV2(@JsonProperty(required=true, value="dd-service") String ddService, @JsonProperty(required=true, value="schema-version") ServiceDefinitionV2Version schemaVersion) {
        this.ddService = ddService;
        this.schemaVersion = schemaVersion;
        this.unparsed |= !schemaVersion.isValid();
    }

    public ServiceDefinitionV2 contacts(List<ServiceDefinitionV2Contact> contacts) {
        this.contacts = contacts;
        for (ServiceDefinitionV2Contact item : contacts) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ServiceDefinitionV2 addContactsItem(ServiceDefinitionV2Contact contactsItem) {
        if (this.contacts == null) {
            this.contacts = new ArrayList<ServiceDefinitionV2Contact>();
        }
        this.contacts.add(contactsItem);
        this.unparsed |= contactsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="contacts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ServiceDefinitionV2Contact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<ServiceDefinitionV2Contact> contacts) {
        this.contacts = contacts;
    }

    public ServiceDefinitionV2 ddService(String ddService) {
        this.ddService = ddService;
        return this;
    }

    @JsonProperty(value="dd-service")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDdService() {
        return this.ddService;
    }

    public void setDdService(String ddService) {
        this.ddService = ddService;
    }

    public ServiceDefinitionV2 ddTeam(String ddTeam) {
        this.ddTeam = ddTeam;
        return this;
    }

    @Nullable
    @JsonProperty(value="dd-team")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDdTeam() {
        return this.ddTeam;
    }

    public void setDdTeam(String ddTeam) {
        this.ddTeam = ddTeam;
    }

    public ServiceDefinitionV2 docs(List<ServiceDefinitionV2Doc> docs) {
        this.docs = docs;
        for (ServiceDefinitionV2Doc item : docs) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ServiceDefinitionV2 addDocsItem(ServiceDefinitionV2Doc docsItem) {
        if (this.docs == null) {
            this.docs = new ArrayList<ServiceDefinitionV2Doc>();
        }
        this.docs.add(docsItem);
        this.unparsed |= docsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="docs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ServiceDefinitionV2Doc> getDocs() {
        return this.docs;
    }

    public void setDocs(List<ServiceDefinitionV2Doc> docs) {
        this.docs = docs;
    }

    public ServiceDefinitionV2 extensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public ServiceDefinitionV2 putExtensionsItem(String key, Object extensionsItem) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(key, extensionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="extensions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    public ServiceDefinitionV2 integrations(ServiceDefinitionV2Integrations integrations) {
        this.integrations = integrations;
        this.unparsed |= integrations.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="integrations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceDefinitionV2Integrations getIntegrations() {
        return this.integrations;
    }

    public void setIntegrations(ServiceDefinitionV2Integrations integrations) {
        this.integrations = integrations;
    }

    public ServiceDefinitionV2 links(List<ServiceDefinitionV2Link> links) {
        this.links = links;
        for (ServiceDefinitionV2Link item : links) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ServiceDefinitionV2 addLinksItem(ServiceDefinitionV2Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<ServiceDefinitionV2Link>();
        }
        this.links.add(linksItem);
        this.unparsed |= linksItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ServiceDefinitionV2Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<ServiceDefinitionV2Link> links) {
        this.links = links;
    }

    public ServiceDefinitionV2 repos(List<ServiceDefinitionV2Repo> repos) {
        this.repos = repos;
        for (ServiceDefinitionV2Repo item : repos) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ServiceDefinitionV2 addReposItem(ServiceDefinitionV2Repo reposItem) {
        if (this.repos == null) {
            this.repos = new ArrayList<ServiceDefinitionV2Repo>();
        }
        this.repos.add(reposItem);
        this.unparsed |= reposItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="repos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ServiceDefinitionV2Repo> getRepos() {
        return this.repos;
    }

    public void setRepos(List<ServiceDefinitionV2Repo> repos) {
        this.repos = repos;
    }

    public ServiceDefinitionV2 schemaVersion(ServiceDefinitionV2Version schemaVersion) {
        this.schemaVersion = schemaVersion;
        this.unparsed |= !schemaVersion.isValid();
        return this;
    }

    @JsonProperty(value="schema-version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ServiceDefinitionV2Version getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(ServiceDefinitionV2Version schemaVersion) {
        if (!schemaVersion.isValid()) {
            this.unparsed = true;
        }
        this.schemaVersion = schemaVersion;
    }

    public ServiceDefinitionV2 tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ServiceDefinitionV2 addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public ServiceDefinitionV2 team(String team) {
        this.team = team;
        return this;
    }

    @Nullable
    @JsonProperty(value="team")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTeam() {
        return this.team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    @JsonAnySetter
    public ServiceDefinitionV2 putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDefinitionV2 serviceDefinitionV2 = (ServiceDefinitionV2)o;
        return Objects.equals(this.contacts, serviceDefinitionV2.contacts) && Objects.equals(this.ddService, serviceDefinitionV2.ddService) && Objects.equals(this.ddTeam, serviceDefinitionV2.ddTeam) && Objects.equals(this.docs, serviceDefinitionV2.docs) && Objects.equals(this.extensions, serviceDefinitionV2.extensions) && Objects.equals(this.integrations, serviceDefinitionV2.integrations) && Objects.equals(this.links, serviceDefinitionV2.links) && Objects.equals(this.repos, serviceDefinitionV2.repos) && Objects.equals(this.schemaVersion, serviceDefinitionV2.schemaVersion) && Objects.equals(this.tags, serviceDefinitionV2.tags) && Objects.equals(this.team, serviceDefinitionV2.team) && Objects.equals(this.additionalProperties, serviceDefinitionV2.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.contacts, this.ddService, this.ddTeam, this.docs, this.extensions, this.integrations, this.links, this.repos, this.schemaVersion, this.tags, this.team, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceDefinitionV2 {\n");
        sb.append("    contacts: ").append(this.toIndentedString(this.contacts)).append("\n");
        sb.append("    ddService: ").append(this.toIndentedString(this.ddService)).append("\n");
        sb.append("    ddTeam: ").append(this.toIndentedString(this.ddTeam)).append("\n");
        sb.append("    docs: ").append(this.toIndentedString(this.docs)).append("\n");
        sb.append("    extensions: ").append(this.toIndentedString(this.extensions)).append("\n");
        sb.append("    integrations: ").append(this.toIndentedString(this.integrations)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    repos: ").append(this.toIndentedString(this.repos)).append("\n");
        sb.append("    schemaVersion: ").append(this.toIndentedString(this.schemaVersion)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    team: ").append(this.toIndentedString(this.team)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

