/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.Advisory;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"auto_solvable", "avoided_advisories", "fixed_advisories", "library_name", "library_version", "new_advisories", "remaining_advisories", "type"})
public class Remediation {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AUTO_SOLVABLE = "auto_solvable";
    private Boolean autoSolvable;
    public static final String JSON_PROPERTY_AVOIDED_ADVISORIES = "avoided_advisories";
    private List<Advisory> avoidedAdvisories = new ArrayList<Advisory>();
    public static final String JSON_PROPERTY_FIXED_ADVISORIES = "fixed_advisories";
    private List<Advisory> fixedAdvisories = new ArrayList<Advisory>();
    public static final String JSON_PROPERTY_LIBRARY_NAME = "library_name";
    private String libraryName;
    public static final String JSON_PROPERTY_LIBRARY_VERSION = "library_version";
    private String libraryVersion;
    public static final String JSON_PROPERTY_NEW_ADVISORIES = "new_advisories";
    private List<Advisory> newAdvisories = new ArrayList<Advisory>();
    public static final String JSON_PROPERTY_REMAINING_ADVISORIES = "remaining_advisories";
    private List<Advisory> remainingAdvisories = new ArrayList<Advisory>();
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    private Map<String, Object> additionalProperties;

    public Remediation() {
    }

    @JsonCreator
    public Remediation(@JsonProperty(required=true, value="auto_solvable") Boolean autoSolvable, @JsonProperty(required=true, value="avoided_advisories") List<Advisory> avoidedAdvisories, @JsonProperty(required=true, value="fixed_advisories") List<Advisory> fixedAdvisories, @JsonProperty(required=true, value="library_name") String libraryName, @JsonProperty(required=true, value="library_version") String libraryVersion, @JsonProperty(required=true, value="new_advisories") List<Advisory> newAdvisories, @JsonProperty(required=true, value="remaining_advisories") List<Advisory> remainingAdvisories, @JsonProperty(required=true, value="type") String type) {
        this.autoSolvable = autoSolvable;
        this.avoidedAdvisories = avoidedAdvisories;
        this.fixedAdvisories = fixedAdvisories;
        this.libraryName = libraryName;
        this.libraryVersion = libraryVersion;
        this.newAdvisories = newAdvisories;
        this.remainingAdvisories = remainingAdvisories;
        this.type = type;
    }

    public Remediation autoSolvable(Boolean autoSolvable) {
        this.autoSolvable = autoSolvable;
        return this;
    }

    @JsonProperty(value="auto_solvable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getAutoSolvable() {
        return this.autoSolvable;
    }

    public void setAutoSolvable(Boolean autoSolvable) {
        this.autoSolvable = autoSolvable;
    }

    public Remediation avoidedAdvisories(List<Advisory> avoidedAdvisories) {
        this.avoidedAdvisories = avoidedAdvisories;
        for (Advisory item : avoidedAdvisories) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public Remediation addAvoidedAdvisoriesItem(Advisory avoidedAdvisoriesItem) {
        this.avoidedAdvisories.add(avoidedAdvisoriesItem);
        this.unparsed |= avoidedAdvisoriesItem.unparsed;
        return this;
    }

    @JsonProperty(value="avoided_advisories")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Advisory> getAvoidedAdvisories() {
        return this.avoidedAdvisories;
    }

    public void setAvoidedAdvisories(List<Advisory> avoidedAdvisories) {
        this.avoidedAdvisories = avoidedAdvisories;
    }

    public Remediation fixedAdvisories(List<Advisory> fixedAdvisories) {
        this.fixedAdvisories = fixedAdvisories;
        for (Advisory item : fixedAdvisories) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public Remediation addFixedAdvisoriesItem(Advisory fixedAdvisoriesItem) {
        this.fixedAdvisories.add(fixedAdvisoriesItem);
        this.unparsed |= fixedAdvisoriesItem.unparsed;
        return this;
    }

    @JsonProperty(value="fixed_advisories")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Advisory> getFixedAdvisories() {
        return this.fixedAdvisories;
    }

    public void setFixedAdvisories(List<Advisory> fixedAdvisories) {
        this.fixedAdvisories = fixedAdvisories;
    }

    public Remediation libraryName(String libraryName) {
        this.libraryName = libraryName;
        return this;
    }

    @JsonProperty(value="library_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
    }

    public Remediation libraryVersion(String libraryVersion) {
        this.libraryVersion = libraryVersion;
        return this;
    }

    @JsonProperty(value="library_version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLibraryVersion() {
        return this.libraryVersion;
    }

    public void setLibraryVersion(String libraryVersion) {
        this.libraryVersion = libraryVersion;
    }

    public Remediation newAdvisories(List<Advisory> newAdvisories) {
        this.newAdvisories = newAdvisories;
        for (Advisory item : newAdvisories) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public Remediation addNewAdvisoriesItem(Advisory newAdvisoriesItem) {
        this.newAdvisories.add(newAdvisoriesItem);
        this.unparsed |= newAdvisoriesItem.unparsed;
        return this;
    }

    @JsonProperty(value="new_advisories")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Advisory> getNewAdvisories() {
        return this.newAdvisories;
    }

    public void setNewAdvisories(List<Advisory> newAdvisories) {
        this.newAdvisories = newAdvisories;
    }

    public Remediation remainingAdvisories(List<Advisory> remainingAdvisories) {
        this.remainingAdvisories = remainingAdvisories;
        for (Advisory item : remainingAdvisories) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public Remediation addRemainingAdvisoriesItem(Advisory remainingAdvisoriesItem) {
        this.remainingAdvisories.add(remainingAdvisoriesItem);
        this.unparsed |= remainingAdvisoriesItem.unparsed;
        return this;
    }

    @JsonProperty(value="remaining_advisories")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Advisory> getRemainingAdvisories() {
        return this.remainingAdvisories;
    }

    public void setRemainingAdvisories(List<Advisory> remainingAdvisories) {
        this.remainingAdvisories = remainingAdvisories;
    }

    public Remediation type(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonAnySetter
    public Remediation putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Remediation remediation = (Remediation)o;
        return Objects.equals(this.autoSolvable, remediation.autoSolvable) && Objects.equals(this.avoidedAdvisories, remediation.avoidedAdvisories) && Objects.equals(this.fixedAdvisories, remediation.fixedAdvisories) && Objects.equals(this.libraryName, remediation.libraryName) && Objects.equals(this.libraryVersion, remediation.libraryVersion) && Objects.equals(this.newAdvisories, remediation.newAdvisories) && Objects.equals(this.remainingAdvisories, remediation.remainingAdvisories) && Objects.equals(this.type, remediation.type) && Objects.equals(this.additionalProperties, remediation.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.autoSolvable, this.avoidedAdvisories, this.fixedAdvisories, this.libraryName, this.libraryVersion, this.newAdvisories, this.remainingAdvisories, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Remediation {\n");
        sb.append("    autoSolvable: ").append(this.toIndentedString(this.autoSolvable)).append("\n");
        sb.append("    avoidedAdvisories: ").append(this.toIndentedString(this.avoidedAdvisories)).append("\n");
        sb.append("    fixedAdvisories: ").append(this.toIndentedString(this.fixedAdvisories)).append("\n");
        sb.append("    libraryName: ").append(this.toIndentedString(this.libraryName)).append("\n");
        sb.append("    libraryVersion: ").append(this.toIndentedString(this.libraryVersion)).append("\n");
        sb.append("    newAdvisories: ").append(this.toIndentedString(this.newAdvisories)).append("\n");
        sb.append("    remainingAdvisories: ").append(this.toIndentedString(this.remainingAdvisories)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

