/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.RUMEventProcessingState;
import com.datadog.api.client.v2.model.RUMProductAnalyticsRetentionState;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "product_analytics_retention_state", "rum_event_processing_state", "type"})
public class RUMApplicationCreateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRODUCT_ANALYTICS_RETENTION_STATE = "product_analytics_retention_state";
    private RUMProductAnalyticsRetentionState productAnalyticsRetentionState;
    public static final String JSON_PROPERTY_RUM_EVENT_PROCESSING_STATE = "rum_event_processing_state";
    private RUMEventProcessingState rumEventProcessingState;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    private Map<String, Object> additionalProperties;

    public RUMApplicationCreateAttributes() {
    }

    @JsonCreator
    public RUMApplicationCreateAttributes(@JsonProperty(required=true, value="name") String name) {
        this.name = name;
    }

    public RUMApplicationCreateAttributes name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RUMApplicationCreateAttributes productAnalyticsRetentionState(RUMProductAnalyticsRetentionState productAnalyticsRetentionState) {
        this.productAnalyticsRetentionState = productAnalyticsRetentionState;
        this.unparsed |= !productAnalyticsRetentionState.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="product_analytics_retention_state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMProductAnalyticsRetentionState getProductAnalyticsRetentionState() {
        return this.productAnalyticsRetentionState;
    }

    public void setProductAnalyticsRetentionState(RUMProductAnalyticsRetentionState productAnalyticsRetentionState) {
        if (!productAnalyticsRetentionState.isValid()) {
            this.unparsed = true;
        }
        this.productAnalyticsRetentionState = productAnalyticsRetentionState;
    }

    public RUMApplicationCreateAttributes rumEventProcessingState(RUMEventProcessingState rumEventProcessingState) {
        this.rumEventProcessingState = rumEventProcessingState;
        this.unparsed |= !rumEventProcessingState.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="rum_event_processing_state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMEventProcessingState getRumEventProcessingState() {
        return this.rumEventProcessingState;
    }

    public void setRumEventProcessingState(RUMEventProcessingState rumEventProcessingState) {
        if (!rumEventProcessingState.isValid()) {
            this.unparsed = true;
        }
        this.rumEventProcessingState = rumEventProcessingState;
    }

    public RUMApplicationCreateAttributes type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonAnySetter
    public RUMApplicationCreateAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RUMApplicationCreateAttributes rumApplicationCreateAttributes = (RUMApplicationCreateAttributes)o;
        return Objects.equals(this.name, rumApplicationCreateAttributes.name) && Objects.equals(this.productAnalyticsRetentionState, rumApplicationCreateAttributes.productAnalyticsRetentionState) && Objects.equals(this.rumEventProcessingState, rumApplicationCreateAttributes.rumEventProcessingState) && Objects.equals(this.type, rumApplicationCreateAttributes.type) && Objects.equals(this.additionalProperties, rumApplicationCreateAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.productAnalyticsRetentionState, this.rumEventProcessingState, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RUMApplicationCreateAttributes {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    productAnalyticsRetentionState: ").append(this.toIndentedString(this.productAnalyticsRetentionState)).append("\n");
        sb.append("    rumEventProcessingState: ").append(this.toIndentedString(this.rumEventProcessingState)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

