/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.MetricsAggregator;
import com.datadog.api.client.v2.model.MetricsDataSource;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"aggregator", "data_source", "name", "query"})
public class MetricsScalarQuery {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATOR = "aggregator";
    private MetricsAggregator aggregator = MetricsAggregator.AVG;
    public static final String JSON_PROPERTY_DATA_SOURCE = "data_source";
    private MetricsDataSource dataSource = MetricsDataSource.METRICS;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    private Map<String, Object> additionalProperties;

    public MetricsScalarQuery() {
    }

    @JsonCreator
    public MetricsScalarQuery(@JsonProperty(required=true, value="aggregator") MetricsAggregator aggregator, @JsonProperty(required=true, value="data_source") MetricsDataSource dataSource, @JsonProperty(required=true, value="query") String query) {
        this.aggregator = aggregator;
        this.unparsed |= !aggregator.isValid();
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
        this.query = query;
    }

    public MetricsScalarQuery aggregator(MetricsAggregator aggregator) {
        this.aggregator = aggregator;
        this.unparsed |= !aggregator.isValid();
        return this;
    }

    @JsonProperty(value="aggregator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MetricsAggregator getAggregator() {
        return this.aggregator;
    }

    public void setAggregator(MetricsAggregator aggregator) {
        if (!aggregator.isValid()) {
            this.unparsed = true;
        }
        this.aggregator = aggregator;
    }

    public MetricsScalarQuery dataSource(MetricsDataSource dataSource) {
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
        return this;
    }

    @JsonProperty(value="data_source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MetricsDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(MetricsDataSource dataSource) {
        if (!dataSource.isValid()) {
            this.unparsed = true;
        }
        this.dataSource = dataSource;
    }

    public MetricsScalarQuery name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetricsScalarQuery query(String query) {
        this.query = query;
        return this;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @JsonAnySetter
    public MetricsScalarQuery putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricsScalarQuery metricsScalarQuery = (MetricsScalarQuery)o;
        return Objects.equals(this.aggregator, metricsScalarQuery.aggregator) && Objects.equals(this.dataSource, metricsScalarQuery.dataSource) && Objects.equals(this.name, metricsScalarQuery.name) && Objects.equals(this.query, metricsScalarQuery.query) && Objects.equals(this.additionalProperties, metricsScalarQuery.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.aggregator, this.dataSource, this.name, this.query, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricsScalarQuery {\n");
        sb.append("    aggregator: ").append(this.toIndentedString(this.aggregator)).append("\n");
        sb.append("    dataSource: ").append(this.toIndentedString(this.dataSource)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

