/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.InputSchemaParametersType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"defaultValue", "description", "label", "name", "type"})
public class InputSchemaParameters {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DEFAULT_VALUE = "defaultValue";
    private Object defaultValue = null;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TYPE = "type";
    private InputSchemaParametersType type;
    private Map<String, Object> additionalProperties;

    public InputSchemaParameters() {
    }

    @JsonCreator
    public InputSchemaParameters(@JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="type") InputSchemaParametersType type) {
        this.name = name;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public InputSchemaParameters defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Nullable
    @JsonProperty(value="defaultValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public InputSchemaParameters description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public InputSchemaParameters label(String label) {
        this.label = label;
        return this;
    }

    @Nullable
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public InputSchemaParameters name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InputSchemaParameters type(InputSchemaParametersType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public InputSchemaParametersType getType() {
        return this.type;
    }

    public void setType(InputSchemaParametersType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public InputSchemaParameters putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputSchemaParameters inputSchemaParameters = (InputSchemaParameters)o;
        return Objects.equals(this.defaultValue, inputSchemaParameters.defaultValue) && Objects.equals(this.description, inputSchemaParameters.description) && Objects.equals(this.label, inputSchemaParameters.label) && Objects.equals(this.name, inputSchemaParameters.name) && Objects.equals(this.type, inputSchemaParameters.type) && Objects.equals(this.additionalProperties, inputSchemaParameters.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.defaultValue, this.description, this.label, this.name, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InputSchemaParameters {\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

