/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.HTTPBody;
import com.datadog.api.client.v2.model.HTTPHeader;
import com.datadog.api.client.v2.model.HTTPToken;
import com.datadog.api.client.v2.model.HTTPTokenAuthType;
import com.datadog.api.client.v2.model.UrlParam;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"body", "headers", "tokens", "type", "url_parameters"})
public class HTTPTokenAuth {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_BODY = "body";
    private HTTPBody body;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    private List<HTTPHeader> headers = null;
    public static final String JSON_PROPERTY_TOKENS = "tokens";
    private List<HTTPToken> tokens = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private HTTPTokenAuthType type;
    public static final String JSON_PROPERTY_URL_PARAMETERS = "url_parameters";
    private List<UrlParam> urlParameters = null;
    private Map<String, Object> additionalProperties;

    public HTTPTokenAuth() {
    }

    @JsonCreator
    public HTTPTokenAuth(@JsonProperty(required=true, value="type") HTTPTokenAuthType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public HTTPTokenAuth body(HTTPBody body) {
        this.body = body;
        this.unparsed |= body.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HTTPBody getBody() {
        return this.body;
    }

    public void setBody(HTTPBody body) {
        this.body = body;
    }

    public HTTPTokenAuth headers(List<HTTPHeader> headers) {
        this.headers = headers;
        for (HTTPHeader item : headers) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public HTTPTokenAuth addHeadersItem(HTTPHeader headersItem) {
        if (this.headers == null) {
            this.headers = new ArrayList<HTTPHeader>();
        }
        this.headers.add(headersItem);
        this.unparsed |= headersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<HTTPHeader> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<HTTPHeader> headers) {
        this.headers = headers;
    }

    public HTTPTokenAuth tokens(List<HTTPToken> tokens) {
        this.tokens = tokens;
        for (HTTPToken item : tokens) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public HTTPTokenAuth addTokensItem(HTTPToken tokensItem) {
        if (this.tokens == null) {
            this.tokens = new ArrayList<HTTPToken>();
        }
        this.tokens.add(tokensItem);
        this.unparsed |= tokensItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="tokens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<HTTPToken> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<HTTPToken> tokens) {
        this.tokens = tokens;
    }

    public HTTPTokenAuth type(HTTPTokenAuthType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public HTTPTokenAuthType getType() {
        return this.type;
    }

    public void setType(HTTPTokenAuthType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public HTTPTokenAuth urlParameters(List<UrlParam> urlParameters) {
        this.urlParameters = urlParameters;
        for (UrlParam item : urlParameters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public HTTPTokenAuth addUrlParametersItem(UrlParam urlParametersItem) {
        if (this.urlParameters == null) {
            this.urlParameters = new ArrayList<UrlParam>();
        }
        this.urlParameters.add(urlParametersItem);
        this.unparsed |= urlParametersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="url_parameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UrlParam> getUrlParameters() {
        return this.urlParameters;
    }

    public void setUrlParameters(List<UrlParam> urlParameters) {
        this.urlParameters = urlParameters;
    }

    @JsonAnySetter
    public HTTPTokenAuth putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPTokenAuth httpTokenAuth = (HTTPTokenAuth)o;
        return Objects.equals(this.body, httpTokenAuth.body) && Objects.equals(this.headers, httpTokenAuth.headers) && Objects.equals(this.tokens, httpTokenAuth.tokens) && Objects.equals(this.type, httpTokenAuth.type) && Objects.equals(this.urlParameters, httpTokenAuth.urlParameters) && Objects.equals(this.additionalProperties, httpTokenAuth.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.headers, this.tokens, this.type, this.urlParameters, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HTTPTokenAuth {\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    tokens: ").append(this.toIndentedString(this.tokens)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    urlParameters: ").append(this.toIndentedString(this.urlParameters)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

