/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.EntityV3APIVersion;
import com.datadog.api.client.v2.model.EntityV3Integrations;
import com.datadog.api.client.v2.model.EntityV3Metadata;
import com.datadog.api.client.v2.model.EntityV3ServiceDatadog;
import com.datadog.api.client.v2.model.EntityV3ServiceKind;
import com.datadog.api.client.v2.model.EntityV3ServiceSpec;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"apiVersion", "datadog", "extensions", "integrations", "kind", "metadata", "spec"})
public class EntityV3Service {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    private EntityV3APIVersion apiVersion;
    public static final String JSON_PROPERTY_DATADOG = "datadog";
    private EntityV3ServiceDatadog datadog;
    public static final String JSON_PROPERTY_EXTENSIONS = "extensions";
    private Map<String, Object> extensions = null;
    public static final String JSON_PROPERTY_INTEGRATIONS = "integrations";
    private EntityV3Integrations integrations;
    public static final String JSON_PROPERTY_KIND = "kind";
    private EntityV3ServiceKind kind;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private EntityV3Metadata metadata;
    public static final String JSON_PROPERTY_SPEC = "spec";
    private EntityV3ServiceSpec spec;

    public EntityV3Service() {
    }

    @JsonCreator
    public EntityV3Service(@JsonProperty(required=true, value="apiVersion") EntityV3APIVersion apiVersion, @JsonProperty(required=true, value="kind") EntityV3ServiceKind kind, @JsonProperty(required=true, value="metadata") EntityV3Metadata metadata) {
        this.apiVersion = apiVersion;
        this.unparsed |= !apiVersion.isValid();
        this.kind = kind;
        this.unparsed |= !kind.isValid();
        this.metadata = metadata;
        this.unparsed |= metadata.unparsed;
    }

    public EntityV3Service apiVersion(EntityV3APIVersion apiVersion) {
        this.apiVersion = apiVersion;
        this.unparsed |= !apiVersion.isValid();
        return this;
    }

    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EntityV3APIVersion getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(EntityV3APIVersion apiVersion) {
        if (!apiVersion.isValid()) {
            this.unparsed = true;
        }
        this.apiVersion = apiVersion;
    }

    public EntityV3Service datadog(EntityV3ServiceDatadog datadog) {
        this.datadog = datadog;
        this.unparsed |= datadog.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="datadog")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityV3ServiceDatadog getDatadog() {
        return this.datadog;
    }

    public void setDatadog(EntityV3ServiceDatadog datadog) {
        this.datadog = datadog;
    }

    public EntityV3Service extensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public EntityV3Service putExtensionsItem(String key, Object extensionsItem) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(key, extensionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="extensions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    public EntityV3Service integrations(EntityV3Integrations integrations) {
        this.integrations = integrations;
        this.unparsed |= integrations.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="integrations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityV3Integrations getIntegrations() {
        return this.integrations;
    }

    public void setIntegrations(EntityV3Integrations integrations) {
        this.integrations = integrations;
    }

    public EntityV3Service kind(EntityV3ServiceKind kind) {
        this.kind = kind;
        this.unparsed |= !kind.isValid();
        return this;
    }

    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EntityV3ServiceKind getKind() {
        return this.kind;
    }

    public void setKind(EntityV3ServiceKind kind) {
        if (!kind.isValid()) {
            this.unparsed = true;
        }
        this.kind = kind;
    }

    public EntityV3Service metadata(EntityV3Metadata metadata) {
        this.metadata = metadata;
        this.unparsed |= metadata.unparsed;
        return this;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EntityV3Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(EntityV3Metadata metadata) {
        this.metadata = metadata;
    }

    public EntityV3Service spec(EntityV3ServiceSpec spec) {
        this.spec = spec;
        this.unparsed |= spec.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="spec")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityV3ServiceSpec getSpec() {
        return this.spec;
    }

    public void setSpec(EntityV3ServiceSpec spec) {
        this.spec = spec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityV3Service entityV3Service = (EntityV3Service)o;
        return Objects.equals(this.apiVersion, entityV3Service.apiVersion) && Objects.equals(this.datadog, entityV3Service.datadog) && Objects.equals(this.extensions, entityV3Service.extensions) && Objects.equals(this.integrations, entityV3Service.integrations) && Objects.equals(this.kind, entityV3Service.kind) && Objects.equals(this.metadata, entityV3Service.metadata) && Objects.equals(this.spec, entityV3Service.spec);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.datadog, this.extensions, this.integrations, this.kind, this.metadata, this.spec);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityV3Service {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    datadog: ").append(this.toIndentedString(this.datadog)).append("\n");
        sb.append("    extensions: ").append(this.toIndentedString(this.extensions)).append("\n");
        sb.append("    integrations: ").append(this.toIndentedString(this.integrations)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

