/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.FiltersPerProduct;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"created_at", "created_by", "name", "principals", "product_filters"})
public class DatasetAttributesResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_BY = "created_by";
    private UUID createdBy;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRINCIPALS = "principals";
    private List<String> principals = null;
    public static final String JSON_PROPERTY_PRODUCT_FILTERS = "product_filters";
    private List<FiltersPerProduct> productFilters = null;
    private Map<String, Object> additionalProperties;

    public DatasetAttributesResponse createdAt(OffsetDateTime createdAt) {
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    @Nullable
    @JsonIgnore
    public OffsetDateTime getCreatedAt() {
        return this.createdAt.orElse(null);
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getCreatedAt_JsonNullable() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt_JsonNullable(JsonNullable<OffsetDateTime> createdAt) {
        this.createdAt = createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = JsonNullable.of(createdAt);
    }

    public DatasetAttributesResponse createdBy(UUID createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UUID createdBy) {
        this.createdBy = createdBy;
    }

    public DatasetAttributesResponse name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DatasetAttributesResponse principals(List<String> principals) {
        this.principals = principals;
        return this;
    }

    public DatasetAttributesResponse addPrincipalsItem(String principalsItem) {
        if (this.principals == null) {
            this.principals = new ArrayList<String>();
        }
        this.principals.add(principalsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="principals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(List<String> principals) {
        this.principals = principals;
    }

    public DatasetAttributesResponse productFilters(List<FiltersPerProduct> productFilters) {
        this.productFilters = productFilters;
        for (FiltersPerProduct item : productFilters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public DatasetAttributesResponse addProductFiltersItem(FiltersPerProduct productFiltersItem) {
        if (this.productFilters == null) {
            this.productFilters = new ArrayList<FiltersPerProduct>();
        }
        this.productFilters.add(productFiltersItem);
        this.unparsed |= productFiltersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="product_filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FiltersPerProduct> getProductFilters() {
        return this.productFilters;
    }

    public void setProductFilters(List<FiltersPerProduct> productFilters) {
        this.productFilters = productFilters;
    }

    @JsonAnySetter
    public DatasetAttributesResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetAttributesResponse datasetAttributesResponse = (DatasetAttributesResponse)o;
        return Objects.equals(this.createdAt, datasetAttributesResponse.createdAt) && Objects.equals(this.createdBy, datasetAttributesResponse.createdBy) && Objects.equals(this.name, datasetAttributesResponse.name) && Objects.equals(this.principals, datasetAttributesResponse.principals) && Objects.equals(this.productFilters, datasetAttributesResponse.productFilters) && Objects.equals(this.additionalProperties, datasetAttributesResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.createdBy, this.name, this.principals, this.productFilters, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatasetAttributesResponse {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    principals: ").append(this.toIndentedString(this.principals)).append("\n");
        sb.append("    productFilters: ").append(this.toIndentedString(this.productFilters)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

