/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CasePriority;
import com.datadog.api.client.v2.model.CaseStatus;
import com.datadog.api.client.v2.model.CaseType;
import com.datadog.api.client.v2.model.JiraIssue;
import com.datadog.api.client.v2.model.ServiceNowTicket;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"archived_at", "attributes", "closed_at", "created_at", "description", "jira_issue", "key", "modified_at", "priority", "service_now_ticket", "status", "title", "type"})
public class CaseAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ARCHIVED_AT = "archived_at";
    private JsonNullable<OffsetDateTime> archivedAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, List<String>> attributes = null;
    public static final String JSON_PROPERTY_CLOSED_AT = "closed_at";
    private JsonNullable<OffsetDateTime> closedAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_JIRA_ISSUE = "jira_issue";
    private JsonNullable<JiraIssue> jiraIssue = JsonNullable.undefined();
    public static final String JSON_PROPERTY_KEY = "key";
    private String key;
    public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
    private JsonNullable<OffsetDateTime> modifiedAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private CasePriority priority = CasePriority.NOT_DEFINED;
    public static final String JSON_PROPERTY_SERVICE_NOW_TICKET = "service_now_ticket";
    private JsonNullable<ServiceNowTicket> serviceNowTicket = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATUS = "status";
    private CaseStatus status;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TYPE = "type";
    private CaseType type;
    private Map<String, Object> additionalProperties;

    @Nullable
    @JsonIgnore
    public OffsetDateTime getArchivedAt() {
        if (this.archivedAt == null) {
            this.archivedAt = JsonNullable.undefined();
        }
        return this.archivedAt.orElse(null);
    }

    @JsonProperty(value="archived_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getArchivedAt_JsonNullable() {
        return this.archivedAt;
    }

    @JsonProperty(value="archived_at")
    private void setArchivedAt_JsonNullable(JsonNullable<OffsetDateTime> archivedAt) {
        this.archivedAt = archivedAt;
    }

    public CaseAttributes attributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
        return this;
    }

    public CaseAttributes putAttributesItem(String key, List<String> attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, List<String>>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    @Nullable
    @JsonIgnore
    public OffsetDateTime getClosedAt() {
        if (this.closedAt == null) {
            this.closedAt = JsonNullable.undefined();
        }
        return this.closedAt.orElse(null);
    }

    @JsonProperty(value="closed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getClosedAt_JsonNullable() {
        return this.closedAt;
    }

    @JsonProperty(value="closed_at")
    private void setClosedAt_JsonNullable(JsonNullable<OffsetDateTime> closedAt) {
        this.closedAt = closedAt;
    }

    @Nullable
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public CaseAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Nullable
    @JsonIgnore
    public JiraIssue getJiraIssue() {
        if (this.jiraIssue == null) {
            this.jiraIssue = JsonNullable.undefined();
        }
        return this.jiraIssue.orElse(null);
    }

    @JsonProperty(value="jira_issue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<JiraIssue> getJiraIssue_JsonNullable() {
        return this.jiraIssue;
    }

    @JsonProperty(value="jira_issue")
    private void setJiraIssue_JsonNullable(JsonNullable<JiraIssue> jiraIssue) {
        this.jiraIssue = jiraIssue;
    }

    public CaseAttributes key(String key) {
        this.key = key;
        return this;
    }

    @Nullable
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Nullable
    @JsonIgnore
    public OffsetDateTime getModifiedAt() {
        if (this.modifiedAt == null) {
            this.modifiedAt = JsonNullable.undefined();
        }
        return this.modifiedAt.orElse(null);
    }

    @JsonProperty(value="modified_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getModifiedAt_JsonNullable() {
        return this.modifiedAt;
    }

    @JsonProperty(value="modified_at")
    private void setModifiedAt_JsonNullable(JsonNullable<OffsetDateTime> modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public CaseAttributes priority(CasePriority priority) {
        this.priority = priority;
        this.unparsed |= !priority.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CasePriority getPriority() {
        return this.priority;
    }

    public void setPriority(CasePriority priority) {
        if (!priority.isValid()) {
            this.unparsed = true;
        }
        this.priority = priority;
    }

    @Nullable
    @JsonIgnore
    public ServiceNowTicket getServiceNowTicket() {
        if (this.serviceNowTicket == null) {
            this.serviceNowTicket = JsonNullable.undefined();
        }
        return this.serviceNowTicket.orElse(null);
    }

    @JsonProperty(value="service_now_ticket")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<ServiceNowTicket> getServiceNowTicket_JsonNullable() {
        return this.serviceNowTicket;
    }

    @JsonProperty(value="service_now_ticket")
    private void setServiceNowTicket_JsonNullable(JsonNullable<ServiceNowTicket> serviceNowTicket) {
        this.serviceNowTicket = serviceNowTicket;
    }

    public CaseAttributes status(CaseStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(CaseStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public CaseAttributes title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CaseAttributes type(CaseType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CaseType getType() {
        return this.type;
    }

    public void setType(CaseType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public CaseAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseAttributes caseAttributes = (CaseAttributes)o;
        return Objects.equals(this.archivedAt, caseAttributes.archivedAt) && Objects.equals(this.attributes, caseAttributes.attributes) && Objects.equals(this.closedAt, caseAttributes.closedAt) && Objects.equals(this.createdAt, caseAttributes.createdAt) && Objects.equals(this.description, caseAttributes.description) && Objects.equals(this.jiraIssue, caseAttributes.jiraIssue) && Objects.equals(this.key, caseAttributes.key) && Objects.equals(this.modifiedAt, caseAttributes.modifiedAt) && Objects.equals(this.priority, caseAttributes.priority) && Objects.equals(this.serviceNowTicket, caseAttributes.serviceNowTicket) && Objects.equals(this.status, caseAttributes.status) && Objects.equals(this.title, caseAttributes.title) && Objects.equals(this.type, caseAttributes.type) && Objects.equals(this.additionalProperties, caseAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.archivedAt, this.attributes, this.closedAt, this.createdAt, this.description, this.jiraIssue, this.key, this.modifiedAt, this.priority, this.serviceNowTicket, this.status, this.title, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CaseAttributes {\n");
        sb.append("    archivedAt: ").append(this.toIndentedString(this.archivedAt)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    closedAt: ").append(this.toIndentedString(this.closedAt)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    jiraIssue: ").append(this.toIndentedString(this.jiraIssue)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    serviceNowTicket: ").append(this.toIndentedString(this.serviceNowTicket)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

