/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"excluded_accounts", "include_new_accounts", "included_accounts"})
public class AccountFilteringConfig {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_EXCLUDED_ACCOUNTS = "excluded_accounts";
    private List<String> excludedAccounts = null;
    public static final String JSON_PROPERTY_INCLUDE_NEW_ACCOUNTS = "include_new_accounts";
    private JsonNullable<Boolean> includeNewAccounts = JsonNullable.undefined();
    public static final String JSON_PROPERTY_INCLUDED_ACCOUNTS = "included_accounts";
    private List<String> includedAccounts = null;
    private Map<String, Object> additionalProperties;

    public AccountFilteringConfig excludedAccounts(List<String> excludedAccounts) {
        this.excludedAccounts = excludedAccounts;
        return this;
    }

    public AccountFilteringConfig addExcludedAccountsItem(String excludedAccountsItem) {
        if (this.excludedAccounts == null) {
            this.excludedAccounts = new ArrayList<String>();
        }
        this.excludedAccounts.add(excludedAccountsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="excluded_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getExcludedAccounts() {
        return this.excludedAccounts;
    }

    public void setExcludedAccounts(List<String> excludedAccounts) {
        this.excludedAccounts = excludedAccounts;
    }

    public AccountFilteringConfig includeNewAccounts(Boolean includeNewAccounts) {
        this.includeNewAccounts = JsonNullable.of(includeNewAccounts);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Boolean getIncludeNewAccounts() {
        return this.includeNewAccounts.orElse(null);
    }

    @JsonProperty(value="include_new_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Boolean> getIncludeNewAccounts_JsonNullable() {
        return this.includeNewAccounts;
    }

    @JsonProperty(value="include_new_accounts")
    public void setIncludeNewAccounts_JsonNullable(JsonNullable<Boolean> includeNewAccounts) {
        this.includeNewAccounts = includeNewAccounts;
    }

    public void setIncludeNewAccounts(Boolean includeNewAccounts) {
        this.includeNewAccounts = JsonNullable.of(includeNewAccounts);
    }

    public AccountFilteringConfig includedAccounts(List<String> includedAccounts) {
        this.includedAccounts = includedAccounts;
        return this;
    }

    public AccountFilteringConfig addIncludedAccountsItem(String includedAccountsItem) {
        if (this.includedAccounts == null) {
            this.includedAccounts = new ArrayList<String>();
        }
        this.includedAccounts.add(includedAccountsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="included_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIncludedAccounts() {
        return this.includedAccounts;
    }

    public void setIncludedAccounts(List<String> includedAccounts) {
        this.includedAccounts = includedAccounts;
    }

    @JsonAnySetter
    public AccountFilteringConfig putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountFilteringConfig accountFilteringConfig = (AccountFilteringConfig)o;
        return Objects.equals(this.excludedAccounts, accountFilteringConfig.excludedAccounts) && Objects.equals(this.includeNewAccounts, accountFilteringConfig.includeNewAccounts) && Objects.equals(this.includedAccounts, accountFilteringConfig.includedAccounts) && Objects.equals(this.additionalProperties, accountFilteringConfig.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.excludedAccounts, this.includeNewAccounts, this.includedAccounts, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountFilteringConfig {\n");
        sb.append("    excludedAccounts: ").append(this.toIndentedString(this.excludedAccounts)).append("\n");
        sb.append("    includeNewAccounts: ").append(this.toIndentedString(this.includeNewAccounts)).append("\n");
        sb.append("    includedAccounts: ").append(this.toIndentedString(this.includedAccounts)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

