/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.AWSAccountPartition;
import com.datadog.api.client.v2.model.AWSAuthConfig;
import com.datadog.api.client.v2.model.AWSLogsConfig;
import com.datadog.api.client.v2.model.AWSMetricsConfig;
import com.datadog.api.client.v2.model.AWSRegions;
import com.datadog.api.client.v2.model.AWSResourcesConfig;
import com.datadog.api.client.v2.model.AWSTracesConfig;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

@JsonPropertyOrder(value={"account_tags", "auth_config", "aws_account_id", "aws_partition", "aws_regions", "logs_config", "metrics_config", "resources_config", "traces_config"})
public class AWSAccountUpdateRequestAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCOUNT_TAGS = "account_tags";
    private JsonNullable<List<String>> accountTags = JsonNullable.undefined();
    public static final String JSON_PROPERTY_AUTH_CONFIG = "auth_config";
    private AWSAuthConfig authConfig;
    public static final String JSON_PROPERTY_AWS_ACCOUNT_ID = "aws_account_id";
    private String awsAccountId;
    public static final String JSON_PROPERTY_AWS_PARTITION = "aws_partition";
    private AWSAccountPartition awsPartition;
    public static final String JSON_PROPERTY_AWS_REGIONS = "aws_regions";
    private AWSRegions awsRegions;
    public static final String JSON_PROPERTY_LOGS_CONFIG = "logs_config";
    private AWSLogsConfig logsConfig;
    public static final String JSON_PROPERTY_METRICS_CONFIG = "metrics_config";
    private AWSMetricsConfig metricsConfig;
    public static final String JSON_PROPERTY_RESOURCES_CONFIG = "resources_config";
    private AWSResourcesConfig resourcesConfig;
    public static final String JSON_PROPERTY_TRACES_CONFIG = "traces_config";
    private AWSTracesConfig tracesConfig;
    private Map<String, Object> additionalProperties;

    public AWSAccountUpdateRequestAttributes() {
    }

    @JsonCreator
    public AWSAccountUpdateRequestAttributes(@JsonProperty(required=true, value="aws_account_id") String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public AWSAccountUpdateRequestAttributes accountTags(List<String> accountTags) {
        this.accountTags = JsonNullable.of(accountTags);
        return this;
    }

    public AWSAccountUpdateRequestAttributes addAccountTagsItem(String accountTagsItem) {
        if (this.accountTags == null || !this.accountTags.isPresent()) {
            this.accountTags = JsonNullable.of(new ArrayList());
        }
        try {
            this.accountTags.get().add(accountTagsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getAccountTags() {
        return this.accountTags.orElse(null);
    }

    @JsonProperty(value="account_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getAccountTags_JsonNullable() {
        return this.accountTags;
    }

    @JsonProperty(value="account_tags")
    public void setAccountTags_JsonNullable(JsonNullable<List<String>> accountTags) {
        this.accountTags = accountTags;
    }

    public void setAccountTags(List<String> accountTags) {
        this.accountTags = JsonNullable.of(accountTags);
    }

    public AWSAccountUpdateRequestAttributes authConfig(AWSAuthConfig authConfig) {
        this.authConfig = authConfig;
        this.unparsed |= authConfig.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="auth_config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AWSAuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public void setAuthConfig(AWSAuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    public AWSAccountUpdateRequestAttributes awsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
        return this;
    }

    @JsonProperty(value="aws_account_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public AWSAccountUpdateRequestAttributes awsPartition(AWSAccountPartition awsPartition) {
        this.awsPartition = awsPartition;
        this.unparsed |= !awsPartition.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="aws_partition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AWSAccountPartition getAwsPartition() {
        return this.awsPartition;
    }

    public void setAwsPartition(AWSAccountPartition awsPartition) {
        if (!awsPartition.isValid()) {
            this.unparsed = true;
        }
        this.awsPartition = awsPartition;
    }

    public AWSAccountUpdateRequestAttributes awsRegions(AWSRegions awsRegions) {
        this.awsRegions = awsRegions;
        this.unparsed |= awsRegions.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="aws_regions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AWSRegions getAwsRegions() {
        return this.awsRegions;
    }

    public void setAwsRegions(AWSRegions awsRegions) {
        this.awsRegions = awsRegions;
    }

    public AWSAccountUpdateRequestAttributes logsConfig(AWSLogsConfig logsConfig) {
        this.logsConfig = logsConfig;
        this.unparsed |= logsConfig.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="logs_config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AWSLogsConfig getLogsConfig() {
        return this.logsConfig;
    }

    public void setLogsConfig(AWSLogsConfig logsConfig) {
        this.logsConfig = logsConfig;
    }

    public AWSAccountUpdateRequestAttributes metricsConfig(AWSMetricsConfig metricsConfig) {
        this.metricsConfig = metricsConfig;
        this.unparsed |= metricsConfig.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="metrics_config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AWSMetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    public void setMetricsConfig(AWSMetricsConfig metricsConfig) {
        this.metricsConfig = metricsConfig;
    }

    public AWSAccountUpdateRequestAttributes resourcesConfig(AWSResourcesConfig resourcesConfig) {
        this.resourcesConfig = resourcesConfig;
        this.unparsed |= resourcesConfig.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="resources_config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AWSResourcesConfig getResourcesConfig() {
        return this.resourcesConfig;
    }

    public void setResourcesConfig(AWSResourcesConfig resourcesConfig) {
        this.resourcesConfig = resourcesConfig;
    }

    public AWSAccountUpdateRequestAttributes tracesConfig(AWSTracesConfig tracesConfig) {
        this.tracesConfig = tracesConfig;
        this.unparsed |= tracesConfig.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="traces_config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AWSTracesConfig getTracesConfig() {
        return this.tracesConfig;
    }

    public void setTracesConfig(AWSTracesConfig tracesConfig) {
        this.tracesConfig = tracesConfig;
    }

    @JsonAnySetter
    public AWSAccountUpdateRequestAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSAccountUpdateRequestAttributes awsAccountUpdateRequestAttributes = (AWSAccountUpdateRequestAttributes)o;
        return Objects.equals(this.accountTags, awsAccountUpdateRequestAttributes.accountTags) && Objects.equals(this.authConfig, awsAccountUpdateRequestAttributes.authConfig) && Objects.equals(this.awsAccountId, awsAccountUpdateRequestAttributes.awsAccountId) && Objects.equals(this.awsPartition, awsAccountUpdateRequestAttributes.awsPartition) && Objects.equals(this.awsRegions, awsAccountUpdateRequestAttributes.awsRegions) && Objects.equals(this.logsConfig, awsAccountUpdateRequestAttributes.logsConfig) && Objects.equals(this.metricsConfig, awsAccountUpdateRequestAttributes.metricsConfig) && Objects.equals(this.resourcesConfig, awsAccountUpdateRequestAttributes.resourcesConfig) && Objects.equals(this.tracesConfig, awsAccountUpdateRequestAttributes.tracesConfig) && Objects.equals(this.additionalProperties, awsAccountUpdateRequestAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.accountTags, this.authConfig, this.awsAccountId, this.awsPartition, this.awsRegions, this.logsConfig, this.metricsConfig, this.resourcesConfig, this.tracesConfig, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSAccountUpdateRequestAttributes {\n");
        sb.append("    accountTags: ").append(this.toIndentedString(this.accountTags)).append("\n");
        sb.append("    authConfig: ").append(this.toIndentedString(this.authConfig)).append("\n");
        sb.append("    awsAccountId: ").append(this.toIndentedString(this.awsAccountId)).append("\n");
        sb.append("    awsPartition: ").append(this.toIndentedString(this.awsPartition)).append("\n");
        sb.append("    awsRegions: ").append(this.toIndentedString(this.awsRegions)).append("\n");
        sb.append("    logsConfig: ").append(this.toIndentedString(this.logsConfig)).append("\n");
        sb.append("    metricsConfig: ").append(this.toIndentedString(this.metricsConfig)).append("\n");
        sb.append("    resourcesConfig: ").append(this.toIndentedString(this.resourcesConfig)).append("\n");
        sb.append("    tracesConfig: ").append(this.toIndentedString(this.tracesConfig)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

