/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CreateWorkflowRequest;
import com.datadog.api.client.v2.model.CreateWorkflowResponse;
import com.datadog.api.client.v2.model.GetWorkflowResponse;
import com.datadog.api.client.v2.model.UpdateWorkflowRequest;
import com.datadog.api.client.v2.model.UpdateWorkflowResponse;
import com.datadog.api.client.v2.model.WorkflowInstanceCreateRequest;
import com.datadog.api.client.v2.model.WorkflowInstanceCreateResponse;
import com.datadog.api.client.v2.model.WorkflowListInstancesResponse;
import com.datadog.api.client.v2.model.WorklflowCancelInstanceResponse;
import com.datadog.api.client.v2.model.WorklflowGetInstanceResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class WorkflowAutomationApi {
    private ApiClient apiClient;

    public WorkflowAutomationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public WorkflowAutomationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public WorklflowCancelInstanceResponse cancelWorkflowInstance(String workflowId, String instanceId) throws ApiException {
        return this.cancelWorkflowInstanceWithHttpInfo(workflowId, instanceId).getData();
    }

    public CompletableFuture<WorklflowCancelInstanceResponse> cancelWorkflowInstanceAsync(String workflowId, String instanceId) {
        return this.cancelWorkflowInstanceWithHttpInfoAsync(workflowId, instanceId).thenApply(response -> (WorklflowCancelInstanceResponse)response.getData());
    }

    public ApiResponse<WorklflowCancelInstanceResponse> cancelWorkflowInstanceWithHttpInfo(String workflowId, String instanceId) throws ApiException {
        Object localVarPostBody = null;
        if (workflowId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowId' when calling cancelWorkflowInstance");
        }
        if (instanceId == null) {
            throw new ApiException(400, "Missing the required parameter 'instanceId' when calling cancelWorkflowInstance");
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances/{instance_id}/cancel".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString())).replaceAll("\\{instance_id\\}", this.apiClient.escapeString(instanceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.cancelWorkflowInstance", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorklflowCancelInstanceResponse>(){});
    }

    public CompletableFuture<ApiResponse<WorklflowCancelInstanceResponse>> cancelWorkflowInstanceWithHttpInfoAsync(String workflowId, String instanceId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (workflowId == null) {
            CompletableFuture<ApiResponse<WorklflowCancelInstanceResponse>> result = new CompletableFuture<ApiResponse<WorklflowCancelInstanceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'workflowId' when calling cancelWorkflowInstance"));
            return result;
        }
        if (instanceId == null) {
            CompletableFuture<ApiResponse<WorklflowCancelInstanceResponse>> result = new CompletableFuture<ApiResponse<WorklflowCancelInstanceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'instanceId' when calling cancelWorkflowInstance"));
            return result;
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances/{instance_id}/cancel".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString())).replaceAll("\\{instance_id\\}", this.apiClient.escapeString(instanceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.cancelWorkflowInstance", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<WorklflowCancelInstanceResponse>> result = new CompletableFuture<ApiResponse<WorklflowCancelInstanceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorklflowCancelInstanceResponse>(){});
    }

    public CreateWorkflowResponse createWorkflow(CreateWorkflowRequest body) throws ApiException {
        return this.createWorkflowWithHttpInfo(body).getData();
    }

    public CompletableFuture<CreateWorkflowResponse> createWorkflowAsync(CreateWorkflowRequest body) {
        return this.createWorkflowWithHttpInfoAsync(body).thenApply(response -> (CreateWorkflowResponse)response.getData());
    }

    public ApiResponse<CreateWorkflowResponse> createWorkflowWithHttpInfo(CreateWorkflowRequest body) throws ApiException {
        CreateWorkflowRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createWorkflow");
        }
        String localVarPath = "/api/v2/workflows";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.createWorkflow", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateWorkflowResponse>(){});
    }

    public CompletableFuture<ApiResponse<CreateWorkflowResponse>> createWorkflowWithHttpInfoAsync(CreateWorkflowRequest body) {
        Invocation.Builder builder;
        CreateWorkflowRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CreateWorkflowResponse>> result = new CompletableFuture<ApiResponse<CreateWorkflowResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createWorkflow"));
            return result;
        }
        String localVarPath = "/api/v2/workflows";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.createWorkflow", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CreateWorkflowResponse>> result = new CompletableFuture<ApiResponse<CreateWorkflowResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateWorkflowResponse>(){});
    }

    public WorkflowInstanceCreateResponse createWorkflowInstance(String workflowId, WorkflowInstanceCreateRequest body) throws ApiException {
        return this.createWorkflowInstanceWithHttpInfo(workflowId, body).getData();
    }

    public CompletableFuture<WorkflowInstanceCreateResponse> createWorkflowInstanceAsync(String workflowId, WorkflowInstanceCreateRequest body) {
        return this.createWorkflowInstanceWithHttpInfoAsync(workflowId, body).thenApply(response -> (WorkflowInstanceCreateResponse)response.getData());
    }

    public ApiResponse<WorkflowInstanceCreateResponse> createWorkflowInstanceWithHttpInfo(String workflowId, WorkflowInstanceCreateRequest body) throws ApiException {
        WorkflowInstanceCreateRequest localVarPostBody = body;
        if (workflowId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowId' when calling createWorkflowInstance");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createWorkflowInstance");
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.createWorkflowInstance", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorkflowInstanceCreateResponse>(){});
    }

    public CompletableFuture<ApiResponse<WorkflowInstanceCreateResponse>> createWorkflowInstanceWithHttpInfoAsync(String workflowId, WorkflowInstanceCreateRequest body) {
        Invocation.Builder builder;
        WorkflowInstanceCreateRequest localVarPostBody = body;
        if (workflowId == null) {
            CompletableFuture<ApiResponse<WorkflowInstanceCreateResponse>> result = new CompletableFuture<ApiResponse<WorkflowInstanceCreateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'workflowId' when calling createWorkflowInstance"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<WorkflowInstanceCreateResponse>> result = new CompletableFuture<ApiResponse<WorkflowInstanceCreateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createWorkflowInstance"));
            return result;
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.createWorkflowInstance", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<WorkflowInstanceCreateResponse>> result = new CompletableFuture<ApiResponse<WorkflowInstanceCreateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorkflowInstanceCreateResponse>(){});
    }

    public void deleteWorkflow(String workflowId) throws ApiException {
        this.deleteWorkflowWithHttpInfo(workflowId);
    }

    public CompletableFuture<Void> deleteWorkflowAsync(String workflowId) {
        return this.deleteWorkflowWithHttpInfoAsync(workflowId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteWorkflowWithHttpInfo(String workflowId) throws ApiException {
        Object localVarPostBody = null;
        if (workflowId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowId' when calling deleteWorkflow");
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.deleteWorkflow", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteWorkflowWithHttpInfoAsync(String workflowId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (workflowId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'workflowId' when calling deleteWorkflow"));
            return result;
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.deleteWorkflow", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public GetWorkflowResponse getWorkflow(String workflowId) throws ApiException {
        return this.getWorkflowWithHttpInfo(workflowId).getData();
    }

    public CompletableFuture<GetWorkflowResponse> getWorkflowAsync(String workflowId) {
        return this.getWorkflowWithHttpInfoAsync(workflowId).thenApply(response -> (GetWorkflowResponse)response.getData());
    }

    public ApiResponse<GetWorkflowResponse> getWorkflowWithHttpInfo(String workflowId) throws ApiException {
        Object localVarPostBody = null;
        if (workflowId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowId' when calling getWorkflow");
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.getWorkflow", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetWorkflowResponse>(){});
    }

    public CompletableFuture<ApiResponse<GetWorkflowResponse>> getWorkflowWithHttpInfoAsync(String workflowId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (workflowId == null) {
            CompletableFuture<ApiResponse<GetWorkflowResponse>> result = new CompletableFuture<ApiResponse<GetWorkflowResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'workflowId' when calling getWorkflow"));
            return result;
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.getWorkflow", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetWorkflowResponse>> result = new CompletableFuture<ApiResponse<GetWorkflowResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetWorkflowResponse>(){});
    }

    public WorklflowGetInstanceResponse getWorkflowInstance(String workflowId, String instanceId) throws ApiException {
        return this.getWorkflowInstanceWithHttpInfo(workflowId, instanceId).getData();
    }

    public CompletableFuture<WorklflowGetInstanceResponse> getWorkflowInstanceAsync(String workflowId, String instanceId) {
        return this.getWorkflowInstanceWithHttpInfoAsync(workflowId, instanceId).thenApply(response -> (WorklflowGetInstanceResponse)response.getData());
    }

    public ApiResponse<WorklflowGetInstanceResponse> getWorkflowInstanceWithHttpInfo(String workflowId, String instanceId) throws ApiException {
        Object localVarPostBody = null;
        if (workflowId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowId' when calling getWorkflowInstance");
        }
        if (instanceId == null) {
            throw new ApiException(400, "Missing the required parameter 'instanceId' when calling getWorkflowInstance");
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances/{instance_id}".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString())).replaceAll("\\{instance_id\\}", this.apiClient.escapeString(instanceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.getWorkflowInstance", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorklflowGetInstanceResponse>(){});
    }

    public CompletableFuture<ApiResponse<WorklflowGetInstanceResponse>> getWorkflowInstanceWithHttpInfoAsync(String workflowId, String instanceId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (workflowId == null) {
            CompletableFuture<ApiResponse<WorklflowGetInstanceResponse>> result = new CompletableFuture<ApiResponse<WorklflowGetInstanceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'workflowId' when calling getWorkflowInstance"));
            return result;
        }
        if (instanceId == null) {
            CompletableFuture<ApiResponse<WorklflowGetInstanceResponse>> result = new CompletableFuture<ApiResponse<WorklflowGetInstanceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'instanceId' when calling getWorkflowInstance"));
            return result;
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances/{instance_id}".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString())).replaceAll("\\{instance_id\\}", this.apiClient.escapeString(instanceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.getWorkflowInstance", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<WorklflowGetInstanceResponse>> result = new CompletableFuture<ApiResponse<WorklflowGetInstanceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorklflowGetInstanceResponse>(){});
    }

    public WorkflowListInstancesResponse listWorkflowInstances(String workflowId) throws ApiException {
        return this.listWorkflowInstancesWithHttpInfo(workflowId, new ListWorkflowInstancesOptionalParameters()).getData();
    }

    public CompletableFuture<WorkflowListInstancesResponse> listWorkflowInstancesAsync(String workflowId) {
        return this.listWorkflowInstancesWithHttpInfoAsync(workflowId, new ListWorkflowInstancesOptionalParameters()).thenApply(response -> (WorkflowListInstancesResponse)response.getData());
    }

    public WorkflowListInstancesResponse listWorkflowInstances(String workflowId, ListWorkflowInstancesOptionalParameters parameters) throws ApiException {
        return this.listWorkflowInstancesWithHttpInfo(workflowId, parameters).getData();
    }

    public CompletableFuture<WorkflowListInstancesResponse> listWorkflowInstancesAsync(String workflowId, ListWorkflowInstancesOptionalParameters parameters) {
        return this.listWorkflowInstancesWithHttpInfoAsync(workflowId, parameters).thenApply(response -> (WorkflowListInstancesResponse)response.getData());
    }

    public ApiResponse<WorkflowListInstancesResponse> listWorkflowInstancesWithHttpInfo(String workflowId, ListWorkflowInstancesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (workflowId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowId' when calling listWorkflowInstances");
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.listWorkflowInstances", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorkflowListInstancesResponse>(){});
    }

    public CompletableFuture<ApiResponse<WorkflowListInstancesResponse>> listWorkflowInstancesWithHttpInfoAsync(String workflowId, ListWorkflowInstancesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (workflowId == null) {
            CompletableFuture<ApiResponse<WorkflowListInstancesResponse>> result = new CompletableFuture<ApiResponse<WorkflowListInstancesResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'workflowId' when calling listWorkflowInstances"));
            return result;
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        try {
            builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.listWorkflowInstances", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<WorkflowListInstancesResponse>> result = new CompletableFuture<ApiResponse<WorkflowListInstancesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorkflowListInstancesResponse>(){});
    }

    public UpdateWorkflowResponse updateWorkflow(String workflowId, UpdateWorkflowRequest body) throws ApiException {
        return this.updateWorkflowWithHttpInfo(workflowId, body).getData();
    }

    public CompletableFuture<UpdateWorkflowResponse> updateWorkflowAsync(String workflowId, UpdateWorkflowRequest body) {
        return this.updateWorkflowWithHttpInfoAsync(workflowId, body).thenApply(response -> (UpdateWorkflowResponse)response.getData());
    }

    public ApiResponse<UpdateWorkflowResponse> updateWorkflowWithHttpInfo(String workflowId, UpdateWorkflowRequest body) throws ApiException {
        UpdateWorkflowRequest localVarPostBody = body;
        if (workflowId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowId' when calling updateWorkflow");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateWorkflow");
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.updateWorkflow", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpdateWorkflowResponse>(){});
    }

    public CompletableFuture<ApiResponse<UpdateWorkflowResponse>> updateWorkflowWithHttpInfoAsync(String workflowId, UpdateWorkflowRequest body) {
        Invocation.Builder builder;
        UpdateWorkflowRequest localVarPostBody = body;
        if (workflowId == null) {
            CompletableFuture<ApiResponse<UpdateWorkflowResponse>> result = new CompletableFuture<ApiResponse<UpdateWorkflowResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'workflowId' when calling updateWorkflow"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<UpdateWorkflowResponse>> result = new CompletableFuture<ApiResponse<UpdateWorkflowResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateWorkflow"));
            return result;
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.updateWorkflow", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UpdateWorkflowResponse>> result = new CompletableFuture<ApiResponse<UpdateWorkflowResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpdateWorkflowResponse>(){});
    }

    public static class ListWorkflowInstancesOptionalParameters {
        private Long pageSize;
        private Long pageNumber;

        public ListWorkflowInstancesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListWorkflowInstancesOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }
    }
}

