/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.SLOReportPostResponse;
import com.datadog.api.client.v2.model.SLOReportStatusGetResponse;
import com.datadog.api.client.v2.model.SloReportCreateRequest;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class ServiceLevelObjectivesApi {
    private ApiClient apiClient;

    public ServiceLevelObjectivesApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ServiceLevelObjectivesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SLOReportPostResponse createSLOReportJob(SloReportCreateRequest body) throws ApiException {
        return this.createSLOReportJobWithHttpInfo(body).getData();
    }

    public CompletableFuture<SLOReportPostResponse> createSLOReportJobAsync(SloReportCreateRequest body) {
        return this.createSLOReportJobWithHttpInfoAsync(body).thenApply(response -> (SLOReportPostResponse)response.getData());
    }

    public ApiResponse<SLOReportPostResponse> createSLOReportJobWithHttpInfo(SloReportCreateRequest body) throws ApiException {
        String operationId = "createSLOReportJob";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        SloReportCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSLOReportJob");
        }
        String localVarPath = "/api/v2/slo/report";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceLevelObjectivesApi.createSLOReportJob", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOReportPostResponse>(){});
    }

    public CompletableFuture<ApiResponse<SLOReportPostResponse>> createSLOReportJobWithHttpInfoAsync(SloReportCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createSLOReportJob";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<SLOReportPostResponse>> result = new CompletableFuture<ApiResponse<SLOReportPostResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        SloReportCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SLOReportPostResponse>> result = new CompletableFuture<ApiResponse<SLOReportPostResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSLOReportJob"));
            return result;
        }
        String localVarPath = "/api/v2/slo/report";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ServiceLevelObjectivesApi.createSLOReportJob", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SLOReportPostResponse>> result = new CompletableFuture<ApiResponse<SLOReportPostResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOReportPostResponse>(){});
    }

    public String getSLOReport(String reportId) throws ApiException {
        return this.getSLOReportWithHttpInfo(reportId).getData();
    }

    public CompletableFuture<String> getSLOReportAsync(String reportId) {
        return this.getSLOReportWithHttpInfoAsync(reportId).thenApply(response -> (String)response.getData());
    }

    public ApiResponse<String> getSLOReportWithHttpInfo(String reportId) throws ApiException {
        String operationId = "getSLOReport";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (reportId == null) {
            throw new ApiException(400, "Missing the required parameter 'reportId' when calling getSLOReport");
        }
        String localVarPath = "/api/v2/slo/report/{report_id}/download".replaceAll("\\{report_id\\}", this.apiClient.escapeString(reportId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceLevelObjectivesApi.getSLOReport", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"text/csv", "application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<String>(){});
    }

    public CompletableFuture<ApiResponse<String>> getSLOReportWithHttpInfoAsync(String reportId) {
        Invocation.Builder builder;
        String operationId = "getSLOReport";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<String>> result = new CompletableFuture<ApiResponse<String>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (reportId == null) {
            CompletableFuture<ApiResponse<String>> result = new CompletableFuture<ApiResponse<String>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'reportId' when calling getSLOReport"));
            return result;
        }
        String localVarPath = "/api/v2/slo/report/{report_id}/download".replaceAll("\\{report_id\\}", this.apiClient.escapeString(reportId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ServiceLevelObjectivesApi.getSLOReport", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"text/csv", "application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<String>> result = new CompletableFuture<ApiResponse<String>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<String>(){});
    }

    public SLOReportStatusGetResponse getSLOReportJobStatus(String reportId) throws ApiException {
        return this.getSLOReportJobStatusWithHttpInfo(reportId).getData();
    }

    public CompletableFuture<SLOReportStatusGetResponse> getSLOReportJobStatusAsync(String reportId) {
        return this.getSLOReportJobStatusWithHttpInfoAsync(reportId).thenApply(response -> (SLOReportStatusGetResponse)response.getData());
    }

    public ApiResponse<SLOReportStatusGetResponse> getSLOReportJobStatusWithHttpInfo(String reportId) throws ApiException {
        String operationId = "getSLOReportJobStatus";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (reportId == null) {
            throw new ApiException(400, "Missing the required parameter 'reportId' when calling getSLOReportJobStatus");
        }
        String localVarPath = "/api/v2/slo/report/{report_id}/status".replaceAll("\\{report_id\\}", this.apiClient.escapeString(reportId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceLevelObjectivesApi.getSLOReportJobStatus", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOReportStatusGetResponse>(){});
    }

    public CompletableFuture<ApiResponse<SLOReportStatusGetResponse>> getSLOReportJobStatusWithHttpInfoAsync(String reportId) {
        Invocation.Builder builder;
        String operationId = "getSLOReportJobStatus";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<SLOReportStatusGetResponse>> result = new CompletableFuture<ApiResponse<SLOReportStatusGetResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (reportId == null) {
            CompletableFuture<ApiResponse<SLOReportStatusGetResponse>> result = new CompletableFuture<ApiResponse<SLOReportStatusGetResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'reportId' when calling getSLOReportJobStatus"));
            return result;
        }
        String localVarPath = "/api/v2/slo/report/{report_id}/status".replaceAll("\\{report_id\\}", this.apiClient.escapeString(reportId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ServiceLevelObjectivesApi.getSLOReportJobStatus", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SLOReportStatusGetResponse>> result = new CompletableFuture<ApiResponse<SLOReportStatusGetResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOReportStatusGetResponse>(){});
    }
}

