/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.RumMetricCreateRequest;
import com.datadog.api.client.v2.model.RumMetricResponse;
import com.datadog.api.client.v2.model.RumMetricUpdateRequest;
import com.datadog.api.client.v2.model.RumMetricsResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class RumMetricsApi {
    private ApiClient apiClient;

    public RumMetricsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public RumMetricsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RumMetricResponse createRumMetric(RumMetricCreateRequest body) throws ApiException {
        return this.createRumMetricWithHttpInfo(body).getData();
    }

    public CompletableFuture<RumMetricResponse> createRumMetricAsync(RumMetricCreateRequest body) {
        return this.createRumMetricWithHttpInfoAsync(body).thenApply(response -> (RumMetricResponse)response.getData());
    }

    public ApiResponse<RumMetricResponse> createRumMetricWithHttpInfo(RumMetricCreateRequest body) throws ApiException {
        RumMetricCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createRumMetric");
        }
        String localVarPath = "/api/v2/rum/config/metrics";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumMetricsApi.createRumMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumMetricResponse>(){});
    }

    public CompletableFuture<ApiResponse<RumMetricResponse>> createRumMetricWithHttpInfoAsync(RumMetricCreateRequest body) {
        Invocation.Builder builder;
        RumMetricCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<RumMetricResponse>> result = new CompletableFuture<ApiResponse<RumMetricResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createRumMetric"));
            return result;
        }
        String localVarPath = "/api/v2/rum/config/metrics";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumMetricsApi.createRumMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RumMetricResponse>> result = new CompletableFuture<ApiResponse<RumMetricResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumMetricResponse>(){});
    }

    public void deleteRumMetric(String metricId) throws ApiException {
        this.deleteRumMetricWithHttpInfo(metricId);
    }

    public CompletableFuture<Void> deleteRumMetricAsync(String metricId) {
        return this.deleteRumMetricWithHttpInfoAsync(metricId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteRumMetricWithHttpInfo(String metricId) throws ApiException {
        Object localVarPostBody = null;
        if (metricId == null) {
            throw new ApiException(400, "Missing the required parameter 'metricId' when calling deleteRumMetric");
        }
        String localVarPath = "/api/v2/rum/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumMetricsApi.deleteRumMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteRumMetricWithHttpInfoAsync(String metricId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (metricId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricId' when calling deleteRumMetric"));
            return result;
        }
        String localVarPath = "/api/v2/rum/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumMetricsApi.deleteRumMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public RumMetricResponse getRumMetric(String metricId) throws ApiException {
        return this.getRumMetricWithHttpInfo(metricId).getData();
    }

    public CompletableFuture<RumMetricResponse> getRumMetricAsync(String metricId) {
        return this.getRumMetricWithHttpInfoAsync(metricId).thenApply(response -> (RumMetricResponse)response.getData());
    }

    public ApiResponse<RumMetricResponse> getRumMetricWithHttpInfo(String metricId) throws ApiException {
        Object localVarPostBody = null;
        if (metricId == null) {
            throw new ApiException(400, "Missing the required parameter 'metricId' when calling getRumMetric");
        }
        String localVarPath = "/api/v2/rum/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumMetricsApi.getRumMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumMetricResponse>(){});
    }

    public CompletableFuture<ApiResponse<RumMetricResponse>> getRumMetricWithHttpInfoAsync(String metricId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (metricId == null) {
            CompletableFuture<ApiResponse<RumMetricResponse>> result = new CompletableFuture<ApiResponse<RumMetricResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricId' when calling getRumMetric"));
            return result;
        }
        String localVarPath = "/api/v2/rum/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumMetricsApi.getRumMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RumMetricResponse>> result = new CompletableFuture<ApiResponse<RumMetricResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumMetricResponse>(){});
    }

    public RumMetricsResponse listRumMetrics() throws ApiException {
        return this.listRumMetricsWithHttpInfo().getData();
    }

    public CompletableFuture<RumMetricsResponse> listRumMetricsAsync() {
        return this.listRumMetricsWithHttpInfoAsync().thenApply(response -> (RumMetricsResponse)response.getData());
    }

    public ApiResponse<RumMetricsResponse> listRumMetricsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/rum/config/metrics";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumMetricsApi.listRumMetrics", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumMetricsResponse>(){});
    }

    public CompletableFuture<ApiResponse<RumMetricsResponse>> listRumMetricsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/rum/config/metrics";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumMetricsApi.listRumMetrics", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RumMetricsResponse>> result = new CompletableFuture<ApiResponse<RumMetricsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumMetricsResponse>(){});
    }

    public RumMetricResponse updateRumMetric(String metricId, RumMetricUpdateRequest body) throws ApiException {
        return this.updateRumMetricWithHttpInfo(metricId, body).getData();
    }

    public CompletableFuture<RumMetricResponse> updateRumMetricAsync(String metricId, RumMetricUpdateRequest body) {
        return this.updateRumMetricWithHttpInfoAsync(metricId, body).thenApply(response -> (RumMetricResponse)response.getData());
    }

    public ApiResponse<RumMetricResponse> updateRumMetricWithHttpInfo(String metricId, RumMetricUpdateRequest body) throws ApiException {
        RumMetricUpdateRequest localVarPostBody = body;
        if (metricId == null) {
            throw new ApiException(400, "Missing the required parameter 'metricId' when calling updateRumMetric");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateRumMetric");
        }
        String localVarPath = "/api/v2/rum/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumMetricsApi.updateRumMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumMetricResponse>(){});
    }

    public CompletableFuture<ApiResponse<RumMetricResponse>> updateRumMetricWithHttpInfoAsync(String metricId, RumMetricUpdateRequest body) {
        Invocation.Builder builder;
        RumMetricUpdateRequest localVarPostBody = body;
        if (metricId == null) {
            CompletableFuture<ApiResponse<RumMetricResponse>> result = new CompletableFuture<ApiResponse<RumMetricResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricId' when calling updateRumMetric"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<RumMetricResponse>> result = new CompletableFuture<ApiResponse<RumMetricResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateRumMetric"));
            return result;
        }
        String localVarPath = "/api/v2/rum/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumMetricsApi.updateRumMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RumMetricResponse>> result = new CompletableFuture<ApiResponse<RumMetricResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumMetricResponse>(){});
    }
}

