/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.DatasetCreateRequest;
import com.datadog.api.client.v2.model.DatasetResponseMulti;
import com.datadog.api.client.v2.model.DatasetResponseSingle;
import com.datadog.api.client.v2.model.DatasetUpdateRequest;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class DatasetsApi {
    private ApiClient apiClient;

    public DatasetsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public DatasetsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DatasetResponseSingle createDataset(DatasetCreateRequest body) throws ApiException {
        return this.createDatasetWithHttpInfo(body).getData();
    }

    public CompletableFuture<DatasetResponseSingle> createDatasetAsync(DatasetCreateRequest body) {
        return this.createDatasetWithHttpInfoAsync(body).thenApply(response -> (DatasetResponseSingle)response.getData());
    }

    public ApiResponse<DatasetResponseSingle> createDatasetWithHttpInfo(DatasetCreateRequest body) throws ApiException {
        String operationId = "createDataset";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        DatasetCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDataset");
        }
        String localVarPath = "/api/v2/datasets";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DatasetsApi.createDataset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DatasetResponseSingle>(){});
    }

    public CompletableFuture<ApiResponse<DatasetResponseSingle>> createDatasetWithHttpInfoAsync(DatasetCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createDataset";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DatasetResponseSingle>> result = new CompletableFuture<ApiResponse<DatasetResponseSingle>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        DatasetCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DatasetResponseSingle>> result = new CompletableFuture<ApiResponse<DatasetResponseSingle>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDataset"));
            return result;
        }
        String localVarPath = "/api/v2/datasets";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DatasetsApi.createDataset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DatasetResponseSingle>> result = new CompletableFuture<ApiResponse<DatasetResponseSingle>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DatasetResponseSingle>(){});
    }

    public void deleteDataset(String datasetId) throws ApiException {
        this.deleteDatasetWithHttpInfo(datasetId);
    }

    public CompletableFuture<Void> deleteDatasetAsync(String datasetId) {
        return this.deleteDatasetWithHttpInfoAsync(datasetId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteDatasetWithHttpInfo(String datasetId) throws ApiException {
        String operationId = "deleteDataset";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (datasetId == null) {
            throw new ApiException(400, "Missing the required parameter 'datasetId' when calling deleteDataset");
        }
        String localVarPath = "/api/v2/datasets/{dataset_id}".replaceAll("\\{dataset_id\\}", this.apiClient.escapeString(datasetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DatasetsApi.deleteDataset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteDatasetWithHttpInfoAsync(String datasetId) {
        Invocation.Builder builder;
        String operationId = "deleteDataset";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (datasetId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'datasetId' when calling deleteDataset"));
            return result;
        }
        String localVarPath = "/api/v2/datasets/{dataset_id}".replaceAll("\\{dataset_id\\}", this.apiClient.escapeString(datasetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DatasetsApi.deleteDataset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public DatasetResponseMulti getAllDatasets() throws ApiException {
        return this.getAllDatasetsWithHttpInfo().getData();
    }

    public CompletableFuture<DatasetResponseMulti> getAllDatasetsAsync() {
        return this.getAllDatasetsWithHttpInfoAsync().thenApply(response -> (DatasetResponseMulti)response.getData());
    }

    public ApiResponse<DatasetResponseMulti> getAllDatasetsWithHttpInfo() throws ApiException {
        String operationId = "getAllDatasets";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/datasets";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DatasetsApi.getAllDatasets", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DatasetResponseMulti>(){});
    }

    public CompletableFuture<ApiResponse<DatasetResponseMulti>> getAllDatasetsWithHttpInfoAsync() {
        Invocation.Builder builder;
        String operationId = "getAllDatasets";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DatasetResponseMulti>> result = new CompletableFuture<ApiResponse<DatasetResponseMulti>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/datasets";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DatasetsApi.getAllDatasets", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DatasetResponseMulti>> result = new CompletableFuture<ApiResponse<DatasetResponseMulti>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DatasetResponseMulti>(){});
    }

    public DatasetResponseSingle getDataset(String datasetId) throws ApiException {
        return this.getDatasetWithHttpInfo(datasetId).getData();
    }

    public CompletableFuture<DatasetResponseSingle> getDatasetAsync(String datasetId) {
        return this.getDatasetWithHttpInfoAsync(datasetId).thenApply(response -> (DatasetResponseSingle)response.getData());
    }

    public ApiResponse<DatasetResponseSingle> getDatasetWithHttpInfo(String datasetId) throws ApiException {
        String operationId = "getDataset";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (datasetId == null) {
            throw new ApiException(400, "Missing the required parameter 'datasetId' when calling getDataset");
        }
        String localVarPath = "/api/v2/datasets/{dataset_id}".replaceAll("\\{dataset_id\\}", this.apiClient.escapeString(datasetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DatasetsApi.getDataset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DatasetResponseSingle>(){});
    }

    public CompletableFuture<ApiResponse<DatasetResponseSingle>> getDatasetWithHttpInfoAsync(String datasetId) {
        Invocation.Builder builder;
        String operationId = "getDataset";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DatasetResponseSingle>> result = new CompletableFuture<ApiResponse<DatasetResponseSingle>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (datasetId == null) {
            CompletableFuture<ApiResponse<DatasetResponseSingle>> result = new CompletableFuture<ApiResponse<DatasetResponseSingle>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'datasetId' when calling getDataset"));
            return result;
        }
        String localVarPath = "/api/v2/datasets/{dataset_id}".replaceAll("\\{dataset_id\\}", this.apiClient.escapeString(datasetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DatasetsApi.getDataset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DatasetResponseSingle>> result = new CompletableFuture<ApiResponse<DatasetResponseSingle>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DatasetResponseSingle>(){});
    }

    public DatasetResponseSingle updateDataset(String datasetId, DatasetUpdateRequest body) throws ApiException {
        return this.updateDatasetWithHttpInfo(datasetId, body).getData();
    }

    public CompletableFuture<DatasetResponseSingle> updateDatasetAsync(String datasetId, DatasetUpdateRequest body) {
        return this.updateDatasetWithHttpInfoAsync(datasetId, body).thenApply(response -> (DatasetResponseSingle)response.getData());
    }

    public ApiResponse<DatasetResponseSingle> updateDatasetWithHttpInfo(String datasetId, DatasetUpdateRequest body) throws ApiException {
        String operationId = "updateDataset";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        DatasetUpdateRequest localVarPostBody = body;
        if (datasetId == null) {
            throw new ApiException(400, "Missing the required parameter 'datasetId' when calling updateDataset");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDataset");
        }
        String localVarPath = "/api/v2/datasets/{dataset_id}".replaceAll("\\{dataset_id\\}", this.apiClient.escapeString(datasetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DatasetsApi.updateDataset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DatasetResponseSingle>(){});
    }

    public CompletableFuture<ApiResponse<DatasetResponseSingle>> updateDatasetWithHttpInfoAsync(String datasetId, DatasetUpdateRequest body) {
        Invocation.Builder builder;
        String operationId = "updateDataset";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DatasetResponseSingle>> result = new CompletableFuture<ApiResponse<DatasetResponseSingle>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        DatasetUpdateRequest localVarPostBody = body;
        if (datasetId == null) {
            CompletableFuture<ApiResponse<DatasetResponseSingle>> result = new CompletableFuture<ApiResponse<DatasetResponseSingle>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'datasetId' when calling updateDataset"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<DatasetResponseSingle>> result = new CompletableFuture<ApiResponse<DatasetResponseSingle>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateDataset"));
            return result;
        }
        String localVarPath = "/api/v2/datasets/{dataset_id}".replaceAll("\\{dataset_id\\}", this.apiClient.escapeString(datasetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DatasetsApi.updateDataset", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DatasetResponseSingle>> result = new CompletableFuture<ApiResponse<DatasetResponseSingle>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DatasetResponseSingle>(){});
    }
}

