/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CancelDataDeletionResponseBody;
import com.datadog.api.client.v2.model.CreateDataDeletionRequestBody;
import com.datadog.api.client.v2.model.CreateDataDeletionResponseBody;
import com.datadog.api.client.v2.model.GetDataDeletionsResponseBody;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class DataDeletionApi {
    private ApiClient apiClient;

    public DataDeletionApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public DataDeletionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CancelDataDeletionResponseBody cancelDataDeletionRequest(String id) throws ApiException {
        return this.cancelDataDeletionRequestWithHttpInfo(id).getData();
    }

    public CompletableFuture<CancelDataDeletionResponseBody> cancelDataDeletionRequestAsync(String id) {
        return this.cancelDataDeletionRequestWithHttpInfoAsync(id).thenApply(response -> (CancelDataDeletionResponseBody)response.getData());
    }

    public ApiResponse<CancelDataDeletionResponseBody> cancelDataDeletionRequestWithHttpInfo(String id) throws ApiException {
        String operationId = "cancelDataDeletionRequest";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling cancelDataDeletionRequest");
        }
        String localVarPath = "/api/v2/deletion/requests/{id}/cancel".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DataDeletionApi.cancelDataDeletionRequest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CancelDataDeletionResponseBody>(){});
    }

    public CompletableFuture<ApiResponse<CancelDataDeletionResponseBody>> cancelDataDeletionRequestWithHttpInfoAsync(String id) {
        Invocation.Builder builder;
        String operationId = "cancelDataDeletionRequest";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<CancelDataDeletionResponseBody>> result = new CompletableFuture<ApiResponse<CancelDataDeletionResponseBody>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<CancelDataDeletionResponseBody>> result = new CompletableFuture<ApiResponse<CancelDataDeletionResponseBody>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling cancelDataDeletionRequest"));
            return result;
        }
        String localVarPath = "/api/v2/deletion/requests/{id}/cancel".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DataDeletionApi.cancelDataDeletionRequest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CancelDataDeletionResponseBody>> result = new CompletableFuture<ApiResponse<CancelDataDeletionResponseBody>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CancelDataDeletionResponseBody>(){});
    }

    public CreateDataDeletionResponseBody createDataDeletionRequest(String product, CreateDataDeletionRequestBody body) throws ApiException {
        return this.createDataDeletionRequestWithHttpInfo(product, body).getData();
    }

    public CompletableFuture<CreateDataDeletionResponseBody> createDataDeletionRequestAsync(String product, CreateDataDeletionRequestBody body) {
        return this.createDataDeletionRequestWithHttpInfoAsync(product, body).thenApply(response -> (CreateDataDeletionResponseBody)response.getData());
    }

    public ApiResponse<CreateDataDeletionResponseBody> createDataDeletionRequestWithHttpInfo(String product, CreateDataDeletionRequestBody body) throws ApiException {
        String operationId = "createDataDeletionRequest";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        CreateDataDeletionRequestBody localVarPostBody = body;
        if (product == null) {
            throw new ApiException(400, "Missing the required parameter 'product' when calling createDataDeletionRequest");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDataDeletionRequest");
        }
        String localVarPath = "/api/v2/deletion/data/{product}".replaceAll("\\{product\\}", this.apiClient.escapeString(product.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DataDeletionApi.createDataDeletionRequest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateDataDeletionResponseBody>(){});
    }

    public CompletableFuture<ApiResponse<CreateDataDeletionResponseBody>> createDataDeletionRequestWithHttpInfoAsync(String product, CreateDataDeletionRequestBody body) {
        Invocation.Builder builder;
        String operationId = "createDataDeletionRequest";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<CreateDataDeletionResponseBody>> result = new CompletableFuture<ApiResponse<CreateDataDeletionResponseBody>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        CreateDataDeletionRequestBody localVarPostBody = body;
        if (product == null) {
            CompletableFuture<ApiResponse<CreateDataDeletionResponseBody>> result = new CompletableFuture<ApiResponse<CreateDataDeletionResponseBody>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'product' when calling createDataDeletionRequest"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<CreateDataDeletionResponseBody>> result = new CompletableFuture<ApiResponse<CreateDataDeletionResponseBody>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDataDeletionRequest"));
            return result;
        }
        String localVarPath = "/api/v2/deletion/data/{product}".replaceAll("\\{product\\}", this.apiClient.escapeString(product.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DataDeletionApi.createDataDeletionRequest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CreateDataDeletionResponseBody>> result = new CompletableFuture<ApiResponse<CreateDataDeletionResponseBody>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateDataDeletionResponseBody>(){});
    }

    public GetDataDeletionsResponseBody getDataDeletionRequests() throws ApiException {
        return this.getDataDeletionRequestsWithHttpInfo(new GetDataDeletionRequestsOptionalParameters()).getData();
    }

    public CompletableFuture<GetDataDeletionsResponseBody> getDataDeletionRequestsAsync() {
        return this.getDataDeletionRequestsWithHttpInfoAsync(new GetDataDeletionRequestsOptionalParameters()).thenApply(response -> (GetDataDeletionsResponseBody)response.getData());
    }

    public GetDataDeletionsResponseBody getDataDeletionRequests(GetDataDeletionRequestsOptionalParameters parameters) throws ApiException {
        return this.getDataDeletionRequestsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<GetDataDeletionsResponseBody> getDataDeletionRequestsAsync(GetDataDeletionRequestsOptionalParameters parameters) {
        return this.getDataDeletionRequestsWithHttpInfoAsync(parameters).thenApply(response -> (GetDataDeletionsResponseBody)response.getData());
    }

    public ApiResponse<GetDataDeletionsResponseBody> getDataDeletionRequestsWithHttpInfo(GetDataDeletionRequestsOptionalParameters parameters) throws ApiException {
        String operationId = "getDataDeletionRequests";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String nextPage = parameters.nextPage;
        String product = parameters.product;
        String query = parameters.query;
        String status = parameters.status;
        Long pageSize = parameters.pageSize;
        String localVarPath = "/api/v2/deletion/requests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "next_page", nextPage));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "product", product));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DataDeletionApi.getDataDeletionRequests", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetDataDeletionsResponseBody>(){});
    }

    public CompletableFuture<ApiResponse<GetDataDeletionsResponseBody>> getDataDeletionRequestsWithHttpInfoAsync(GetDataDeletionRequestsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getDataDeletionRequests";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<GetDataDeletionsResponseBody>> result = new CompletableFuture<ApiResponse<GetDataDeletionsResponseBody>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String nextPage = parameters.nextPage;
        String product = parameters.product;
        String query = parameters.query;
        String status = parameters.status;
        Long pageSize = parameters.pageSize;
        String localVarPath = "/api/v2/deletion/requests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "next_page", nextPage));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "product", product));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        try {
            builder = this.apiClient.createBuilder("v2.DataDeletionApi.getDataDeletionRequests", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetDataDeletionsResponseBody>> result = new CompletableFuture<ApiResponse<GetDataDeletionsResponseBody>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetDataDeletionsResponseBody>(){});
    }

    public static class GetDataDeletionRequestsOptionalParameters {
        private String nextPage;
        private String product;
        private String query;
        private String status;
        private Long pageSize;

        public GetDataDeletionRequestsOptionalParameters nextPage(String nextPage) {
            this.nextPage = nextPage;
            return this;
        }

        public GetDataDeletionRequestsOptionalParameters product(String product) {
            this.product = product;
            return this;
        }

        public GetDataDeletionRequestsOptionalParameters query(String query) {
            this.query = query;
            return this;
        }

        public GetDataDeletionRequestsOptionalParameters status(String status) {
            this.status = status;
            return this;
        }

        public GetDataDeletionRequestsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

