/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CsmAgentsResponse;
import com.datadog.api.client.v2.model.OrderDirection;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class CsmAgentsApi {
    private ApiClient apiClient;

    public CsmAgentsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public CsmAgentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CsmAgentsResponse listAllCSMAgents() throws ApiException {
        return this.listAllCSMAgentsWithHttpInfo(new ListAllCSMAgentsOptionalParameters()).getData();
    }

    public CompletableFuture<CsmAgentsResponse> listAllCSMAgentsAsync() {
        return this.listAllCSMAgentsWithHttpInfoAsync(new ListAllCSMAgentsOptionalParameters()).thenApply(response -> (CsmAgentsResponse)response.getData());
    }

    public CsmAgentsResponse listAllCSMAgents(ListAllCSMAgentsOptionalParameters parameters) throws ApiException {
        return this.listAllCSMAgentsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<CsmAgentsResponse> listAllCSMAgentsAsync(ListAllCSMAgentsOptionalParameters parameters) {
        return this.listAllCSMAgentsWithHttpInfoAsync(parameters).thenApply(response -> (CsmAgentsResponse)response.getData());
    }

    public ApiResponse<CsmAgentsResponse> listAllCSMAgentsWithHttpInfo(ListAllCSMAgentsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Integer page = parameters.page;
        Integer size = parameters.size;
        String query = parameters.query;
        OrderDirection orderDirection = parameters.orderDirection;
        String localVarPath = "/api/v2/csm/onboarding/agents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "size", size));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order_direction", orderDirection));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmAgentsApi.listAllCSMAgents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CsmAgentsResponse>(){});
    }

    public CompletableFuture<ApiResponse<CsmAgentsResponse>> listAllCSMAgentsWithHttpInfoAsync(ListAllCSMAgentsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Integer page = parameters.page;
        Integer size = parameters.size;
        String query = parameters.query;
        OrderDirection orderDirection = parameters.orderDirection;
        String localVarPath = "/api/v2/csm/onboarding/agents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "size", size));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order_direction", orderDirection));
        try {
            builder = this.apiClient.createBuilder("v2.CsmAgentsApi.listAllCSMAgents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CsmAgentsResponse>> result = new CompletableFuture<ApiResponse<CsmAgentsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CsmAgentsResponse>(){});
    }

    public CsmAgentsResponse listAllCSMServerlessAgents() throws ApiException {
        return this.listAllCSMServerlessAgentsWithHttpInfo(new ListAllCSMServerlessAgentsOptionalParameters()).getData();
    }

    public CompletableFuture<CsmAgentsResponse> listAllCSMServerlessAgentsAsync() {
        return this.listAllCSMServerlessAgentsWithHttpInfoAsync(new ListAllCSMServerlessAgentsOptionalParameters()).thenApply(response -> (CsmAgentsResponse)response.getData());
    }

    public CsmAgentsResponse listAllCSMServerlessAgents(ListAllCSMServerlessAgentsOptionalParameters parameters) throws ApiException {
        return this.listAllCSMServerlessAgentsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<CsmAgentsResponse> listAllCSMServerlessAgentsAsync(ListAllCSMServerlessAgentsOptionalParameters parameters) {
        return this.listAllCSMServerlessAgentsWithHttpInfoAsync(parameters).thenApply(response -> (CsmAgentsResponse)response.getData());
    }

    public ApiResponse<CsmAgentsResponse> listAllCSMServerlessAgentsWithHttpInfo(ListAllCSMServerlessAgentsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Integer page = parameters.page;
        Integer size = parameters.size;
        String query = parameters.query;
        OrderDirection orderDirection = parameters.orderDirection;
        String localVarPath = "/api/v2/csm/onboarding/serverless/agents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "size", size));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order_direction", orderDirection));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmAgentsApi.listAllCSMServerlessAgents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CsmAgentsResponse>(){});
    }

    public CompletableFuture<ApiResponse<CsmAgentsResponse>> listAllCSMServerlessAgentsWithHttpInfoAsync(ListAllCSMServerlessAgentsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Integer page = parameters.page;
        Integer size = parameters.size;
        String query = parameters.query;
        OrderDirection orderDirection = parameters.orderDirection;
        String localVarPath = "/api/v2/csm/onboarding/serverless/agents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "size", size));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order_direction", orderDirection));
        try {
            builder = this.apiClient.createBuilder("v2.CsmAgentsApi.listAllCSMServerlessAgents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CsmAgentsResponse>> result = new CompletableFuture<ApiResponse<CsmAgentsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CsmAgentsResponse>(){});
    }

    public static class ListAllCSMServerlessAgentsOptionalParameters {
        private Integer page;
        private Integer size;
        private String query;
        private OrderDirection orderDirection;

        public ListAllCSMServerlessAgentsOptionalParameters page(Integer page) {
            this.page = page;
            return this;
        }

        public ListAllCSMServerlessAgentsOptionalParameters size(Integer size) {
            this.size = size;
            return this;
        }

        public ListAllCSMServerlessAgentsOptionalParameters query(String query) {
            this.query = query;
            return this;
        }

        public ListAllCSMServerlessAgentsOptionalParameters orderDirection(OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }
    }

    public static class ListAllCSMAgentsOptionalParameters {
        private Integer page;
        private Integer size;
        private String query;
        private OrderDirection orderDirection;

        public ListAllCSMAgentsOptionalParameters page(Integer page) {
            this.page = page;
            return this;
        }

        public ListAllCSMAgentsOptionalParameters size(Integer size) {
            this.size = size;
            return this;
        }

        public ListAllCSMAgentsOptionalParameters query(String query) {
            this.query = query;
            return this;
        }

        public ListAllCSMAgentsOptionalParameters orderDirection(OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }
    }
}

