/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"code", "details", "message"})
public class LogsAPIError {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CODE = "code";
    private String code;
    public static final String JSON_PROPERTY_DETAILS = "details";
    private List<LogsAPIError> details = null;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    private Map<String, Object> additionalProperties;

    public LogsAPIError code(String code) {
        this.code = code;
        return this;
    }

    @Nullable
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public LogsAPIError details(List<LogsAPIError> details) {
        this.details = details;
        for (LogsAPIError item : details) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsAPIError addDetailsItem(LogsAPIError detailsItem) {
        if (this.details == null) {
            this.details = new ArrayList<LogsAPIError>();
        }
        this.details.add(detailsItem);
        this.unparsed |= detailsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsAPIError> getDetails() {
        return this.details;
    }

    public void setDetails(List<LogsAPIError> details) {
        this.details = details;
    }

    public LogsAPIError message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonAnySetter
    public LogsAPIError putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsAPIError logsApiError = (LogsAPIError)o;
        return Objects.equals(this.code, logsApiError.code) && Objects.equals(this.details, logsApiError.details) && Objects.equals(this.message, logsApiError.message) && Objects.equals(this.additionalProperties, logsApiError.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.details, this.message, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsAPIError {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

