/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.SBOMComponent;
import com.datadog.api.client.v2.model.SBOMComponentDependency;
import com.datadog.api.client.v2.model.SBOMMetadata;
import com.datadog.api.client.v2.model.SpecVersion;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"bomFormat", "components", "dependencies", "metadata", "serialNumber", "specVersion", "version"})
public class SBOMAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_BOM_FORMAT = "bomFormat";
    private String bomFormat;
    public static final String JSON_PROPERTY_COMPONENTS = "components";
    private List<SBOMComponent> components = new ArrayList<SBOMComponent>();
    public static final String JSON_PROPERTY_DEPENDENCIES = "dependencies";
    private List<SBOMComponentDependency> dependencies = new ArrayList<SBOMComponentDependency>();
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private SBOMMetadata metadata;
    public static final String JSON_PROPERTY_SERIAL_NUMBER = "serialNumber";
    private String serialNumber;
    public static final String JSON_PROPERTY_SPEC_VERSION = "specVersion";
    private SpecVersion specVersion;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Long version;
    private Map<String, Object> additionalProperties;

    public SBOMAttributes() {
    }

    @JsonCreator
    public SBOMAttributes(@JsonProperty(required=true, value="bomFormat") String bomFormat, @JsonProperty(required=true, value="components") List<SBOMComponent> components, @JsonProperty(required=true, value="dependencies") List<SBOMComponentDependency> dependencies, @JsonProperty(required=true, value="metadata") SBOMMetadata metadata, @JsonProperty(required=true, value="serialNumber") String serialNumber, @JsonProperty(required=true, value="specVersion") SpecVersion specVersion, @JsonProperty(required=true, value="version") Long version) {
        this.bomFormat = bomFormat;
        this.components = components;
        this.dependencies = dependencies;
        this.metadata = metadata;
        this.unparsed |= metadata.unparsed;
        this.serialNumber = serialNumber;
        this.specVersion = specVersion;
        this.unparsed |= !specVersion.isValid();
        this.version = version;
    }

    public SBOMAttributes bomFormat(String bomFormat) {
        this.bomFormat = bomFormat;
        return this;
    }

    @JsonProperty(value="bomFormat")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBomFormat() {
        return this.bomFormat;
    }

    public void setBomFormat(String bomFormat) {
        this.bomFormat = bomFormat;
    }

    public SBOMAttributes components(List<SBOMComponent> components) {
        this.components = components;
        for (SBOMComponent item : components) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SBOMAttributes addComponentsItem(SBOMComponent componentsItem) {
        this.components.add(componentsItem);
        this.unparsed |= componentsItem.unparsed;
        return this;
    }

    @JsonProperty(value="components")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SBOMComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<SBOMComponent> components) {
        this.components = components;
    }

    public SBOMAttributes dependencies(List<SBOMComponentDependency> dependencies) {
        this.dependencies = dependencies;
        for (SBOMComponentDependency item : dependencies) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SBOMAttributes addDependenciesItem(SBOMComponentDependency dependenciesItem) {
        this.dependencies.add(dependenciesItem);
        this.unparsed |= dependenciesItem.unparsed;
        return this;
    }

    @JsonProperty(value="dependencies")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SBOMComponentDependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<SBOMComponentDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public SBOMAttributes metadata(SBOMMetadata metadata) {
        this.metadata = metadata;
        this.unparsed |= metadata.unparsed;
        return this;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SBOMMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(SBOMMetadata metadata) {
        this.metadata = metadata;
    }

    public SBOMAttributes serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @JsonProperty(value="serialNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public SBOMAttributes specVersion(SpecVersion specVersion) {
        this.specVersion = specVersion;
        this.unparsed |= !specVersion.isValid();
        return this;
    }

    @JsonProperty(value="specVersion")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SpecVersion getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(SpecVersion specVersion) {
        if (!specVersion.isValid()) {
            this.unparsed = true;
        }
        this.specVersion = specVersion;
    }

    public SBOMAttributes version(Long version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    @JsonAnySetter
    public SBOMAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SBOMAttributes sbomAttributes = (SBOMAttributes)o;
        return Objects.equals(this.bomFormat, sbomAttributes.bomFormat) && Objects.equals(this.components, sbomAttributes.components) && Objects.equals(this.dependencies, sbomAttributes.dependencies) && Objects.equals(this.metadata, sbomAttributes.metadata) && Objects.equals(this.serialNumber, sbomAttributes.serialNumber) && Objects.equals(this.specVersion, sbomAttributes.specVersion) && Objects.equals(this.version, sbomAttributes.version) && Objects.equals(this.additionalProperties, sbomAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.bomFormat, this.components, this.dependencies, this.metadata, this.serialNumber, this.specVersion, this.version, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SBOMAttributes {\n");
        sb.append("    bomFormat: ").append(this.toIndentedString(this.bomFormat)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("    dependencies: ").append(this.toIndentedString(this.dependencies)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString(this.serialNumber)).append("\n");
        sb.append("    specVersion: ").append(this.toIndentedString(this.specVersion)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

