/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.RetentionFilterAllType;
import com.datadog.api.client.v2.model.SpansFilterCreate;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"enabled", "filter", "filter_type", "name", "rate", "trace_rate"})
public class RetentionFilterUpdateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private SpansFilterCreate filter;
    public static final String JSON_PROPERTY_FILTER_TYPE = "filter_type";
    private RetentionFilterAllType filterType = RetentionFilterAllType.SPANS_SAMPLING_PROCESSOR;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_RATE = "rate";
    private Double rate;
    public static final String JSON_PROPERTY_TRACE_RATE = "trace_rate";
    private Double traceRate;
    private Map<String, Object> additionalProperties;

    public RetentionFilterUpdateAttributes() {
    }

    @JsonCreator
    public RetentionFilterUpdateAttributes(@JsonProperty(required=true, value="enabled") Boolean enabled, @JsonProperty(required=true, value="filter") SpansFilterCreate filter, @JsonProperty(required=true, value="filter_type") RetentionFilterAllType filterType, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="rate") Double rate) {
        this.enabled = enabled;
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        this.filterType = filterType;
        this.unparsed |= !filterType.isValid();
        this.name = name;
        this.rate = rate;
    }

    public RetentionFilterUpdateAttributes enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public RetentionFilterUpdateAttributes filter(SpansFilterCreate filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SpansFilterCreate getFilter() {
        return this.filter;
    }

    public void setFilter(SpansFilterCreate filter) {
        this.filter = filter;
    }

    public RetentionFilterUpdateAttributes filterType(RetentionFilterAllType filterType) {
        this.filterType = filterType;
        this.unparsed |= !filterType.isValid();
        return this;
    }

    @JsonProperty(value="filter_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RetentionFilterAllType getFilterType() {
        return this.filterType;
    }

    public void setFilterType(RetentionFilterAllType filterType) {
        if (!filterType.isValid()) {
            this.unparsed = true;
        }
        this.filterType = filterType;
    }

    public RetentionFilterUpdateAttributes name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RetentionFilterUpdateAttributes rate(Double rate) {
        this.rate = rate;
        return this;
    }

    @JsonProperty(value="rate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Double getRate() {
        return this.rate;
    }

    public void setRate(Double rate) {
        this.rate = rate;
    }

    public RetentionFilterUpdateAttributes traceRate(Double traceRate) {
        this.traceRate = traceRate;
        return this;
    }

    @Nullable
    @JsonProperty(value="trace_rate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTraceRate() {
        return this.traceRate;
    }

    public void setTraceRate(Double traceRate) {
        this.traceRate = traceRate;
    }

    @JsonAnySetter
    public RetentionFilterUpdateAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetentionFilterUpdateAttributes retentionFilterUpdateAttributes = (RetentionFilterUpdateAttributes)o;
        return Objects.equals(this.enabled, retentionFilterUpdateAttributes.enabled) && Objects.equals(this.filter, retentionFilterUpdateAttributes.filter) && Objects.equals(this.filterType, retentionFilterUpdateAttributes.filterType) && Objects.equals(this.name, retentionFilterUpdateAttributes.name) && Objects.equals(this.rate, retentionFilterUpdateAttributes.rate) && Objects.equals(this.traceRate, retentionFilterUpdateAttributes.traceRate) && Objects.equals(this.additionalProperties, retentionFilterUpdateAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.filter, this.filterType, this.name, this.rate, this.traceRate, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RetentionFilterUpdateAttributes {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    filterType: ").append(this.toIndentedString(this.filterType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    traceRate: ").append(this.toIndentedString(this.traceRate)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

