/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.GCPSTSDelegateAccountResponse;
import com.datadog.api.client.v2.model.GCPSTSServiceAccountCreateRequest;
import com.datadog.api.client.v2.model.GCPSTSServiceAccountResponse;
import com.datadog.api.client.v2.model.GCPSTSServiceAccountUpdateRequest;
import com.datadog.api.client.v2.model.GCPSTSServiceAccountsResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class GcpIntegrationApi {
    private ApiClient apiClient;

    public GcpIntegrationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public GcpIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public GCPSTSServiceAccountResponse createGCPSTSAccount(GCPSTSServiceAccountCreateRequest body) throws ApiException {
        return this.createGCPSTSAccountWithHttpInfo(body).getData();
    }

    public CompletableFuture<GCPSTSServiceAccountResponse> createGCPSTSAccountAsync(GCPSTSServiceAccountCreateRequest body) {
        return this.createGCPSTSAccountWithHttpInfoAsync(body).thenApply(response -> (GCPSTSServiceAccountResponse)response.getData());
    }

    public ApiResponse<GCPSTSServiceAccountResponse> createGCPSTSAccountWithHttpInfo(GCPSTSServiceAccountCreateRequest body) throws ApiException {
        GCPSTSServiceAccountCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createGCPSTSAccount");
        }
        String localVarPath = "/api/v2/integration/gcp/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.GcpIntegrationApi.createGCPSTSAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPSTSServiceAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<GCPSTSServiceAccountResponse>> createGCPSTSAccountWithHttpInfoAsync(GCPSTSServiceAccountCreateRequest body) {
        Invocation.Builder builder;
        GCPSTSServiceAccountCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<GCPSTSServiceAccountResponse>> result = new CompletableFuture<ApiResponse<GCPSTSServiceAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createGCPSTSAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integration/gcp/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.GcpIntegrationApi.createGCPSTSAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GCPSTSServiceAccountResponse>> result = new CompletableFuture<ApiResponse<GCPSTSServiceAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPSTSServiceAccountResponse>(){});
    }

    public void deleteGCPSTSAccount(String accountId) throws ApiException {
        this.deleteGCPSTSAccountWithHttpInfo(accountId);
    }

    public CompletableFuture<Void> deleteGCPSTSAccountAsync(String accountId) {
        return this.deleteGCPSTSAccountWithHttpInfoAsync(accountId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteGCPSTSAccountWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteGCPSTSAccount");
        }
        String localVarPath = "/api/v2/integration/gcp/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.GcpIntegrationApi.deleteGCPSTSAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteGCPSTSAccountWithHttpInfoAsync(String accountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling deleteGCPSTSAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integration/gcp/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.GcpIntegrationApi.deleteGCPSTSAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public GCPSTSDelegateAccountResponse getGCPSTSDelegate() throws ApiException {
        return this.getGCPSTSDelegateWithHttpInfo().getData();
    }

    public CompletableFuture<GCPSTSDelegateAccountResponse> getGCPSTSDelegateAsync() {
        return this.getGCPSTSDelegateWithHttpInfoAsync().thenApply(response -> (GCPSTSDelegateAccountResponse)response.getData());
    }

    public ApiResponse<GCPSTSDelegateAccountResponse> getGCPSTSDelegateWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration/gcp/sts_delegate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.GcpIntegrationApi.getGCPSTSDelegate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPSTSDelegateAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<GCPSTSDelegateAccountResponse>> getGCPSTSDelegateWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration/gcp/sts_delegate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.GcpIntegrationApi.getGCPSTSDelegate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GCPSTSDelegateAccountResponse>> result = new CompletableFuture<ApiResponse<GCPSTSDelegateAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPSTSDelegateAccountResponse>(){});
    }

    public GCPSTSServiceAccountsResponse listGCPSTSAccounts() throws ApiException {
        return this.listGCPSTSAccountsWithHttpInfo().getData();
    }

    public CompletableFuture<GCPSTSServiceAccountsResponse> listGCPSTSAccountsAsync() {
        return this.listGCPSTSAccountsWithHttpInfoAsync().thenApply(response -> (GCPSTSServiceAccountsResponse)response.getData());
    }

    public ApiResponse<GCPSTSServiceAccountsResponse> listGCPSTSAccountsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration/gcp/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.GcpIntegrationApi.listGCPSTSAccounts", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPSTSServiceAccountsResponse>(){});
    }

    public CompletableFuture<ApiResponse<GCPSTSServiceAccountsResponse>> listGCPSTSAccountsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration/gcp/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.GcpIntegrationApi.listGCPSTSAccounts", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GCPSTSServiceAccountsResponse>> result = new CompletableFuture<ApiResponse<GCPSTSServiceAccountsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPSTSServiceAccountsResponse>(){});
    }

    public GCPSTSDelegateAccountResponse makeGCPSTSDelegate() throws ApiException {
        return this.makeGCPSTSDelegateWithHttpInfo(new MakeGCPSTSDelegateOptionalParameters()).getData();
    }

    public CompletableFuture<GCPSTSDelegateAccountResponse> makeGCPSTSDelegateAsync() {
        return this.makeGCPSTSDelegateWithHttpInfoAsync(new MakeGCPSTSDelegateOptionalParameters()).thenApply(response -> (GCPSTSDelegateAccountResponse)response.getData());
    }

    public GCPSTSDelegateAccountResponse makeGCPSTSDelegate(MakeGCPSTSDelegateOptionalParameters parameters) throws ApiException {
        return this.makeGCPSTSDelegateWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<GCPSTSDelegateAccountResponse> makeGCPSTSDelegateAsync(MakeGCPSTSDelegateOptionalParameters parameters) {
        return this.makeGCPSTSDelegateWithHttpInfoAsync(parameters).thenApply(response -> (GCPSTSDelegateAccountResponse)response.getData());
    }

    public ApiResponse<GCPSTSDelegateAccountResponse> makeGCPSTSDelegateWithHttpInfo(MakeGCPSTSDelegateOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/integration/gcp/sts_delegate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.GcpIntegrationApi.makeGCPSTSDelegate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPSTSDelegateAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<GCPSTSDelegateAccountResponse>> makeGCPSTSDelegateWithHttpInfoAsync(MakeGCPSTSDelegateOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/integration/gcp/sts_delegate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.GcpIntegrationApi.makeGCPSTSDelegate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GCPSTSDelegateAccountResponse>> result = new CompletableFuture<ApiResponse<GCPSTSDelegateAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPSTSDelegateAccountResponse>(){});
    }

    public GCPSTSServiceAccountResponse updateGCPSTSAccount(String accountId, GCPSTSServiceAccountUpdateRequest body) throws ApiException {
        return this.updateGCPSTSAccountWithHttpInfo(accountId, body).getData();
    }

    public CompletableFuture<GCPSTSServiceAccountResponse> updateGCPSTSAccountAsync(String accountId, GCPSTSServiceAccountUpdateRequest body) {
        return this.updateGCPSTSAccountWithHttpInfoAsync(accountId, body).thenApply(response -> (GCPSTSServiceAccountResponse)response.getData());
    }

    public ApiResponse<GCPSTSServiceAccountResponse> updateGCPSTSAccountWithHttpInfo(String accountId, GCPSTSServiceAccountUpdateRequest body) throws ApiException {
        GCPSTSServiceAccountUpdateRequest localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateGCPSTSAccount");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateGCPSTSAccount");
        }
        String localVarPath = "/api/v2/integration/gcp/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.GcpIntegrationApi.updateGCPSTSAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPSTSServiceAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<GCPSTSServiceAccountResponse>> updateGCPSTSAccountWithHttpInfoAsync(String accountId, GCPSTSServiceAccountUpdateRequest body) {
        Invocation.Builder builder;
        GCPSTSServiceAccountUpdateRequest localVarPostBody = body;
        if (accountId == null) {
            CompletableFuture<ApiResponse<GCPSTSServiceAccountResponse>> result = new CompletableFuture<ApiResponse<GCPSTSServiceAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling updateGCPSTSAccount"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<GCPSTSServiceAccountResponse>> result = new CompletableFuture<ApiResponse<GCPSTSServiceAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateGCPSTSAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integration/gcp/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.GcpIntegrationApi.updateGCPSTSAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GCPSTSServiceAccountResponse>> result = new CompletableFuture<ApiResponse<GCPSTSServiceAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GCPSTSServiceAccountResponse>(){});
    }

    public static class MakeGCPSTSDelegateOptionalParameters {
        private Object body;

        public MakeGCPSTSDelegateOptionalParameters body(Object body) {
            this.body = body;
            return this;
        }
    }
}

