/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CreateIncidentNotificationTemplateRequest;
import com.datadog.api.client.v2.model.IncidentAttachmentAttachmentType;
import com.datadog.api.client.v2.model.IncidentAttachmentRelatedObject;
import com.datadog.api.client.v2.model.IncidentAttachmentUpdateRequest;
import com.datadog.api.client.v2.model.IncidentAttachmentUpdateResponse;
import com.datadog.api.client.v2.model.IncidentAttachmentsResponse;
import com.datadog.api.client.v2.model.IncidentCreateRequest;
import com.datadog.api.client.v2.model.IncidentIntegrationMetadataCreateRequest;
import com.datadog.api.client.v2.model.IncidentIntegrationMetadataListResponse;
import com.datadog.api.client.v2.model.IncidentIntegrationMetadataPatchRequest;
import com.datadog.api.client.v2.model.IncidentIntegrationMetadataResponse;
import com.datadog.api.client.v2.model.IncidentNotificationTemplate;
import com.datadog.api.client.v2.model.IncidentNotificationTemplateArray;
import com.datadog.api.client.v2.model.IncidentRelatedObject;
import com.datadog.api.client.v2.model.IncidentResponse;
import com.datadog.api.client.v2.model.IncidentResponseData;
import com.datadog.api.client.v2.model.IncidentSearchResponse;
import com.datadog.api.client.v2.model.IncidentSearchResponseIncidentsData;
import com.datadog.api.client.v2.model.IncidentSearchSortOrder;
import com.datadog.api.client.v2.model.IncidentTodoCreateRequest;
import com.datadog.api.client.v2.model.IncidentTodoListResponse;
import com.datadog.api.client.v2.model.IncidentTodoPatchRequest;
import com.datadog.api.client.v2.model.IncidentTodoResponse;
import com.datadog.api.client.v2.model.IncidentTypeCreateRequest;
import com.datadog.api.client.v2.model.IncidentTypeListResponse;
import com.datadog.api.client.v2.model.IncidentTypePatchRequest;
import com.datadog.api.client.v2.model.IncidentTypeResponse;
import com.datadog.api.client.v2.model.IncidentUpdateRequest;
import com.datadog.api.client.v2.model.IncidentsResponse;
import com.datadog.api.client.v2.model.PatchIncidentNotificationTemplateRequest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class IncidentsApi {
    private ApiClient apiClient;

    public IncidentsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public IncidentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public IncidentResponse createIncident(IncidentCreateRequest body) throws ApiException {
        return this.createIncidentWithHttpInfo(body).getData();
    }

    public CompletableFuture<IncidentResponse> createIncidentAsync(IncidentCreateRequest body) {
        return this.createIncidentWithHttpInfoAsync(body).thenApply(response -> (IncidentResponse)response.getData());
    }

    public ApiResponse<IncidentResponse> createIncidentWithHttpInfo(IncidentCreateRequest body) throws ApiException {
        String operationId = "createIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createIncident");
        }
        String localVarPath = "/api/v2/incidents";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.createIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentResponse>> createIncidentWithHttpInfoAsync(IncidentCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createIncident"));
            return result;
        }
        String localVarPath = "/api/v2/incidents";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.createIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public IncidentIntegrationMetadataResponse createIncidentIntegration(String incidentId, IncidentIntegrationMetadataCreateRequest body) throws ApiException {
        return this.createIncidentIntegrationWithHttpInfo(incidentId, body).getData();
    }

    public CompletableFuture<IncidentIntegrationMetadataResponse> createIncidentIntegrationAsync(String incidentId, IncidentIntegrationMetadataCreateRequest body) {
        return this.createIncidentIntegrationWithHttpInfoAsync(incidentId, body).thenApply(response -> (IncidentIntegrationMetadataResponse)response.getData());
    }

    public ApiResponse<IncidentIntegrationMetadataResponse> createIncidentIntegrationWithHttpInfo(String incidentId, IncidentIntegrationMetadataCreateRequest body) throws ApiException {
        String operationId = "createIncidentIntegration";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentIntegrationMetadataCreateRequest localVarPostBody = body;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling createIncidentIntegration");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createIncidentIntegration");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/integrations".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.createIncidentIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentIntegrationMetadataResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> createIncidentIntegrationWithHttpInfoAsync(String incidentId, IncidentIntegrationMetadataCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createIncidentIntegration";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentIntegrationMetadataCreateRequest localVarPostBody = body;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling createIncidentIntegration"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createIncidentIntegration"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/integrations".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.createIncidentIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentIntegrationMetadataResponse>(){});
    }

    public IncidentNotificationTemplate createIncidentNotificationTemplate(CreateIncidentNotificationTemplateRequest body) throws ApiException {
        return this.createIncidentNotificationTemplateWithHttpInfo(body).getData();
    }

    public CompletableFuture<IncidentNotificationTemplate> createIncidentNotificationTemplateAsync(CreateIncidentNotificationTemplateRequest body) {
        return this.createIncidentNotificationTemplateWithHttpInfoAsync(body).thenApply(response -> (IncidentNotificationTemplate)response.getData());
    }

    public ApiResponse<IncidentNotificationTemplate> createIncidentNotificationTemplateWithHttpInfo(CreateIncidentNotificationTemplateRequest body) throws ApiException {
        String operationId = "createIncidentNotificationTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        CreateIncidentNotificationTemplateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createIncidentNotificationTemplate");
        }
        String localVarPath = "/api/v2/incidents/config/notification-templates";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.createIncidentNotificationTemplate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentNotificationTemplate>(){});
    }

    public CompletableFuture<ApiResponse<IncidentNotificationTemplate>> createIncidentNotificationTemplateWithHttpInfoAsync(CreateIncidentNotificationTemplateRequest body) {
        Invocation.Builder builder;
        String operationId = "createIncidentNotificationTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentNotificationTemplate>> result = new CompletableFuture<ApiResponse<IncidentNotificationTemplate>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        CreateIncidentNotificationTemplateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentNotificationTemplate>> result = new CompletableFuture<ApiResponse<IncidentNotificationTemplate>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createIncidentNotificationTemplate"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/config/notification-templates";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.createIncidentNotificationTemplate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentNotificationTemplate>> result = new CompletableFuture<ApiResponse<IncidentNotificationTemplate>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentNotificationTemplate>(){});
    }

    public IncidentTodoResponse createIncidentTodo(String incidentId, IncidentTodoCreateRequest body) throws ApiException {
        return this.createIncidentTodoWithHttpInfo(incidentId, body).getData();
    }

    public CompletableFuture<IncidentTodoResponse> createIncidentTodoAsync(String incidentId, IncidentTodoCreateRequest body) {
        return this.createIncidentTodoWithHttpInfoAsync(incidentId, body).thenApply(response -> (IncidentTodoResponse)response.getData());
    }

    public ApiResponse<IncidentTodoResponse> createIncidentTodoWithHttpInfo(String incidentId, IncidentTodoCreateRequest body) throws ApiException {
        String operationId = "createIncidentTodo";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentTodoCreateRequest localVarPostBody = body;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling createIncidentTodo");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createIncidentTodo");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/todos".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.createIncidentTodo", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTodoResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentTodoResponse>> createIncidentTodoWithHttpInfoAsync(String incidentId, IncidentTodoCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createIncidentTodo";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentTodoResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentTodoCreateRequest localVarPostBody = body;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentTodoResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling createIncidentTodo"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentTodoResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createIncidentTodo"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/todos".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.createIncidentTodo", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentTodoResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTodoResponse>(){});
    }

    public IncidentTypeResponse createIncidentType(IncidentTypeCreateRequest body) throws ApiException {
        return this.createIncidentTypeWithHttpInfo(body).getData();
    }

    public CompletableFuture<IncidentTypeResponse> createIncidentTypeAsync(IncidentTypeCreateRequest body) {
        return this.createIncidentTypeWithHttpInfoAsync(body).thenApply(response -> (IncidentTypeResponse)response.getData());
    }

    public ApiResponse<IncidentTypeResponse> createIncidentTypeWithHttpInfo(IncidentTypeCreateRequest body) throws ApiException {
        String operationId = "createIncidentType";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentTypeCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createIncidentType");
        }
        String localVarPath = "/api/v2/incidents/config/types";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.createIncidentType", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTypeResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentTypeResponse>> createIncidentTypeWithHttpInfoAsync(IncidentTypeCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createIncidentType";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentTypeResponse>> result = new CompletableFuture<ApiResponse<IncidentTypeResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentTypeCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentTypeResponse>> result = new CompletableFuture<ApiResponse<IncidentTypeResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createIncidentType"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/config/types";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.createIncidentType", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentTypeResponse>> result = new CompletableFuture<ApiResponse<IncidentTypeResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTypeResponse>(){});
    }

    public void deleteIncident(String incidentId) throws ApiException {
        this.deleteIncidentWithHttpInfo(incidentId);
    }

    public CompletableFuture<Void> deleteIncidentAsync(String incidentId) {
        return this.deleteIncidentWithHttpInfoAsync(incidentId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteIncidentWithHttpInfo(String incidentId) throws ApiException {
        String operationId = "deleteIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling deleteIncident");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.deleteIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteIncidentWithHttpInfoAsync(String incidentId) {
        Invocation.Builder builder;
        String operationId = "deleteIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling deleteIncident"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.deleteIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteIncidentIntegration(String incidentId, String integrationMetadataId) throws ApiException {
        this.deleteIncidentIntegrationWithHttpInfo(incidentId, integrationMetadataId);
    }

    public CompletableFuture<Void> deleteIncidentIntegrationAsync(String incidentId, String integrationMetadataId) {
        return this.deleteIncidentIntegrationWithHttpInfoAsync(incidentId, integrationMetadataId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteIncidentIntegrationWithHttpInfo(String incidentId, String integrationMetadataId) throws ApiException {
        String operationId = "deleteIncidentIntegration";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling deleteIncidentIntegration");
        }
        if (integrationMetadataId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationMetadataId' when calling deleteIncidentIntegration");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/integrations/{integration_metadata_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString())).replaceAll("\\{integration_metadata_id\\}", this.apiClient.escapeString(integrationMetadataId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.deleteIncidentIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteIncidentIntegrationWithHttpInfoAsync(String incidentId, String integrationMetadataId) {
        Invocation.Builder builder;
        String operationId = "deleteIncidentIntegration";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling deleteIncidentIntegration"));
            return result;
        }
        if (integrationMetadataId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'integrationMetadataId' when calling deleteIncidentIntegration"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/integrations/{integration_metadata_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString())).replaceAll("\\{integration_metadata_id\\}", this.apiClient.escapeString(integrationMetadataId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.deleteIncidentIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteIncidentNotificationTemplate(UUID id) throws ApiException {
        this.deleteIncidentNotificationTemplateWithHttpInfo(id, new DeleteIncidentNotificationTemplateOptionalParameters());
    }

    public CompletableFuture<Void> deleteIncidentNotificationTemplateAsync(UUID id) {
        return this.deleteIncidentNotificationTemplateWithHttpInfoAsync(id, new DeleteIncidentNotificationTemplateOptionalParameters()).thenApply(response -> (Void)response.getData());
    }

    public void deleteIncidentNotificationTemplate(UUID id, DeleteIncidentNotificationTemplateOptionalParameters parameters) throws ApiException {
        this.deleteIncidentNotificationTemplateWithHttpInfo(id, parameters);
    }

    public CompletableFuture<Void> deleteIncidentNotificationTemplateAsync(UUID id, DeleteIncidentNotificationTemplateOptionalParameters parameters) {
        return this.deleteIncidentNotificationTemplateWithHttpInfoAsync(id, parameters).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteIncidentNotificationTemplateWithHttpInfo(UUID id, DeleteIncidentNotificationTemplateOptionalParameters parameters) throws ApiException {
        String operationId = "deleteIncidentNotificationTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteIncidentNotificationTemplate");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/incidents/config/notification-templates/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.deleteIncidentNotificationTemplate", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteIncidentNotificationTemplateWithHttpInfoAsync(UUID id, DeleteIncidentNotificationTemplateOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "deleteIncidentNotificationTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling deleteIncidentNotificationTemplate"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/incidents/config/notification-templates/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.deleteIncidentNotificationTemplate", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteIncidentTodo(String incidentId, String todoId) throws ApiException {
        this.deleteIncidentTodoWithHttpInfo(incidentId, todoId);
    }

    public CompletableFuture<Void> deleteIncidentTodoAsync(String incidentId, String todoId) {
        return this.deleteIncidentTodoWithHttpInfoAsync(incidentId, todoId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteIncidentTodoWithHttpInfo(String incidentId, String todoId) throws ApiException {
        String operationId = "deleteIncidentTodo";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling deleteIncidentTodo");
        }
        if (todoId == null) {
            throw new ApiException(400, "Missing the required parameter 'todoId' when calling deleteIncidentTodo");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/todos/{todo_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString())).replaceAll("\\{todo_id\\}", this.apiClient.escapeString(todoId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.deleteIncidentTodo", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteIncidentTodoWithHttpInfoAsync(String incidentId, String todoId) {
        Invocation.Builder builder;
        String operationId = "deleteIncidentTodo";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling deleteIncidentTodo"));
            return result;
        }
        if (todoId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'todoId' when calling deleteIncidentTodo"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/todos/{todo_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString())).replaceAll("\\{todo_id\\}", this.apiClient.escapeString(todoId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.deleteIncidentTodo", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteIncidentType(String incidentTypeId) throws ApiException {
        this.deleteIncidentTypeWithHttpInfo(incidentTypeId);
    }

    public CompletableFuture<Void> deleteIncidentTypeAsync(String incidentTypeId) {
        return this.deleteIncidentTypeWithHttpInfoAsync(incidentTypeId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteIncidentTypeWithHttpInfo(String incidentTypeId) throws ApiException {
        String operationId = "deleteIncidentType";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentTypeId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentTypeId' when calling deleteIncidentType");
        }
        String localVarPath = "/api/v2/incidents/config/types/{incident_type_id}".replaceAll("\\{incident_type_id\\}", this.apiClient.escapeString(incidentTypeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.deleteIncidentType", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteIncidentTypeWithHttpInfoAsync(String incidentTypeId) {
        Invocation.Builder builder;
        String operationId = "deleteIncidentType";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentTypeId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentTypeId' when calling deleteIncidentType"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/config/types/{incident_type_id}".replaceAll("\\{incident_type_id\\}", this.apiClient.escapeString(incidentTypeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.deleteIncidentType", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public IncidentResponse getIncident(String incidentId) throws ApiException {
        return this.getIncidentWithHttpInfo(incidentId, new GetIncidentOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentResponse> getIncidentAsync(String incidentId) {
        return this.getIncidentWithHttpInfoAsync(incidentId, new GetIncidentOptionalParameters()).thenApply(response -> (IncidentResponse)response.getData());
    }

    public IncidentResponse getIncident(String incidentId, GetIncidentOptionalParameters parameters) throws ApiException {
        return this.getIncidentWithHttpInfo(incidentId, parameters).getData();
    }

    public CompletableFuture<IncidentResponse> getIncidentAsync(String incidentId, GetIncidentOptionalParameters parameters) {
        return this.getIncidentWithHttpInfoAsync(incidentId, parameters).thenApply(response -> (IncidentResponse)response.getData());
    }

    public ApiResponse<IncidentResponse> getIncidentWithHttpInfo(String incidentId, GetIncidentOptionalParameters parameters) throws ApiException {
        String operationId = "getIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling getIncident");
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.getIncident", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentResponse>> getIncidentWithHttpInfoAsync(String incidentId, GetIncidentOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling getIncident"));
            return result;
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.getIncident", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public IncidentIntegrationMetadataResponse getIncidentIntegration(String incidentId, String integrationMetadataId) throws ApiException {
        return this.getIncidentIntegrationWithHttpInfo(incidentId, integrationMetadataId).getData();
    }

    public CompletableFuture<IncidentIntegrationMetadataResponse> getIncidentIntegrationAsync(String incidentId, String integrationMetadataId) {
        return this.getIncidentIntegrationWithHttpInfoAsync(incidentId, integrationMetadataId).thenApply(response -> (IncidentIntegrationMetadataResponse)response.getData());
    }

    public ApiResponse<IncidentIntegrationMetadataResponse> getIncidentIntegrationWithHttpInfo(String incidentId, String integrationMetadataId) throws ApiException {
        String operationId = "getIncidentIntegration";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling getIncidentIntegration");
        }
        if (integrationMetadataId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationMetadataId' when calling getIncidentIntegration");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/integrations/{integration_metadata_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString())).replaceAll("\\{integration_metadata_id\\}", this.apiClient.escapeString(integrationMetadataId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.getIncidentIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentIntegrationMetadataResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> getIncidentIntegrationWithHttpInfoAsync(String incidentId, String integrationMetadataId) {
        Invocation.Builder builder;
        String operationId = "getIncidentIntegration";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling getIncidentIntegration"));
            return result;
        }
        if (integrationMetadataId == null) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'integrationMetadataId' when calling getIncidentIntegration"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/integrations/{integration_metadata_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString())).replaceAll("\\{integration_metadata_id\\}", this.apiClient.escapeString(integrationMetadataId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.getIncidentIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentIntegrationMetadataResponse>(){});
    }

    public IncidentNotificationTemplate getIncidentNotificationTemplate(UUID id) throws ApiException {
        return this.getIncidentNotificationTemplateWithHttpInfo(id, new GetIncidentNotificationTemplateOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentNotificationTemplate> getIncidentNotificationTemplateAsync(UUID id) {
        return this.getIncidentNotificationTemplateWithHttpInfoAsync(id, new GetIncidentNotificationTemplateOptionalParameters()).thenApply(response -> (IncidentNotificationTemplate)response.getData());
    }

    public IncidentNotificationTemplate getIncidentNotificationTemplate(UUID id, GetIncidentNotificationTemplateOptionalParameters parameters) throws ApiException {
        return this.getIncidentNotificationTemplateWithHttpInfo(id, parameters).getData();
    }

    public CompletableFuture<IncidentNotificationTemplate> getIncidentNotificationTemplateAsync(UUID id, GetIncidentNotificationTemplateOptionalParameters parameters) {
        return this.getIncidentNotificationTemplateWithHttpInfoAsync(id, parameters).thenApply(response -> (IncidentNotificationTemplate)response.getData());
    }

    public ApiResponse<IncidentNotificationTemplate> getIncidentNotificationTemplateWithHttpInfo(UUID id, GetIncidentNotificationTemplateOptionalParameters parameters) throws ApiException {
        String operationId = "getIncidentNotificationTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getIncidentNotificationTemplate");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/incidents/config/notification-templates/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.getIncidentNotificationTemplate", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentNotificationTemplate>(){});
    }

    public CompletableFuture<ApiResponse<IncidentNotificationTemplate>> getIncidentNotificationTemplateWithHttpInfoAsync(UUID id, GetIncidentNotificationTemplateOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getIncidentNotificationTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentNotificationTemplate>> result = new CompletableFuture<ApiResponse<IncidentNotificationTemplate>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<IncidentNotificationTemplate>> result = new CompletableFuture<ApiResponse<IncidentNotificationTemplate>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling getIncidentNotificationTemplate"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/incidents/config/notification-templates/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.getIncidentNotificationTemplate", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentNotificationTemplate>> result = new CompletableFuture<ApiResponse<IncidentNotificationTemplate>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentNotificationTemplate>(){});
    }

    public IncidentTodoResponse getIncidentTodo(String incidentId, String todoId) throws ApiException {
        return this.getIncidentTodoWithHttpInfo(incidentId, todoId).getData();
    }

    public CompletableFuture<IncidentTodoResponse> getIncidentTodoAsync(String incidentId, String todoId) {
        return this.getIncidentTodoWithHttpInfoAsync(incidentId, todoId).thenApply(response -> (IncidentTodoResponse)response.getData());
    }

    public ApiResponse<IncidentTodoResponse> getIncidentTodoWithHttpInfo(String incidentId, String todoId) throws ApiException {
        String operationId = "getIncidentTodo";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling getIncidentTodo");
        }
        if (todoId == null) {
            throw new ApiException(400, "Missing the required parameter 'todoId' when calling getIncidentTodo");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/todos/{todo_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString())).replaceAll("\\{todo_id\\}", this.apiClient.escapeString(todoId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.getIncidentTodo", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTodoResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentTodoResponse>> getIncidentTodoWithHttpInfoAsync(String incidentId, String todoId) {
        Invocation.Builder builder;
        String operationId = "getIncidentTodo";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentTodoResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentTodoResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling getIncidentTodo"));
            return result;
        }
        if (todoId == null) {
            CompletableFuture<ApiResponse<IncidentTodoResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'todoId' when calling getIncidentTodo"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/todos/{todo_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString())).replaceAll("\\{todo_id\\}", this.apiClient.escapeString(todoId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.getIncidentTodo", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentTodoResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTodoResponse>(){});
    }

    public IncidentTypeResponse getIncidentType(String incidentTypeId) throws ApiException {
        return this.getIncidentTypeWithHttpInfo(incidentTypeId).getData();
    }

    public CompletableFuture<IncidentTypeResponse> getIncidentTypeAsync(String incidentTypeId) {
        return this.getIncidentTypeWithHttpInfoAsync(incidentTypeId).thenApply(response -> (IncidentTypeResponse)response.getData());
    }

    public ApiResponse<IncidentTypeResponse> getIncidentTypeWithHttpInfo(String incidentTypeId) throws ApiException {
        String operationId = "getIncidentType";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentTypeId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentTypeId' when calling getIncidentType");
        }
        String localVarPath = "/api/v2/incidents/config/types/{incident_type_id}".replaceAll("\\{incident_type_id\\}", this.apiClient.escapeString(incidentTypeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.getIncidentType", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTypeResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentTypeResponse>> getIncidentTypeWithHttpInfoAsync(String incidentTypeId) {
        Invocation.Builder builder;
        String operationId = "getIncidentType";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentTypeResponse>> result = new CompletableFuture<ApiResponse<IncidentTypeResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentTypeId == null) {
            CompletableFuture<ApiResponse<IncidentTypeResponse>> result = new CompletableFuture<ApiResponse<IncidentTypeResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentTypeId' when calling getIncidentType"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/config/types/{incident_type_id}".replaceAll("\\{incident_type_id\\}", this.apiClient.escapeString(incidentTypeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.getIncidentType", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentTypeResponse>> result = new CompletableFuture<ApiResponse<IncidentTypeResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTypeResponse>(){});
    }

    public IncidentAttachmentsResponse listIncidentAttachments(String incidentId) throws ApiException {
        return this.listIncidentAttachmentsWithHttpInfo(incidentId, new ListIncidentAttachmentsOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentAttachmentsResponse> listIncidentAttachmentsAsync(String incidentId) {
        return this.listIncidentAttachmentsWithHttpInfoAsync(incidentId, new ListIncidentAttachmentsOptionalParameters()).thenApply(response -> (IncidentAttachmentsResponse)response.getData());
    }

    public IncidentAttachmentsResponse listIncidentAttachments(String incidentId, ListIncidentAttachmentsOptionalParameters parameters) throws ApiException {
        return this.listIncidentAttachmentsWithHttpInfo(incidentId, parameters).getData();
    }

    public CompletableFuture<IncidentAttachmentsResponse> listIncidentAttachmentsAsync(String incidentId, ListIncidentAttachmentsOptionalParameters parameters) {
        return this.listIncidentAttachmentsWithHttpInfoAsync(incidentId, parameters).thenApply(response -> (IncidentAttachmentsResponse)response.getData());
    }

    public ApiResponse<IncidentAttachmentsResponse> listIncidentAttachmentsWithHttpInfo(String incidentId, ListIncidentAttachmentsOptionalParameters parameters) throws ApiException {
        String operationId = "listIncidentAttachments";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling listIncidentAttachments");
        }
        List include = parameters.include;
        List filterAttachmentType = parameters.filterAttachmentType;
        String localVarPath = "/api/v2/incidents/{incident_id}/attachments".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[attachment_type]", filterAttachmentType));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidentAttachments", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentAttachmentsResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentAttachmentsResponse>> listIncidentAttachmentsWithHttpInfoAsync(String incidentId, ListIncidentAttachmentsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listIncidentAttachments";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentAttachmentsResponse>> result = new CompletableFuture<ApiResponse<IncidentAttachmentsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentAttachmentsResponse>> result = new CompletableFuture<ApiResponse<IncidentAttachmentsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling listIncidentAttachments"));
            return result;
        }
        List include = parameters.include;
        List filterAttachmentType = parameters.filterAttachmentType;
        String localVarPath = "/api/v2/incidents/{incident_id}/attachments".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[attachment_type]", filterAttachmentType));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidentAttachments", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentAttachmentsResponse>> result = new CompletableFuture<ApiResponse<IncidentAttachmentsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentAttachmentsResponse>(){});
    }

    public IncidentIntegrationMetadataListResponse listIncidentIntegrations(String incidentId) throws ApiException {
        return this.listIncidentIntegrationsWithHttpInfo(incidentId).getData();
    }

    public CompletableFuture<IncidentIntegrationMetadataListResponse> listIncidentIntegrationsAsync(String incidentId) {
        return this.listIncidentIntegrationsWithHttpInfoAsync(incidentId).thenApply(response -> (IncidentIntegrationMetadataListResponse)response.getData());
    }

    public ApiResponse<IncidentIntegrationMetadataListResponse> listIncidentIntegrationsWithHttpInfo(String incidentId) throws ApiException {
        String operationId = "listIncidentIntegrations";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling listIncidentIntegrations");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/integrations".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidentIntegrations", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentIntegrationMetadataListResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentIntegrationMetadataListResponse>> listIncidentIntegrationsWithHttpInfoAsync(String incidentId) {
        Invocation.Builder builder;
        String operationId = "listIncidentIntegrations";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataListResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataListResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataListResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling listIncidentIntegrations"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/integrations".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidentIntegrations", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataListResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentIntegrationMetadataListResponse>(){});
    }

    public IncidentNotificationTemplateArray listIncidentNotificationTemplates() throws ApiException {
        return this.listIncidentNotificationTemplatesWithHttpInfo(new ListIncidentNotificationTemplatesOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentNotificationTemplateArray> listIncidentNotificationTemplatesAsync() {
        return this.listIncidentNotificationTemplatesWithHttpInfoAsync(new ListIncidentNotificationTemplatesOptionalParameters()).thenApply(response -> (IncidentNotificationTemplateArray)response.getData());
    }

    public IncidentNotificationTemplateArray listIncidentNotificationTemplates(ListIncidentNotificationTemplatesOptionalParameters parameters) throws ApiException {
        return this.listIncidentNotificationTemplatesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<IncidentNotificationTemplateArray> listIncidentNotificationTemplatesAsync(ListIncidentNotificationTemplatesOptionalParameters parameters) {
        return this.listIncidentNotificationTemplatesWithHttpInfoAsync(parameters).thenApply(response -> (IncidentNotificationTemplateArray)response.getData());
    }

    public ApiResponse<IncidentNotificationTemplateArray> listIncidentNotificationTemplatesWithHttpInfo(ListIncidentNotificationTemplatesOptionalParameters parameters) throws ApiException {
        String operationId = "listIncidentNotificationTemplates";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        UUID filterIncidentType = parameters.filterIncidentType;
        String include = parameters.include;
        String localVarPath = "/api/v2/incidents/config/notification-templates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[incident-type]", filterIncidentType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidentNotificationTemplates", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentNotificationTemplateArray>(){});
    }

    public CompletableFuture<ApiResponse<IncidentNotificationTemplateArray>> listIncidentNotificationTemplatesWithHttpInfoAsync(ListIncidentNotificationTemplatesOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listIncidentNotificationTemplates";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentNotificationTemplateArray>> result = new CompletableFuture<ApiResponse<IncidentNotificationTemplateArray>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        UUID filterIncidentType = parameters.filterIncidentType;
        String include = parameters.include;
        String localVarPath = "/api/v2/incidents/config/notification-templates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[incident-type]", filterIncidentType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidentNotificationTemplates", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentNotificationTemplateArray>> result = new CompletableFuture<ApiResponse<IncidentNotificationTemplateArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentNotificationTemplateArray>(){});
    }

    public IncidentsResponse listIncidents() throws ApiException {
        return this.listIncidentsWithHttpInfo(new ListIncidentsOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentsResponse> listIncidentsAsync() {
        return this.listIncidentsWithHttpInfoAsync(new ListIncidentsOptionalParameters()).thenApply(response -> (IncidentsResponse)response.getData());
    }

    public IncidentsResponse listIncidents(ListIncidentsOptionalParameters parameters) throws ApiException {
        return this.listIncidentsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<IncidentsResponse> listIncidentsAsync(ListIncidentsOptionalParameters parameters) {
        return this.listIncidentsWithHttpInfoAsync(parameters).thenApply(response -> (IncidentsResponse)response.getData());
    }

    public PaginationIterable<IncidentResponseData> listIncidentsWithPagination() {
        ListIncidentsOptionalParameters parameters = new ListIncidentsOptionalParameters();
        return this.listIncidentsWithPagination(parameters);
    }

    public PaginationIterable<IncidentResponseData> listIncidentsWithPagination(ListIncidentsOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageOffset";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageSize == null) {
            limit = 10L;
            parameters.pageSize(limit);
        } else {
            limit = parameters.pageSize;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<IncidentResponseData> iterator = new PaginationIterable<IncidentResponseData>(this, "listIncidents", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<IncidentsResponse> listIncidentsWithHttpInfo(ListIncidentsOptionalParameters parameters) throws ApiException {
        String operationId = "listIncidents";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        List include = parameters.include;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/v2/incidents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentsResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentsResponse>> listIncidentsWithHttpInfoAsync(ListIncidentsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listIncidents";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentsResponse>> result = new CompletableFuture<ApiResponse<IncidentsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        List include = parameters.include;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/v2/incidents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentsResponse>> result = new CompletableFuture<ApiResponse<IncidentsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentsResponse>(){});
    }

    public IncidentTodoListResponse listIncidentTodos(String incidentId) throws ApiException {
        return this.listIncidentTodosWithHttpInfo(incidentId).getData();
    }

    public CompletableFuture<IncidentTodoListResponse> listIncidentTodosAsync(String incidentId) {
        return this.listIncidentTodosWithHttpInfoAsync(incidentId).thenApply(response -> (IncidentTodoListResponse)response.getData());
    }

    public ApiResponse<IncidentTodoListResponse> listIncidentTodosWithHttpInfo(String incidentId) throws ApiException {
        String operationId = "listIncidentTodos";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling listIncidentTodos");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/todos".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidentTodos", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTodoListResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentTodoListResponse>> listIncidentTodosWithHttpInfoAsync(String incidentId) {
        Invocation.Builder builder;
        String operationId = "listIncidentTodos";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentTodoListResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoListResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentTodoListResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling listIncidentTodos"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/todos".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidentTodos", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentTodoListResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTodoListResponse>(){});
    }

    public IncidentTypeListResponse listIncidentTypes() throws ApiException {
        return this.listIncidentTypesWithHttpInfo(new ListIncidentTypesOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentTypeListResponse> listIncidentTypesAsync() {
        return this.listIncidentTypesWithHttpInfoAsync(new ListIncidentTypesOptionalParameters()).thenApply(response -> (IncidentTypeListResponse)response.getData());
    }

    public IncidentTypeListResponse listIncidentTypes(ListIncidentTypesOptionalParameters parameters) throws ApiException {
        return this.listIncidentTypesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<IncidentTypeListResponse> listIncidentTypesAsync(ListIncidentTypesOptionalParameters parameters) {
        return this.listIncidentTypesWithHttpInfoAsync(parameters).thenApply(response -> (IncidentTypeListResponse)response.getData());
    }

    public ApiResponse<IncidentTypeListResponse> listIncidentTypesWithHttpInfo(ListIncidentTypesOptionalParameters parameters) throws ApiException {
        String operationId = "listIncidentTypes";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Boolean includeDeleted = parameters.includeDeleted;
        String localVarPath = "/api/v2/incidents/config/types";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_deleted", includeDeleted));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidentTypes", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTypeListResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentTypeListResponse>> listIncidentTypesWithHttpInfoAsync(ListIncidentTypesOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listIncidentTypes";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentTypeListResponse>> result = new CompletableFuture<ApiResponse<IncidentTypeListResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Boolean includeDeleted = parameters.includeDeleted;
        String localVarPath = "/api/v2/incidents/config/types";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_deleted", includeDeleted));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidentTypes", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentTypeListResponse>> result = new CompletableFuture<ApiResponse<IncidentTypeListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTypeListResponse>(){});
    }

    public IncidentSearchResponse searchIncidents(String query) throws ApiException {
        return this.searchIncidentsWithHttpInfo(query, new SearchIncidentsOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentSearchResponse> searchIncidentsAsync(String query) {
        return this.searchIncidentsWithHttpInfoAsync(query, new SearchIncidentsOptionalParameters()).thenApply(response -> (IncidentSearchResponse)response.getData());
    }

    public IncidentSearchResponse searchIncidents(String query, SearchIncidentsOptionalParameters parameters) throws ApiException {
        return this.searchIncidentsWithHttpInfo(query, parameters).getData();
    }

    public CompletableFuture<IncidentSearchResponse> searchIncidentsAsync(String query, SearchIncidentsOptionalParameters parameters) {
        return this.searchIncidentsWithHttpInfoAsync(query, parameters).thenApply(response -> (IncidentSearchResponse)response.getData());
    }

    public PaginationIterable<IncidentSearchResponseIncidentsData> searchIncidentsWithPagination(String query) {
        SearchIncidentsOptionalParameters parameters = new SearchIncidentsOptionalParameters();
        return this.searchIncidentsWithPagination(query, parameters);
    }

    public PaginationIterable<IncidentSearchResponseIncidentsData> searchIncidentsWithPagination(String query, SearchIncidentsOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData.getAttributes.getIncidents";
        String valueGetterPath = "";
        String valueSetterPath = "pageOffset";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageSize == null) {
            limit = 10L;
            parameters.pageSize(limit);
        } else {
            limit = parameters.pageSize;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("query", query);
        args.put("optionalParams", parameters);
        PaginationIterable<IncidentSearchResponseIncidentsData> iterator = new PaginationIterable<IncidentSearchResponseIncidentsData>(this, "searchIncidents", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<IncidentSearchResponse> searchIncidentsWithHttpInfo(String query, SearchIncidentsOptionalParameters parameters) throws ApiException {
        String operationId = "searchIncidents";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (query == null) {
            throw new ApiException(400, "Missing the required parameter 'query' when calling searchIncidents");
        }
        IncidentRelatedObject include = parameters.include;
        IncidentSearchSortOrder sort = parameters.sort;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/v2/incidents/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.searchIncidents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentSearchResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentSearchResponse>> searchIncidentsWithHttpInfoAsync(String query, SearchIncidentsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "searchIncidents";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentSearchResponse>> result = new CompletableFuture<ApiResponse<IncidentSearchResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (query == null) {
            CompletableFuture<ApiResponse<IncidentSearchResponse>> result = new CompletableFuture<ApiResponse<IncidentSearchResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'query' when calling searchIncidents"));
            return result;
        }
        IncidentRelatedObject include = parameters.include;
        IncidentSearchSortOrder sort = parameters.sort;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/v2/incidents/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.searchIncidents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentSearchResponse>> result = new CompletableFuture<ApiResponse<IncidentSearchResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentSearchResponse>(){});
    }

    public IncidentResponse updateIncident(String incidentId, IncidentUpdateRequest body) throws ApiException {
        return this.updateIncidentWithHttpInfo(incidentId, body, new UpdateIncidentOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentResponse> updateIncidentAsync(String incidentId, IncidentUpdateRequest body) {
        return this.updateIncidentWithHttpInfoAsync(incidentId, body, new UpdateIncidentOptionalParameters()).thenApply(response -> (IncidentResponse)response.getData());
    }

    public IncidentResponse updateIncident(String incidentId, IncidentUpdateRequest body, UpdateIncidentOptionalParameters parameters) throws ApiException {
        return this.updateIncidentWithHttpInfo(incidentId, body, parameters).getData();
    }

    public CompletableFuture<IncidentResponse> updateIncidentAsync(String incidentId, IncidentUpdateRequest body, UpdateIncidentOptionalParameters parameters) {
        return this.updateIncidentWithHttpInfoAsync(incidentId, body, parameters).thenApply(response -> (IncidentResponse)response.getData());
    }

    public ApiResponse<IncidentResponse> updateIncidentWithHttpInfo(String incidentId, IncidentUpdateRequest body, UpdateIncidentOptionalParameters parameters) throws ApiException {
        String operationId = "updateIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentUpdateRequest localVarPostBody = body;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncident");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncident");
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncident", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentResponse>> updateIncidentWithHttpInfoAsync(String incidentId, IncidentUpdateRequest body, UpdateIncidentOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "updateIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentUpdateRequest localVarPostBody = body;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncident"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateIncident"));
            return result;
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncident", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public IncidentAttachmentUpdateResponse updateIncidentAttachments(String incidentId, IncidentAttachmentUpdateRequest body) throws ApiException {
        return this.updateIncidentAttachmentsWithHttpInfo(incidentId, body, new UpdateIncidentAttachmentsOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentAttachmentUpdateResponse> updateIncidentAttachmentsAsync(String incidentId, IncidentAttachmentUpdateRequest body) {
        return this.updateIncidentAttachmentsWithHttpInfoAsync(incidentId, body, new UpdateIncidentAttachmentsOptionalParameters()).thenApply(response -> (IncidentAttachmentUpdateResponse)response.getData());
    }

    public IncidentAttachmentUpdateResponse updateIncidentAttachments(String incidentId, IncidentAttachmentUpdateRequest body, UpdateIncidentAttachmentsOptionalParameters parameters) throws ApiException {
        return this.updateIncidentAttachmentsWithHttpInfo(incidentId, body, parameters).getData();
    }

    public CompletableFuture<IncidentAttachmentUpdateResponse> updateIncidentAttachmentsAsync(String incidentId, IncidentAttachmentUpdateRequest body, UpdateIncidentAttachmentsOptionalParameters parameters) {
        return this.updateIncidentAttachmentsWithHttpInfoAsync(incidentId, body, parameters).thenApply(response -> (IncidentAttachmentUpdateResponse)response.getData());
    }

    public ApiResponse<IncidentAttachmentUpdateResponse> updateIncidentAttachmentsWithHttpInfo(String incidentId, IncidentAttachmentUpdateRequest body, UpdateIncidentAttachmentsOptionalParameters parameters) throws ApiException {
        String operationId = "updateIncidentAttachments";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentAttachmentUpdateRequest localVarPostBody = body;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncidentAttachments");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentAttachments");
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}/attachments".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncidentAttachments", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentAttachmentUpdateResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>> updateIncidentAttachmentsWithHttpInfoAsync(String incidentId, IncidentAttachmentUpdateRequest body, UpdateIncidentAttachmentsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "updateIncidentAttachments";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>> result = new CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentAttachmentUpdateRequest localVarPostBody = body;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>> result = new CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncidentAttachments"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>> result = new CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentAttachments"));
            return result;
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}/attachments".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncidentAttachments", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>> result = new CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentAttachmentUpdateResponse>(){});
    }

    public IncidentIntegrationMetadataResponse updateIncidentIntegration(String incidentId, String integrationMetadataId, IncidentIntegrationMetadataPatchRequest body) throws ApiException {
        return this.updateIncidentIntegrationWithHttpInfo(incidentId, integrationMetadataId, body).getData();
    }

    public CompletableFuture<IncidentIntegrationMetadataResponse> updateIncidentIntegrationAsync(String incidentId, String integrationMetadataId, IncidentIntegrationMetadataPatchRequest body) {
        return this.updateIncidentIntegrationWithHttpInfoAsync(incidentId, integrationMetadataId, body).thenApply(response -> (IncidentIntegrationMetadataResponse)response.getData());
    }

    public ApiResponse<IncidentIntegrationMetadataResponse> updateIncidentIntegrationWithHttpInfo(String incidentId, String integrationMetadataId, IncidentIntegrationMetadataPatchRequest body) throws ApiException {
        String operationId = "updateIncidentIntegration";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentIntegrationMetadataPatchRequest localVarPostBody = body;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncidentIntegration");
        }
        if (integrationMetadataId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationMetadataId' when calling updateIncidentIntegration");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentIntegration");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/integrations/{integration_metadata_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString())).replaceAll("\\{integration_metadata_id\\}", this.apiClient.escapeString(integrationMetadataId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncidentIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentIntegrationMetadataResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> updateIncidentIntegrationWithHttpInfoAsync(String incidentId, String integrationMetadataId, IncidentIntegrationMetadataPatchRequest body) {
        Invocation.Builder builder;
        String operationId = "updateIncidentIntegration";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentIntegrationMetadataPatchRequest localVarPostBody = body;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncidentIntegration"));
            return result;
        }
        if (integrationMetadataId == null) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'integrationMetadataId' when calling updateIncidentIntegration"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentIntegration"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/integrations/{integration_metadata_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString())).replaceAll("\\{integration_metadata_id\\}", this.apiClient.escapeString(integrationMetadataId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncidentIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>> result = new CompletableFuture<ApiResponse<IncidentIntegrationMetadataResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentIntegrationMetadataResponse>(){});
    }

    public IncidentNotificationTemplate updateIncidentNotificationTemplate(UUID id, PatchIncidentNotificationTemplateRequest body) throws ApiException {
        return this.updateIncidentNotificationTemplateWithHttpInfo(id, body, new UpdateIncidentNotificationTemplateOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentNotificationTemplate> updateIncidentNotificationTemplateAsync(UUID id, PatchIncidentNotificationTemplateRequest body) {
        return this.updateIncidentNotificationTemplateWithHttpInfoAsync(id, body, new UpdateIncidentNotificationTemplateOptionalParameters()).thenApply(response -> (IncidentNotificationTemplate)response.getData());
    }

    public IncidentNotificationTemplate updateIncidentNotificationTemplate(UUID id, PatchIncidentNotificationTemplateRequest body, UpdateIncidentNotificationTemplateOptionalParameters parameters) throws ApiException {
        return this.updateIncidentNotificationTemplateWithHttpInfo(id, body, parameters).getData();
    }

    public CompletableFuture<IncidentNotificationTemplate> updateIncidentNotificationTemplateAsync(UUID id, PatchIncidentNotificationTemplateRequest body, UpdateIncidentNotificationTemplateOptionalParameters parameters) {
        return this.updateIncidentNotificationTemplateWithHttpInfoAsync(id, body, parameters).thenApply(response -> (IncidentNotificationTemplate)response.getData());
    }

    public ApiResponse<IncidentNotificationTemplate> updateIncidentNotificationTemplateWithHttpInfo(UUID id, PatchIncidentNotificationTemplateRequest body, UpdateIncidentNotificationTemplateOptionalParameters parameters) throws ApiException {
        String operationId = "updateIncidentNotificationTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        PatchIncidentNotificationTemplateRequest localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateIncidentNotificationTemplate");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentNotificationTemplate");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/incidents/config/notification-templates/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncidentNotificationTemplate", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentNotificationTemplate>(){});
    }

    public CompletableFuture<ApiResponse<IncidentNotificationTemplate>> updateIncidentNotificationTemplateWithHttpInfoAsync(UUID id, PatchIncidentNotificationTemplateRequest body, UpdateIncidentNotificationTemplateOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "updateIncidentNotificationTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentNotificationTemplate>> result = new CompletableFuture<ApiResponse<IncidentNotificationTemplate>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        PatchIncidentNotificationTemplateRequest localVarPostBody = body;
        if (id == null) {
            CompletableFuture<ApiResponse<IncidentNotificationTemplate>> result = new CompletableFuture<ApiResponse<IncidentNotificationTemplate>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling updateIncidentNotificationTemplate"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentNotificationTemplate>> result = new CompletableFuture<ApiResponse<IncidentNotificationTemplate>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentNotificationTemplate"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/incidents/config/notification-templates/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncidentNotificationTemplate", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentNotificationTemplate>> result = new CompletableFuture<ApiResponse<IncidentNotificationTemplate>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentNotificationTemplate>(){});
    }

    public IncidentTodoResponse updateIncidentTodo(String incidentId, String todoId, IncidentTodoPatchRequest body) throws ApiException {
        return this.updateIncidentTodoWithHttpInfo(incidentId, todoId, body).getData();
    }

    public CompletableFuture<IncidentTodoResponse> updateIncidentTodoAsync(String incidentId, String todoId, IncidentTodoPatchRequest body) {
        return this.updateIncidentTodoWithHttpInfoAsync(incidentId, todoId, body).thenApply(response -> (IncidentTodoResponse)response.getData());
    }

    public ApiResponse<IncidentTodoResponse> updateIncidentTodoWithHttpInfo(String incidentId, String todoId, IncidentTodoPatchRequest body) throws ApiException {
        String operationId = "updateIncidentTodo";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentTodoPatchRequest localVarPostBody = body;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncidentTodo");
        }
        if (todoId == null) {
            throw new ApiException(400, "Missing the required parameter 'todoId' when calling updateIncidentTodo");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentTodo");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/todos/{todo_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString())).replaceAll("\\{todo_id\\}", this.apiClient.escapeString(todoId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncidentTodo", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTodoResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentTodoResponse>> updateIncidentTodoWithHttpInfoAsync(String incidentId, String todoId, IncidentTodoPatchRequest body) {
        Invocation.Builder builder;
        String operationId = "updateIncidentTodo";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentTodoResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentTodoPatchRequest localVarPostBody = body;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentTodoResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncidentTodo"));
            return result;
        }
        if (todoId == null) {
            CompletableFuture<ApiResponse<IncidentTodoResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'todoId' when calling updateIncidentTodo"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentTodoResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentTodo"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/{incident_id}/relationships/todos/{todo_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString())).replaceAll("\\{todo_id\\}", this.apiClient.escapeString(todoId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncidentTodo", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentTodoResponse>> result = new CompletableFuture<ApiResponse<IncidentTodoResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTodoResponse>(){});
    }

    public IncidentTypeResponse updateIncidentType(String incidentTypeId, IncidentTypePatchRequest body) throws ApiException {
        return this.updateIncidentTypeWithHttpInfo(incidentTypeId, body).getData();
    }

    public CompletableFuture<IncidentTypeResponse> updateIncidentTypeAsync(String incidentTypeId, IncidentTypePatchRequest body) {
        return this.updateIncidentTypeWithHttpInfoAsync(incidentTypeId, body).thenApply(response -> (IncidentTypeResponse)response.getData());
    }

    public ApiResponse<IncidentTypeResponse> updateIncidentTypeWithHttpInfo(String incidentTypeId, IncidentTypePatchRequest body) throws ApiException {
        String operationId = "updateIncidentType";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentTypePatchRequest localVarPostBody = body;
        if (incidentTypeId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentTypeId' when calling updateIncidentType");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentType");
        }
        String localVarPath = "/api/v2/incidents/config/types/{incident_type_id}".replaceAll("\\{incident_type_id\\}", this.apiClient.escapeString(incidentTypeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncidentType", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTypeResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentTypeResponse>> updateIncidentTypeWithHttpInfoAsync(String incidentTypeId, IncidentTypePatchRequest body) {
        Invocation.Builder builder;
        String operationId = "updateIncidentType";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentTypeResponse>> result = new CompletableFuture<ApiResponse<IncidentTypeResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentTypePatchRequest localVarPostBody = body;
        if (incidentTypeId == null) {
            CompletableFuture<ApiResponse<IncidentTypeResponse>> result = new CompletableFuture<ApiResponse<IncidentTypeResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentTypeId' when calling updateIncidentType"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentTypeResponse>> result = new CompletableFuture<ApiResponse<IncidentTypeResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentType"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/config/types/{incident_type_id}".replaceAll("\\{incident_type_id\\}", this.apiClient.escapeString(incidentTypeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncidentType", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentTypeResponse>> result = new CompletableFuture<ApiResponse<IncidentTypeResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTypeResponse>(){});
    }

    public static class UpdateIncidentNotificationTemplateOptionalParameters {
        private String include;

        public UpdateIncidentNotificationTemplateOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class UpdateIncidentAttachmentsOptionalParameters {
        private List<IncidentAttachmentRelatedObject> include;

        public UpdateIncidentAttachmentsOptionalParameters include(List<IncidentAttachmentRelatedObject> include) {
            this.include = include;
            return this;
        }
    }

    public static class UpdateIncidentOptionalParameters {
        private List<IncidentRelatedObject> include;

        public UpdateIncidentOptionalParameters include(List<IncidentRelatedObject> include) {
            this.include = include;
            return this;
        }
    }

    public static class SearchIncidentsOptionalParameters {
        private IncidentRelatedObject include;
        private IncidentSearchSortOrder sort;
        private Long pageSize;
        private Long pageOffset;

        public SearchIncidentsOptionalParameters include(IncidentRelatedObject include) {
            this.include = include;
            return this;
        }

        public SearchIncidentsOptionalParameters sort(IncidentSearchSortOrder sort) {
            this.sort = sort;
            return this;
        }

        public SearchIncidentsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public SearchIncidentsOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }
    }

    public static class ListIncidentTypesOptionalParameters {
        private Boolean includeDeleted;

        public ListIncidentTypesOptionalParameters includeDeleted(Boolean includeDeleted) {
            this.includeDeleted = includeDeleted;
            return this;
        }
    }

    public static class ListIncidentsOptionalParameters {
        private List<IncidentRelatedObject> include;
        private Long pageSize;
        private Long pageOffset;

        public ListIncidentsOptionalParameters include(List<IncidentRelatedObject> include) {
            this.include = include;
            return this;
        }

        public ListIncidentsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListIncidentsOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }
    }

    public static class ListIncidentNotificationTemplatesOptionalParameters {
        private UUID filterIncidentType;
        private String include;

        public ListIncidentNotificationTemplatesOptionalParameters filterIncidentType(UUID filterIncidentType) {
            this.filterIncidentType = filterIncidentType;
            return this;
        }

        public ListIncidentNotificationTemplatesOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class ListIncidentAttachmentsOptionalParameters {
        private List<IncidentAttachmentRelatedObject> include;
        private List<IncidentAttachmentAttachmentType> filterAttachmentType;

        public ListIncidentAttachmentsOptionalParameters include(List<IncidentAttachmentRelatedObject> include) {
            this.include = include;
            return this;
        }

        public ListIncidentAttachmentsOptionalParameters filterAttachmentType(List<IncidentAttachmentAttachmentType> filterAttachmentType) {
            this.filterAttachmentType = filterAttachmentType;
            return this;
        }
    }

    public static class GetIncidentNotificationTemplateOptionalParameters {
        private String include;

        public GetIncidentNotificationTemplateOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class GetIncidentOptionalParameters {
        private List<IncidentRelatedObject> include;

        public GetIncidentOptionalParameters include(List<IncidentRelatedObject> include) {
            this.include = include;
            return this;
        }
    }

    public static class DeleteIncidentNotificationTemplateOptionalParameters {
        private String include;

        public DeleteIncidentNotificationTemplateOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }
}

