/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CreateActionConnectionRequest;
import com.datadog.api.client.v2.model.CreateActionConnectionResponse;
import com.datadog.api.client.v2.model.GetActionConnectionResponse;
import com.datadog.api.client.v2.model.GetAppKeyRegistrationResponse;
import com.datadog.api.client.v2.model.ListAppKeyRegistrationsResponse;
import com.datadog.api.client.v2.model.RegisterAppKeyResponse;
import com.datadog.api.client.v2.model.UpdateActionConnectionRequest;
import com.datadog.api.client.v2.model.UpdateActionConnectionResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class ActionConnectionApi {
    private ApiClient apiClient;

    public ActionConnectionApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ActionConnectionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CreateActionConnectionResponse createActionConnection(CreateActionConnectionRequest body) throws ApiException {
        return this.createActionConnectionWithHttpInfo(body).getData();
    }

    public CompletableFuture<CreateActionConnectionResponse> createActionConnectionAsync(CreateActionConnectionRequest body) {
        return this.createActionConnectionWithHttpInfoAsync(body).thenApply(response -> (CreateActionConnectionResponse)response.getData());
    }

    public ApiResponse<CreateActionConnectionResponse> createActionConnectionWithHttpInfo(CreateActionConnectionRequest body) throws ApiException {
        CreateActionConnectionRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createActionConnection");
        }
        String localVarPath = "/api/v2/actions/connections";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionConnectionApi.createActionConnection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateActionConnectionResponse>(){});
    }

    public CompletableFuture<ApiResponse<CreateActionConnectionResponse>> createActionConnectionWithHttpInfoAsync(CreateActionConnectionRequest body) {
        Invocation.Builder builder;
        CreateActionConnectionRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CreateActionConnectionResponse>> result = new CompletableFuture<ApiResponse<CreateActionConnectionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createActionConnection"));
            return result;
        }
        String localVarPath = "/api/v2/actions/connections";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ActionConnectionApi.createActionConnection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CreateActionConnectionResponse>> result = new CompletableFuture<ApiResponse<CreateActionConnectionResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateActionConnectionResponse>(){});
    }

    public void deleteActionConnection(String connectionId) throws ApiException {
        this.deleteActionConnectionWithHttpInfo(connectionId);
    }

    public CompletableFuture<Void> deleteActionConnectionAsync(String connectionId) {
        return this.deleteActionConnectionWithHttpInfoAsync(connectionId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteActionConnectionWithHttpInfo(String connectionId) throws ApiException {
        Object localVarPostBody = null;
        if (connectionId == null) {
            throw new ApiException(400, "Missing the required parameter 'connectionId' when calling deleteActionConnection");
        }
        String localVarPath = "/api/v2/actions/connections/{connection_id}".replaceAll("\\{connection_id\\}", this.apiClient.escapeString(connectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionConnectionApi.deleteActionConnection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteActionConnectionWithHttpInfoAsync(String connectionId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (connectionId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'connectionId' when calling deleteActionConnection"));
            return result;
        }
        String localVarPath = "/api/v2/actions/connections/{connection_id}".replaceAll("\\{connection_id\\}", this.apiClient.escapeString(connectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ActionConnectionApi.deleteActionConnection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public GetActionConnectionResponse getActionConnection(String connectionId) throws ApiException {
        return this.getActionConnectionWithHttpInfo(connectionId).getData();
    }

    public CompletableFuture<GetActionConnectionResponse> getActionConnectionAsync(String connectionId) {
        return this.getActionConnectionWithHttpInfoAsync(connectionId).thenApply(response -> (GetActionConnectionResponse)response.getData());
    }

    public ApiResponse<GetActionConnectionResponse> getActionConnectionWithHttpInfo(String connectionId) throws ApiException {
        Object localVarPostBody = null;
        if (connectionId == null) {
            throw new ApiException(400, "Missing the required parameter 'connectionId' when calling getActionConnection");
        }
        String localVarPath = "/api/v2/actions/connections/{connection_id}".replaceAll("\\{connection_id\\}", this.apiClient.escapeString(connectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionConnectionApi.getActionConnection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetActionConnectionResponse>(){});
    }

    public CompletableFuture<ApiResponse<GetActionConnectionResponse>> getActionConnectionWithHttpInfoAsync(String connectionId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (connectionId == null) {
            CompletableFuture<ApiResponse<GetActionConnectionResponse>> result = new CompletableFuture<ApiResponse<GetActionConnectionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'connectionId' when calling getActionConnection"));
            return result;
        }
        String localVarPath = "/api/v2/actions/connections/{connection_id}".replaceAll("\\{connection_id\\}", this.apiClient.escapeString(connectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ActionConnectionApi.getActionConnection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetActionConnectionResponse>> result = new CompletableFuture<ApiResponse<GetActionConnectionResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetActionConnectionResponse>(){});
    }

    public GetAppKeyRegistrationResponse getAppKeyRegistration(String appKeyId) throws ApiException {
        return this.getAppKeyRegistrationWithHttpInfo(appKeyId).getData();
    }

    public CompletableFuture<GetAppKeyRegistrationResponse> getAppKeyRegistrationAsync(String appKeyId) {
        return this.getAppKeyRegistrationWithHttpInfoAsync(appKeyId).thenApply(response -> (GetAppKeyRegistrationResponse)response.getData());
    }

    public ApiResponse<GetAppKeyRegistrationResponse> getAppKeyRegistrationWithHttpInfo(String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling getAppKeyRegistration");
        }
        String localVarPath = "/api/v2/actions/app_key_registrations/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionConnectionApi.getAppKeyRegistration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetAppKeyRegistrationResponse>(){});
    }

    public CompletableFuture<ApiResponse<GetAppKeyRegistrationResponse>> getAppKeyRegistrationWithHttpInfoAsync(String appKeyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (appKeyId == null) {
            CompletableFuture<ApiResponse<GetAppKeyRegistrationResponse>> result = new CompletableFuture<ApiResponse<GetAppKeyRegistrationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appKeyId' when calling getAppKeyRegistration"));
            return result;
        }
        String localVarPath = "/api/v2/actions/app_key_registrations/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ActionConnectionApi.getAppKeyRegistration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetAppKeyRegistrationResponse>> result = new CompletableFuture<ApiResponse<GetAppKeyRegistrationResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetAppKeyRegistrationResponse>(){});
    }

    public ListAppKeyRegistrationsResponse listAppKeyRegistrations() throws ApiException {
        return this.listAppKeyRegistrationsWithHttpInfo(new ListAppKeyRegistrationsOptionalParameters()).getData();
    }

    public CompletableFuture<ListAppKeyRegistrationsResponse> listAppKeyRegistrationsAsync() {
        return this.listAppKeyRegistrationsWithHttpInfoAsync(new ListAppKeyRegistrationsOptionalParameters()).thenApply(response -> (ListAppKeyRegistrationsResponse)response.getData());
    }

    public ListAppKeyRegistrationsResponse listAppKeyRegistrations(ListAppKeyRegistrationsOptionalParameters parameters) throws ApiException {
        return this.listAppKeyRegistrationsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListAppKeyRegistrationsResponse> listAppKeyRegistrationsAsync(ListAppKeyRegistrationsOptionalParameters parameters) {
        return this.listAppKeyRegistrationsWithHttpInfoAsync(parameters).thenApply(response -> (ListAppKeyRegistrationsResponse)response.getData());
    }

    public ApiResponse<ListAppKeyRegistrationsResponse> listAppKeyRegistrationsWithHttpInfo(ListAppKeyRegistrationsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/actions/app_key_registrations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionConnectionApi.listAppKeyRegistrations", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListAppKeyRegistrationsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListAppKeyRegistrationsResponse>> listAppKeyRegistrationsWithHttpInfoAsync(ListAppKeyRegistrationsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/actions/app_key_registrations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        try {
            builder = this.apiClient.createBuilder("v2.ActionConnectionApi.listAppKeyRegistrations", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListAppKeyRegistrationsResponse>> result = new CompletableFuture<ApiResponse<ListAppKeyRegistrationsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListAppKeyRegistrationsResponse>(){});
    }

    public RegisterAppKeyResponse registerAppKey(String appKeyId) throws ApiException {
        return this.registerAppKeyWithHttpInfo(appKeyId).getData();
    }

    public CompletableFuture<RegisterAppKeyResponse> registerAppKeyAsync(String appKeyId) {
        return this.registerAppKeyWithHttpInfoAsync(appKeyId).thenApply(response -> (RegisterAppKeyResponse)response.getData());
    }

    public ApiResponse<RegisterAppKeyResponse> registerAppKeyWithHttpInfo(String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling registerAppKey");
        }
        String localVarPath = "/api/v2/actions/app_key_registrations/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionConnectionApi.registerAppKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RegisterAppKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<RegisterAppKeyResponse>> registerAppKeyWithHttpInfoAsync(String appKeyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (appKeyId == null) {
            CompletableFuture<ApiResponse<RegisterAppKeyResponse>> result = new CompletableFuture<ApiResponse<RegisterAppKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appKeyId' when calling registerAppKey"));
            return result;
        }
        String localVarPath = "/api/v2/actions/app_key_registrations/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ActionConnectionApi.registerAppKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RegisterAppKeyResponse>> result = new CompletableFuture<ApiResponse<RegisterAppKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RegisterAppKeyResponse>(){});
    }

    public void unregisterAppKey(String appKeyId) throws ApiException {
        this.unregisterAppKeyWithHttpInfo(appKeyId);
    }

    public CompletableFuture<Void> unregisterAppKeyAsync(String appKeyId) {
        return this.unregisterAppKeyWithHttpInfoAsync(appKeyId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> unregisterAppKeyWithHttpInfo(String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling unregisterAppKey");
        }
        String localVarPath = "/api/v2/actions/app_key_registrations/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionConnectionApi.unregisterAppKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> unregisterAppKeyWithHttpInfoAsync(String appKeyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (appKeyId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appKeyId' when calling unregisterAppKey"));
            return result;
        }
        String localVarPath = "/api/v2/actions/app_key_registrations/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ActionConnectionApi.unregisterAppKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public UpdateActionConnectionResponse updateActionConnection(String connectionId, UpdateActionConnectionRequest body) throws ApiException {
        return this.updateActionConnectionWithHttpInfo(connectionId, body).getData();
    }

    public CompletableFuture<UpdateActionConnectionResponse> updateActionConnectionAsync(String connectionId, UpdateActionConnectionRequest body) {
        return this.updateActionConnectionWithHttpInfoAsync(connectionId, body).thenApply(response -> (UpdateActionConnectionResponse)response.getData());
    }

    public ApiResponse<UpdateActionConnectionResponse> updateActionConnectionWithHttpInfo(String connectionId, UpdateActionConnectionRequest body) throws ApiException {
        UpdateActionConnectionRequest localVarPostBody = body;
        if (connectionId == null) {
            throw new ApiException(400, "Missing the required parameter 'connectionId' when calling updateActionConnection");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateActionConnection");
        }
        String localVarPath = "/api/v2/actions/connections/{connection_id}".replaceAll("\\{connection_id\\}", this.apiClient.escapeString(connectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionConnectionApi.updateActionConnection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpdateActionConnectionResponse>(){});
    }

    public CompletableFuture<ApiResponse<UpdateActionConnectionResponse>> updateActionConnectionWithHttpInfoAsync(String connectionId, UpdateActionConnectionRequest body) {
        Invocation.Builder builder;
        UpdateActionConnectionRequest localVarPostBody = body;
        if (connectionId == null) {
            CompletableFuture<ApiResponse<UpdateActionConnectionResponse>> result = new CompletableFuture<ApiResponse<UpdateActionConnectionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'connectionId' when calling updateActionConnection"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<UpdateActionConnectionResponse>> result = new CompletableFuture<ApiResponse<UpdateActionConnectionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateActionConnection"));
            return result;
        }
        String localVarPath = "/api/v2/actions/connections/{connection_id}".replaceAll("\\{connection_id\\}", this.apiClient.escapeString(connectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ActionConnectionApi.updateActionConnection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UpdateActionConnectionResponse>> result = new CompletableFuture<ApiResponse<UpdateActionConnectionResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpdateActionConnectionResponse>(){});
    }

    public static class ListAppKeyRegistrationsOptionalParameters {
        private Long pageSize;
        private Long pageNumber;

        public ListAppKeyRegistrationsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListAppKeyRegistrationsOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }
    }
}

