/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.VulnerabilitySeverity;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"score", "severity", "vector"})
public class CVSS {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_SCORE = "score";
    private Double score;
    public static final String JSON_PROPERTY_SEVERITY = "severity";
    private VulnerabilitySeverity severity;
    public static final String JSON_PROPERTY_VECTOR = "vector";
    private String vector;
    private Map<String, Object> additionalProperties;

    public CVSS() {
    }

    @JsonCreator
    public CVSS(@JsonProperty(required=true, value="score") Double score, @JsonProperty(required=true, value="severity") VulnerabilitySeverity severity, @JsonProperty(required=true, value="vector") String vector) {
        this.score = score;
        this.severity = severity;
        this.unparsed |= !severity.isValid();
        this.vector = vector;
    }

    public CVSS score(Double score) {
        this.score = score;
        return this;
    }

    @JsonProperty(value="score")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public CVSS severity(VulnerabilitySeverity severity) {
        this.severity = severity;
        this.unparsed |= !severity.isValid();
        return this;
    }

    @JsonProperty(value="severity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VulnerabilitySeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(VulnerabilitySeverity severity) {
        if (!severity.isValid()) {
            this.unparsed = true;
        }
        this.severity = severity;
    }

    public CVSS vector(String vector) {
        this.vector = vector;
        return this;
    }

    @JsonProperty(value="vector")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVector() {
        return this.vector;
    }

    public void setVector(String vector) {
        this.vector = vector;
    }

    @JsonAnySetter
    public CVSS putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CVSS cvss = (CVSS)o;
        return Objects.equals(this.score, cvss.score) && Objects.equals(this.severity, cvss.severity) && Objects.equals(this.vector, cvss.vector) && Objects.equals(this.additionalProperties, cvss.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.score, this.severity, this.vector, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CVSS {\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString(this.severity)).append("\n");
        sb.append("    vector: ").append(this.toIndentedString(this.vector)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

