/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CreateRuleRequest;
import com.datadog.api.client.v2.model.CreateRuleResponse;
import com.datadog.api.client.v2.model.ListRulesResponse;
import com.datadog.api.client.v2.model.ListRulesResponseDataItem;
import com.datadog.api.client.v2.model.OutcomesBatchRequest;
import com.datadog.api.client.v2.model.OutcomesBatchResponse;
import com.datadog.api.client.v2.model.OutcomesResponse;
import com.datadog.api.client.v2.model.OutcomesResponseDataItem;
import com.datadog.api.client.v2.model.UpdateRuleRequest;
import com.datadog.api.client.v2.model.UpdateRuleResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class ServiceScorecardsApi {
    private ApiClient apiClient;

    public ServiceScorecardsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ServiceScorecardsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OutcomesBatchResponse createScorecardOutcomesBatch(OutcomesBatchRequest body) throws ApiException {
        return this.createScorecardOutcomesBatchWithHttpInfo(body).getData();
    }

    public CompletableFuture<OutcomesBatchResponse> createScorecardOutcomesBatchAsync(OutcomesBatchRequest body) {
        return this.createScorecardOutcomesBatchWithHttpInfoAsync(body).thenApply(response -> (OutcomesBatchResponse)response.getData());
    }

    public ApiResponse<OutcomesBatchResponse> createScorecardOutcomesBatchWithHttpInfo(OutcomesBatchRequest body) throws ApiException {
        String operationId = "createScorecardOutcomesBatch";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        OutcomesBatchRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createScorecardOutcomesBatch");
        }
        String localVarPath = "/api/v2/scorecard/outcomes/batch";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceScorecardsApi.createScorecardOutcomesBatch", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OutcomesBatchResponse>(){});
    }

    public CompletableFuture<ApiResponse<OutcomesBatchResponse>> createScorecardOutcomesBatchWithHttpInfoAsync(OutcomesBatchRequest body) {
        Invocation.Builder builder;
        String operationId = "createScorecardOutcomesBatch";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<OutcomesBatchResponse>> result = new CompletableFuture<ApiResponse<OutcomesBatchResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        OutcomesBatchRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<OutcomesBatchResponse>> result = new CompletableFuture<ApiResponse<OutcomesBatchResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createScorecardOutcomesBatch"));
            return result;
        }
        String localVarPath = "/api/v2/scorecard/outcomes/batch";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ServiceScorecardsApi.createScorecardOutcomesBatch", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OutcomesBatchResponse>> result = new CompletableFuture<ApiResponse<OutcomesBatchResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OutcomesBatchResponse>(){});
    }

    public CreateRuleResponse createScorecardRule(CreateRuleRequest body) throws ApiException {
        return this.createScorecardRuleWithHttpInfo(body).getData();
    }

    public CompletableFuture<CreateRuleResponse> createScorecardRuleAsync(CreateRuleRequest body) {
        return this.createScorecardRuleWithHttpInfoAsync(body).thenApply(response -> (CreateRuleResponse)response.getData());
    }

    public ApiResponse<CreateRuleResponse> createScorecardRuleWithHttpInfo(CreateRuleRequest body) throws ApiException {
        String operationId = "createScorecardRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        CreateRuleRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createScorecardRule");
        }
        String localVarPath = "/api/v2/scorecard/rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceScorecardsApi.createScorecardRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<CreateRuleResponse>> createScorecardRuleWithHttpInfoAsync(CreateRuleRequest body) {
        Invocation.Builder builder;
        String operationId = "createScorecardRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<CreateRuleResponse>> result = new CompletableFuture<ApiResponse<CreateRuleResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        CreateRuleRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CreateRuleResponse>> result = new CompletableFuture<ApiResponse<CreateRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createScorecardRule"));
            return result;
        }
        String localVarPath = "/api/v2/scorecard/rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ServiceScorecardsApi.createScorecardRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CreateRuleResponse>> result = new CompletableFuture<ApiResponse<CreateRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateRuleResponse>(){});
    }

    public void deleteScorecardRule(String ruleId) throws ApiException {
        this.deleteScorecardRuleWithHttpInfo(ruleId);
    }

    public CompletableFuture<Void> deleteScorecardRuleAsync(String ruleId) {
        return this.deleteScorecardRuleWithHttpInfoAsync(ruleId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteScorecardRuleWithHttpInfo(String ruleId) throws ApiException {
        String operationId = "deleteScorecardRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteScorecardRule");
        }
        String localVarPath = "/api/v2/scorecard/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceScorecardsApi.deleteScorecardRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteScorecardRuleWithHttpInfoAsync(String ruleId) {
        Invocation.Builder builder;
        String operationId = "deleteScorecardRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteScorecardRule"));
            return result;
        }
        String localVarPath = "/api/v2/scorecard/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ServiceScorecardsApi.deleteScorecardRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public OutcomesResponse listScorecardOutcomes() throws ApiException {
        return this.listScorecardOutcomesWithHttpInfo(new ListScorecardOutcomesOptionalParameters()).getData();
    }

    public CompletableFuture<OutcomesResponse> listScorecardOutcomesAsync() {
        return this.listScorecardOutcomesWithHttpInfoAsync(new ListScorecardOutcomesOptionalParameters()).thenApply(response -> (OutcomesResponse)response.getData());
    }

    public OutcomesResponse listScorecardOutcomes(ListScorecardOutcomesOptionalParameters parameters) throws ApiException {
        return this.listScorecardOutcomesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<OutcomesResponse> listScorecardOutcomesAsync(ListScorecardOutcomesOptionalParameters parameters) {
        return this.listScorecardOutcomesWithHttpInfoAsync(parameters).thenApply(response -> (OutcomesResponse)response.getData());
    }

    public PaginationIterable<OutcomesResponseDataItem> listScorecardOutcomesWithPagination() {
        ListScorecardOutcomesOptionalParameters parameters = new ListScorecardOutcomesOptionalParameters();
        return this.listScorecardOutcomesWithPagination(parameters);
    }

    public PaginationIterable<OutcomesResponseDataItem> listScorecardOutcomesWithPagination(ListScorecardOutcomesOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageOffset";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageSize == null) {
            limit = 10L;
            parameters.pageSize(limit);
        } else {
            limit = parameters.pageSize;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<OutcomesResponseDataItem> iterator = new PaginationIterable<OutcomesResponseDataItem>(this, "listScorecardOutcomes", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<OutcomesResponse> listScorecardOutcomesWithHttpInfo(ListScorecardOutcomesOptionalParameters parameters) throws ApiException {
        String operationId = "listScorecardOutcomes";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String include = parameters.include;
        String fieldsOutcome = parameters.fieldsOutcome;
        String fieldsRule = parameters.fieldsRule;
        String filterOutcomeServiceName = parameters.filterOutcomeServiceName;
        String filterOutcomeState = parameters.filterOutcomeState;
        Boolean filterRuleEnabled = parameters.filterRuleEnabled;
        String filterRuleId = parameters.filterRuleId;
        String filterRuleName = parameters.filterRuleName;
        String localVarPath = "/api/v2/scorecard/outcomes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fields[outcome]", fieldsOutcome));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fields[rule]", fieldsRule));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[outcome][service_name]", filterOutcomeServiceName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[outcome][state]", filterOutcomeState));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][enabled]", filterRuleEnabled));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][id]", filterRuleId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][name]", filterRuleName));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceScorecardsApi.listScorecardOutcomes", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OutcomesResponse>(){});
    }

    public CompletableFuture<ApiResponse<OutcomesResponse>> listScorecardOutcomesWithHttpInfoAsync(ListScorecardOutcomesOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listScorecardOutcomes";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<OutcomesResponse>> result = new CompletableFuture<ApiResponse<OutcomesResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String include = parameters.include;
        String fieldsOutcome = parameters.fieldsOutcome;
        String fieldsRule = parameters.fieldsRule;
        String filterOutcomeServiceName = parameters.filterOutcomeServiceName;
        String filterOutcomeState = parameters.filterOutcomeState;
        Boolean filterRuleEnabled = parameters.filterRuleEnabled;
        String filterRuleId = parameters.filterRuleId;
        String filterRuleName = parameters.filterRuleName;
        String localVarPath = "/api/v2/scorecard/outcomes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fields[outcome]", fieldsOutcome));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fields[rule]", fieldsRule));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[outcome][service_name]", filterOutcomeServiceName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[outcome][state]", filterOutcomeState));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][enabled]", filterRuleEnabled));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][id]", filterRuleId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][name]", filterRuleName));
        try {
            builder = this.apiClient.createBuilder("v2.ServiceScorecardsApi.listScorecardOutcomes", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OutcomesResponse>> result = new CompletableFuture<ApiResponse<OutcomesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OutcomesResponse>(){});
    }

    public ListRulesResponse listScorecardRules() throws ApiException {
        return this.listScorecardRulesWithHttpInfo(new ListScorecardRulesOptionalParameters()).getData();
    }

    public CompletableFuture<ListRulesResponse> listScorecardRulesAsync() {
        return this.listScorecardRulesWithHttpInfoAsync(new ListScorecardRulesOptionalParameters()).thenApply(response -> (ListRulesResponse)response.getData());
    }

    public ListRulesResponse listScorecardRules(ListScorecardRulesOptionalParameters parameters) throws ApiException {
        return this.listScorecardRulesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListRulesResponse> listScorecardRulesAsync(ListScorecardRulesOptionalParameters parameters) {
        return this.listScorecardRulesWithHttpInfoAsync(parameters).thenApply(response -> (ListRulesResponse)response.getData());
    }

    public PaginationIterable<ListRulesResponseDataItem> listScorecardRulesWithPagination() {
        ListScorecardRulesOptionalParameters parameters = new ListScorecardRulesOptionalParameters();
        return this.listScorecardRulesWithPagination(parameters);
    }

    public PaginationIterable<ListRulesResponseDataItem> listScorecardRulesWithPagination(ListScorecardRulesOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageOffset";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageSize == null) {
            limit = 10L;
            parameters.pageSize(limit);
        } else {
            limit = parameters.pageSize;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<ListRulesResponseDataItem> iterator = new PaginationIterable<ListRulesResponseDataItem>(this, "listScorecardRules", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<ListRulesResponse> listScorecardRulesWithHttpInfo(ListScorecardRulesOptionalParameters parameters) throws ApiException {
        String operationId = "listScorecardRules";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String include = parameters.include;
        String filterRuleId = parameters.filterRuleId;
        Boolean filterRuleEnabled = parameters.filterRuleEnabled;
        Boolean filterRuleCustom = parameters.filterRuleCustom;
        String filterRuleName = parameters.filterRuleName;
        String filterRuleDescription = parameters.filterRuleDescription;
        String fieldsRule = parameters.fieldsRule;
        String fieldsScorecard = parameters.fieldsScorecard;
        String localVarPath = "/api/v2/scorecard/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][id]", filterRuleId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][enabled]", filterRuleEnabled));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][custom]", filterRuleCustom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][name]", filterRuleName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][description]", filterRuleDescription));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fields[rule]", fieldsRule));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fields[scorecard]", fieldsScorecard));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceScorecardsApi.listScorecardRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListRulesResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListRulesResponse>> listScorecardRulesWithHttpInfoAsync(ListScorecardRulesOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listScorecardRules";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ListRulesResponse>> result = new CompletableFuture<ApiResponse<ListRulesResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String include = parameters.include;
        String filterRuleId = parameters.filterRuleId;
        Boolean filterRuleEnabled = parameters.filterRuleEnabled;
        Boolean filterRuleCustom = parameters.filterRuleCustom;
        String filterRuleName = parameters.filterRuleName;
        String filterRuleDescription = parameters.filterRuleDescription;
        String fieldsRule = parameters.fieldsRule;
        String fieldsScorecard = parameters.fieldsScorecard;
        String localVarPath = "/api/v2/scorecard/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][id]", filterRuleId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][enabled]", filterRuleEnabled));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][custom]", filterRuleCustom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][name]", filterRuleName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule][description]", filterRuleDescription));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fields[rule]", fieldsRule));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fields[scorecard]", fieldsScorecard));
        try {
            builder = this.apiClient.createBuilder("v2.ServiceScorecardsApi.listScorecardRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListRulesResponse>> result = new CompletableFuture<ApiResponse<ListRulesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListRulesResponse>(){});
    }

    public UpdateRuleResponse updateScorecardRule(String ruleId, UpdateRuleRequest body) throws ApiException {
        return this.updateScorecardRuleWithHttpInfo(ruleId, body).getData();
    }

    public CompletableFuture<UpdateRuleResponse> updateScorecardRuleAsync(String ruleId, UpdateRuleRequest body) {
        return this.updateScorecardRuleWithHttpInfoAsync(ruleId, body).thenApply(response -> (UpdateRuleResponse)response.getData());
    }

    public ApiResponse<UpdateRuleResponse> updateScorecardRuleWithHttpInfo(String ruleId, UpdateRuleRequest body) throws ApiException {
        String operationId = "updateScorecardRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        UpdateRuleRequest localVarPostBody = body;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling updateScorecardRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateScorecardRule");
        }
        String localVarPath = "/api/v2/scorecard/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceScorecardsApi.updateScorecardRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpdateRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<UpdateRuleResponse>> updateScorecardRuleWithHttpInfoAsync(String ruleId, UpdateRuleRequest body) {
        Invocation.Builder builder;
        String operationId = "updateScorecardRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<UpdateRuleResponse>> result = new CompletableFuture<ApiResponse<UpdateRuleResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        UpdateRuleRequest localVarPostBody = body;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<UpdateRuleResponse>> result = new CompletableFuture<ApiResponse<UpdateRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling updateScorecardRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<UpdateRuleResponse>> result = new CompletableFuture<ApiResponse<UpdateRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateScorecardRule"));
            return result;
        }
        String localVarPath = "/api/v2/scorecard/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ServiceScorecardsApi.updateScorecardRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UpdateRuleResponse>> result = new CompletableFuture<ApiResponse<UpdateRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpdateRuleResponse>(){});
    }

    public static class ListScorecardRulesOptionalParameters {
        private Long pageSize;
        private Long pageOffset;
        private String include;
        private String filterRuleId;
        private Boolean filterRuleEnabled;
        private Boolean filterRuleCustom;
        private String filterRuleName;
        private String filterRuleDescription;
        private String fieldsRule;
        private String fieldsScorecard;

        public ListScorecardRulesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListScorecardRulesOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public ListScorecardRulesOptionalParameters include(String include) {
            this.include = include;
            return this;
        }

        public ListScorecardRulesOptionalParameters filterRuleId(String filterRuleId) {
            this.filterRuleId = filterRuleId;
            return this;
        }

        public ListScorecardRulesOptionalParameters filterRuleEnabled(Boolean filterRuleEnabled) {
            this.filterRuleEnabled = filterRuleEnabled;
            return this;
        }

        public ListScorecardRulesOptionalParameters filterRuleCustom(Boolean filterRuleCustom) {
            this.filterRuleCustom = filterRuleCustom;
            return this;
        }

        public ListScorecardRulesOptionalParameters filterRuleName(String filterRuleName) {
            this.filterRuleName = filterRuleName;
            return this;
        }

        public ListScorecardRulesOptionalParameters filterRuleDescription(String filterRuleDescription) {
            this.filterRuleDescription = filterRuleDescription;
            return this;
        }

        public ListScorecardRulesOptionalParameters fieldsRule(String fieldsRule) {
            this.fieldsRule = fieldsRule;
            return this;
        }

        public ListScorecardRulesOptionalParameters fieldsScorecard(String fieldsScorecard) {
            this.fieldsScorecard = fieldsScorecard;
            return this;
        }
    }

    public static class ListScorecardOutcomesOptionalParameters {
        private Long pageSize;
        private Long pageOffset;
        private String include;
        private String fieldsOutcome;
        private String fieldsRule;
        private String filterOutcomeServiceName;
        private String filterOutcomeState;
        private Boolean filterRuleEnabled;
        private String filterRuleId;
        private String filterRuleName;

        public ListScorecardOutcomesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListScorecardOutcomesOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public ListScorecardOutcomesOptionalParameters include(String include) {
            this.include = include;
            return this;
        }

        public ListScorecardOutcomesOptionalParameters fieldsOutcome(String fieldsOutcome) {
            this.fieldsOutcome = fieldsOutcome;
            return this;
        }

        public ListScorecardOutcomesOptionalParameters fieldsRule(String fieldsRule) {
            this.fieldsRule = fieldsRule;
            return this;
        }

        public ListScorecardOutcomesOptionalParameters filterOutcomeServiceName(String filterOutcomeServiceName) {
            this.filterOutcomeServiceName = filterOutcomeServiceName;
            return this;
        }

        public ListScorecardOutcomesOptionalParameters filterOutcomeState(String filterOutcomeState) {
            this.filterOutcomeState = filterOutcomeState;
            return this;
        }

        public ListScorecardOutcomesOptionalParameters filterRuleEnabled(Boolean filterRuleEnabled) {
            this.filterRuleEnabled = filterRuleEnabled;
            return this;
        }

        public ListScorecardOutcomesOptionalParameters filterRuleId(String filterRuleId) {
            this.filterRuleId = filterRuleId;
            return this;
        }

        public ListScorecardOutcomesOptionalParameters filterRuleName(String filterRuleName) {
            this.filterRuleName = filterRuleName;
            return this;
        }
    }
}

