/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.LogsDailyLimitReset;
import com.datadog.api.client.v1.model.LogsExclusion;
import com.datadog.api.client.v1.model.LogsFilter;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"daily_limit", "daily_limit_reset", "daily_limit_warning_threshold_percentage", "disable_daily_limit", "exclusion_filters", "filter", "num_flex_logs_retention_days", "num_retention_days"})
public class LogsIndexUpdateRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DAILY_LIMIT = "daily_limit";
    private Long dailyLimit;
    public static final String JSON_PROPERTY_DAILY_LIMIT_RESET = "daily_limit_reset";
    private LogsDailyLimitReset dailyLimitReset;
    public static final String JSON_PROPERTY_DAILY_LIMIT_WARNING_THRESHOLD_PERCENTAGE = "daily_limit_warning_threshold_percentage";
    private Double dailyLimitWarningThresholdPercentage;
    public static final String JSON_PROPERTY_DISABLE_DAILY_LIMIT = "disable_daily_limit";
    private Boolean disableDailyLimit;
    public static final String JSON_PROPERTY_EXCLUSION_FILTERS = "exclusion_filters";
    private List<LogsExclusion> exclusionFilters = null;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private LogsFilter filter;
    public static final String JSON_PROPERTY_NUM_FLEX_LOGS_RETENTION_DAYS = "num_flex_logs_retention_days";
    private Long numFlexLogsRetentionDays;
    public static final String JSON_PROPERTY_NUM_RETENTION_DAYS = "num_retention_days";
    private Long numRetentionDays;
    private Map<String, Object> additionalProperties;

    public LogsIndexUpdateRequest() {
    }

    @JsonCreator
    public LogsIndexUpdateRequest(@JsonProperty(required=true, value="filter") LogsFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
    }

    public LogsIndexUpdateRequest dailyLimit(Long dailyLimit) {
        this.dailyLimit = dailyLimit;
        return this;
    }

    @Nullable
    @JsonProperty(value="daily_limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDailyLimit() {
        return this.dailyLimit;
    }

    public void setDailyLimit(Long dailyLimit) {
        this.dailyLimit = dailyLimit;
    }

    public LogsIndexUpdateRequest dailyLimitReset(LogsDailyLimitReset dailyLimitReset) {
        this.dailyLimitReset = dailyLimitReset;
        this.unparsed |= dailyLimitReset.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="daily_limit_reset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsDailyLimitReset getDailyLimitReset() {
        return this.dailyLimitReset;
    }

    public void setDailyLimitReset(LogsDailyLimitReset dailyLimitReset) {
        this.dailyLimitReset = dailyLimitReset;
    }

    public LogsIndexUpdateRequest dailyLimitWarningThresholdPercentage(Double dailyLimitWarningThresholdPercentage) {
        this.dailyLimitWarningThresholdPercentage = dailyLimitWarningThresholdPercentage;
        return this;
    }

    @Nullable
    @JsonProperty(value="daily_limit_warning_threshold_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getDailyLimitWarningThresholdPercentage() {
        return this.dailyLimitWarningThresholdPercentage;
    }

    public void setDailyLimitWarningThresholdPercentage(Double dailyLimitWarningThresholdPercentage) {
        this.dailyLimitWarningThresholdPercentage = dailyLimitWarningThresholdPercentage;
    }

    public LogsIndexUpdateRequest disableDailyLimit(Boolean disableDailyLimit) {
        this.disableDailyLimit = disableDailyLimit;
        return this;
    }

    @Nullable
    @JsonProperty(value="disable_daily_limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDisableDailyLimit() {
        return this.disableDailyLimit;
    }

    public void setDisableDailyLimit(Boolean disableDailyLimit) {
        this.disableDailyLimit = disableDailyLimit;
    }

    public LogsIndexUpdateRequest exclusionFilters(List<LogsExclusion> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
        for (LogsExclusion item : exclusionFilters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsIndexUpdateRequest addExclusionFiltersItem(LogsExclusion exclusionFiltersItem) {
        if (this.exclusionFilters == null) {
            this.exclusionFilters = new ArrayList<LogsExclusion>();
        }
        this.exclusionFilters.add(exclusionFiltersItem);
        this.unparsed |= exclusionFiltersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="exclusion_filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsExclusion> getExclusionFilters() {
        return this.exclusionFilters;
    }

    public void setExclusionFilters(List<LogsExclusion> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
    }

    public LogsIndexUpdateRequest filter(LogsFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LogsFilter filter) {
        this.filter = filter;
    }

    public LogsIndexUpdateRequest numFlexLogsRetentionDays(Long numFlexLogsRetentionDays) {
        this.numFlexLogsRetentionDays = numFlexLogsRetentionDays;
        return this;
    }

    @Nullable
    @JsonProperty(value="num_flex_logs_retention_days")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNumFlexLogsRetentionDays() {
        return this.numFlexLogsRetentionDays;
    }

    public void setNumFlexLogsRetentionDays(Long numFlexLogsRetentionDays) {
        this.numFlexLogsRetentionDays = numFlexLogsRetentionDays;
    }

    public LogsIndexUpdateRequest numRetentionDays(Long numRetentionDays) {
        this.numRetentionDays = numRetentionDays;
        return this;
    }

    @Nullable
    @JsonProperty(value="num_retention_days")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNumRetentionDays() {
        return this.numRetentionDays;
    }

    public void setNumRetentionDays(Long numRetentionDays) {
        this.numRetentionDays = numRetentionDays;
    }

    @JsonAnySetter
    public LogsIndexUpdateRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsIndexUpdateRequest logsIndexUpdateRequest = (LogsIndexUpdateRequest)o;
        return Objects.equals(this.dailyLimit, logsIndexUpdateRequest.dailyLimit) && Objects.equals(this.dailyLimitReset, logsIndexUpdateRequest.dailyLimitReset) && Objects.equals(this.dailyLimitWarningThresholdPercentage, logsIndexUpdateRequest.dailyLimitWarningThresholdPercentage) && Objects.equals(this.disableDailyLimit, logsIndexUpdateRequest.disableDailyLimit) && Objects.equals(this.exclusionFilters, logsIndexUpdateRequest.exclusionFilters) && Objects.equals(this.filter, logsIndexUpdateRequest.filter) && Objects.equals(this.numFlexLogsRetentionDays, logsIndexUpdateRequest.numFlexLogsRetentionDays) && Objects.equals(this.numRetentionDays, logsIndexUpdateRequest.numRetentionDays) && Objects.equals(this.additionalProperties, logsIndexUpdateRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.dailyLimit, this.dailyLimitReset, this.dailyLimitWarningThresholdPercentage, this.disableDailyLimit, this.exclusionFilters, this.filter, this.numFlexLogsRetentionDays, this.numRetentionDays, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsIndexUpdateRequest {\n");
        sb.append("    dailyLimit: ").append(this.toIndentedString(this.dailyLimit)).append("\n");
        sb.append("    dailyLimitReset: ").append(this.toIndentedString(this.dailyLimitReset)).append("\n");
        sb.append("    dailyLimitWarningThresholdPercentage: ").append(this.toIndentedString(this.dailyLimitWarningThresholdPercentage)).append("\n");
        sb.append("    disableDailyLimit: ").append(this.toIndentedString(this.disableDailyLimit)).append("\n");
        sb.append("    exclusionFilters: ").append(this.toIndentedString(this.exclusionFilters)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    numFlexLogsRetentionDays: ").append(this.toIndentedString(this.numFlexLogsRetentionDays)).append("\n");
        sb.append("    numRetentionDays: ").append(this.toIndentedString(this.numRetentionDays)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

