/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.MonitorConfigPolicyCreateRequest;
import com.datadog.api.client.v2.model.MonitorConfigPolicyEditRequest;
import com.datadog.api.client.v2.model.MonitorConfigPolicyListResponse;
import com.datadog.api.client.v2.model.MonitorConfigPolicyResponse;
import com.datadog.api.client.v2.model.MonitorNotificationRuleCreateRequest;
import com.datadog.api.client.v2.model.MonitorNotificationRuleListResponse;
import com.datadog.api.client.v2.model.MonitorNotificationRuleResponse;
import com.datadog.api.client.v2.model.MonitorNotificationRuleUpdateRequest;
import com.datadog.api.client.v2.model.MonitorUserTemplateCreateRequest;
import com.datadog.api.client.v2.model.MonitorUserTemplateCreateResponse;
import com.datadog.api.client.v2.model.MonitorUserTemplateListResponse;
import com.datadog.api.client.v2.model.MonitorUserTemplateResponse;
import com.datadog.api.client.v2.model.MonitorUserTemplateUpdateRequest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class MonitorsApi {
    private ApiClient apiClient;

    public MonitorsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public MonitorsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public MonitorConfigPolicyResponse createMonitorConfigPolicy(MonitorConfigPolicyCreateRequest body) throws ApiException {
        return this.createMonitorConfigPolicyWithHttpInfo(body).getData();
    }

    public CompletableFuture<MonitorConfigPolicyResponse> createMonitorConfigPolicyAsync(MonitorConfigPolicyCreateRequest body) {
        return this.createMonitorConfigPolicyWithHttpInfoAsync(body).thenApply(response -> (MonitorConfigPolicyResponse)response.getData());
    }

    public ApiResponse<MonitorConfigPolicyResponse> createMonitorConfigPolicyWithHttpInfo(MonitorConfigPolicyCreateRequest body) throws ApiException {
        MonitorConfigPolicyCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createMonitorConfigPolicy");
        }
        String localVarPath = "/api/v2/monitor/policy";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.createMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> createMonitorConfigPolicyWithHttpInfoAsync(MonitorConfigPolicyCreateRequest body) {
        Invocation.Builder builder;
        MonitorConfigPolicyCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createMonitorConfigPolicy"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/policy";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.createMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyResponse>(){});
    }

    public MonitorNotificationRuleResponse createMonitorNotificationRule(MonitorNotificationRuleCreateRequest body) throws ApiException {
        return this.createMonitorNotificationRuleWithHttpInfo(body).getData();
    }

    public CompletableFuture<MonitorNotificationRuleResponse> createMonitorNotificationRuleAsync(MonitorNotificationRuleCreateRequest body) {
        return this.createMonitorNotificationRuleWithHttpInfoAsync(body).thenApply(response -> (MonitorNotificationRuleResponse)response.getData());
    }

    public ApiResponse<MonitorNotificationRuleResponse> createMonitorNotificationRuleWithHttpInfo(MonitorNotificationRuleCreateRequest body) throws ApiException {
        String operationId = "createMonitorNotificationRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        MonitorNotificationRuleCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createMonitorNotificationRule");
        }
        String localVarPath = "/api/v2/monitor/notification_rule";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.createMonitorNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorNotificationRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>> createMonitorNotificationRuleWithHttpInfoAsync(MonitorNotificationRuleCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createMonitorNotificationRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>> result = new CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        MonitorNotificationRuleCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>> result = new CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createMonitorNotificationRule"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/notification_rule";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.createMonitorNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>> result = new CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorNotificationRuleResponse>(){});
    }

    public MonitorUserTemplateCreateResponse createMonitorUserTemplate(MonitorUserTemplateCreateRequest body) throws ApiException {
        return this.createMonitorUserTemplateWithHttpInfo(body).getData();
    }

    public CompletableFuture<MonitorUserTemplateCreateResponse> createMonitorUserTemplateAsync(MonitorUserTemplateCreateRequest body) {
        return this.createMonitorUserTemplateWithHttpInfoAsync(body).thenApply(response -> (MonitorUserTemplateCreateResponse)response.getData());
    }

    public ApiResponse<MonitorUserTemplateCreateResponse> createMonitorUserTemplateWithHttpInfo(MonitorUserTemplateCreateRequest body) throws ApiException {
        String operationId = "createMonitorUserTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        MonitorUserTemplateCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createMonitorUserTemplate");
        }
        String localVarPath = "/api/v2/monitor/template";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.createMonitorUserTemplate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorUserTemplateCreateResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorUserTemplateCreateResponse>> createMonitorUserTemplateWithHttpInfoAsync(MonitorUserTemplateCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createMonitorUserTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<MonitorUserTemplateCreateResponse>> result = new CompletableFuture<ApiResponse<MonitorUserTemplateCreateResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        MonitorUserTemplateCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<MonitorUserTemplateCreateResponse>> result = new CompletableFuture<ApiResponse<MonitorUserTemplateCreateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createMonitorUserTemplate"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/template";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.createMonitorUserTemplate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorUserTemplateCreateResponse>> result = new CompletableFuture<ApiResponse<MonitorUserTemplateCreateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorUserTemplateCreateResponse>(){});
    }

    public void deleteMonitorConfigPolicy(String policyId) throws ApiException {
        this.deleteMonitorConfigPolicyWithHttpInfo(policyId);
    }

    public CompletableFuture<Void> deleteMonitorConfigPolicyAsync(String policyId) {
        return this.deleteMonitorConfigPolicyWithHttpInfoAsync(policyId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteMonitorConfigPolicyWithHttpInfo(String policyId) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deleteMonitorConfigPolicy");
        }
        String localVarPath = "/api/v2/monitor/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.deleteMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteMonitorConfigPolicyWithHttpInfoAsync(String policyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (policyId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'policyId' when calling deleteMonitorConfigPolicy"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.deleteMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteMonitorNotificationRule(String ruleId) throws ApiException {
        this.deleteMonitorNotificationRuleWithHttpInfo(ruleId);
    }

    public CompletableFuture<Void> deleteMonitorNotificationRuleAsync(String ruleId) {
        return this.deleteMonitorNotificationRuleWithHttpInfoAsync(ruleId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteMonitorNotificationRuleWithHttpInfo(String ruleId) throws ApiException {
        String operationId = "deleteMonitorNotificationRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteMonitorNotificationRule");
        }
        String localVarPath = "/api/v2/monitor/notification_rule/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.deleteMonitorNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteMonitorNotificationRuleWithHttpInfoAsync(String ruleId) {
        Invocation.Builder builder;
        String operationId = "deleteMonitorNotificationRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteMonitorNotificationRule"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/notification_rule/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.deleteMonitorNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteMonitorUserTemplate(String templateId) throws ApiException {
        this.deleteMonitorUserTemplateWithHttpInfo(templateId);
    }

    public CompletableFuture<Void> deleteMonitorUserTemplateAsync(String templateId) {
        return this.deleteMonitorUserTemplateWithHttpInfoAsync(templateId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteMonitorUserTemplateWithHttpInfo(String templateId) throws ApiException {
        String operationId = "deleteMonitorUserTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteMonitorUserTemplate");
        }
        String localVarPath = "/api/v2/monitor/template/{template_id}".replaceAll("\\{template_id\\}", this.apiClient.escapeString(templateId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.deleteMonitorUserTemplate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteMonitorUserTemplateWithHttpInfoAsync(String templateId) {
        Invocation.Builder builder;
        String operationId = "deleteMonitorUserTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (templateId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'templateId' when calling deleteMonitorUserTemplate"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/template/{template_id}".replaceAll("\\{template_id\\}", this.apiClient.escapeString(templateId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.deleteMonitorUserTemplate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public MonitorConfigPolicyResponse getMonitorConfigPolicy(String policyId) throws ApiException {
        return this.getMonitorConfigPolicyWithHttpInfo(policyId).getData();
    }

    public CompletableFuture<MonitorConfigPolicyResponse> getMonitorConfigPolicyAsync(String policyId) {
        return this.getMonitorConfigPolicyWithHttpInfoAsync(policyId).thenApply(response -> (MonitorConfigPolicyResponse)response.getData());
    }

    public ApiResponse<MonitorConfigPolicyResponse> getMonitorConfigPolicyWithHttpInfo(String policyId) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling getMonitorConfigPolicy");
        }
        String localVarPath = "/api/v2/monitor/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.getMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> getMonitorConfigPolicyWithHttpInfoAsync(String policyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (policyId == null) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'policyId' when calling getMonitorConfigPolicy"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.getMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyResponse>(){});
    }

    public MonitorNotificationRuleResponse getMonitorNotificationRule(String ruleId) throws ApiException {
        return this.getMonitorNotificationRuleWithHttpInfo(ruleId, new GetMonitorNotificationRuleOptionalParameters()).getData();
    }

    public CompletableFuture<MonitorNotificationRuleResponse> getMonitorNotificationRuleAsync(String ruleId) {
        return this.getMonitorNotificationRuleWithHttpInfoAsync(ruleId, new GetMonitorNotificationRuleOptionalParameters()).thenApply(response -> (MonitorNotificationRuleResponse)response.getData());
    }

    public MonitorNotificationRuleResponse getMonitorNotificationRule(String ruleId, GetMonitorNotificationRuleOptionalParameters parameters) throws ApiException {
        return this.getMonitorNotificationRuleWithHttpInfo(ruleId, parameters).getData();
    }

    public CompletableFuture<MonitorNotificationRuleResponse> getMonitorNotificationRuleAsync(String ruleId, GetMonitorNotificationRuleOptionalParameters parameters) {
        return this.getMonitorNotificationRuleWithHttpInfoAsync(ruleId, parameters).thenApply(response -> (MonitorNotificationRuleResponse)response.getData());
    }

    public ApiResponse<MonitorNotificationRuleResponse> getMonitorNotificationRuleWithHttpInfo(String ruleId, GetMonitorNotificationRuleOptionalParameters parameters) throws ApiException {
        String operationId = "getMonitorNotificationRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling getMonitorNotificationRule");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/monitor/notification_rule/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.getMonitorNotificationRule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorNotificationRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>> getMonitorNotificationRuleWithHttpInfoAsync(String ruleId, GetMonitorNotificationRuleOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getMonitorNotificationRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>> result = new CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>> result = new CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling getMonitorNotificationRule"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/monitor/notification_rule/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.getMonitorNotificationRule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>> result = new CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorNotificationRuleResponse>(){});
    }

    public MonitorNotificationRuleListResponse getMonitorNotificationRules() throws ApiException {
        return this.getMonitorNotificationRulesWithHttpInfo(new GetMonitorNotificationRulesOptionalParameters()).getData();
    }

    public CompletableFuture<MonitorNotificationRuleListResponse> getMonitorNotificationRulesAsync() {
        return this.getMonitorNotificationRulesWithHttpInfoAsync(new GetMonitorNotificationRulesOptionalParameters()).thenApply(response -> (MonitorNotificationRuleListResponse)response.getData());
    }

    public MonitorNotificationRuleListResponse getMonitorNotificationRules(GetMonitorNotificationRulesOptionalParameters parameters) throws ApiException {
        return this.getMonitorNotificationRulesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<MonitorNotificationRuleListResponse> getMonitorNotificationRulesAsync(GetMonitorNotificationRulesOptionalParameters parameters) {
        return this.getMonitorNotificationRulesWithHttpInfoAsync(parameters).thenApply(response -> (MonitorNotificationRuleListResponse)response.getData());
    }

    public ApiResponse<MonitorNotificationRuleListResponse> getMonitorNotificationRulesWithHttpInfo(GetMonitorNotificationRulesOptionalParameters parameters) throws ApiException {
        String operationId = "getMonitorNotificationRules";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String include = parameters.include;
        String localVarPath = "/api/v2/monitor/notification_rule";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.getMonitorNotificationRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorNotificationRuleListResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorNotificationRuleListResponse>> getMonitorNotificationRulesWithHttpInfoAsync(GetMonitorNotificationRulesOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getMonitorNotificationRules";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<MonitorNotificationRuleListResponse>> result = new CompletableFuture<ApiResponse<MonitorNotificationRuleListResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String include = parameters.include;
        String localVarPath = "/api/v2/monitor/notification_rule";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.getMonitorNotificationRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorNotificationRuleListResponse>> result = new CompletableFuture<ApiResponse<MonitorNotificationRuleListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorNotificationRuleListResponse>(){});
    }

    public MonitorUserTemplateResponse getMonitorUserTemplate(String templateId) throws ApiException {
        return this.getMonitorUserTemplateWithHttpInfo(templateId, new GetMonitorUserTemplateOptionalParameters()).getData();
    }

    public CompletableFuture<MonitorUserTemplateResponse> getMonitorUserTemplateAsync(String templateId) {
        return this.getMonitorUserTemplateWithHttpInfoAsync(templateId, new GetMonitorUserTemplateOptionalParameters()).thenApply(response -> (MonitorUserTemplateResponse)response.getData());
    }

    public MonitorUserTemplateResponse getMonitorUserTemplate(String templateId, GetMonitorUserTemplateOptionalParameters parameters) throws ApiException {
        return this.getMonitorUserTemplateWithHttpInfo(templateId, parameters).getData();
    }

    public CompletableFuture<MonitorUserTemplateResponse> getMonitorUserTemplateAsync(String templateId, GetMonitorUserTemplateOptionalParameters parameters) {
        return this.getMonitorUserTemplateWithHttpInfoAsync(templateId, parameters).thenApply(response -> (MonitorUserTemplateResponse)response.getData());
    }

    public ApiResponse<MonitorUserTemplateResponse> getMonitorUserTemplateWithHttpInfo(String templateId, GetMonitorUserTemplateOptionalParameters parameters) throws ApiException {
        String operationId = "getMonitorUserTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getMonitorUserTemplate");
        }
        Boolean withAllVersions = parameters.withAllVersions;
        String localVarPath = "/api/v2/monitor/template/{template_id}".replaceAll("\\{template_id\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "with_all_versions", withAllVersions));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.getMonitorUserTemplate", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorUserTemplateResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorUserTemplateResponse>> getMonitorUserTemplateWithHttpInfoAsync(String templateId, GetMonitorUserTemplateOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getMonitorUserTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<MonitorUserTemplateResponse>> result = new CompletableFuture<ApiResponse<MonitorUserTemplateResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (templateId == null) {
            CompletableFuture<ApiResponse<MonitorUserTemplateResponse>> result = new CompletableFuture<ApiResponse<MonitorUserTemplateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'templateId' when calling getMonitorUserTemplate"));
            return result;
        }
        Boolean withAllVersions = parameters.withAllVersions;
        String localVarPath = "/api/v2/monitor/template/{template_id}".replaceAll("\\{template_id\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "with_all_versions", withAllVersions));
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.getMonitorUserTemplate", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorUserTemplateResponse>> result = new CompletableFuture<ApiResponse<MonitorUserTemplateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorUserTemplateResponse>(){});
    }

    public MonitorConfigPolicyListResponse listMonitorConfigPolicies() throws ApiException {
        return this.listMonitorConfigPoliciesWithHttpInfo().getData();
    }

    public CompletableFuture<MonitorConfigPolicyListResponse> listMonitorConfigPoliciesAsync() {
        return this.listMonitorConfigPoliciesWithHttpInfoAsync().thenApply(response -> (MonitorConfigPolicyListResponse)response.getData());
    }

    public ApiResponse<MonitorConfigPolicyListResponse> listMonitorConfigPoliciesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/monitor/policy";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.listMonitorConfigPolicies", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyListResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorConfigPolicyListResponse>> listMonitorConfigPoliciesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/monitor/policy";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.listMonitorConfigPolicies", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyListResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyListResponse>(){});
    }

    public MonitorUserTemplateListResponse listMonitorUserTemplates() throws ApiException {
        return this.listMonitorUserTemplatesWithHttpInfo().getData();
    }

    public CompletableFuture<MonitorUserTemplateListResponse> listMonitorUserTemplatesAsync() {
        return this.listMonitorUserTemplatesWithHttpInfoAsync().thenApply(response -> (MonitorUserTemplateListResponse)response.getData());
    }

    public ApiResponse<MonitorUserTemplateListResponse> listMonitorUserTemplatesWithHttpInfo() throws ApiException {
        String operationId = "listMonitorUserTemplates";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/monitor/template";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.listMonitorUserTemplates", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorUserTemplateListResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorUserTemplateListResponse>> listMonitorUserTemplatesWithHttpInfoAsync() {
        Invocation.Builder builder;
        String operationId = "listMonitorUserTemplates";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<MonitorUserTemplateListResponse>> result = new CompletableFuture<ApiResponse<MonitorUserTemplateListResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/monitor/template";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.listMonitorUserTemplates", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorUserTemplateListResponse>> result = new CompletableFuture<ApiResponse<MonitorUserTemplateListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorUserTemplateListResponse>(){});
    }

    public MonitorConfigPolicyResponse updateMonitorConfigPolicy(String policyId, MonitorConfigPolicyEditRequest body) throws ApiException {
        return this.updateMonitorConfigPolicyWithHttpInfo(policyId, body).getData();
    }

    public CompletableFuture<MonitorConfigPolicyResponse> updateMonitorConfigPolicyAsync(String policyId, MonitorConfigPolicyEditRequest body) {
        return this.updateMonitorConfigPolicyWithHttpInfoAsync(policyId, body).thenApply(response -> (MonitorConfigPolicyResponse)response.getData());
    }

    public ApiResponse<MonitorConfigPolicyResponse> updateMonitorConfigPolicyWithHttpInfo(String policyId, MonitorConfigPolicyEditRequest body) throws ApiException {
        MonitorConfigPolicyEditRequest localVarPostBody = body;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling updateMonitorConfigPolicy");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateMonitorConfigPolicy");
        }
        String localVarPath = "/api/v2/monitor/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.updateMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> updateMonitorConfigPolicyWithHttpInfoAsync(String policyId, MonitorConfigPolicyEditRequest body) {
        Invocation.Builder builder;
        MonitorConfigPolicyEditRequest localVarPostBody = body;
        if (policyId == null) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'policyId' when calling updateMonitorConfigPolicy"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateMonitorConfigPolicy"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.updateMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyResponse>(){});
    }

    public MonitorNotificationRuleResponse updateMonitorNotificationRule(String ruleId, MonitorNotificationRuleUpdateRequest body) throws ApiException {
        return this.updateMonitorNotificationRuleWithHttpInfo(ruleId, body).getData();
    }

    public CompletableFuture<MonitorNotificationRuleResponse> updateMonitorNotificationRuleAsync(String ruleId, MonitorNotificationRuleUpdateRequest body) {
        return this.updateMonitorNotificationRuleWithHttpInfoAsync(ruleId, body).thenApply(response -> (MonitorNotificationRuleResponse)response.getData());
    }

    public ApiResponse<MonitorNotificationRuleResponse> updateMonitorNotificationRuleWithHttpInfo(String ruleId, MonitorNotificationRuleUpdateRequest body) throws ApiException {
        String operationId = "updateMonitorNotificationRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        MonitorNotificationRuleUpdateRequest localVarPostBody = body;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling updateMonitorNotificationRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateMonitorNotificationRule");
        }
        String localVarPath = "/api/v2/monitor/notification_rule/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.updateMonitorNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorNotificationRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>> updateMonitorNotificationRuleWithHttpInfoAsync(String ruleId, MonitorNotificationRuleUpdateRequest body) {
        Invocation.Builder builder;
        String operationId = "updateMonitorNotificationRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>> result = new CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        MonitorNotificationRuleUpdateRequest localVarPostBody = body;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>> result = new CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling updateMonitorNotificationRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>> result = new CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateMonitorNotificationRule"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/notification_rule/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.updateMonitorNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>> result = new CompletableFuture<ApiResponse<MonitorNotificationRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorNotificationRuleResponse>(){});
    }

    public MonitorUserTemplateResponse updateMonitorUserTemplate(String templateId, MonitorUserTemplateUpdateRequest body) throws ApiException {
        return this.updateMonitorUserTemplateWithHttpInfo(templateId, body).getData();
    }

    public CompletableFuture<MonitorUserTemplateResponse> updateMonitorUserTemplateAsync(String templateId, MonitorUserTemplateUpdateRequest body) {
        return this.updateMonitorUserTemplateWithHttpInfoAsync(templateId, body).thenApply(response -> (MonitorUserTemplateResponse)response.getData());
    }

    public ApiResponse<MonitorUserTemplateResponse> updateMonitorUserTemplateWithHttpInfo(String templateId, MonitorUserTemplateUpdateRequest body) throws ApiException {
        String operationId = "updateMonitorUserTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        MonitorUserTemplateUpdateRequest localVarPostBody = body;
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateMonitorUserTemplate");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateMonitorUserTemplate");
        }
        String localVarPath = "/api/v2/monitor/template/{template_id}".replaceAll("\\{template_id\\}", this.apiClient.escapeString(templateId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.updateMonitorUserTemplate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorUserTemplateResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorUserTemplateResponse>> updateMonitorUserTemplateWithHttpInfoAsync(String templateId, MonitorUserTemplateUpdateRequest body) {
        Invocation.Builder builder;
        String operationId = "updateMonitorUserTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<MonitorUserTemplateResponse>> result = new CompletableFuture<ApiResponse<MonitorUserTemplateResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        MonitorUserTemplateUpdateRequest localVarPostBody = body;
        if (templateId == null) {
            CompletableFuture<ApiResponse<MonitorUserTemplateResponse>> result = new CompletableFuture<ApiResponse<MonitorUserTemplateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'templateId' when calling updateMonitorUserTemplate"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<MonitorUserTemplateResponse>> result = new CompletableFuture<ApiResponse<MonitorUserTemplateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateMonitorUserTemplate"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/template/{template_id}".replaceAll("\\{template_id\\}", this.apiClient.escapeString(templateId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.updateMonitorUserTemplate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorUserTemplateResponse>> result = new CompletableFuture<ApiResponse<MonitorUserTemplateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorUserTemplateResponse>(){});
    }

    public void validateExistingMonitorUserTemplate(String templateId, MonitorUserTemplateUpdateRequest body) throws ApiException {
        this.validateExistingMonitorUserTemplateWithHttpInfo(templateId, body);
    }

    public CompletableFuture<Void> validateExistingMonitorUserTemplateAsync(String templateId, MonitorUserTemplateUpdateRequest body) {
        return this.validateExistingMonitorUserTemplateWithHttpInfoAsync(templateId, body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> validateExistingMonitorUserTemplateWithHttpInfo(String templateId, MonitorUserTemplateUpdateRequest body) throws ApiException {
        String operationId = "validateExistingMonitorUserTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        MonitorUserTemplateUpdateRequest localVarPostBody = body;
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling validateExistingMonitorUserTemplate");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling validateExistingMonitorUserTemplate");
        }
        String localVarPath = "/api/v2/monitor/template/{template_id}/validate".replaceAll("\\{template_id\\}", this.apiClient.escapeString(templateId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.validateExistingMonitorUserTemplate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> validateExistingMonitorUserTemplateWithHttpInfoAsync(String templateId, MonitorUserTemplateUpdateRequest body) {
        Invocation.Builder builder;
        String operationId = "validateExistingMonitorUserTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        MonitorUserTemplateUpdateRequest localVarPostBody = body;
        if (templateId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'templateId' when calling validateExistingMonitorUserTemplate"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling validateExistingMonitorUserTemplate"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/template/{template_id}/validate".replaceAll("\\{template_id\\}", this.apiClient.escapeString(templateId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.validateExistingMonitorUserTemplate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void validateMonitorUserTemplate(MonitorUserTemplateCreateRequest body) throws ApiException {
        this.validateMonitorUserTemplateWithHttpInfo(body);
    }

    public CompletableFuture<Void> validateMonitorUserTemplateAsync(MonitorUserTemplateCreateRequest body) {
        return this.validateMonitorUserTemplateWithHttpInfoAsync(body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> validateMonitorUserTemplateWithHttpInfo(MonitorUserTemplateCreateRequest body) throws ApiException {
        String operationId = "validateMonitorUserTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        MonitorUserTemplateCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling validateMonitorUserTemplate");
        }
        String localVarPath = "/api/v2/monitor/template/validate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.validateMonitorUserTemplate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> validateMonitorUserTemplateWithHttpInfoAsync(MonitorUserTemplateCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "validateMonitorUserTemplate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        MonitorUserTemplateCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling validateMonitorUserTemplate"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/template/validate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.validateMonitorUserTemplate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public static class GetMonitorUserTemplateOptionalParameters {
        private Boolean withAllVersions;

        public GetMonitorUserTemplateOptionalParameters withAllVersions(Boolean withAllVersions) {
            this.withAllVersions = withAllVersions;
            return this;
        }
    }

    public static class GetMonitorNotificationRulesOptionalParameters {
        private String include;

        public GetMonitorNotificationRulesOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class GetMonitorNotificationRuleOptionalParameters {
        private String include;

        public GetMonitorNotificationRuleOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }
}

