/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.TableWidgetCellDisplayMode;
import com.datadog.api.client.v1.model.WidgetConditionalFormat;
import com.datadog.api.client.v1.model.WidgetFormulaCellDisplayModeOptions;
import com.datadog.api.client.v1.model.WidgetFormulaLimit;
import com.datadog.api.client.v1.model.WidgetFormulaStyle;
import com.datadog.api.client.v1.model.WidgetNumberFormat;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"alias", "cell_display_mode", "cell_display_mode_options", "conditional_formats", "formula", "limit", "number_format", "style"})
public class WidgetFormula {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ALIAS = "alias";
    private String alias;
    public static final String JSON_PROPERTY_CELL_DISPLAY_MODE = "cell_display_mode";
    private TableWidgetCellDisplayMode cellDisplayMode;
    public static final String JSON_PROPERTY_CELL_DISPLAY_MODE_OPTIONS = "cell_display_mode_options";
    private WidgetFormulaCellDisplayModeOptions cellDisplayModeOptions;
    public static final String JSON_PROPERTY_CONDITIONAL_FORMATS = "conditional_formats";
    private List<WidgetConditionalFormat> conditionalFormats = null;
    public static final String JSON_PROPERTY_FORMULA = "formula";
    private String formula;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private WidgetFormulaLimit limit;
    public static final String JSON_PROPERTY_NUMBER_FORMAT = "number_format";
    private WidgetNumberFormat numberFormat;
    public static final String JSON_PROPERTY_STYLE = "style";
    private WidgetFormulaStyle style;
    private Map<String, Object> additionalProperties;

    public WidgetFormula() {
    }

    @JsonCreator
    public WidgetFormula(@JsonProperty(required=true, value="formula") String formula) {
        this.formula = formula;
    }

    public WidgetFormula alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Nullable
    @JsonProperty(value="alias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public WidgetFormula cellDisplayMode(TableWidgetCellDisplayMode cellDisplayMode) {
        this.cellDisplayMode = cellDisplayMode;
        this.unparsed |= !cellDisplayMode.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="cell_display_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TableWidgetCellDisplayMode getCellDisplayMode() {
        return this.cellDisplayMode;
    }

    public void setCellDisplayMode(TableWidgetCellDisplayMode cellDisplayMode) {
        if (!cellDisplayMode.isValid()) {
            this.unparsed = true;
        }
        this.cellDisplayMode = cellDisplayMode;
    }

    public WidgetFormula cellDisplayModeOptions(WidgetFormulaCellDisplayModeOptions cellDisplayModeOptions) {
        this.cellDisplayModeOptions = cellDisplayModeOptions;
        this.unparsed |= cellDisplayModeOptions.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="cell_display_mode_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetFormulaCellDisplayModeOptions getCellDisplayModeOptions() {
        return this.cellDisplayModeOptions;
    }

    public void setCellDisplayModeOptions(WidgetFormulaCellDisplayModeOptions cellDisplayModeOptions) {
        this.cellDisplayModeOptions = cellDisplayModeOptions;
    }

    public WidgetFormula conditionalFormats(List<WidgetConditionalFormat> conditionalFormats) {
        this.conditionalFormats = conditionalFormats;
        for (WidgetConditionalFormat item : conditionalFormats) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public WidgetFormula addConditionalFormatsItem(WidgetConditionalFormat conditionalFormatsItem) {
        if (this.conditionalFormats == null) {
            this.conditionalFormats = new ArrayList<WidgetConditionalFormat>();
        }
        this.conditionalFormats.add(conditionalFormatsItem);
        this.unparsed |= conditionalFormatsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="conditional_formats")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetConditionalFormat> getConditionalFormats() {
        return this.conditionalFormats;
    }

    public void setConditionalFormats(List<WidgetConditionalFormat> conditionalFormats) {
        this.conditionalFormats = conditionalFormats;
    }

    public WidgetFormula formula(String formula) {
        this.formula = formula;
        return this;
    }

    @JsonProperty(value="formula")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public WidgetFormula limit(WidgetFormulaLimit limit) {
        this.limit = limit;
        this.unparsed |= limit.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetFormulaLimit getLimit() {
        return this.limit;
    }

    public void setLimit(WidgetFormulaLimit limit) {
        this.limit = limit;
    }

    public WidgetFormula numberFormat(WidgetNumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.unparsed |= numberFormat.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="number_format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetNumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(WidgetNumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public WidgetFormula style(WidgetFormulaStyle style) {
        this.style = style;
        this.unparsed |= style.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetFormulaStyle getStyle() {
        return this.style;
    }

    public void setStyle(WidgetFormulaStyle style) {
        this.style = style;
    }

    @JsonAnySetter
    public WidgetFormula putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WidgetFormula widgetFormula = (WidgetFormula)o;
        return Objects.equals(this.alias, widgetFormula.alias) && Objects.equals(this.cellDisplayMode, widgetFormula.cellDisplayMode) && Objects.equals(this.cellDisplayModeOptions, widgetFormula.cellDisplayModeOptions) && Objects.equals(this.conditionalFormats, widgetFormula.conditionalFormats) && Objects.equals(this.formula, widgetFormula.formula) && Objects.equals(this.limit, widgetFormula.limit) && Objects.equals(this.numberFormat, widgetFormula.numberFormat) && Objects.equals(this.style, widgetFormula.style) && Objects.equals(this.additionalProperties, widgetFormula.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.cellDisplayMode, this.cellDisplayModeOptions, this.conditionalFormats, this.formula, this.limit, this.numberFormat, this.style, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WidgetFormula {\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    cellDisplayMode: ").append(this.toIndentedString(this.cellDisplayMode)).append("\n");
        sb.append("    cellDisplayModeOptions: ").append(this.toIndentedString(this.cellDisplayModeOptions)).append("\n");
        sb.append("    conditionalFormats: ").append(this.toIndentedString(this.conditionalFormats)).append("\n");
        sb.append("    formula: ").append(this.toIndentedString(this.formula)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    numberFormat: ").append(this.toIndentedString(this.numberFormat)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

