/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.AWSAccountType;
import com.datadog.api.client.v2.model.AWSAccountUpdateRequestAttributes;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"attributes", "id", "type"})
public class AWSAccountUpdateRequestData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private AWSAccountUpdateRequestAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private AWSAccountType type = AWSAccountType.ACCOUNT;
    private Map<String, Object> additionalProperties;

    public AWSAccountUpdateRequestData() {
    }

    @JsonCreator
    public AWSAccountUpdateRequestData(@JsonProperty(required=true, value="attributes") AWSAccountUpdateRequestAttributes attributes, @JsonProperty(required=true, value="type") AWSAccountType type) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public AWSAccountUpdateRequestData attributes(AWSAccountUpdateRequestAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AWSAccountUpdateRequestAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AWSAccountUpdateRequestAttributes attributes) {
        this.attributes = attributes;
    }

    public AWSAccountUpdateRequestData id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AWSAccountUpdateRequestData type(AWSAccountType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AWSAccountType getType() {
        return this.type;
    }

    public void setType(AWSAccountType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public AWSAccountUpdateRequestData putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSAccountUpdateRequestData awsAccountUpdateRequestData = (AWSAccountUpdateRequestData)o;
        return Objects.equals(this.attributes, awsAccountUpdateRequestData.attributes) && Objects.equals(this.id, awsAccountUpdateRequestData.id) && Objects.equals(this.type, awsAccountUpdateRequestData.type) && Objects.equals(this.additionalProperties, awsAccountUpdateRequestData.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.id, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSAccountUpdateRequestData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

