/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.Schedule;
import com.datadog.api.client.v2.model.ScheduleCreateRequest;
import com.datadog.api.client.v2.model.ScheduleUpdateRequest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class OnCallApi {
    private ApiClient apiClient;

    public OnCallApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public OnCallApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Schedule createOnCallSchedule(ScheduleCreateRequest body) throws ApiException {
        return this.createOnCallScheduleWithHttpInfo(body, new CreateOnCallScheduleOptionalParameters()).getData();
    }

    public CompletableFuture<Schedule> createOnCallScheduleAsync(ScheduleCreateRequest body) {
        return this.createOnCallScheduleWithHttpInfoAsync(body, new CreateOnCallScheduleOptionalParameters()).thenApply(response -> (Schedule)response.getData());
    }

    public Schedule createOnCallSchedule(ScheduleCreateRequest body, CreateOnCallScheduleOptionalParameters parameters) throws ApiException {
        return this.createOnCallScheduleWithHttpInfo(body, parameters).getData();
    }

    public CompletableFuture<Schedule> createOnCallScheduleAsync(ScheduleCreateRequest body, CreateOnCallScheduleOptionalParameters parameters) {
        return this.createOnCallScheduleWithHttpInfoAsync(body, parameters).thenApply(response -> (Schedule)response.getData());
    }

    public ApiResponse<Schedule> createOnCallScheduleWithHttpInfo(ScheduleCreateRequest body, CreateOnCallScheduleOptionalParameters parameters) throws ApiException {
        ScheduleCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createOnCallSchedule");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/schedules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.createOnCallSchedule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Schedule>(){});
    }

    public CompletableFuture<ApiResponse<Schedule>> createOnCallScheduleWithHttpInfoAsync(ScheduleCreateRequest body, CreateOnCallScheduleOptionalParameters parameters) {
        Invocation.Builder builder;
        ScheduleCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Schedule>> result = new CompletableFuture<ApiResponse<Schedule>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createOnCallSchedule"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/schedules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.createOnCallSchedule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Schedule>> result = new CompletableFuture<ApiResponse<Schedule>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Schedule>(){});
    }

    public void deleteOnCallSchedule(String scheduleId) throws ApiException {
        this.deleteOnCallScheduleWithHttpInfo(scheduleId);
    }

    public CompletableFuture<Void> deleteOnCallScheduleAsync(String scheduleId) {
        return this.deleteOnCallScheduleWithHttpInfoAsync(scheduleId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteOnCallScheduleWithHttpInfo(String scheduleId) throws ApiException {
        Object localVarPostBody = null;
        if (scheduleId == null) {
            throw new ApiException(400, "Missing the required parameter 'scheduleId' when calling deleteOnCallSchedule");
        }
        String localVarPath = "/api/v2/on-call/schedules/{schedule_id}".replaceAll("\\{schedule_id\\}", this.apiClient.escapeString(scheduleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.deleteOnCallSchedule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteOnCallScheduleWithHttpInfoAsync(String scheduleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (scheduleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'scheduleId' when calling deleteOnCallSchedule"));
            return result;
        }
        String localVarPath = "/api/v2/on-call/schedules/{schedule_id}".replaceAll("\\{schedule_id\\}", this.apiClient.escapeString(scheduleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.deleteOnCallSchedule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public Schedule getOnCallSchedule(String scheduleId) throws ApiException {
        return this.getOnCallScheduleWithHttpInfo(scheduleId, new GetOnCallScheduleOptionalParameters()).getData();
    }

    public CompletableFuture<Schedule> getOnCallScheduleAsync(String scheduleId) {
        return this.getOnCallScheduleWithHttpInfoAsync(scheduleId, new GetOnCallScheduleOptionalParameters()).thenApply(response -> (Schedule)response.getData());
    }

    public Schedule getOnCallSchedule(String scheduleId, GetOnCallScheduleOptionalParameters parameters) throws ApiException {
        return this.getOnCallScheduleWithHttpInfo(scheduleId, parameters).getData();
    }

    public CompletableFuture<Schedule> getOnCallScheduleAsync(String scheduleId, GetOnCallScheduleOptionalParameters parameters) {
        return this.getOnCallScheduleWithHttpInfoAsync(scheduleId, parameters).thenApply(response -> (Schedule)response.getData());
    }

    public ApiResponse<Schedule> getOnCallScheduleWithHttpInfo(String scheduleId, GetOnCallScheduleOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (scheduleId == null) {
            throw new ApiException(400, "Missing the required parameter 'scheduleId' when calling getOnCallSchedule");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/schedules/{schedule_id}".replaceAll("\\{schedule_id\\}", this.apiClient.escapeString(scheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.getOnCallSchedule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Schedule>(){});
    }

    public CompletableFuture<ApiResponse<Schedule>> getOnCallScheduleWithHttpInfoAsync(String scheduleId, GetOnCallScheduleOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (scheduleId == null) {
            CompletableFuture<ApiResponse<Schedule>> result = new CompletableFuture<ApiResponse<Schedule>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'scheduleId' when calling getOnCallSchedule"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/schedules/{schedule_id}".replaceAll("\\{schedule_id\\}", this.apiClient.escapeString(scheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.getOnCallSchedule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Schedule>> result = new CompletableFuture<ApiResponse<Schedule>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Schedule>(){});
    }

    public Schedule updateOnCallSchedule(String scheduleId, ScheduleUpdateRequest body) throws ApiException {
        return this.updateOnCallScheduleWithHttpInfo(scheduleId, body, new UpdateOnCallScheduleOptionalParameters()).getData();
    }

    public CompletableFuture<Schedule> updateOnCallScheduleAsync(String scheduleId, ScheduleUpdateRequest body) {
        return this.updateOnCallScheduleWithHttpInfoAsync(scheduleId, body, new UpdateOnCallScheduleOptionalParameters()).thenApply(response -> (Schedule)response.getData());
    }

    public Schedule updateOnCallSchedule(String scheduleId, ScheduleUpdateRequest body, UpdateOnCallScheduleOptionalParameters parameters) throws ApiException {
        return this.updateOnCallScheduleWithHttpInfo(scheduleId, body, parameters).getData();
    }

    public CompletableFuture<Schedule> updateOnCallScheduleAsync(String scheduleId, ScheduleUpdateRequest body, UpdateOnCallScheduleOptionalParameters parameters) {
        return this.updateOnCallScheduleWithHttpInfoAsync(scheduleId, body, parameters).thenApply(response -> (Schedule)response.getData());
    }

    public ApiResponse<Schedule> updateOnCallScheduleWithHttpInfo(String scheduleId, ScheduleUpdateRequest body, UpdateOnCallScheduleOptionalParameters parameters) throws ApiException {
        ScheduleUpdateRequest localVarPostBody = body;
        if (scheduleId == null) {
            throw new ApiException(400, "Missing the required parameter 'scheduleId' when calling updateOnCallSchedule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateOnCallSchedule");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/schedules/{schedule_id}".replaceAll("\\{schedule_id\\}", this.apiClient.escapeString(scheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.updateOnCallSchedule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Schedule>(){});
    }

    public CompletableFuture<ApiResponse<Schedule>> updateOnCallScheduleWithHttpInfoAsync(String scheduleId, ScheduleUpdateRequest body, UpdateOnCallScheduleOptionalParameters parameters) {
        Invocation.Builder builder;
        ScheduleUpdateRequest localVarPostBody = body;
        if (scheduleId == null) {
            CompletableFuture<ApiResponse<Schedule>> result = new CompletableFuture<ApiResponse<Schedule>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'scheduleId' when calling updateOnCallSchedule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Schedule>> result = new CompletableFuture<ApiResponse<Schedule>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateOnCallSchedule"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/schedules/{schedule_id}".replaceAll("\\{schedule_id\\}", this.apiClient.escapeString(scheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.updateOnCallSchedule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Schedule>> result = new CompletableFuture<ApiResponse<Schedule>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Schedule>(){});
    }

    public static class UpdateOnCallScheduleOptionalParameters {
        private String include;

        public UpdateOnCallScheduleOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class GetOnCallScheduleOptionalParameters {
        private String include;

        public GetOnCallScheduleOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class CreateOnCallScheduleOptionalParameters {
        private String include;

        public CreateOnCallScheduleOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }
}

