/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.AppsSortField;
import com.datadog.api.client.v2.model.CreateAppRequest;
import com.datadog.api.client.v2.model.CreateAppResponse;
import com.datadog.api.client.v2.model.DeleteAppResponse;
import com.datadog.api.client.v2.model.DeleteAppsRequest;
import com.datadog.api.client.v2.model.DeleteAppsResponse;
import com.datadog.api.client.v2.model.GetAppResponse;
import com.datadog.api.client.v2.model.ListAppsResponse;
import com.datadog.api.client.v2.model.PublishAppResponse;
import com.datadog.api.client.v2.model.UnpublishAppResponse;
import com.datadog.api.client.v2.model.UpdateAppRequest;
import com.datadog.api.client.v2.model.UpdateAppResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class AppBuilderApi {
    private ApiClient apiClient;

    public AppBuilderApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public AppBuilderApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CreateAppResponse createApp(CreateAppRequest body) throws ApiException {
        return this.createAppWithHttpInfo(body).getData();
    }

    public CompletableFuture<CreateAppResponse> createAppAsync(CreateAppRequest body) {
        return this.createAppWithHttpInfoAsync(body).thenApply(response -> (CreateAppResponse)response.getData());
    }

    public ApiResponse<CreateAppResponse> createAppWithHttpInfo(CreateAppRequest body) throws ApiException {
        CreateAppRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createApp");
        }
        String localVarPath = "/api/v2/app-builder/apps";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppBuilderApi.createApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateAppResponse>(){});
    }

    public CompletableFuture<ApiResponse<CreateAppResponse>> createAppWithHttpInfoAsync(CreateAppRequest body) {
        Invocation.Builder builder;
        CreateAppRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CreateAppResponse>> result = new CompletableFuture<ApiResponse<CreateAppResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createApp"));
            return result;
        }
        String localVarPath = "/api/v2/app-builder/apps";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AppBuilderApi.createApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CreateAppResponse>> result = new CompletableFuture<ApiResponse<CreateAppResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateAppResponse>(){});
    }

    public DeleteAppResponse deleteApp(UUID appId) throws ApiException {
        return this.deleteAppWithHttpInfo(appId).getData();
    }

    public CompletableFuture<DeleteAppResponse> deleteAppAsync(UUID appId) {
        return this.deleteAppWithHttpInfoAsync(appId).thenApply(response -> (DeleteAppResponse)response.getData());
    }

    public ApiResponse<DeleteAppResponse> deleteAppWithHttpInfo(UUID appId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteApp");
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppBuilderApi.deleteApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeleteAppResponse>(){});
    }

    public CompletableFuture<ApiResponse<DeleteAppResponse>> deleteAppWithHttpInfoAsync(UUID appId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (appId == null) {
            CompletableFuture<ApiResponse<DeleteAppResponse>> result = new CompletableFuture<ApiResponse<DeleteAppResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling deleteApp"));
            return result;
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AppBuilderApi.deleteApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DeleteAppResponse>> result = new CompletableFuture<ApiResponse<DeleteAppResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeleteAppResponse>(){});
    }

    public DeleteAppsResponse deleteApps(DeleteAppsRequest body) throws ApiException {
        return this.deleteAppsWithHttpInfo(body).getData();
    }

    public CompletableFuture<DeleteAppsResponse> deleteAppsAsync(DeleteAppsRequest body) {
        return this.deleteAppsWithHttpInfoAsync(body).thenApply(response -> (DeleteAppsResponse)response.getData());
    }

    public ApiResponse<DeleteAppsResponse> deleteAppsWithHttpInfo(DeleteAppsRequest body) throws ApiException {
        DeleteAppsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteApps");
        }
        String localVarPath = "/api/v2/app-builder/apps";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppBuilderApi.deleteApps", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeleteAppsResponse>(){});
    }

    public CompletableFuture<ApiResponse<DeleteAppsResponse>> deleteAppsWithHttpInfoAsync(DeleteAppsRequest body) {
        Invocation.Builder builder;
        DeleteAppsRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DeleteAppsResponse>> result = new CompletableFuture<ApiResponse<DeleteAppsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deleteApps"));
            return result;
        }
        String localVarPath = "/api/v2/app-builder/apps";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AppBuilderApi.deleteApps", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DeleteAppsResponse>> result = new CompletableFuture<ApiResponse<DeleteAppsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeleteAppsResponse>(){});
    }

    public GetAppResponse getApp(UUID appId) throws ApiException {
        return this.getAppWithHttpInfo(appId, new GetAppOptionalParameters()).getData();
    }

    public CompletableFuture<GetAppResponse> getAppAsync(UUID appId) {
        return this.getAppWithHttpInfoAsync(appId, new GetAppOptionalParameters()).thenApply(response -> (GetAppResponse)response.getData());
    }

    public GetAppResponse getApp(UUID appId, GetAppOptionalParameters parameters) throws ApiException {
        return this.getAppWithHttpInfo(appId, parameters).getData();
    }

    public CompletableFuture<GetAppResponse> getAppAsync(UUID appId, GetAppOptionalParameters parameters) {
        return this.getAppWithHttpInfoAsync(appId, parameters).thenApply(response -> (GetAppResponse)response.getData());
    }

    public ApiResponse<GetAppResponse> getAppWithHttpInfo(UUID appId, GetAppOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getApp");
        }
        String version = parameters.version;
        String localVarPath = "/api/v2/app-builder/apps/{app_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "version", version));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppBuilderApi.getApp", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetAppResponse>(){});
    }

    public CompletableFuture<ApiResponse<GetAppResponse>> getAppWithHttpInfoAsync(UUID appId, GetAppOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (appId == null) {
            CompletableFuture<ApiResponse<GetAppResponse>> result = new CompletableFuture<ApiResponse<GetAppResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling getApp"));
            return result;
        }
        String version = parameters.version;
        String localVarPath = "/api/v2/app-builder/apps/{app_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "version", version));
        try {
            builder = this.apiClient.createBuilder("v2.AppBuilderApi.getApp", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetAppResponse>> result = new CompletableFuture<ApiResponse<GetAppResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetAppResponse>(){});
    }

    public ListAppsResponse listApps() throws ApiException {
        return this.listAppsWithHttpInfo(new ListAppsOptionalParameters()).getData();
    }

    public CompletableFuture<ListAppsResponse> listAppsAsync() {
        return this.listAppsWithHttpInfoAsync(new ListAppsOptionalParameters()).thenApply(response -> (ListAppsResponse)response.getData());
    }

    public ListAppsResponse listApps(ListAppsOptionalParameters parameters) throws ApiException {
        return this.listAppsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListAppsResponse> listAppsAsync(ListAppsOptionalParameters parameters) {
        return this.listAppsWithHttpInfoAsync(parameters).thenApply(response -> (ListAppsResponse)response.getData());
    }

    public ApiResponse<ListAppsResponse> listAppsWithHttpInfo(ListAppsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long limit = parameters.limit;
        Long page = parameters.page;
        String filterUserName = parameters.filterUserName;
        UUID filterUserUuid = parameters.filterUserUuid;
        String filterName = parameters.filterName;
        String filterQuery = parameters.filterQuery;
        Boolean filterDeployed = parameters.filterDeployed;
        String filterTags = parameters.filterTags;
        Boolean filterFavorite = parameters.filterFavorite;
        Boolean filterSelfService = parameters.filterSelfService;
        List sort = parameters.sort;
        String localVarPath = "/api/v2/app-builder/apps";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[user_name]", filterUserName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[user_uuid]", filterUserUuid));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[name]", filterName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[deployed]", filterDeployed));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags]", filterTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[favorite]", filterFavorite));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[self_service]", filterSelfService));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "sort", sort));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppBuilderApi.listApps", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListAppsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListAppsResponse>> listAppsWithHttpInfoAsync(ListAppsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long limit = parameters.limit;
        Long page = parameters.page;
        String filterUserName = parameters.filterUserName;
        UUID filterUserUuid = parameters.filterUserUuid;
        String filterName = parameters.filterName;
        String filterQuery = parameters.filterQuery;
        Boolean filterDeployed = parameters.filterDeployed;
        String filterTags = parameters.filterTags;
        Boolean filterFavorite = parameters.filterFavorite;
        Boolean filterSelfService = parameters.filterSelfService;
        List sort = parameters.sort;
        String localVarPath = "/api/v2/app-builder/apps";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[user_name]", filterUserName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[user_uuid]", filterUserUuid));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[name]", filterName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[deployed]", filterDeployed));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags]", filterTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[favorite]", filterFavorite));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[self_service]", filterSelfService));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "sort", sort));
        try {
            builder = this.apiClient.createBuilder("v2.AppBuilderApi.listApps", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListAppsResponse>> result = new CompletableFuture<ApiResponse<ListAppsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListAppsResponse>(){});
    }

    public PublishAppResponse publishApp(UUID appId) throws ApiException {
        return this.publishAppWithHttpInfo(appId).getData();
    }

    public CompletableFuture<PublishAppResponse> publishAppAsync(UUID appId) {
        return this.publishAppWithHttpInfoAsync(appId).thenApply(response -> (PublishAppResponse)response.getData());
    }

    public ApiResponse<PublishAppResponse> publishAppWithHttpInfo(UUID appId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling publishApp");
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}/deployment".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppBuilderApi.publishApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PublishAppResponse>(){});
    }

    public CompletableFuture<ApiResponse<PublishAppResponse>> publishAppWithHttpInfoAsync(UUID appId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (appId == null) {
            CompletableFuture<ApiResponse<PublishAppResponse>> result = new CompletableFuture<ApiResponse<PublishAppResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling publishApp"));
            return result;
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}/deployment".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AppBuilderApi.publishApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<PublishAppResponse>> result = new CompletableFuture<ApiResponse<PublishAppResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PublishAppResponse>(){});
    }

    public UnpublishAppResponse unpublishApp(UUID appId) throws ApiException {
        return this.unpublishAppWithHttpInfo(appId).getData();
    }

    public CompletableFuture<UnpublishAppResponse> unpublishAppAsync(UUID appId) {
        return this.unpublishAppWithHttpInfoAsync(appId).thenApply(response -> (UnpublishAppResponse)response.getData());
    }

    public ApiResponse<UnpublishAppResponse> unpublishAppWithHttpInfo(UUID appId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling unpublishApp");
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}/deployment".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppBuilderApi.unpublishApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UnpublishAppResponse>(){});
    }

    public CompletableFuture<ApiResponse<UnpublishAppResponse>> unpublishAppWithHttpInfoAsync(UUID appId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (appId == null) {
            CompletableFuture<ApiResponse<UnpublishAppResponse>> result = new CompletableFuture<ApiResponse<UnpublishAppResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling unpublishApp"));
            return result;
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}/deployment".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AppBuilderApi.unpublishApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UnpublishAppResponse>> result = new CompletableFuture<ApiResponse<UnpublishAppResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UnpublishAppResponse>(){});
    }

    public UpdateAppResponse updateApp(UUID appId, UpdateAppRequest body) throws ApiException {
        return this.updateAppWithHttpInfo(appId, body).getData();
    }

    public CompletableFuture<UpdateAppResponse> updateAppAsync(UUID appId, UpdateAppRequest body) {
        return this.updateAppWithHttpInfoAsync(appId, body).thenApply(response -> (UpdateAppResponse)response.getData());
    }

    public ApiResponse<UpdateAppResponse> updateAppWithHttpInfo(UUID appId, UpdateAppRequest body) throws ApiException {
        UpdateAppRequest localVarPostBody = body;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling updateApp");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateApp");
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppBuilderApi.updateApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpdateAppResponse>(){});
    }

    public CompletableFuture<ApiResponse<UpdateAppResponse>> updateAppWithHttpInfoAsync(UUID appId, UpdateAppRequest body) {
        Invocation.Builder builder;
        UpdateAppRequest localVarPostBody = body;
        if (appId == null) {
            CompletableFuture<ApiResponse<UpdateAppResponse>> result = new CompletableFuture<ApiResponse<UpdateAppResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling updateApp"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<UpdateAppResponse>> result = new CompletableFuture<ApiResponse<UpdateAppResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateApp"));
            return result;
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AppBuilderApi.updateApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UpdateAppResponse>> result = new CompletableFuture<ApiResponse<UpdateAppResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpdateAppResponse>(){});
    }

    public static class ListAppsOptionalParameters {
        private Long limit;
        private Long page;
        private String filterUserName;
        private UUID filterUserUuid;
        private String filterName;
        private String filterQuery;
        private Boolean filterDeployed;
        private String filterTags;
        private Boolean filterFavorite;
        private Boolean filterSelfService;
        private List<AppsSortField> sort;

        public ListAppsOptionalParameters limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public ListAppsOptionalParameters page(Long page) {
            this.page = page;
            return this;
        }

        public ListAppsOptionalParameters filterUserName(String filterUserName) {
            this.filterUserName = filterUserName;
            return this;
        }

        public ListAppsOptionalParameters filterUserUuid(UUID filterUserUuid) {
            this.filterUserUuid = filterUserUuid;
            return this;
        }

        public ListAppsOptionalParameters filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public ListAppsOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public ListAppsOptionalParameters filterDeployed(Boolean filterDeployed) {
            this.filterDeployed = filterDeployed;
            return this;
        }

        public ListAppsOptionalParameters filterTags(String filterTags) {
            this.filterTags = filterTags;
            return this;
        }

        public ListAppsOptionalParameters filterFavorite(Boolean filterFavorite) {
            this.filterFavorite = filterFavorite;
            return this;
        }

        public ListAppsOptionalParameters filterSelfService(Boolean filterSelfService) {
            this.filterSelfService = filterSelfService;
            return this;
        }

        public ListAppsOptionalParameters sort(List<AppsSortField> sort) {
            this.sort = sort;
            return this;
        }
    }

    public static class GetAppOptionalParameters {
        private String version;

        public GetAppOptionalParameters version(String version) {
            this.version = version;
            return this;
        }
    }
}

