/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CompletionGate;
import com.datadog.api.client.v2.model.ErrorHandler;
import com.datadog.api.client.v2.model.OutboundEdge;
import com.datadog.api.client.v2.model.Parameter;
import com.datadog.api.client.v2.model.ReadinessGate;
import com.datadog.api.client.v2.model.StepDisplay;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"actionId", "completionGate", "connectionLabel", "display", "errorHandlers", "name", "outboundEdges", "parameters", "readinessGate"})
public class Step {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACTION_ID = "actionId";
    private String actionId;
    public static final String JSON_PROPERTY_COMPLETION_GATE = "completionGate";
    private CompletionGate completionGate;
    public static final String JSON_PROPERTY_CONNECTION_LABEL = "connectionLabel";
    private String connectionLabel;
    public static final String JSON_PROPERTY_DISPLAY = "display";
    private StepDisplay display;
    public static final String JSON_PROPERTY_ERROR_HANDLERS = "errorHandlers";
    private List<ErrorHandler> errorHandlers = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OUTBOUND_EDGES = "outboundEdges";
    private List<OutboundEdge> outboundEdges = null;
    public static final String JSON_PROPERTY_PARAMETERS = "parameters";
    private List<Parameter> parameters = null;
    public static final String JSON_PROPERTY_READINESS_GATE = "readinessGate";
    private ReadinessGate readinessGate;
    private Map<String, Object> additionalProperties;

    public Step() {
    }

    @JsonCreator
    public Step(@JsonProperty(required=true, value="actionId") String actionId, @JsonProperty(required=true, value="name") String name) {
        this.actionId = actionId;
        this.name = name;
    }

    public Step actionId(String actionId) {
        this.actionId = actionId;
        return this;
    }

    @JsonProperty(value="actionId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public Step completionGate(CompletionGate completionGate) {
        this.completionGate = completionGate;
        this.unparsed |= completionGate.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="completionGate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CompletionGate getCompletionGate() {
        return this.completionGate;
    }

    public void setCompletionGate(CompletionGate completionGate) {
        this.completionGate = completionGate;
    }

    public Step connectionLabel(String connectionLabel) {
        this.connectionLabel = connectionLabel;
        return this;
    }

    @Nullable
    @JsonProperty(value="connectionLabel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getConnectionLabel() {
        return this.connectionLabel;
    }

    public void setConnectionLabel(String connectionLabel) {
        this.connectionLabel = connectionLabel;
    }

    public Step display(StepDisplay display) {
        this.display = display;
        this.unparsed |= display.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="display")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StepDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(StepDisplay display) {
        this.display = display;
    }

    public Step errorHandlers(List<ErrorHandler> errorHandlers) {
        this.errorHandlers = errorHandlers;
        for (ErrorHandler item : errorHandlers) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public Step addErrorHandlersItem(ErrorHandler errorHandlersItem) {
        if (this.errorHandlers == null) {
            this.errorHandlers = new ArrayList<ErrorHandler>();
        }
        this.errorHandlers.add(errorHandlersItem);
        this.unparsed |= errorHandlersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="errorHandlers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ErrorHandler> getErrorHandlers() {
        return this.errorHandlers;
    }

    public void setErrorHandlers(List<ErrorHandler> errorHandlers) {
        this.errorHandlers = errorHandlers;
    }

    public Step name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Step outboundEdges(List<OutboundEdge> outboundEdges) {
        this.outboundEdges = outboundEdges;
        for (OutboundEdge item : outboundEdges) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public Step addOutboundEdgesItem(OutboundEdge outboundEdgesItem) {
        if (this.outboundEdges == null) {
            this.outboundEdges = new ArrayList<OutboundEdge>();
        }
        this.outboundEdges.add(outboundEdgesItem);
        this.unparsed |= outboundEdgesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="outboundEdges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OutboundEdge> getOutboundEdges() {
        return this.outboundEdges;
    }

    public void setOutboundEdges(List<OutboundEdge> outboundEdges) {
        this.outboundEdges = outboundEdges;
    }

    public Step parameters(List<Parameter> parameters) {
        this.parameters = parameters;
        for (Parameter item : parameters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public Step addParametersItem(Parameter parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        this.parameters.add(parametersItem);
        this.unparsed |= parametersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public Step readinessGate(ReadinessGate readinessGate) {
        this.readinessGate = readinessGate;
        this.unparsed |= readinessGate.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="readinessGate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReadinessGate getReadinessGate() {
        return this.readinessGate;
    }

    public void setReadinessGate(ReadinessGate readinessGate) {
        this.readinessGate = readinessGate;
    }

    @JsonAnySetter
    public Step putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Step step = (Step)o;
        return Objects.equals(this.actionId, step.actionId) && Objects.equals(this.completionGate, step.completionGate) && Objects.equals(this.connectionLabel, step.connectionLabel) && Objects.equals(this.display, step.display) && Objects.equals(this.errorHandlers, step.errorHandlers) && Objects.equals(this.name, step.name) && Objects.equals(this.outboundEdges, step.outboundEdges) && Objects.equals(this.parameters, step.parameters) && Objects.equals(this.readinessGate, step.readinessGate) && Objects.equals(this.additionalProperties, step.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.actionId, this.completionGate, this.connectionLabel, this.display, this.errorHandlers, this.name, this.outboundEdges, this.parameters, this.readinessGate, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Step {\n");
        sb.append("    actionId: ").append(this.toIndentedString(this.actionId)).append("\n");
        sb.append("    completionGate: ").append(this.toIndentedString(this.completionGate)).append("\n");
        sb.append("    connectionLabel: ").append(this.toIndentedString(this.connectionLabel)).append("\n");
        sb.append("    display: ").append(this.toIndentedString(this.display)).append("\n");
        sb.append("    errorHandlers: ").append(this.toIndentedString(this.errorHandlers)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    outboundEdges: ").append(this.toIndentedString(this.outboundEdges)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    readinessGate: ").append(this.toIndentedString(this.readinessGate)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

