/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"character_count", "keywords", "use_recommended_keywords"})
public class SensitiveDataScannerIncludedKeywordConfiguration {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CHARACTER_COUNT = "character_count";
    private Long characterCount;
    public static final String JSON_PROPERTY_KEYWORDS = "keywords";
    private List<String> keywords = new ArrayList<String>();
    public static final String JSON_PROPERTY_USE_RECOMMENDED_KEYWORDS = "use_recommended_keywords";
    private Boolean useRecommendedKeywords;
    private Map<String, Object> additionalProperties;

    public SensitiveDataScannerIncludedKeywordConfiguration() {
    }

    @JsonCreator
    public SensitiveDataScannerIncludedKeywordConfiguration(@JsonProperty(required=true, value="character_count") Long characterCount, @JsonProperty(required=true, value="keywords") List<String> keywords) {
        this.characterCount = characterCount;
        this.keywords = keywords;
    }

    public SensitiveDataScannerIncludedKeywordConfiguration characterCount(Long characterCount) {
        this.characterCount = characterCount;
        return this;
    }

    @JsonProperty(value="character_count")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getCharacterCount() {
        return this.characterCount;
    }

    public void setCharacterCount(Long characterCount) {
        this.characterCount = characterCount;
    }

    public SensitiveDataScannerIncludedKeywordConfiguration keywords(List<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    public SensitiveDataScannerIncludedKeywordConfiguration addKeywordsItem(String keywordsItem) {
        this.keywords.add(keywordsItem);
        return this;
    }

    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public SensitiveDataScannerIncludedKeywordConfiguration useRecommendedKeywords(Boolean useRecommendedKeywords) {
        this.useRecommendedKeywords = useRecommendedKeywords;
        return this;
    }

    @Nullable
    @JsonProperty(value="use_recommended_keywords")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUseRecommendedKeywords() {
        return this.useRecommendedKeywords;
    }

    public void setUseRecommendedKeywords(Boolean useRecommendedKeywords) {
        this.useRecommendedKeywords = useRecommendedKeywords;
    }

    @JsonAnySetter
    public SensitiveDataScannerIncludedKeywordConfiguration putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SensitiveDataScannerIncludedKeywordConfiguration sensitiveDataScannerIncludedKeywordConfiguration = (SensitiveDataScannerIncludedKeywordConfiguration)o;
        return Objects.equals(this.characterCount, sensitiveDataScannerIncludedKeywordConfiguration.characterCount) && Objects.equals(this.keywords, sensitiveDataScannerIncludedKeywordConfiguration.keywords) && Objects.equals(this.useRecommendedKeywords, sensitiveDataScannerIncludedKeywordConfiguration.useRecommendedKeywords) && Objects.equals(this.additionalProperties, sensitiveDataScannerIncludedKeywordConfiguration.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.characterCount, this.keywords, this.useRecommendedKeywords, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SensitiveDataScannerIncludedKeywordConfiguration {\n");
        sb.append("    characterCount: ").append(this.toIndentedString(this.characterCount)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    useRecommendedKeywords: ").append(this.toIndentedString(this.useRecommendedKeywords)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

