/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CIAppCreatePipelineEventRequest;
import com.datadog.api.client.v2.model.CIAppPipelineEvent;
import com.datadog.api.client.v2.model.CIAppPipelineEventsRequest;
import com.datadog.api.client.v2.model.CIAppPipelineEventsResponse;
import com.datadog.api.client.v2.model.CIAppPipelinesAggregateRequest;
import com.datadog.api.client.v2.model.CIAppPipelinesAnalyticsAggregateResponse;
import com.datadog.api.client.v2.model.CIAppQueryPageOptions;
import com.datadog.api.client.v2.model.CIAppSort;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class CiVisibilityPipelinesApi {
    private ApiClient apiClient;

    public CiVisibilityPipelinesApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public CiVisibilityPipelinesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CIAppPipelinesAnalyticsAggregateResponse aggregateCIAppPipelineEvents(CIAppPipelinesAggregateRequest body) throws ApiException {
        return this.aggregateCIAppPipelineEventsWithHttpInfo(body).getData();
    }

    public CompletableFuture<CIAppPipelinesAnalyticsAggregateResponse> aggregateCIAppPipelineEventsAsync(CIAppPipelinesAggregateRequest body) {
        return this.aggregateCIAppPipelineEventsWithHttpInfoAsync(body).thenApply(response -> (CIAppPipelinesAnalyticsAggregateResponse)response.getData());
    }

    public ApiResponse<CIAppPipelinesAnalyticsAggregateResponse> aggregateCIAppPipelineEventsWithHttpInfo(CIAppPipelinesAggregateRequest body) throws ApiException {
        CIAppPipelinesAggregateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling aggregateCIAppPipelineEvents");
        }
        String localVarPath = "/api/v2/ci/pipelines/analytics/aggregate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CiVisibilityPipelinesApi.aggregateCIAppPipelineEvents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CIAppPipelinesAnalyticsAggregateResponse>(){});
    }

    public CompletableFuture<ApiResponse<CIAppPipelinesAnalyticsAggregateResponse>> aggregateCIAppPipelineEventsWithHttpInfoAsync(CIAppPipelinesAggregateRequest body) {
        Invocation.Builder builder;
        CIAppPipelinesAggregateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CIAppPipelinesAnalyticsAggregateResponse>> result = new CompletableFuture<ApiResponse<CIAppPipelinesAnalyticsAggregateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling aggregateCIAppPipelineEvents"));
            return result;
        }
        String localVarPath = "/api/v2/ci/pipelines/analytics/aggregate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CiVisibilityPipelinesApi.aggregateCIAppPipelineEvents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CIAppPipelinesAnalyticsAggregateResponse>> result = new CompletableFuture<ApiResponse<CIAppPipelinesAnalyticsAggregateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CIAppPipelinesAnalyticsAggregateResponse>(){});
    }

    public Object createCIAppPipelineEvent(CIAppCreatePipelineEventRequest body) throws ApiException {
        return this.createCIAppPipelineEventWithHttpInfo(body).getData();
    }

    public CompletableFuture<Object> createCIAppPipelineEventAsync(CIAppCreatePipelineEventRequest body) {
        return this.createCIAppPipelineEventWithHttpInfoAsync(body).thenApply(response -> response.getData());
    }

    public ApiResponse<Object> createCIAppPipelineEventWithHttpInfo(CIAppCreatePipelineEventRequest body) throws ApiException {
        CIAppCreatePipelineEventRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCIAppPipelineEvent");
        }
        String localVarPath = "/api/v2/ci/pipeline";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CiVisibilityPipelinesApi.createCIAppPipelineEvent", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> createCIAppPipelineEventWithHttpInfoAsync(CIAppCreatePipelineEventRequest body) {
        Invocation.Builder builder;
        CIAppCreatePipelineEventRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCIAppPipelineEvent"));
            return result;
        }
        String localVarPath = "/api/v2/ci/pipeline";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CiVisibilityPipelinesApi.createCIAppPipelineEvent", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CIAppPipelineEventsResponse listCIAppPipelineEvents() throws ApiException {
        return this.listCIAppPipelineEventsWithHttpInfo(new ListCIAppPipelineEventsOptionalParameters()).getData();
    }

    public CompletableFuture<CIAppPipelineEventsResponse> listCIAppPipelineEventsAsync() {
        return this.listCIAppPipelineEventsWithHttpInfoAsync(new ListCIAppPipelineEventsOptionalParameters()).thenApply(response -> (CIAppPipelineEventsResponse)response.getData());
    }

    public CIAppPipelineEventsResponse listCIAppPipelineEvents(ListCIAppPipelineEventsOptionalParameters parameters) throws ApiException {
        return this.listCIAppPipelineEventsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<CIAppPipelineEventsResponse> listCIAppPipelineEventsAsync(ListCIAppPipelineEventsOptionalParameters parameters) {
        return this.listCIAppPipelineEventsWithHttpInfoAsync(parameters).thenApply(response -> (CIAppPipelineEventsResponse)response.getData());
    }

    public PaginationIterable<CIAppPipelineEvent> listCIAppPipelineEventsWithPagination() {
        ListCIAppPipelineEventsOptionalParameters parameters = new ListCIAppPipelineEventsOptionalParameters();
        return this.listCIAppPipelineEventsWithPagination(parameters);
    }

    public PaginationIterable<CIAppPipelineEvent> listCIAppPipelineEventsWithPagination(ListCIAppPipelineEventsOptionalParameters parameters) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "pageCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 10;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<CIAppPipelineEvent> iterator = new PaginationIterable<CIAppPipelineEvent>(this, "listCIAppPipelineEvents", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<CIAppPipelineEventsResponse> listCIAppPipelineEventsWithHttpInfo(ListCIAppPipelineEventsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        CIAppSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/ci/pipelines/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CiVisibilityPipelinesApi.listCIAppPipelineEvents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CIAppPipelineEventsResponse>(){});
    }

    public CompletableFuture<ApiResponse<CIAppPipelineEventsResponse>> listCIAppPipelineEventsWithHttpInfoAsync(ListCIAppPipelineEventsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        CIAppSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/ci/pipelines/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        try {
            builder = this.apiClient.createBuilder("v2.CiVisibilityPipelinesApi.listCIAppPipelineEvents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CIAppPipelineEventsResponse>> result = new CompletableFuture<ApiResponse<CIAppPipelineEventsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CIAppPipelineEventsResponse>(){});
    }

    public CIAppPipelineEventsResponse searchCIAppPipelineEvents() throws ApiException {
        return this.searchCIAppPipelineEventsWithHttpInfo(new SearchCIAppPipelineEventsOptionalParameters()).getData();
    }

    public CompletableFuture<CIAppPipelineEventsResponse> searchCIAppPipelineEventsAsync() {
        return this.searchCIAppPipelineEventsWithHttpInfoAsync(new SearchCIAppPipelineEventsOptionalParameters()).thenApply(response -> (CIAppPipelineEventsResponse)response.getData());
    }

    public CIAppPipelineEventsResponse searchCIAppPipelineEvents(SearchCIAppPipelineEventsOptionalParameters parameters) throws ApiException {
        return this.searchCIAppPipelineEventsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<CIAppPipelineEventsResponse> searchCIAppPipelineEventsAsync(SearchCIAppPipelineEventsOptionalParameters parameters) {
        return this.searchCIAppPipelineEventsWithHttpInfoAsync(parameters).thenApply(response -> (CIAppPipelineEventsResponse)response.getData());
    }

    public PaginationIterable<CIAppPipelineEvent> searchCIAppPipelineEventsWithPagination() {
        SearchCIAppPipelineEventsOptionalParameters parameters = new SearchCIAppPipelineEventsOptionalParameters();
        return this.searchCIAppPipelineEventsWithPagination(parameters);
    }

    public PaginationIterable<CIAppPipelineEvent> searchCIAppPipelineEventsWithPagination(SearchCIAppPipelineEventsOptionalParameters parameters) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "body.getPage.setCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.body == null) {
            parameters.body(new CIAppPipelineEventsRequest());
        }
        if (parameters.body.getPage() == null) {
            parameters.body.setPage(new CIAppQueryPageOptions());
        }
        if (parameters.body.getPage().getLimit() == null) {
            limit = 10;
            parameters.body.getPage().setLimit(limit);
        } else {
            limit = parameters.body.getPage().getLimit();
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<CIAppPipelineEvent> iterator = new PaginationIterable<CIAppPipelineEvent>(this, "searchCIAppPipelineEvents", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<CIAppPipelineEventsResponse> searchCIAppPipelineEventsWithHttpInfo(SearchCIAppPipelineEventsOptionalParameters parameters) throws ApiException {
        CIAppPipelineEventsRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/ci/pipelines/events/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CiVisibilityPipelinesApi.searchCIAppPipelineEvents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CIAppPipelineEventsResponse>(){});
    }

    public CompletableFuture<ApiResponse<CIAppPipelineEventsResponse>> searchCIAppPipelineEventsWithHttpInfoAsync(SearchCIAppPipelineEventsOptionalParameters parameters) {
        Invocation.Builder builder;
        CIAppPipelineEventsRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/ci/pipelines/events/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CiVisibilityPipelinesApi.searchCIAppPipelineEvents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CIAppPipelineEventsResponse>> result = new CompletableFuture<ApiResponse<CIAppPipelineEventsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CIAppPipelineEventsResponse>(){});
    }

    public static class SearchCIAppPipelineEventsOptionalParameters {
        private CIAppPipelineEventsRequest body;

        public SearchCIAppPipelineEventsOptionalParameters body(CIAppPipelineEventsRequest body) {
            this.body = body;
            return this;
        }
    }

    public static class ListCIAppPipelineEventsOptionalParameters {
        private String filterQuery;
        private OffsetDateTime filterFrom;
        private OffsetDateTime filterTo;
        private CIAppSort sort;
        private String pageCursor;
        private Integer pageLimit;

        public ListCIAppPipelineEventsOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public ListCIAppPipelineEventsOptionalParameters filterFrom(OffsetDateTime filterFrom) {
            this.filterFrom = filterFrom;
            return this;
        }

        public ListCIAppPipelineEventsOptionalParameters filterTo(OffsetDateTime filterTo) {
            this.filterTo = filterTo;
            return this;
        }

        public ListCIAppPipelineEventsOptionalParameters sort(CIAppSort sort) {
            this.sort = sort;
            return this;
        }

        public ListCIAppPipelineEventsOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public ListCIAppPipelineEventsOptionalParameters pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }
    }
}

